/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import jade.core.AID;
import jade.core.Specifier;
import java.util.Vector;

class DelegationChainElement {
    static final char DELEGATION_CHAIN_SEPARATOR = ';';
    static final char ELEMENT_SEPARATOR = ',';
    private AID executor;
    private String executionId;

    public DelegationChainElement() {
    }

    public DelegationChainElement(AID executor, String executionId) {
        this.executor = executor;
        this.executionId = executionId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public AID getExecutor() {
        return this.executor;
    }

    public void setExecutor(AID executor) {
        this.executor = executor;
    }

    public static final DelegationChainElement[] parseDelegationChain(String dc) {
        Vector v = Specifier.parseList((String)dc, (char)';');
        DelegationChainElement[] result = new DelegationChainElement[v.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = DelegationChainElement.parse((String)v.elementAt(i));
        }
        return result;
    }

    public static final DelegationChainElement parse(String element) {
        if (element == null || element.length() == 0) {
            return null;
        }
        Vector v = Specifier.parseList((String)element, (char)',');
        String executorName = (String)v.elementAt(0);
        String executionId = (String)v.elementAt(1);
        DelegationChainElement result = new DelegationChainElement(new AID(executorName, true), executionId);
        return result;
    }

    public static boolean shorter(String dc1, String dc2) {
        DelegationChainElement[] del2;
        DelegationChainElement[] del1 = DelegationChainElement.parseDelegationChain(dc1);
        return del1.length < (del2 = DelegationChainElement.parseDelegationChain(dc2)).length;
    }
}

