/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.DynamicWebServiceInvocationBehaviour;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.WebServiceAddressingContext;
import com.tilab.wade.performer.WebServiceSecurityContext;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.descriptors.Parameter;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.onto.BeanOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ObjectSchema;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.webservice.dynamicClient.AddressingProperties;
import jade.webservice.dynamicClient.DynamicClient;
import jade.webservice.dynamicClient.DynamicClientCache;
import jade.webservice.dynamicClient.DynamicClientException;
import jade.webservice.dynamicClient.DynamicClientProperties;
import jade.webservice.dynamicClient.OperationInfo;
import jade.webservice.dynamicClient.SecurityProperties;
import jade.webservice.dynamicClient.WSData;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicWebService
extends BuildingBlock {
    private WorkflowBehaviour owner;
    private URI wsdl;
    private URL endpoint;
    private String serviceName;
    private String portName;
    private String operationName;
    private int timeout;
    private WebServiceSecurityContext securityContext;
    private WebServiceAddressingContext addressingContext;
    private boolean noWrap;
    private String packageName;
    private WSData wsInputData;
    private WSData wsOutputData;
    private transient DynamicClient dynamicClient;
    private transient SecurityProperties dcSecurityProperties;
    private transient AddressingProperties dcAddressingProperties;
    private transient String wsdlHttpUsername;
    private transient String wsdlHttpPassword;

    public DynamicWebService(WorkflowBehaviour owner, DynamicWebServiceInvocationBehaviour activity) {
        super(activity);
        this.owner = owner;
        this.timeout = -1;
        this.noWrap = false;
        this.wsInputData = new WSData();
        this.wsOutputData = new WSData();
    }

    public URI getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(URI wsdl) {
        this.wsdl = wsdl;
        this.dynamicClient = null;
    }

    public URL getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URL endpoint) {
        this.endpoint = endpoint;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public WebServiceSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(WebServiceSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public WebServiceAddressingContext getAddressingContext() {
        return this.addressingContext;
    }

    public void setAddressingContext(WebServiceAddressingContext addressingContext) {
        this.addressingContext = addressingContext;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean noWrap) {
        this.noWrap = noWrap;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public WorkflowBehaviour getOwner() {
        return this.owner;
    }

    @Override
    public void reset() {
        this.wsInputData = new WSData();
        this.wsOutputData = new WSData();
    }

    public final void fill(String key, Object value) {
        this.wsInputData.setParameter(key, DynamicWebService.getAbsValue(value));
    }

    public final void fill(String key, String value) {
        this.wsInputData.setParameter(key, value);
    }

    public final void fill(String key, boolean value) {
        this.wsInputData.setParameter(key, value);
    }

    public final void fill(String key, int value) {
        this.wsInputData.setParameter(key, value);
    }

    public final void fill(String key, long value) {
        this.wsInputData.setParameter(key, value);
    }

    public final void fill(String key, float value) {
        this.wsInputData.setParameter(key, value);
    }

    public final void fill(String key, double value) {
        this.wsInputData.setParameter(key, value);
    }

    public final void fill(String key, Date value) {
        this.wsInputData.setParameter(key, value);
    }

    public final void fill(String key, byte[] value) {
        this.wsInputData.setParameter(key, value);
    }

    public final void fillHeader(String key, Object value) {
        this.wsInputData.setHeader(key, DynamicWebService.getAbsValue(value));
    }

    public final void fillHeader(String key, String value) {
        this.wsInputData.setHeader(key, value);
    }

    public final void fillHeader(String key, boolean value) {
        this.wsInputData.setHeader(key, value);
    }

    public final void fillHeader(String key, int value) {
        this.wsInputData.setHeader(key, value);
    }

    public final void fillHeader(String key, long value) {
        this.wsInputData.setHeader(key, value);
    }

    public final void fillHeader(String key, float value) {
        this.wsInputData.setHeader(key, value);
    }

    public final void fillHeader(String key, double value) {
        this.wsInputData.setHeader(key, value);
    }

    public final void fillHeader(String key, Date value) {
        this.wsInputData.setHeader(key, value);
    }

    public final void fillHeader(String key, byte[] value) {
        this.wsInputData.setHeader(key, value);
    }

    public final Object extract(String key) {
        return this.getOutput(key);
    }

    public final Object extract(String key, Class clazz) throws OntologyException {
        return DynamicWebService.castValue(this.extract(key), clazz);
    }

    public final Object extractHeader(String key) {
        return this.getOutput("header." + key);
    }

    public final Object extractHeader(String key, Class clazz) throws OntologyException {
        return DynamicWebService.castValue(this.extractHeader(key), clazz);
    }

    private static void addClassToOnto(BeanOntology beanOnto, Class clazz) throws OntologyException {
        if (beanOnto.getSchema(clazz) == null) {
            beanOnto.add(clazz);
        }
    }

    private static AbsObject getAbsValue(Object value) {
        AbsObject absValue;
        if (value == null) {
            absValue = null;
        } else if (value instanceof AbsObject) {
            absValue = (AbsObject)value;
        } else {
            try {
                BeanOntology beanOnto = new BeanOntology("TEMP-ONTO");
                if (value.getClass().isArray()) {
                    ArrayList jadeList = new ArrayList();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object o = Array.get(value, i);
                        jadeList.add(o);
                        DynamicWebService.addClassToOnto(beanOnto, o.getClass());
                    }
                    value = jadeList;
                } else if (value instanceof Collection) {
                    ArrayList jadeList = new ArrayList();
                    Collection javaList = (Collection)value;
                    for (Object o : javaList) {
                        jadeList.add(o);
                        DynamicWebService.addClassToOnto(beanOnto, o.getClass());
                    }
                    value = jadeList;
                } else if (value instanceof jade.util.leap.Collection) {
                    Iterator it = ((jade.util.leap.Collection)value).iterator();
                    while (it.hasNext()) {
                        DynamicWebService.addClassToOnto(beanOnto, it.next().getClass());
                    }
                } else {
                    DynamicWebService.addClassToOnto(beanOnto, value.getClass());
                }
                absValue = beanOnto.fromObject(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return absValue;
    }

    private static Object getObjectValue(AbsObject abs, Class clazz) throws OntologyException {
        BeanOntology beanOnto = new BeanOntology("TEMP-ONTO");
        if (clazz.isArray() && abs instanceof AbsAggregate) {
            beanOnto.add(clazz.getComponentType());
        } else {
            beanOnto.add(clazz);
        }
        Object obj = beanOnto.toObject(abs);
        if (clazz.isArray() && obj instanceof jade.util.leap.Collection) {
            List jadeColl = (List)obj;
            Object javaArray = Array.newInstance(clazz.getComponentType(), jadeColl.size());
            for (int i = 0; i < jadeColl.size(); ++i) {
                Array.set(javaArray, i, jadeColl.get(i));
            }
            obj = javaArray;
        }
        return obj;
    }

    private static Object castValue(Object obj, Class clazz) throws OntologyException {
        Object value = null;
        if (clazz.isAssignableFrom(obj.getClass())) {
            value = obj;
        } else if (obj instanceof AbsObject) {
            value = DynamicWebService.getObjectValue((AbsObject)obj, clazz);
        } else {
            throw new ClassCastException("Cannot convert " + obj + " in " + clazz);
        }
        return value;
    }

    private static Object getPrimitiveValue(AbsPrimitive absPrimitive) {
        Object value = null;
        if ("BO_Boolean".equals(absPrimitive.getTypeName())) {
            value = absPrimitive.getBoolean();
        } else if ("BO_String".equals(absPrimitive.getTypeName())) {
            value = absPrimitive.getString();
        } else if ("BO_Integer".equals(absPrimitive.getTypeName())) {
            value = absPrimitive.getInteger();
        } else if ("BO_Float".equals(absPrimitive.getTypeName())) {
            value = Float.valueOf(absPrimitive.getFloat());
        } else if ("BO_Date".equals(absPrimitive.getTypeName())) {
            value = absPrimitive.getDate();
        } else if ("BO_Byte-sequence".equals(absPrimitive.getTypeName())) {
            value = absPrimitive.getByteSequence();
        }
        return value;
    }

    public void invoke() throws Exception {
        DynamicClient dc = this.getDynamicClient();
        this.wsOutputData = dc.invoke(this.serviceName, this.portName, this.operationName, this.endpoint, this.timeout, this.dcSecurityProperties, this.dcAddressingProperties, this.wsInputData);
    }

    private DynamicClient getDynamicClient() throws DynamicClientException {
        if (this.dynamicClient == null) {
            DynamicClientProperties dcp = new DynamicClientProperties();
            dcp.setNoWrap(this.noWrap);
            dcp.setPackageName(this.packageName);
            DynamicClientCache dcc = DynamicClientCache.getInstance();
            this.applySecurityContext(dcc);
            this.applyAddressingContext(dcc);
            this.dynamicClient = dcc.get(this.wsdl, this.wsdlHttpUsername, this.wsdlHttpPassword, dcp);
        }
        return this.dynamicClient;
    }

    private void applySecurityContext(DynamicClientCache dcc) {
        WebServiceSecurityContext currentScurityContext = EngineHelper.extractWebServiceSecurityContext(this.owner, this.activity.getBehaviourName());
        if (currentScurityContext == null) {
            currentScurityContext = this.securityContext;
        }
        this.dcSecurityProperties = null;
        this.wsdlHttpUsername = null;
        this.wsdlHttpPassword = null;
        if (currentScurityContext != null) {
            this.wsdlHttpUsername = currentScurityContext.getWsdlHttpUsername();
            this.wsdlHttpPassword = currentScurityContext.getWsdlHttpPassword();
            this.dcSecurityProperties = new SecurityProperties();
            this.dcSecurityProperties.setHttpUsername(currentScurityContext.getHttpUsername());
            this.dcSecurityProperties.setHttpPassword(currentScurityContext.getHttpPassword());
            this.dcSecurityProperties.setWSSUsername(currentScurityContext.getWSSUsername());
            this.dcSecurityProperties.setWSSPassword(currentScurityContext.getWSSPassword());
            this.dcSecurityProperties.setWSSPasswordType(currentScurityContext.getWSSPasswordType());
            if (currentScurityContext.isWSSMustUnderstand() != null) {
                this.dcSecurityProperties.setWSSMustUnderstand(currentScurityContext.isWSSMustUnderstand().booleanValue());
            }
            if (currentScurityContext.getWSSTimeToLive() != null) {
                this.dcSecurityProperties.setWSSTimeToLive(currentScurityContext.getWSSTimeToLive().intValue());
            }
            if (currentScurityContext.getTrustStore() != null && currentScurityContext.getTrustStorePassword() != null) {
                DynamicClientCache.setTrustStore((String)currentScurityContext.getTrustStore());
                DynamicClientCache.setTrustStorePassword((String)currentScurityContext.getTrustStorePassword());
            }
            if (currentScurityContext.isEnableCertificateChecking() != null) {
                if (currentScurityContext.isEnableCertificateChecking().booleanValue()) {
                    dcc.enableCertificateChecking();
                } else {
                    dcc.disableCertificateChecking();
                }
            }
        }
    }

    private void applyAddressingContext(DynamicClientCache dcc) {
        WebServiceAddressingContext currentAddressingContext = EngineHelper.extractWebServiceAddressingContext(this.owner, this.activity.getBehaviourName());
        if (currentAddressingContext == null) {
            currentAddressingContext = this.addressingContext;
        }
        this.dcAddressingProperties = null;
        if (currentAddressingContext != null) {
            this.dcAddressingProperties = new AddressingProperties();
            this.dcAddressingProperties.setVersion(currentAddressingContext.getVersion());
            this.dcAddressingProperties.setMustUnderstand(currentAddressingContext.isMustUnderstand());
            this.dcAddressingProperties.setSendDefaultMessageID(currentAddressingContext.isSendDefaultMessageID());
            this.dcAddressingProperties.setMessageID(currentAddressingContext.getMessageID());
            this.dcAddressingProperties.setAction(currentAddressingContext.getAction());
            this.dcAddressingProperties.setSendDefaultFrom(currentAddressingContext.isSendDefaultFrom());
            this.dcAddressingProperties.setFrom(currentAddressingContext.getFrom());
            this.dcAddressingProperties.setSendDefaultTo(currentAddressingContext.isSendDefaultTo());
            this.dcAddressingProperties.setTo(currentAddressingContext.getTo());
            this.dcAddressingProperties.setFaultTo(currentAddressingContext.getFaultTo());
            this.dcAddressingProperties.setReplyTo(currentAddressingContext.getReplyTo());
        }
    }

    public static void clearDynamicClientsCache() {
        DynamicClientCache.getInstance().clear();
    }

    public static void removeDynamicClientCache(URI wsdl) {
        DynamicClientCache.getInstance().remove(wsdl);
    }

    @Override
    public AbsObject createAbsTemplate(String key) throws Exception {
        OperationInfo oi = this.getDynamicClient().getService(this.serviceName).getPort(this.portName).getOperation(this.operationName);
        int sepPos = key.indexOf(".");
        Object pi = sepPos > 0 ? oi.getInputHeader(key.substring(sepPos + 1)) : oi.getInputParameter(key);
        return AbsHelper.createAbsTemplate((ObjectSchema)pi.getSchema());
    }

    @Override
    public Ontology createOntology() throws Exception {
        return this.getDynamicClient().getOntology();
    }

    private java.util.List<String> getParameterNames(int mode) {
        java.util.ArrayList<String> parameterNames = new java.util.ArrayList<String>();
        try {
            Set hNames;
            Set pNames;
            OperationInfo oi = this.getDynamicClient().getService(this.serviceName).getPort(this.portName).getOperation(this.operationName);
            if (mode == 0) {
                pNames = oi.getInputParameterNames();
                hNames = oi.getInputHeaderNames();
            } else {
                pNames = oi.getOutputParameterNames();
                hNames = oi.getOutputHeaderNames();
            }
            parameterNames.addAll(pNames);
            for (String hName : hNames) {
                parameterNames.add("header." + hName);
            }
        }
        catch (DynamicClientException e) {
            throw new RuntimeException(e);
        }
        return parameterNames;
    }

    @Override
    public java.util.List<String> getInputParameterNames() {
        return this.getParameterNames(0);
    }

    @Override
    public java.util.List<String> getOutputParameterNames() {
        return this.getParameterNames(1);
    }

    @Override
    public boolean requireAbsParameters() {
        return true;
    }

    private Object getValue(String key, WSData wsData) {
        int sepPos = key.indexOf(".");
        AbsObject abs = sepPos > 0 ? wsData.getHeader(key.substring(sepPos + 1)) : wsData.getParameter(key);
        Object value = null;
        value = abs != null && abs.getAbsType() == 4 ? DynamicWebService.getPrimitiveValue((AbsPrimitive)abs) : abs;
        return value;
    }

    @Override
    public Object getInput(String key) {
        return this.getValue(key, this.wsInputData);
    }

    @Override
    public Object getOutput(String key) {
        return this.getValue(key, this.wsOutputData);
    }

    private void setValue(String key, Object value, WSData wsData) {
        AbsObject absValue = DynamicWebService.getAbsValue(value);
        int sepPos = key.indexOf(".");
        if (sepPos > 0) {
            wsData.setHeader(key.substring(sepPos + 1), absValue);
        } else {
            wsData.setParameter(key, absValue);
        }
    }

    @Override
    public void setInput(String key, Object value) {
        this.setValue(key, value, this.wsInputData);
    }

    @Override
    public void setOutput(String key, Object value) {
        this.setValue(key, value, this.wsOutputData);
    }

    @Override
    public boolean isInputEmpty(String key) {
        int sepPos = key.indexOf(".");
        if (sepPos > 0) {
            return this.wsInputData.isHeaderEmpty(key.substring(sepPos + 1));
        }
        return this.wsInputData.isParameterEmpty(key);
    }

    private Parameter getFormalDescriptor(String key, int mode) {
        try {
            OperationInfo oi = this.getDynamicClient().getService(this.serviceName).getPort(this.portName).getOperation(this.operationName);
            Parameter p = null;
            int sepPos = key.indexOf(".");
            Object pi = sepPos > 0 ? (mode == 0 ? oi.getInputHeader(key.substring(sepPos + 1)) : oi.getOutputHeader(key.substring(sepPos + 1))) : (mode == 0 ? oi.getInputParameter(key) : oi.getOutputParameter(key));
            if (pi != null) {
                Class primitiveTypeClass;
                Integer cardMax;
                p = new Parameter();
                p.setName(pi.getName());
                p.setMode(pi.getMode());
                p.setMandatory(pi.isMandatory());
                p.setDefaultValue(pi.getDefaultValue());
                p.setRegex(pi.getRegex());
                p.setDocumentation(pi.getDocumentation());
                p.setPermittedValues(pi.getPermittedValues());
                p.setSchema((ObjectSchema)pi.getSchema());
                Integer cardMin = pi.getCardMin();
                if (cardMin != null) {
                    p.setCardMin(cardMin.intValue());
                }
                if ((cardMax = pi.getCardMax()) != null) {
                    p.setCardMax(cardMax.intValue());
                }
                if ((primitiveTypeClass = pi.getPrimitiveTypeClass()) != null) {
                    p.setType(primitiveTypeClass.getName());
                    p.setTypeClass(primitiveTypeClass);
                }
            }
            return p;
        }
        catch (DynamicClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Parameter getInputParameter(String key) {
        return this.getFormalDescriptor(key, 0);
    }

    @Override
    public Parameter getOutputParameter(String key) {
        return this.getFormalDescriptor(key, 1);
    }
}

