/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.ActivityBehaviour;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.DynamicWebService;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.WebServiceAddressingContext;
import com.tilab.wade.performer.WebServiceSecurityContext;
import com.tilab.wade.performer.WorkflowBehaviour;
import jade.core.Agent;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class DynamicWebServiceInvocationBehaviour
extends ActivityBehaviour {
    private MethodInvocator invocator;
    private DynamicWebService dynamicWebService;

    public DynamicWebServiceInvocationBehaviour(String name, WorkflowBehaviour owner) {
        this(name, owner, true);
    }

    public DynamicWebServiceInvocationBehaviour(String name, WorkflowBehaviour owner, boolean callExecuteMethod) {
        super(name, owner);
        this.dynamicWebService = new DynamicWebService(owner, this);
        String methodName = callExecuteMethod ? EngineHelper.activityName2Method(this.getBehaviourName()) : "performDynamicWebService";
        EngineHelper.checkMethodName(methodName, "activity", name);
        this.invocator = new MethodInvocator(owner, methodName, this.dynamicWebService, DynamicWebService.class);
    }

    public void setWsdl(String wsdl) {
        try {
            this.dynamicWebService.setWsdl(new URI(wsdl));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed wsdl address " + wsdl, e);
        }
    }

    public void setService(String service) {
        this.dynamicWebService.setServiceName(service);
    }

    public void setPort(String port) {
        this.dynamicWebService.setPortName(port);
    }

    public void setOperation(String operation) {
        this.dynamicWebService.setOperationName(operation);
    }

    public void setTimeout(int timeout) {
        this.dynamicWebService.setTimeout(timeout);
    }

    public void setSecurityContext(WebServiceSecurityContext securityContext) {
        this.dynamicWebService.setSecurityContext(securityContext);
    }

    public void setAddressingContext(WebServiceAddressingContext addressingContext) {
        this.dynamicWebService.setAddressingContext(addressingContext);
    }

    public void setNoWrapTypes(boolean noWrap) {
        this.dynamicWebService.setNoWrap(noWrap);
    }

    public void setPackageName(String packageName) {
        this.dynamicWebService.setPackageName(packageName);
    }

    public void setEndpointAddress(String endpointAddress) {
        try {
            this.dynamicWebService.setEndpoint(new URL(endpointAddress));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed endpoint address " + endpointAddress, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        try {
            this.owner.enterInterruptableSection();
            this.invocator.invoke();
        }
        catch (InterruptedException ie) {
        }
        catch (Agent.Interrupted i) {
        }
        catch (ThreadDeath td) {
        }
        catch (Throwable t) {
            this.handleException(t);
            t.printStackTrace();
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    public void reset() {
        super.reset();
        this.dynamicWebService.reset();
    }

    public BuildingBlock getBuildingBlock(String id) {
        return this.dynamicWebService;
    }

    public boolean requireSave() {
        return true;
    }
}

