/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.ontology.WorkflowDetails;
import com.tilab.wade.performer.Application;
import com.tilab.wade.performer.BaseApplication;
import com.tilab.wade.performer.DefaultParameterValues;
import com.tilab.wade.performer.ExceptionTransition;
import com.tilab.wade.performer.FormalParameter;
import com.tilab.wade.performer.FormalParametersException;
import com.tilab.wade.performer.HierarchyNode;
import com.tilab.wade.performer.OntologyHolder;
import com.tilab.wade.performer.OutgoingTransitions;
import com.tilab.wade.performer.ReflectiveException;
import com.tilab.wade.performer.Transition;
import com.tilab.wade.performer.UnmanagedField;
import com.tilab.wade.performer.WebServiceAddressingContext;
import com.tilab.wade.performer.WebServiceSecurityContext;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.WorkflowException;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.event.ExecutionErrorEvent;
import com.tilab.wade.performer.event.UnhandledExceptionEvent;
import com.tilab.wade.performer.event.WorkflowEvent;
import com.tilab.wade.performer.layout.WorkflowDescription;
import com.tilab.wade.performer.ontology.Modifier;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.onto.AggregateHelper;
import jade.content.onto.BasicOntology;
import jade.content.onto.OntologyException;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineHelper {
    public static final String ACTIVITY_METHOD_PREFIX = "execute";
    public static final String BEFORE_ACTIVITY_METHOD_PREFIX = "before";
    public static final String AFTER_ACTIVITY_METHOD_PREFIX = "after";
    public static final String CONDITION_METHOD_PREFIX = "check";
    public static final int EXECUTE_METHOD_TYPE = 0;
    public static final int BEFORE_METHOD_TYPE = 1;
    public static final int AFTER_METHOD_TYPE = 2;
    private static Logger myLogger = Logger.getMyLogger((String)"com.tilab.wade.performer.EngineHelper");
    private static Map<Class, Object> defaultValues = new Hashtable<Class, Object>();

    public static void fillFormalParameters(Object obj, Class rootClass, List formalParams) {
        ArrayList unindexedParams = new ArrayList();
        EngineHelper.recursiveFill(obj.getClass(), rootClass, formalParams, (List)unindexedParams);
        Collections.sort(unindexedParams.toList());
        Iterator unindexedIt = unindexedParams.iterator();
        for (int i = 0; i < formalParams.size(); ++i) {
            if (formalParams.get(i) != null) continue;
            if (unindexedIt.hasNext()) {
                formalParams.remove(i);
                formalParams.add(i, unindexedIt.next());
                continue;
            }
            throw new FormalParametersException("Class " + obj.getClass() + ": Missing formal parameter at index " + i);
        }
        while (unindexedIt.hasNext()) {
            formalParams.add(unindexedIt.next());
        }
    }

    private static void recursiveFill(Class c, Class rootClass, List formalParams, List unindexedParams) {
        Class superclass = c.getSuperclass();
        if (superclass != null && !superclass.equals(rootClass)) {
            EngineHelper.recursiveFill(superclass, rootClass, formalParams, unindexedParams);
        }
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int index;
            FormalParameter fp = fields[i].getAnnotation(FormalParameter.class);
            if (fp == null) continue;
            Parameter p = new Parameter();
            p.setName(fields[i].getName());
            p.setMode(fp.mode());
            p.setType(fields[i].getType().getName());
            p.setTypeClass(fields[i].getType());
            Class elementTypeClass = EngineHelper.getElementTypeClass(fields[i]);
            if (fp.elementType() != Object.class) {
                elementTypeClass = fp.elementType();
            }
            if (elementTypeClass != null) {
                p.setElementTypeClass(elementTypeClass);
                p.setElementType(elementTypeClass.getName());
            }
            p.setMandatory(fp.mandatory());
            if (fp.cardMin() != -2) {
                p.setCardMin(fp.cardMin());
            }
            if (fp.cardMax() != -2) {
                p.setCardMax(fp.cardMax());
            }
            if (!fp.defaultValue().equals("__NULL__")) {
                p.setDefaultValue((Object)fp.defaultValue());
            }
            if (!fp.regex().equals("__NULL__")) {
                p.setRegex(fp.regex());
            }
            if (!fp.documentation().equals("__NULL__")) {
                p.setDocumentation(fp.documentation());
            }
            if (fp.permittedValues().length > 0) {
                p.setPermittedValues((Object[])fp.permittedValues());
            }
            if ((index = fp.index()) != -1) {
                int size = formalParams.size();
                if (size > index) {
                    Parameter p1 = (Parameter)formalParams.get(index);
                    if (p1 == null) {
                        formalParams.remove(index);
                        formalParams.add(index, (Object)p);
                        continue;
                    }
                    throw new FormalParametersException("Duplicate formal parameter index (" + index + "): " + p.getName() + ", " + p1.getName());
                }
                for (int k = size; k < index; ++k) {
                    formalParams.add(null);
                }
                formalParams.add((Object)p);
                continue;
            }
            unindexedParams.add((Object)p);
        }
    }

    static final void copyInputParameters(Object target, List actualParams) throws WorkflowException {
        List initialActualParams = (List)((ArrayList)actualParams).clone();
        actualParams.clear();
        List formalParams = EngineHelper.getFormalParameters(target);
        int size = formalParams != null ? formalParams.size() : 0;
        for (int i = 0; i < size; ++i) {
            Parameter actual;
            Parameter formal = (Parameter)formalParams.get(i);
            if (formal.getMode() == 0 || formal.getMode() == 2) {
                actual = EngineHelper.getParameter(initialActualParams, formal, i);
                if (actual != null) {
                    Object pValue = actual.getValue();
                    EngineHelper.setFieldValue(actual.getName(), pValue, target);
                    actualParams.add((Object)actual);
                    continue;
                }
                if (!formal.getMandatory()) continue;
                throw new WorkflowException("Missing mandatory value for parameter " + formal);
            }
            actual = EngineHelper.getParameter(initialActualParams, formal, i);
            if (actual == null) {
                actualParams.add((Object)new Parameter(formal.getName(), formal.getType(), formal.getMode()));
                continue;
            }
            actualParams.add((Object)actual);
        }
    }

    static final void extractOutputParameters(Object target, List parameters) throws WorkflowException {
        if (parameters != null) {
            for (Parameter p : parameters) {
                if (p.getMode() != 1 && p.getMode() != 2) continue;
                String pName = p.getName();
                Object pValue = EngineHelper.getFieldValue(pName, target);
                p.setValue(pValue);
            }
        }
    }

    private static List getFormalParameters(Object obj) {
        if (obj instanceof WorkflowBehaviour) {
            return ((WorkflowBehaviour)obj).getFormalParameters();
        }
        if (obj instanceof Application) {
            return ((Application)obj).getFormalParameters();
        }
        ArrayList formalParams = new ArrayList();
        EngineHelper.fillFormalParameters(obj, Object.class, (List)formalParams);
        return formalParams;
    }

    static Set<String> initManagedFields(Object target, Class rootClass) {
        if (rootClass == null) {
            rootClass = Object.class;
        }
        HashSet<String> managedFieldNames = new HashSet<String>();
        EngineHelper.recursiveFillManagedFields(target.getClass(), managedFieldNames, rootClass);
        return managedFieldNames;
    }

    private static void recursiveFillManagedFields(Class c, Set<String> ff, Class rootClass) {
        Class superclass = c.getSuperclass();
        if (!superclass.equals(rootClass)) {
            EngineHelper.recursiveFillManagedFields(superclass, ff, rootClass);
        }
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            UnmanagedField uf;
            Field f = fields[i];
            int m = f.getModifiers();
            if (java.lang.reflect.Modifier.isStatic(m) || java.lang.reflect.Modifier.isFinal(m) || (uf = fields[i].getAnnotation(UnmanagedField.class)) != null) continue;
            ff.add(fields[i].getName());
        }
    }

    private static Object getFieldValue(String name, Object obj) {
        if (obj instanceof WorkflowBehaviour) {
            return ((WorkflowBehaviour)obj).getFieldValue(name);
        }
        if (obj instanceof BaseApplication) {
            return ((BaseApplication)obj).getFieldValue(name);
        }
        return EngineHelper.getFieldValue(name, obj, null);
    }

    static Object getFieldValue(String name, Object obj, Map<String, Field> cachedFields) {
        Field field = null;
        try {
            field = EngineHelper.getField(name, obj, cachedFields);
            return field.get(obj);
        }
        catch (NoSuchFieldException nsfe) {
            throw new ReflectiveException("Connot find field " + name + " in class " + obj.getClass().getName(), nsfe);
        }
        catch (Exception e) {
            throw new ReflectiveException("Unexpected error retrieving value of field " + name + " of type " + field.getType().getName() + " of class " + obj.getClass().getName(), e);
        }
    }

    private static void setFieldValue(String name, Object value, Object obj) {
        if (obj instanceof WorkflowBehaviour) {
            ((WorkflowBehaviour)obj).setFieldValue(name, value);
        } else if (obj instanceof BaseApplication) {
            ((BaseApplication)obj).setFieldValue(name, value);
        } else {
            EngineHelper.setFieldValue(name, value, obj, null);
        }
    }

    static void setFieldValue(String name, Object value, Object obj, Map<String, Field> cachedFields) {
        Field field = null;
        try {
            field = EngineHelper.getField(name, obj, cachedFields);
            Class<AbsObject> type = field.getType();
            if (value != null) {
                if (myLogger.isLoggable(Logger.FINE)) {
                    myLogger.log(Logger.FINE, "Setting field " + name + " of type " + type.getName() + " to value " + value + " of class " + value.getClass().getName());
                }
                if (value instanceof AbsObject && !type.isAssignableFrom(AbsObject.class) && obj instanceof OntologyHolder) {
                    value = AbsHelper.nullifyVariables((AbsObject)((AbsObject)value), (boolean)false);
                    value = ((OntologyHolder)obj).getOntology().toObject((AbsObject)value);
                }
                value = BasicOntology.adjustPrimitiveValue((Object)value, type);
                value = AggregateHelper.adjustAggregateValue((Object)value, type);
            } else {
                if (myLogger.isLoggable(Logger.FINE)) {
                    myLogger.log(Logger.FINE, "Setting field " + name + " of type " + type.getName() + " to null");
                }
                if (type.isPrimitive()) {
                    value = EngineHelper.getDefaultValue(type);
                }
            }
            field.set(obj, value);
        }
        catch (NoSuchFieldException nsfe) {
            throw new ReflectiveException("Cannot find field " + name + " in class " + obj.getClass().getName(), nsfe);
        }
        catch (IllegalArgumentException iae) {
            throw new ReflectiveException("Cannot assign value " + value + " of type " + value.getClass().getName() + " to field " + name + " of type " + field.getType().getName() + " of class " + obj.getClass().getName(), iae);
        }
        catch (OntologyException oe) {
            throw new ReflectiveException("Cannot convert Abs Descriptor " + value + " before assigning it to field " + name + " of type " + field.getType().getName() + " of class" + obj.getClass().getName(), (Exception)((Object)oe));
        }
        catch (Exception e) {
            throw new ReflectiveException("Unexpected error assigning value " + value + " of type " + value.getClass().getName() + " to field " + name + " of type " + field.getType().getName() + " of class " + obj.getClass().getName(), e);
        }
    }

    static Field getField(String fieldName, Object obj, Map<String, Field> cachedFields) throws NoSuchFieldException {
        Field f;
        Field field = f = cachedFields != null ? cachedFields.get(fieldName) : null;
        if (f == null) {
            f = EngineHelper.getField(fieldName, obj.getClass());
            if (f != null) {
                if (!f.isAccessible()) {
                    try {
                        f.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        throw new NoSuchFieldException("Field " + fieldName + " of class " + obj.getClass().getName() + " not accessible.");
                    }
                }
                if (cachedFields != null) {
                    cachedFields.put(fieldName, f);
                }
            } else {
                throw new NoSuchFieldException("Field " + fieldName + " not found in class " + obj.getClass().getName());
            }
        }
        return f;
    }

    private static Field getField(String fieldName, Class currentClass) {
        Field f;
        block2: {
            f = null;
            try {
                f = currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                Class superClass = currentClass.getSuperclass();
                if (WorkflowBehaviour.class.equals(superClass) || Application.class.equals(superClass)) break block2;
                f = EngineHelper.getField(fieldName, superClass);
            }
        }
        return f;
    }

    private static Parameter getParameter(List params, Parameter formalParameter, int index) {
        Parameter param = null;
        for (Parameter p : params) {
            if (p.getName() != null) {
                if (!p.getName().equals(formalParameter.getName())) continue;
                param = p;
                param.setMode(formalParameter.getMode());
                param.setType(formalParameter.getType());
                break;
            }
            if (index >= params.size()) break;
            param = (Parameter)params.get(index);
            param.setName(formalParameter.getName());
            param.setMode(formalParameter.getMode());
            param.setType(formalParameter.getType());
            break;
        }
        return param;
    }

    static final void initTransitions(List tt, List transitions, List exceptionTransitions) {
        if (tt != null) {
            int k;
            for (int i = k = tt.size() - 1; i >= 0; --i) {
                List l;
                Transition t = (Transition)tt.get(i);
                List list = l = t.isException() ? exceptionTransitions : transitions;
                if (t.isDefault()) {
                    l.add((Object)t);
                    continue;
                }
                l.add(0, (Object)t);
            }
        }
    }

    static final int endActivity(HierarchyNode node) {
        OutgoingTransitions ot = node.getOutgoingTransitions();
        List transitions = ot.getTransitions();
        List exceptionTransitions = ot.getExceptionTransitions();
        int ret = -68392;
        Transition t = null;
        try {
            if (!node.isInterrupted()) {
                List tt;
                Throwable lastException = node.getLastException();
                List list = tt = lastException == null ? transitions : exceptionTransitions;
                if (myLogger.isLoggable(Logger.FINE)) {
                    myLogger.log(Logger.FINE, "Evaluating transitions from activity " + node.getBehaviourName() + ". Transitions list size = " + tt.size() + ". Last-exception = " + lastException);
                }
                for (int i = 0; i < tt.size(); ++i) {
                    t = (Transition)tt.get(i);
                    if (myLogger.isLoggable(Logger.FINER)) {
                        myLogger.log(Logger.FINER, "Evaluating " + t);
                    }
                    if (lastException != null) {
                        ((ExceptionTransition)t).setException(lastException);
                    }
                    if (!t.evaluateCondition()) continue;
                    ret = t.getExitValue();
                    if (!myLogger.isLoggable(Logger.FINER)) break;
                    myLogger.log(Logger.FINER, "Exit value " + ret);
                    break;
                }
                if (ret == -68392 && lastException != null) {
                    ret = -68393;
                    if (node.hasJADEDefaultTransition()) {
                        ((WorkflowEngineAgent.WorkflowExecutor)node.root()).getEventEmitter().fireEvent("warning", (WorkflowEvent)new UnhandledExceptionEvent(node.getBehaviourName(), lastException), 2);
                    }
                }
                node.getOwner().handleEndActivity(node);
            }
        }
        catch (Agent.Interrupted ie) {
            ret = -68392;
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            EngineHelper.fireExecutionErrorEvent(node, thr, 1);
            node.propagateException((Throwable)new WorkflowException("Error evaluating condition " + t.getConditionName() + " " + t, thr));
        }
        node.mark();
        return ret;
    }

    static final void fireExecutionErrorEvent(HierarchyNode node, Throwable t, int level) {
        WorkflowEngineAgent.WorkflowExecutor root = (WorkflowEngineAgent.WorkflowExecutor)node.root();
        String workflowName = root.getDescriptor().getId();
        ExecutionErrorEvent errorEvent = new ExecutionErrorEvent(workflowName, node.getBehaviourName(), t);
        root.getEventEmitter().fireEvent("warning", (WorkflowEvent)errorEvent, level);
        root.setLastErrorEvent(errorEvent);
    }

    public static final MessageTemplate adjustReplyTemplate(MessageTemplate template, ACLMessage msg) {
        return MessageTemplate.and((MessageTemplate)template, (MessageTemplate)MessageTemplate.not((MessageTemplate)MessageTemplate.MatchCustom((ACLMessage)msg, (boolean)true)));
    }

    public static String lowerCaseFirst(String str) {
        char[] cc = str.toCharArray();
        cc[0] = Character.toLowerCase(cc[0]);
        return new String(cc);
    }

    public static String upperCaseFirst(String str) {
        char[] cc = str.toCharArray();
        cc[0] = Character.toUpperCase(cc[0]);
        return new String(cc);
    }

    public static final String activityName2Method(String activityName) {
        return EngineHelper.activityName2Method(activityName, 0);
    }

    public static final String activityName2Method(String activityName, int type) {
        String prefix = ACTIVITY_METHOD_PREFIX;
        if (type == 1) {
            prefix = BEFORE_ACTIVITY_METHOD_PREFIX;
        } else if (type == 2) {
            prefix = AFTER_ACTIVITY_METHOD_PREFIX;
        }
        return prefix + activityName;
    }

    public static final String conditionName2Method(String conditionName) {
        return CONDITION_METHOD_PREFIX + conditionName;
    }

    public static void checkMethodName(String methodName, String objectType, String objectName) throws IllegalArgumentException {
        char c = methodName.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            throw new IllegalArgumentException("Method name " + methodName + " for " + objectType + " " + objectName + " is not a valid Java method name");
        }
        for (int i = 1; i < methodName.length(); ++i) {
            c = methodName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException("Method name " + methodName + " for " + objectType + " " + objectName + " is not a valid Java method name");
        }
    }

    public static Object getDefaultValue(String type) {
        Object value = null;
        try {
            Class<?> cl = Class.forName(type);
            value = EngineHelper.getDefaultValue(cl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    static Object getDefaultValue(Class cl) {
        return defaultValues.get(cl);
    }

    public static boolean isEventMessage(ACLMessage msg) {
        return "true".equals(msg.getUserDefinedParameter("WADE-event-message"));
    }

    private static Class getElementTypeClass(Field field) {
        ParameterizedType pt;
        Type[] actuals;
        Class elementTypeClass = null;
        Type fieldType = field.getGenericType();
        if (fieldType instanceof Class) {
            Class fieldClass = (Class)fieldType;
            if (fieldClass.isArray() && fieldClass != byte[].class) {
                elementTypeClass = fieldClass.getComponentType();
            }
        } else if (fieldType instanceof ParameterizedType && (actuals = (pt = (ParameterizedType)fieldType).getActualTypeArguments()).length > 0) {
            elementTypeClass = (Class)actuals[0];
        }
        return elementTypeClass;
    }

    static DefaultParameterValues extractDefaultParameterValues(WorkflowBehaviour wb) {
        DefaultParameterValues dpv = null;
        Modifier dpvModifier = wb.getModifier("DEFAULT_PARAMETER_VALUES_MODIFIER");
        if (dpvModifier != null) {
            dpv = new DefaultParameterValues(dpvModifier);
        }
        return dpv;
    }

    static WebServiceSecurityContext extractWebServiceSecurityContext(WorkflowBehaviour wb, String activityId) {
        WebServiceSecurityContext wfSecurityContext = EngineHelper.internalExtractWebServiceSecurityContext(wb, activityId);
        if (wfSecurityContext == null) {
            wfSecurityContext = EngineHelper.internalExtractWebServiceSecurityContext(wb, null);
        }
        return wfSecurityContext;
    }

    private static WebServiceSecurityContext internalExtractWebServiceSecurityContext(WorkflowBehaviour wb, String activityId) {
        WebServiceSecurityContext securityContext = null;
        String modifierName = activityId == null ? "WEBSERVICE_SECURITY_MODIFIER" : "ACTIVITY_WEBSERVICE_SECURITY_MODIFIER_" + activityId;
        Modifier securityModifier = wb.getModifier(modifierName);
        if (securityModifier != null) {
            securityContext = new WebServiceSecurityContext(securityModifier);
        }
        return securityContext;
    }

    static WebServiceAddressingContext extractWebServiceAddressingContext(WorkflowBehaviour wb, String activityId) {
        WebServiceAddressingContext wfAddressingContext = EngineHelper.internalExtractWebServiceAddressingContext(wb, activityId);
        if (wfAddressingContext == null) {
            wfAddressingContext = EngineHelper.internalExtractWebServiceAddressingContext(wb, null);
        }
        return wfAddressingContext;
    }

    private static WebServiceAddressingContext internalExtractWebServiceAddressingContext(WorkflowBehaviour wb, String activityId) {
        WebServiceAddressingContext addressingContext = null;
        String modifierName = activityId == null ? "WEBSERVICE_ADDRESSING_MODIFIER" : "ACTIVITY_WEBSERVICE_ADDRESSING_MODIFIER_" + activityId;
        Modifier addressingModifier = wb.getModifier(modifierName);
        if (addressingModifier != null) {
            addressingContext = new WebServiceAddressingContext(addressingModifier);
        }
        return addressingContext;
    }

    public static WorkflowDetails buildWorkflowDetails(Class<?> clazz) {
        WorkflowDetails workflowDetails = new WorkflowDetails();
        workflowDetails.setClassName(clazz.getName());
        WorkflowDescription workflowDescription = clazz.getAnnotation(WorkflowDescription.class);
        if (workflowDescription != null) {
            String wdDocumentation;
            String wdName = workflowDescription.name();
            if (!wdName.equals("__NULL__")) {
                workflowDetails.setName(wdName);
            }
            if (!(wdDocumentation = workflowDescription.documentation()).equals("__NULL__")) {
                workflowDetails.setDocumentation(wdDocumentation);
            }
        }
        if (workflowDetails.getName() == null) {
            workflowDetails.setName(clazz.getSimpleName());
        }
        return workflowDetails;
    }

    public static boolean isInteractive(WorkflowEngineAgent.WorkflowExecutor we) {
        return Modifier.getModifier((String)"INTERACTIVE_MODIFIER", (List)we.getModifiers()) != null;
    }

    static {
        defaultValues.put(Integer.class, new Integer(0));
        defaultValues.put(Integer.TYPE, new Integer(0));
        defaultValues.put(Long.class, new Long(0L));
        defaultValues.put(Long.TYPE, new Long(0L));
        defaultValues.put(Short.class, new Short(0));
        defaultValues.put(Short.TYPE, new Short(0));
        defaultValues.put(Character.class, new Character('\u0000'));
        defaultValues.put(Character.TYPE, new Character('\u0000'));
        defaultValues.put(Byte.class, new Byte(0));
        defaultValues.put(Byte.TYPE, new Byte(0));
        defaultValues.put(Boolean.class, new Boolean(false));
        defaultValues.put(Boolean.TYPE, new Boolean(false));
        defaultValues.put(Float.class, new Float(0.0f));
        defaultValues.put(Float.TYPE, new Float(0.0f));
        defaultValues.put(Double.class, new Double(0.0));
        defaultValues.put(Double.TYPE, new Double(0.0));
    }
}

