/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.WatchDog;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.ontology.ExecutorInfo;
import com.tilab.wade.performer.ontology.SubflowInfo;
import com.tilab.wade.performer.transaction.SubflowEntry;
import com.tilab.wade.performer.transaction.TransactionEntry;
import com.tilab.wade.performer.transaction.TransactionManager;
import jade.core.behaviours.Behaviour;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.io.Serializable;
import java.util.Date;

public class ExecutorsTable
implements Serializable {
    private Map executors = new HashMap();

    public synchronized void insert(WorkflowEngineAgent.WorkflowExecutor executor) {
        this.executors.put((Object)executor.getId(), (Object)executor);
    }

    public synchronized WorkflowEngineAgent.WorkflowExecutor get(String id) {
        return (WorkflowEngineAgent.WorkflowExecutor)((Object)this.executors.get((Object)id));
    }

    public synchronized WorkflowEngineAgent.WorkflowExecutor remove(String id) {
        return (WorkflowEngineAgent.WorkflowExecutor)((Object)this.executors.remove((Object)id));
    }

    public synchronized boolean contains(String id) {
        return this.executors.containsKey((Object)id);
    }

    public int size() {
        return this.executors.size();
    }

    public int suspendedCnt() {
        int cnt = 0;
        for (WorkflowEngineAgent.WorkflowExecutor we : this.executors.values()) {
            if (we.getStatus() != 5) continue;
            ++cnt;
        }
        return cnt;
    }

    boolean belongsToRunningSession(WorkflowEngineAgent.WorkflowExecutor executor) {
        String sessionId = executor.getDescriptor().getSessionId();
        if (sessionId != null) {
            for (WorkflowEngineAgent.WorkflowExecutor we : this.executors.values()) {
                WorkflowDescriptor wd = we.getDescriptor();
                if (!sessionId.equals(wd.getSessionId()) || we.getStatus() == 0 || we.getStatus() == 5) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized List getPendingExecutors(String sessionId, Date sessionStartup) {
        ArrayList l = new ArrayList();
        for (WorkflowEngineAgent.WorkflowExecutor we : this.executors.values()) {
            WorkflowDescriptor wd = we.getDescriptor();
            if (!sessionId.equals(wd.getSessionId()) || sessionStartup.equals(wd.getSessionStartup())) continue;
            l.add((Object)we);
        }
        return l;
    }

    public synchronized List getStatus() {
        ArrayList result = new ArrayList();
        for (WorkflowEngineAgent.WorkflowExecutor we : this.executors.values()) {
            ExecutorInfo info = this.getExecutorInfo(we);
            result.add((Object)info);
        }
        return result;
    }

    public synchronized List getStatus(String sessionId) {
        ArrayList result = new ArrayList();
        for (WorkflowEngineAgent.WorkflowExecutor we : this.executors.values()) {
            if (!sessionId.equals(we.getDescriptor().getSessionId())) continue;
            ExecutorInfo info = this.getExecutorInfo(we);
            result.add((Object)info);
        }
        return result;
    }

    private ExecutorInfo getExecutorInfo(WorkflowEngineAgent.WorkflowExecutor we) {
        TransactionManager tm;
        ExecutorInfo info = new ExecutorInfo(we.getId());
        WorkflowDescriptor wd = we.getDescriptor();
        info.setSessionId(wd.getSessionId());
        info.setDelegationChain(wd.getDelegationChain());
        info.setExecutorStatus(we.getStatus());
        Behaviour b = we.getCurrent();
        if (b != null) {
            info.setExecutorFSMState(b.getBehaviourName());
        }
        if ((b = we.getWorkflow().getCurrent()) != null) {
            info.setWorkflowFSMState(b.getBehaviourName());
        }
        info.setAbortCondition(we.getAbortCondition());
        WatchDog watchDog = we.getWatchDog();
        if (watchDog != null) {
            info.setWatchDogExpired(new Boolean(watchDog.isExpired()));
            info.setWatchDogStartTime(new Date(watchDog.getStartTime()));
            info.setWatchDogWakeupTime(new Date(watchDog.getWakeupTime()));
        }
        if ((tm = we.getTransactionManager()) != null) {
            java.util.List subflows = tm.getEntries(TransactionEntry.SUBFLOW_TYPE, null);
            ArrayList subflowInfos = new ArrayList();
            if (subflows != null) {
                for (int i = 0; i < subflows.size(); ++i) {
                    subflowInfos.add((Object)this.getSubflowInfo((SubflowEntry)subflows.get(i)));
                }
            }
            info.setSubflows((List)subflowInfos);
        }
        return info;
    }

    private SubflowInfo getSubflowInfo(SubflowEntry entry) {
        SubflowInfo info = new SubflowInfo(entry.getId());
        info.setDelegatedPerformer(entry.getDelegatedPerformer());
        info.setExecutionId(entry.getExecutionId());
        info.setStatus(entry.getStatus());
        return info;
    }
}

