/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.WorkflowBehaviour;
import jade.util.Logger;
import jade.util.leap.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodInvocator
implements Serializable {
    protected WorkflowBehaviour owner;
    private String methodName;
    private transient Method method;
    private Object param;
    private Class paramClass;
    private boolean optional = false;
    private boolean optionalMethodNotPresent = false;
    private Logger myLogger;

    public MethodInvocator(WorkflowBehaviour owner, String methodName) {
        this(owner, methodName, null, null);
    }

    public MethodInvocator(WorkflowBehaviour owner, String methodName, Object param, Class paramClass) {
        this.owner = owner;
        this.methodName = methodName;
        this.param = param;
        this.paramClass = paramClass;
        this.myLogger = Logger.getMyLogger((String)MethodInvocator.class.getName());
    }

    public void setOptional() {
        this.optional = true;
    }

    public Object invoke() throws Exception {
        if (this.optionalMethodNotPresent) {
            return null;
        }
        if (this.method == null) {
            try {
                this.method = this.getMethod(this.methodName);
            }
            catch (NoSuchMethodException nsme) {
                if (this.optional) {
                    this.optionalMethodNotPresent = true;
                    return null;
                }
                throw nsme;
            }
        }
        Object[] params = this.getMethodParams();
        if (this.myLogger.isLoggable(Logger.FINEST)) {
            this.myLogger.log(Logger.FINEST, "Invoking method " + this.method.getName());
        }
        try {
            return this.method.invoke((Object)this.owner, params);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    protected Object[] getMethodParams() {
        Object[] objectArray;
        if (this.param != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.param;
        } else {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    protected Class[] getMethodParamTypes() {
        if (this.paramClass != null) {
            return new Class[]{this.paramClass};
        }
        if (this.param != null) {
            return new Class[]{this.param.getClass()};
        }
        return new Class[0];
    }

    private Method getMethod(String methodName) throws NoSuchMethodException {
        Class[] paramTypes = this.getMethodParamTypes();
        return this.owner.getMethod(methodName, paramTypes);
    }
}

