/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.RestException;
import com.tilab.wade.performer.RestServiceInvocationBehaviour;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.rest.MethodDescriptor;
import com.tilab.wade.performer.descriptors.rest.ResourceBaseDescriptor;
import com.tilab.wade.performer.descriptors.rest.ResourceDescriptor;
import com.tilab.wade.performer.descriptors.rest.RestDescriptor;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.onto.Ontology;
import jade.content.schema.ObjectSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestService
extends BuildingBlock {
    private transient RestDescriptor descriptor;
    private WorkflowBehaviour owner;
    private String descriptorClassName;
    private String baseUri;
    private String resourceId;
    private String methodId;
    private String requestMediaTypeElement;
    private String responseMediaTypeElement;
    private String faultMediaTypeElement;
    private int timeout;
    private String endpointAddress;
    private Map<String, Object> templateParameters = new HashMap<String, Object>();
    private Map<String, Object> matrixParameters = new HashMap<String, Object>();
    private Map<String, Object> headerParameters = new HashMap<String, Object>();
    private Map<String, Object> queryParameters = new HashMap<String, Object>();
    private Map<String, Object> bodyParameters = new HashMap<String, Object>();
    private Map<String, Object> httpParameters = new HashMap<String, Object>();

    public RestService(WorkflowBehaviour owner, RestServiceInvocationBehaviour activity) {
        super(activity);
        this.owner = owner;
        this.timeout = -1;
    }

    public String getDescriptorClassName() {
        return this.descriptorClassName;
    }

    public void setDescriptorClassName(String descriptorClassName) {
        this.descriptorClassName = descriptorClassName;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public void setMethodId(String methodId) {
        this.methodId = methodId;
    }

    public String getRequestMediaTypeElement() {
        return this.requestMediaTypeElement;
    }

    public void setRequestMediaTypeElement(String requestMediaTypeElement) {
        this.requestMediaTypeElement = requestMediaTypeElement;
    }

    public String getResponseMediaTypeElement() {
        return this.responseMediaTypeElement;
    }

    public void setResponseMediaTypeElement(String responseMediaTypeElement) {
        this.responseMediaTypeElement = responseMediaTypeElement;
    }

    public String getFaultMediaTypeElement() {
        return this.faultMediaTypeElement;
    }

    public void setFaultMediaTypeElement(String faultMediaTypeElement) {
        this.faultMediaTypeElement = faultMediaTypeElement;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public WorkflowBehaviour getOwner() {
        return this.owner;
    }

    RestDescriptor getDescriptor() throws Exception {
        if (this.descriptor == null) {
            ClassLoader wcl = CAServices.getInstance(this.owner.getAgent()).getDefaultClassLoader();
            this.descriptor = (RestDescriptor)Class.forName(this.descriptorClassName, true, wcl).newInstance();
        }
        return this.descriptor;
    }

    public void invoke() throws Exception {
        RestDescriptor restDescriptor;
        try {
            restDescriptor = this.getDescriptor();
        }
        catch (Exception e) {
            throw new RestException("No descriptor found (" + this.descriptorClassName + ")", e);
        }
        restDescriptor.invoke(this);
    }

    public final void fillBody(String key, Object value) {
        this.bodyParameters.put(key, value);
    }

    public final Object extractBody(String key) {
        return this.bodyParameters.get(key);
    }

    public final void fillTemplate(String key, Object value) {
        this.templateParameters.put(key, value);
    }

    public final Object extractTemplate(String key) {
        return this.templateParameters.get(key);
    }

    public final void fillMatrix(String key, Object value) {
        this.matrixParameters.put(key, value);
    }

    public final Object extractMatrix(String key) {
        return this.matrixParameters.get(key);
    }

    public final void fillHeader(String key, Object value) {
        this.headerParameters.put(key, value);
    }

    public final Object extractHeader(String key) {
        return this.headerParameters.get(key);
    }

    public final void fillQuery(String key, Object value) {
        this.queryParameters.put(key, value);
    }

    public final Object extractQuery(String key) {
        return this.queryParameters.get(key);
    }

    public final void fillHttp(String key, Object value) {
        this.httpParameters.put(key, value);
    }

    public final Object extractHttp(String key) {
        return this.httpParameters.get(key);
    }

    @Override
    public void reset() {
        this.templateParameters.clear();
        this.matrixParameters.clear();
        this.headerParameters.clear();
        this.queryParameters.clear();
        this.httpParameters.clear();
        this.bodyParameters.clear();
    }

    public Map<String, Object> getTemplateParameters() {
        return this.templateParameters;
    }

    private MethodDescriptor getMethodDescriptor() {
        try {
            ResourceBaseDescriptor rbd = this.getDescriptor().getResourceBase(this.baseUri);
            if (rbd == null) {
                throw new RuntimeException("The resource base cannot be obtained out of the given base uri " + this.baseUri);
            }
            ResourceDescriptor rd = rbd.getResource(this.resourceId);
            if (rd == null) {
                throw new RuntimeException("The given resource (" + this.resourceId + ") does not exist");
            }
            MethodDescriptor md = rd.getMethod(this.methodId);
            if (md == null) {
                throw new RuntimeException("The given method (" + this.methodId + ") does not exist");
            }
            return md;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean requireAbsParameters() {
        return false;
    }

    @Override
    protected Ontology createOntology() throws Exception {
        return this.getDescriptor().getOntology();
    }

    @Override
    public AbsObject createAbsTemplate(String key) throws Exception {
        Parameter param = this.getParameter(key);
        if (param != null) {
            return AbsHelper.createAbsTemplate((ObjectSchema)param.getSchema());
        }
        throw new Exception("No abs schema found for key " + key);
    }

    private Parameter getParameter(List<Parameter> params, String name) {
        for (Parameter param : params) {
            if (!param.getName().equalsIgnoreCase(name)) continue;
            return param;
        }
        return null;
    }

    private Parameter getParameter(String key) {
        int sepPos = key.indexOf(".");
        String prefix = key.substring(0, sepPos);
        String name = key.substring(sepPos + 1);
        if (prefix.equalsIgnoreCase("header")) {
            return this.getParameter(this.getMethodDescriptor().getHeaderParameters(), name);
        }
        if (prefix.equalsIgnoreCase("template")) {
            return this.getParameter(this.getMethodDescriptor().getTemplateParameters(), name);
        }
        if (prefix.equalsIgnoreCase("matrix")) {
            return this.getParameter(this.getMethodDescriptor().getMatrixParameters(), name);
        }
        if (prefix.equalsIgnoreCase("query")) {
            return this.getParameter(this.getMethodDescriptor().getQueryParameters(), name);
        }
        if (prefix.equalsIgnoreCase("http")) {
            return this.getParameter(this.getMethodDescriptor().getHttpParameters(), name);
        }
        if (prefix.equalsIgnoreCase("body")) {
            if (name.equalsIgnoreCase("request")) {
                return this.getMethodDescriptor().getRequestBody(this.requestMediaTypeElement);
            }
            if (name.equalsIgnoreCase("response")) {
                return this.getMethodDescriptor().getResponseBody(this.responseMediaTypeElement);
            }
        }
        if (prefix.equalsIgnoreCase("fault")) {
            return this.getMethodDescriptor().getFaultBody(Long.parseLong(name), this.faultMediaTypeElement);
        }
        return null;
    }

    private List<String> getParameterNames(List<Parameter> params, int mode, String prefix) {
        ArrayList<String> names = new ArrayList<String>();
        for (Parameter param : params) {
            if (param.getMode() != mode && param.getMode() != 2) continue;
            names.add(prefix + "." + param.getName());
        }
        return names;
    }

    @Override
    public List<String> getInputParameterNames() {
        ArrayList<String> inputs = new ArrayList<String>();
        inputs.addAll(this.getParameterNames(this.getMethodDescriptor().getHeaderParameters(), 0, "header"));
        inputs.addAll(this.getParameterNames(this.getMethodDescriptor().getTemplateParameters(), 0, "template"));
        inputs.addAll(this.getParameterNames(this.getMethodDescriptor().getMatrixParameters(), 0, "matrix"));
        inputs.addAll(this.getParameterNames(this.getMethodDescriptor().getQueryParameters(), 0, "query"));
        inputs.addAll(this.getParameterNames(this.getMethodDescriptor().getHttpParameters(), 0, "http"));
        if (this.getMethodDescriptor().getRequestBody(this.requestMediaTypeElement) != null) {
            inputs.add("body.request");
        }
        return inputs;
    }

    @Override
    public List<String> getOutputParameterNames() {
        ArrayList<String> outputs = new ArrayList<String>();
        outputs.addAll(this.getParameterNames(this.getMethodDescriptor().getHeaderParameters(), 1, "header"));
        outputs.addAll(this.getParameterNames(this.getMethodDescriptor().getHttpParameters(), 1, "http"));
        if (this.getMethodDescriptor().getResponseBody(this.responseMediaTypeElement) != null) {
            outputs.add("body.response");
        }
        for (Long faultStatus : this.getMethodDescriptor().getFaultStatus()) {
            outputs.add("fault." + faultStatus.toString());
        }
        return outputs;
    }

    @Override
    public Parameter getInputParameter(String key) {
        Parameter param = this.getParameter(key);
        if (param.getMode() == 0 || param.getMode() == 2) {
            return param;
        }
        return null;
    }

    @Override
    public Parameter getOutputParameter(String key) {
        Parameter param = this.getParameter(key);
        if (param.getMode() == 1 || param.getMode() == 2) {
            return param;
        }
        return null;
    }

    private Object getValue(String key) {
        int sepPos = key.indexOf(".");
        String prefix = key.substring(0, sepPos);
        String name = key.substring(sepPos + 1);
        if (prefix.equalsIgnoreCase("header")) {
            return this.extractHeader(name);
        }
        if (prefix.equalsIgnoreCase("template")) {
            return this.extractTemplate(name);
        }
        if (prefix.equalsIgnoreCase("matrix")) {
            return this.extractMatrix(name);
        }
        if (prefix.equalsIgnoreCase("query")) {
            return this.extractQuery(name);
        }
        if (prefix.equalsIgnoreCase("http")) {
            return this.extractHttp(name);
        }
        if (prefix.equalsIgnoreCase("body")) {
            return this.extractBody(name);
        }
        if (prefix.equalsIgnoreCase("fault")) {
            return this.extractBody(name);
        }
        return null;
    }

    @Override
    public Object getInput(String key) {
        return this.getValue(key);
    }

    @Override
    public Object getOutput(String key) {
        return this.getValue(key);
    }

    private void setValue(String key, Object value) {
        int sepPos = key.indexOf(".");
        String prefix = key.substring(0, sepPos);
        String name = key.substring(sepPos + 1);
        if (prefix.equalsIgnoreCase("header")) {
            this.fillHeader(name, value);
        } else if (prefix.equalsIgnoreCase("template")) {
            this.fillTemplate(name, value);
        } else if (prefix.equalsIgnoreCase("matrix")) {
            this.fillMatrix(name, value);
        } else if (prefix.equalsIgnoreCase("query")) {
            this.fillQuery(name, value);
        } else if (prefix.equalsIgnoreCase("http")) {
            this.fillHttp(name, value);
        } else if (prefix.equalsIgnoreCase("body")) {
            this.fillBody(name, value);
        } else if (prefix.equalsIgnoreCase("fault")) {
            this.fillBody(name, value);
        }
    }

    @Override
    public void setInput(String key, Object value) {
        this.setValue(key, value);
    }

    @Override
    public void setOutput(String key, Object value) {
        this.setValue(key, value);
    }

    @Override
    public boolean isInputEmpty(String key) {
        int sepPos = key.indexOf(".");
        String prefix = key.substring(0, sepPos);
        String name = key.substring(sepPos + 1);
        if (prefix.equalsIgnoreCase("header")) {
            return !this.headerParameters.containsKey(name);
        }
        if (prefix.equalsIgnoreCase("template")) {
            return !this.templateParameters.containsKey(name);
        }
        if (prefix.equalsIgnoreCase("matrix")) {
            return !this.matrixParameters.containsKey(name);
        }
        if (prefix.equalsIgnoreCase("query")) {
            return !this.queryParameters.containsKey(name);
        }
        if (prefix.equalsIgnoreCase("http")) {
            return !this.httpParameters.containsKey(name);
        }
        if (prefix.equalsIgnoreCase("body")) {
            return !this.bodyParameters.containsKey(name);
        }
        if (prefix.equalsIgnoreCase("fault")) {
            return !this.bodyParameters.containsKey(name);
        }
        return true;
    }
}

