/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.ontology.WorkflowDetails;
import com.tilab.wade.commons.ontology.GetCurrentLoad;
import com.tilab.wade.commons.ontology.WadeManagementOntology;
import com.tilab.wade.performer.DelegationChainElement;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.ontology.WorkflowManagementOntology;
import com.tilab.wade.utils.DFUtils;
import com.tilab.wade.wsma.ontology.SerializedStateChanged;
import com.tilab.wade.wsma.ontology.Started;
import com.tilab.wade.wsma.ontology.StatusChanged;
import com.tilab.wade.wsma.ontology.Terminated;
import com.tilab.wade.wsma.ontology.Thawed;
import com.tilab.wade.wsma.ontology.WorkflowExecutionInfo;
import com.tilab.wade.wsma.ontology.WorkflowStatusOntology;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.Predicate;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Serializable;
import java.util.List;
import java.util.logging.Level;

class StatusManager
implements Serializable {
    private static final long serialVersionUID = -5152409003723640917L;
    protected Logger myLogger = Logger.getMyLogger((String)StatusManager.class.getName());
    private static final String WSMA_POLICY_ATTRIBUTE = "WsmaPolicy";
    private static final String DEFAULT_WSMA_POLICY = WsmaPolicyType.CURRENT_LOAD.name();
    private static final String GET_CURRENT_LOAD_TIMEOUT_ATTRIBUTE = "GetCurrentLoadTimeout";
    private static final long DEFAULT_GET_CURRENT_LOAD_TIMEOUT = 5000L;
    private WsmaPolicyType wsmaPolicyType;
    private long getCurrentLoadTimeout;
    private AID[] wsmaAids;
    private int currentAidIndex = 0;
    private WorkflowEngineAgent workflowEngineAgent;
    private Ontology onto = WorkflowStatusOntology.getInstance();

    public StatusManager(WorkflowEngineAgent workflowEngineAgent) {
        String requireWSMAStr;
        this.workflowEngineAgent = workflowEngineAgent;
        String wsmaPolicyTypeAttribute = workflowEngineAgent.getArgument(WSMA_POLICY_ATTRIBUTE, null);
        if (wsmaPolicyTypeAttribute == null) {
            wsmaPolicyTypeAttribute = workflowEngineAgent.getTypeProperty(WSMA_POLICY_ATTRIBUTE, DEFAULT_WSMA_POLICY);
        }
        this.wsmaPolicyType = WsmaPolicyType.valueOf(wsmaPolicyTypeAttribute);
        this.getCurrentLoadTimeout = workflowEngineAgent.getLongArgument(GET_CURRENT_LOAD_TIMEOUT_ATTRIBUTE, -1L);
        if (this.getCurrentLoadTimeout == -1L) {
            this.getCurrentLoadTimeout = workflowEngineAgent.getLongTypeProperty(GET_CURRENT_LOAD_TIMEOUT_ATTRIBUTE, 5000L);
        }
        boolean requireWSMA = (requireWSMAStr = workflowEngineAgent.getArgument("RequireWSMA", null)) != null ? ((Boolean)BasicOntology.adjustPrimitiveValue((Object)requireWSMAStr, Boolean.class)).booleanValue() : workflowEngineAgent.getBooleanTypeProperty("RequireWSMA", false);
        long wsmaSearchTimeout = workflowEngineAgent.getLongArgument("WSMASearchTimeout", -1L);
        if (wsmaSearchTimeout == -1L) {
            wsmaSearchTimeout = workflowEngineAgent.getLongTypeProperty("WSMASearchTimeout", 10000L);
        }
        long startTime = System.currentTimeMillis();
        do {
            try {
                DFAgentDescription[] dfds = DFUtils.searchAllByType((Agent)workflowEngineAgent, (String)"Workflow Status Manager Agent", null);
                this.wsmaAids = DFUtils.getAIDs((DFAgentDescription[])dfds);
                if (this.wsmaAids.length > 0) break;
                Thread.sleep(500L);
            }
            catch (Exception e) {
                if (!this.myLogger.isLoggable(Logger.WARNING)) continue;
                this.myLogger.log(Logger.WARNING, "Error searching WSMA agents into DF.", (Throwable)e);
            }
        } while (System.currentTimeMillis() - startTime < wsmaSearchTimeout);
        if (this.wsmaAids.length > 0) {
            workflowEngineAgent.getContentManager().registerOntology(this.onto);
            workflowEngineAgent.getContentManager().registerOntology(WorkflowManagementOntology.getInstance());
        } else {
            if (requireWSMA) {
                throw new RuntimeException("Agent " + workflowEngineAgent.getName() + " require workflow status manager agent but it is not available!");
            }
            if (this.myLogger.isLoggable(Logger.WARNING)) {
                this.myLogger.log(Logger.WARNING, "Workflow status manager agents not available but not required. Workflow persistence functions are disabled.");
            }
        }
    }

    public void notifyStarted(WorkflowEngineAgent.WorkflowExecutor wfExecutor) {
        AID wsmaAid = this.getWSMA();
        if (wsmaAid != null) {
            String dc;
            wfExecutor.setWSMA(wsmaAid);
            WorkflowDescriptor wd = wfExecutor.getDescriptor();
            WorkflowBehaviour wb = wfExecutor.getWorkflow();
            WorkflowDetails wDetail = wb.getDetails();
            WorkflowExecutionInfo wei = new WorkflowExecutionInfo();
            wei.setExecutionId(wfExecutor.getId());
            wei.setRequester(wd.getRequester());
            wei.setExecutorName(this.workflowEngineAgent.getAID().getName());
            wei.setSessionId(wd.getSessionId());
            wei.setLongRunning(wb.isLongRunning());
            wei.setTransactional(wd.getTransactional());
            wei.setInteractive(EngineHelper.isInteractive(wfExecutor));
            wei.setStatus(WorkflowExecutionInfo.WorkflowStatus.ACTIVE);
            wei.setWorkflowId(wd.getId());
            wei.setName(wDetail.getName());
            wei.setDocumentation(wDetail.getDocumentation());
            if (wd.getParameters() != null) {
                wei.setWadeParameters(((ArrayList)wd.getParameters()).toList());
            }
            if ((dc = wd.getDelegationChain()) != null) {
                DelegationChainElement[] delegationChainArray = DelegationChainElement.parseDelegationChain(dc);
                DelegationChainElement dce = delegationChainArray[delegationChainArray.length - 1];
                wei.setParentExecutionid(dce.getExecutionId());
            }
            this.sendStatusNotification(wsmaAid, (Predicate)new Started(wei));
        }
    }

    public void notifyThawed(WorkflowEngineAgent.WorkflowExecutor wfExecutor) {
        AID wsmaAid = this.getWSMA();
        if (wsmaAid != null) {
            wfExecutor.setWSMA(wsmaAid);
            String executionId = wfExecutor.getId();
            String executorName = wfExecutor.getWorkflow().getAgent().getName();
            this.sendStatusNotification(wsmaAid, (Predicate)new Thawed(executionId, executorName));
        }
    }

    public void notifyTerminated(WorkflowEngineAgent.WorkflowExecutor wfExecutor, jade.util.leap.List wadeParameters, String errorMessage) {
        AID wsmaAid = wfExecutor.getWSMA();
        if (wsmaAid != null) {
            String executionId = wfExecutor.getId();
            List parameters = new java.util.ArrayList();
            if (wadeParameters != null) {
                parameters = ((ArrayList)wadeParameters).toList();
            }
            this.sendStatusNotification(wsmaAid, (Predicate)new Terminated(executionId, parameters, errorMessage));
        }
    }

    public void notifySerializedStateChanged(WorkflowEngineAgent.WorkflowExecutor wfExecutor, byte[] serializedState) {
        AID wsmaAid = wfExecutor.getWSMA();
        if (wsmaAid != null) {
            String executionId = wfExecutor.getId();
            String currentActivity = wfExecutor.getWorkflow().getCurrent().getBehaviourName();
            this.sendStatusNotification(wsmaAid, (Predicate)new SerializedStateChanged(executionId, currentActivity, serializedState), true);
        }
    }

    public void notifyStatusChanged(WorkflowEngineAgent.WorkflowExecutor wfExecutor, WorkflowExecutionInfo.WorkflowStatus status) {
        AID wsmaAid = wfExecutor.getWSMA();
        if (wsmaAid != null) {
            String executionId = wfExecutor.getId();
            this.sendStatusNotification(wsmaAid, (Predicate)new StatusChanged(executionId, status));
        }
    }

    private AID getWSMA() {
        AID wsma = null;
        if (this.wsmaAids.length > 0) {
            if (this.wsmaPolicyType == WsmaPolicyType.ROUND_ROBIN) {
                wsma = this.getRoundRobinWsma();
            } else if (this.wsmaPolicyType == WsmaPolicyType.CURRENT_LOAD) {
                wsma = this.getLowerLoadWsma();
            } else {
                this.myLogger.log(Logger.WARNING, "Agent " + this.workflowEngineAgent.getName() + " - Wsma policy " + (Object)((Object)this.wsmaPolicyType) + " not supported");
            }
        }
        return wsma;
    }

    private AID getRoundRobinWsma() {
        AID wsmaAid = this.wsmaAids[this.currentAidIndex++ % this.wsmaAids.length];
        if (this.currentAidIndex >= this.wsmaAids.length) {
            this.currentAidIndex = 0;
        }
        return wsmaAid;
    }

    private AID getLowerLoadWsma() {
        AID smallerLoadWsma = null;
        int smallerLoadValue = -1;
        for (AID wsma : this.wsmaAids) {
            int currentLoad = this.getCurrentLoad(wsma);
            if (currentLoad == -1 || smallerLoadValue != -1 && currentLoad >= smallerLoadValue) continue;
            smallerLoadWsma = wsma;
            smallerLoadValue = currentLoad;
        }
        if (smallerLoadWsma == null) {
            smallerLoadWsma = this.getRoundRobinWsma();
        }
        return smallerLoadWsma;
    }

    private int getCurrentLoad(AID wsma) {
        Action action = new Action(wsma, (Concept)new GetCurrentLoad());
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(wsma);
        msg.setLanguage("fipa-sl");
        msg.setOntology(WadeManagementOntology.getInstance().getName());
        try {
            this.workflowEngineAgent.getContentManager().fillContent(msg, (ContentElement)action);
            ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.workflowEngineAgent, (ACLMessage)msg, (long)this.getCurrentLoadTimeout);
            if (reply != null) {
                Result r = (Result)this.workflowEngineAgent.getContentManager().extractContent(reply);
                return (Integer)r.getValue();
            }
            return -1;
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.workflowEngineAgent.getName() + " - Error getting current load from agent " + wsma.getName(), (Throwable)e);
            return -1;
        }
    }

    private void sendStatusNotification(AID wsmaAid, Predicate predicate) {
        this.sendStatusNotification(wsmaAid, predicate, false);
    }

    private void sendStatusNotification(AID wsmaAid, Predicate predicate, boolean useBinaryEncoding) {
        String languageName = useBinaryEncoding ? "LEAP" : "fipa-sl";
        ACLMessage inform = new ACLMessage(7);
        inform.setLanguage(languageName);
        inform.setOntology(this.onto.getName());
        inform.setProtocol("fipa-request");
        inform.addUserDefinedParameter("JADE-ignore-failure", "true");
        inform.addReceiver(wsmaAid);
        try {
            this.workflowEngineAgent.getContentManager().fillContent(inform, (ContentElement)predicate);
            this.myLogger.log(Logger.FINE, "Forwarding status notification " + predicate + " to agent " + wsmaAid);
            this.workflowEngineAgent.send(inform);
        }
        catch (Exception e) {
            this.myLogger.log(Level.SEVERE, "Error encoding status notification request", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WsmaPolicyType {
        ROUND_ROBIN,
        CURRENT_LOAD;

    }
}

