/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.HierarchyNode;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.onto.Ontology;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subflow
extends BuildingBlock {
    private String subflowId;
    private String performer;
    private boolean asynch = false;
    private boolean independent = false;
    private List params = new ArrayList();
    private String executionId;

    public Subflow(HierarchyNode activity) {
        this(null, activity);
    }

    public Subflow(String subflowId, HierarchyNode activity) {
        super(activity);
        this.subflowId = subflowId;
    }

    public void setActivity(HierarchyNode activity) {
        this.activity = activity;
    }

    public String getSubflowId() {
        return this.subflowId;
    }

    public void setSubflowId(String subflowId) {
        this.subflowId = subflowId;
    }

    public final void fill(String key, Object value) {
        Parameter p = new Parameter(value);
        p.setName(key);
        this.params.add((Object)p);
    }

    public final void fill(String key, int value) {
        this.fill(key, new Integer(value));
    }

    public final void fill(String key, long value) {
        this.fill(key, new Long(value));
    }

    public final void fill(String key, boolean value) {
        this.fill(key, new Boolean(value));
    }

    public final void fill(String key, float value) {
        this.fill(key, new Float(value));
    }

    public final void fill(String key, double value) {
        this.fill(key, new Double(value));
    }

    public final Object get(String key) {
        return this.extract(key);
    }

    public final Object extract(String key) {
        Object value = null;
        for (int i = 0; i < this.params.size(); ++i) {
            Parameter param = (Parameter)this.params.get(i);
            if (!param.getName().equals(key)) continue;
            if (Integer.TYPE.getName().equals(param.getType()) && param.getValue() instanceof Long) {
                param.setValue((Object)new Integer(((Long)param.getValue()).intValue()));
            } else if (Float.TYPE.getName().equals(param.getType()) && param.getValue() instanceof Double) {
                param.setValue((Object)new Float(((Double)param.getValue()).floatValue()));
            }
            value = param.getValue();
            break;
        }
        return value;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    public String getPerformer() {
        return this.performer;
    }

    public void setAsynch(boolean asynch) {
        this.asynch = asynch;
    }

    public boolean getAsynch() {
        return this.asynch;
    }

    public void setIndependent(boolean independent) {
        this.independent = independent;
    }

    public boolean getIndependent() {
        return this.independent;
    }

    List getParams() {
        return this.params;
    }

    void setParams(List params) {
        this.params = params;
    }

    WorkflowDescriptor getDescriptor() {
        WorkflowDescriptor dsc = new WorkflowDescriptor(this.subflowId, this.params);
        if (this.asynch && this.independent) {
            dsc.setExecution(1);
        }
        return dsc;
    }

    @Override
    public void reset() {
        this.params.clear();
    }

    private List getFormalParameters() {
        WorkflowBehaviour sb;
        try {
            sb = this.getSubflowBehaviour();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sb.getFormalParameters();
    }

    private Parameter getFormalDescriptor(String key, int mode) {
        List formalParams = this.getFormalParameters();
        for (Parameter p : formalParams) {
            if (!p.getName().equals(key) || p.getMode() != mode && p.getMode() != 2) continue;
            return p;
        }
        return null;
    }

    @Override
    public Parameter getInputParameter(String key) {
        return this.getFormalDescriptor(key, 0);
    }

    @Override
    public Parameter getOutputParameter(String key) {
        return this.getFormalDescriptor(key, 1);
    }

    @Override
    public AbsObject createAbsTemplate(String key) throws Exception {
        Class parameterClass = null;
        for (Parameter p : this.params) {
            if (!p.getName().equals(key)) continue;
            parameterClass = p.getTypeClass(false, this.getSubflowClassLoader());
        }
        if (parameterClass == null) {
            throw new Exception("Parameter class type not found for key " + key);
        }
        return AbsHelper.createAbsTemplate(parameterClass, (Ontology)this.getOntology());
    }

    @Override
    public Ontology createOntology() throws Exception {
        return this.getSubflowBehaviour().getOntology();
    }

    @Override
    public Object getInput(String key) {
        return this.extract(key);
    }

    @Override
    public Object getOutput(String key) {
        return this.extract(key);
    }

    private java.util.List<String> getParameterNames(int mode) {
        java.util.ArrayList<String> parameterNames = new java.util.ArrayList<String>();
        List formalParams = this.getFormalParameters();
        for (Parameter p : formalParams) {
            if (p.getMode() != mode && p.getMode() != 2) continue;
            parameterNames.add(p.getName());
        }
        return parameterNames;
    }

    @Override
    public java.util.List<String> getInputParameterNames() {
        return this.getParameterNames(0);
    }

    @Override
    public java.util.List<String> getOutputParameterNames() {
        return this.getParameterNames(1);
    }

    @Override
    public boolean isInputEmpty(String key) {
        for (Parameter p : this.params) {
            if (!p.getName().equals(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean requireAbsParameters() {
        return false;
    }

    @Override
    public void setInput(String key, Object value) {
        this.fill(key, value);
    }

    @Override
    public void setOutput(String key, Object value) {
        this.fill(key, value);
    }

    private ClassLoader getSubflowClassLoader() {
        WorkflowEngineAgent.WorkflowExecutor rootExecutor = (WorkflowEngineAgent.WorkflowExecutor)this.getActivity().root();
        String classLoaderIdentifier = rootExecutor.getDescriptor().getClassLoaderIdentifier();
        return CAServices.getInstance(this.getActivity().getAgent()).getClassLoader(classLoaderIdentifier);
    }

    private WorkflowBehaviour getSubflowBehaviour() throws Exception {
        WorkflowBehaviour wb;
        Class<?> subflowClass = Class.forName(this.subflowId, true, this.getSubflowClassLoader());
        try {
            wb = (WorkflowBehaviour)subflowClass.newInstance();
        }
        catch (InstantiationException e) {
            String actName = this.getActivity().getBehaviourName();
            Class[] argClass = new Class[]{String.class};
            Object[] arg = new Object[]{actName};
            Constructor<?> constructor = subflowClass.getConstructor(argClass);
            wb = (WorkflowBehaviour)constructor.newInstance(arg);
        }
        return wb;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getExecutionId() {
        return this.executionId;
    }
}

