/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.performer.ActivityBehaviour;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.FailedSubflow;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.Subflow;
import com.tilab.wade.performer.TerminationNotificationReceiver;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.ontology.ExecutionError;
import com.tilab.wade.performer.ontology.GenericError;
import com.tilab.wade.performer.ontology.NotificationError;
import jade.content.Predicate;
import jade.core.Agent;
import jade.domain.AMSService;
import jade.lang.acl.ACLMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubflowDelegationBehaviour
extends ActivityBehaviour {
    private MethodInvocator invocator;
    private Subflow subflow;
    private List<TerminationNotificationReceiver> asynchDelegations = new ArrayList<TerminationNotificationReceiver>();

    public SubflowDelegationBehaviour(String name, WorkflowBehaviour owner) {
        this(name, owner, true);
    }

    public SubflowDelegationBehaviour(String name, WorkflowBehaviour owner, boolean callExecuteMethod) {
        super(name, owner);
        this.subflow = new Subflow(this);
        String methodName = callExecuteMethod ? EngineHelper.activityName2Method(this.getBehaviourName()) : "performSubflow";
        EngineHelper.checkMethodName(methodName, "activity", name);
        this.invocator = new MethodInvocator(owner, methodName, this.subflow, Subflow.class);
    }

    public void setSubflow(String subflowId) {
        this.subflow.setSubflowId(subflowId);
    }

    public void setAsynch() {
        this.subflow.setAsynch(true);
    }

    public void setIndependent() {
        this.subflow.setIndependent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void action() {
        try {
            this.owner.enterInterruptableSection();
            this.invocator.invoke();
        }
        catch (InterruptedException ie) {
        }
        catch (Agent.Interrupted i) {
        }
        catch (ThreadDeath td) {
        }
        catch (Throwable t) {
            this.handleException(t);
            t.printStackTrace();
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.subflow.reset();
    }

    @Override
    public BuildingBlock getBuildingBlock(String id) {
        return this.subflow;
    }

    void addAsynchronousDelegation(TerminationNotificationReceiver recv) {
        this.asynchDelegations.add(recv);
        recv.setDelegationBehaviour(this);
    }

    void removeAsynchronousDelegation(TerminationNotificationReceiver recv) {
        this.asynchDelegations.remove((Object)recv);
    }

    Iterator<TerminationNotificationReceiver> getAllAsynchronousDelegations() {
        return this.asynchDelegations.iterator();
    }

    static void handleSubflowFailure(Agent agent, ACLMessage failure) throws Exception {
        if (failure.getSender().equals((Object)agent.getAMS())) {
            throw new FailedSubflow("Performer " + AMSService.getFailedReceiver((Agent)agent, (ACLMessage)failure).getName() + " does not exist");
        }
        if (failure.getSender().equals((Object)CAServices.getInstance(agent).getLocalCA())) {
            throw new FailedSubflow(failure.getContent());
        }
        Predicate p = (Predicate)agent.getContentManager().extractContent(failure);
        if (p instanceof NotificationError) {
            throw new FailedSubflow("Notification error received from delegated performer " + failure.getSender().getName());
        }
        if (p instanceof GenericError) {
            throw new FailedSubflow("Error loading workflow: " + ((GenericError)p).getReason());
        }
        if (p instanceof ExecutionError) {
            ExecutionError er = (ExecutionError)p;
            FailedSubflow fs = new FailedSubflow("|" + er.getReason());
            fs.setExecutionError(er);
            throw fs;
        }
        throw new FailedSubflow("Unknown error: " + p);
    }

    @Override
    public boolean requireSave() {
        return true;
    }

    Subflow getSubflow() {
        return this.subflow;
    }
}

