/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.ActivityBehaviour;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.Subflow;
import com.tilab.wade.performer.SubflowDelegationBehaviour;
import com.tilab.wade.performer.SubflowList;
import com.tilab.wade.performer.TerminationNotificationReceiver;
import com.tilab.wade.performer.WorkflowBehaviour;
import jade.core.Agent;
import jade.util.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubflowJoinBehaviour
extends ActivityBehaviour {
    public static final String BBINDEX_SEPARTOR = "#";
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int ANY = 0;
    public static final int ALL = 1;
    private int mode = 1;
    private int expectedCnt;
    private int completedCnt;
    private boolean finished = false;
    private List<AsynchronousFlow> asynchFlows = new ArrayList<AsynchronousFlow>();
    private MethodInvocator invocator;
    private SubflowList asyncSubflowMap;
    protected Logger myLogger = Logger.getMyLogger((String)TerminationNotificationReceiver.class.getName());

    public SubflowJoinBehaviour(String name, WorkflowBehaviour owner) {
        super(name, owner);
        this.asyncSubflowMap = new SubflowList();
        String methodName = EngineHelper.activityName2Method(this.getBehaviourName());
        EngineHelper.checkMethodName(methodName, "activity", name);
        this.invocator = new MethodInvocator(owner, methodName, this.asyncSubflowMap, SubflowList.class);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setTimeout(long timeout) {
    }

    public void addSubflowDelegationActivity(String activityName, int policy) {
        AsynchronousFlow af = new AsynchronousFlow(activityName, policy, this.asynchFlows.size());
        this.asynchFlows.add(af);
    }

    @Override
    public void onStart() {
        super.onStart();
        int validAsyncFlowsCnt = 0;
        for (AsynchronousFlow af : this.asynchFlows) {
            if (!af.bind()) continue;
            this.asyncSubflowMap.put(af.getName(), af.getPolicy());
            if (af.getPendingReceivers() <= 0) continue;
            ++validAsyncFlowsCnt;
        }
        this.expectedCnt = this.mode == 0 && validAsyncFlowsCnt != 0 ? 1 : validAsyncFlowsCnt;
        this.completedCnt = 0;
        for (AsynchronousFlow af : this.asynchFlows) {
            af.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void action() {
        try {
            this.owner.enterInterruptableSection();
            if (this.completedCnt == this.expectedCnt) {
                this.myLogger.log(Logger.INFO, ">>>>>>>> SJB " + this.getBehaviourName() + ": invoking activity callback method");
                this.invocator.invoke();
                this.finished = true;
            } else if (this.lastException != null) {
                this.finished = true;
            } else {
                this.myLogger.log(Logger.INFO, ">>>>>>>> SJB " + this.getBehaviourName() + ": suspending workflow");
                this.owner.suspend();
            }
        }
        catch (InterruptedException ie) {
        }
        catch (Agent.Interrupted i) {
        }
        catch (ThreadDeath td) {
        }
        catch (Throwable t) {
            this.handleException(t);
            t.printStackTrace();
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    @Override
    public boolean done() {
        return this.finished || this.isInterrupted();
    }

    @Override
    public int onEnd() {
        for (AsynchronousFlow af : this.asynchFlows) {
            af.clean();
        }
        this.myLogger.log(Logger.INFO, ">>>>>>>> SJB " + this.getBehaviourName() + ": terminated");
        return super.onEnd();
    }

    @Override
    public void reset() {
        this.finished = false;
        this.asyncSubflowMap.reset();
        super.reset();
    }

    @Override
    public BuildingBlock getBuildingBlock(String id) {
        BuildingBlock bb = null;
        int sepPos = id.indexOf(BBINDEX_SEPARTOR);
        if (sepPos > 0 && sepPos < id.length() - 1) {
            String actName = id.substring(0, sepPos);
            String indexStr = id.substring(sepPos + 1);
            try {
                int index = Integer.parseInt(indexStr);
                Object obj = this.asyncSubflowMap.get(actName);
                if (obj != null) {
                    if (obj instanceof Subflow) {
                        bb = (Subflow)obj;
                    } else {
                        List subflows = (List)obj;
                        try {
                            bb = (BuildingBlock)subflows.get(index);
                        }
                        catch (IndexOutOfBoundsException e) {}
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return bb;
    }

    private synchronized boolean handleAsynchronousFlowSuccess(AsynchronousFlow af, List<Subflow> flowResults) {
        if (this.completedCnt < this.expectedCnt && this.lastException == null) {
            ++this.completedCnt;
            for (Subflow subflow : flowResults) {
                subflow.setActivity(this);
            }
            this.asyncSubflowMap.put(af.getName(), af.getPolicy(), flowResults);
            if (this.completedCnt == this.expectedCnt) {
                this.myLogger.log(Logger.INFO, ">>>>>>>> SJB " + this.getBehaviourName() + ": all expected AsynchFlow-s completed successfully. Resuming workflow");
                this.owner.resume();
            }
            return true;
        }
        return false;
    }

    private synchronized boolean handleAsynchronousFlowFailure(AsynchronousFlow af, Exception exception) {
        if (this.completedCnt < this.expectedCnt && this.lastException == null) {
            this.handleException(exception);
            this.myLogger.log(Logger.INFO, ">>>>>>>> SJB " + this.getBehaviourName() + ": AsynchFlow-s " + af.getName() + " failed. Resuming workflow");
            this.owner.resume();
            return true;
        }
        return false;
    }

    @Override
    public boolean requireSave() {
        return true;
    }

    private class AsynchronousFlow
    implements Serializable,
    TerminationNotificationReceiver.TerminationListener {
        private String delegationActivityName;
        private int policy;
        private int index;
        private SubflowDelegationBehaviour delegationBehaviour;
        private List<TerminationNotificationReceiver> pendingReceivers = new ArrayList<TerminationNotificationReceiver>();
        private List<TerminationNotificationReceiver> completedReceivers = new ArrayList<TerminationNotificationReceiver>();
        private List<Subflow> flowResults;
        private int joinedCnt = 0;
        private boolean bound = true;

        AsynchronousFlow(String delegationActivityName, int policy, int index) {
            this.delegationActivityName = delegationActivityName;
            this.policy = policy;
            this.index = index;
        }

        boolean bind() {
            this.delegationBehaviour = (SubflowDelegationBehaviour)SubflowJoinBehaviour.this.owner.getState(this.delegationActivityName);
            if (this.delegationBehaviour != null) {
                this.flowResults = new ArrayList<Subflow>();
                Iterator<TerminationNotificationReceiver> it = this.delegationBehaviour.getAllAsynchronousDelegations();
                while (it.hasNext()) {
                    TerminationNotificationReceiver ter = it.next();
                    this.pendingReceivers.add(ter);
                }
            } else {
                this.bound = false;
            }
            return this.bound;
        }

        void init() {
            TerminationNotificationReceiver[] tt = this.pendingReceivers.toArray(new TerminationNotificationReceiver[0]);
            for (int i = 0; i < tt.length; ++i) {
                tt[i].registerListener(this);
            }
        }

        String getName() {
            return this.delegationActivityName;
        }

        int getPolicy() {
            return this.policy;
        }

        int getIndex() {
            return this.index;
        }

        int getJoinedCnt() {
            return this.index;
        }

        int getPendingReceivers() {
            return this.pendingReceivers.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clean() {
            int i;
            TerminationNotificationReceiver[] pp = null;
            TerminationNotificationReceiver[] cc = null;
            AsynchronousFlow asynchronousFlow = this;
            synchronized (asynchronousFlow) {
                pp = this.pendingReceivers.toArray(new TerminationNotificationReceiver[0]);
                this.pendingReceivers.clear();
                cc = this.completedReceivers.toArray(new TerminationNotificationReceiver[0]);
                this.completedReceivers.clear();
            }
            for (i = 0; i < pp.length; ++i) {
                pp[i].deregisterListener();
            }
            for (i = 0; i < cc.length; ++i) {
                cc[i].deregisterListener();
            }
            this.delegationBehaviour = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTermination(TerminationNotificationReceiver ter) {
            block12: {
                AsynchronousFlow asynchronousFlow = this;
                synchronized (asynchronousFlow) {
                    if (!this.pendingReceivers.remove((Object)ter)) {
                        return;
                    }
                    this.completedReceivers.add(ter);
                    SubflowJoinBehaviour.this.myLogger.log(Logger.INFO, ">>>>>>>> SJB " + SubflowJoinBehaviour.this.getBehaviourName() + ": received termination notification for delegation " + ter.getDelegationId() + " of AsynchFlow " + this.getName());
                }
                try {
                    this.flowResults.add(ter.getResult());
                    if (this.policy != 0 && !this.pendingReceivers.isEmpty()) break block12;
                    SubflowJoinBehaviour.this.myLogger.log(Logger.INFO, ">>>>>>>> SJB " + SubflowJoinBehaviour.this.getBehaviourName() + ": AsynchFlow " + this.getName() + " successfully completed");
                    if (SubflowJoinBehaviour.this.handleAsynchronousFlowSuccess(this, this.flowResults)) {
                        asynchronousFlow = this;
                        synchronized (asynchronousFlow) {
                            for (TerminationNotificationReceiver tt : this.completedReceivers) {
                                tt.setJoined();
                                ++this.joinedCnt;
                            }
                        }
                    }
                    this.clean();
                }
                catch (Exception e) {
                    SubflowJoinBehaviour.this.myLogger.log(Logger.INFO, ">>>>>>>> SJB " + SubflowJoinBehaviour.this.getBehaviourName() + ": AsynchFlow " + this.getName() + " failed due to failure of subflow " + ter.getDelegationId(), (Throwable)e);
                    if (SubflowJoinBehaviour.this.handleAsynchronousFlowFailure(this, e)) {
                        ter.setJoined();
                        ++this.joinedCnt;
                    }
                    this.clean();
                }
            }
        }
    }
}

