/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.BindingManager;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.HierarchyNode;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.OutgoingTransitions;
import com.tilab.wade.performer.Task;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.transaction.TaskEntry;
import com.tilab.wade.performer.transaction.TransactionManager;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.WrapperBehaviour;

public class TaskExecutionBehaviour
extends WrapperBehaviour
implements HierarchyNode {
    protected WorkflowBehaviour owner;
    private OutgoingTransitions outgoingTransitions;
    protected Throwable lastException = null;
    private boolean errorActivity = false;
    private boolean executed = false;
    private boolean reinitializing = false;
    private boolean interrupted = false;
    private BindingManager bindingManager;
    private boolean aborted = false;
    private Task task;
    private boolean hasDedicatedMethod;
    private static long taskEntryCnt = 0L;

    public TaskExecutionBehaviour(String name, Behaviour behaviour, WorkflowBehaviour owner) {
        this(name, behaviour, owner, true);
    }

    public TaskExecutionBehaviour(String name, Behaviour behaviour, WorkflowBehaviour owner, boolean hasDedicatedMethod) {
        super(behaviour);
        this.owner = owner;
        this.setBehaviourName(name.replace(' ', '_'));
        this.outgoingTransitions = new OutgoingTransitions();
        this.hasDedicatedMethod = hasDedicatedMethod;
        this.task = new Task(behaviour, this);
    }

    public void onStart() {
        this.owner.handleBeginActivity(this);
        try {
            this.copyInputParams();
            super.onStart();
        }
        catch (Exception e) {
            this.handleException(e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        try {
            this.owner.enterInterruptableSection();
            super.action();
            if (Thread.interrupted()) {
                throw new Agent.Interrupted();
            }
        }
        catch (Agent.Interrupted i) {
            this.aborted = true;
        }
        catch (ThreadDeath td) {
            this.aborted = true;
        }
        catch (Throwable t) {
            this.aborted = true;
            this.handleException(t);
            t.printStackTrace();
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    public boolean done() {
        return this.aborted || super.done();
    }

    public int onEnd() {
        try {
            super.onEnd();
            TransactionManager tm = this.owner.getTransactionManager();
            Behaviour b = this.getWrappedBehaviour();
            if (tm != null && TaskExecutionBehaviour.isTransactional(b)) {
                String entryId = TaskExecutionBehaviour.generateTaskEntryId(b.getBehaviourName());
                tm.addEntry(new TaskEntry(entryId, b, TaskExecutionBehaviour.getTransactionalFields(b)));
            }
            this.restoreOutputParams();
            return EngineHelper.endActivity(this);
        }
        catch (Exception e) {
            if (this.lastException == null) {
                this.handleException(e);
                e.printStackTrace();
            }
            return -1;
        }
    }

    public WorkflowBehaviour getOwner() {
        return this.owner;
    }

    public OutgoingTransitions getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    public boolean hasJADEDefaultTransition() {
        return this.owner.hasDefaultTransition(this.getBehaviourName());
    }

    public final void mark() {
        this.executed = true;
    }

    public final void reinit() {
        if (this.executed) {
            this.reinitializing = true;
            this.reset();
            this.reinitializing = false;
        }
    }

    public void reset() {
        this.lastException = null;
        this.executed = false;
        super.reset();
    }

    public void restart() {
        if (this.reinitializing) {
            this.myEvent.init(true, -1);
            this.handle(this.myEvent);
        } else {
            super.restart();
        }
    }

    public final WorkflowEngineAgent getAgent() {
        return (WorkflowEngineAgent)this.myAgent;
    }

    public final boolean isError() {
        return this.errorActivity;
    }

    public final void setError(boolean b) {
        this.errorActivity = b;
    }

    public final Throwable getLastException() {
        return this.lastException;
    }

    public void handleException(Throwable t) {
        this.lastException = t;
        EngineHelper.fireExecutionErrorEvent(this, this.lastException, 5);
    }

    public final void propagateException(Throwable t) {
        ((HierarchyNode)this.parent).handleException(t);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted() {
        this.interrupted = true;
    }

    public BindingManager getBindingManager() {
        if (this.bindingManager == null) {
            this.bindingManager = new BindingManager(this);
        }
        return this.bindingManager;
    }

    public BuildingBlock getBuildingBlock(String id) {
        return this.task;
    }

    private void copyInputParams() throws Exception {
        if (this.hasDedicatedMethod) {
            String methodName = EngineHelper.activityName2Method(this.getBehaviourName(), 1);
            EngineHelper.checkMethodName(methodName, "activity", this.getBehaviourName());
            MethodInvocator invocator = new MethodInvocator((WorkflowBehaviour)this.parent, methodName, this.task, Task.class);
            invocator.invoke();
        }
        this.owner.manageBindings(this.task);
        EngineHelper.copyInputParameters(this.getWrappedBehaviour(), this.task.getParams());
    }

    private void restoreOutputParams() throws Exception {
        EngineHelper.extractOutputParameters(this.getWrappedBehaviour(), this.task.getParams());
        if (this.hasDedicatedMethod) {
            String methodName = EngineHelper.activityName2Method(this.getBehaviourName(), 2);
            EngineHelper.checkMethodName(methodName, "activity", this.getBehaviourName());
            MethodInvocator invocator = new MethodInvocator((WorkflowBehaviour)this.parent, methodName, this.task, Task.class);
            invocator.invoke();
        }
    }

    public boolean requireSave() {
        return true;
    }

    public static WorkflowBehaviour getOwner(Behaviour b) {
        Behaviour root = b.root();
        if (root instanceof WorkflowEngineAgent.WorkflowExecutor) {
            return ((WorkflowEngineAgent.WorkflowExecutor)root).getWorkflow();
        }
        return null;
    }

    private static boolean isTransactional(Behaviour b) {
        return false;
    }

    private static DataStore getTransactionalFields(Behaviour b) {
        return new DataStore();
    }

    private static synchronized String generateTaskEntryId(String taskName) {
        String id = "T_" + taskName + '_' + taskEntryCnt;
        ++taskEntryCnt;
        return id;
    }
}

