/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.performer.FailedSubflow;
import com.tilab.wade.performer.Subflow;
import com.tilab.wade.performer.SubflowDelegationBehaviour;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.transaction.SubflowEntry;
import jade.content.ContentException;
import jade.content.onto.basic.Result;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;

public class TerminationNotificationReceiver
extends SimpleBehaviour {
    static final int RUNNING = 0;
    static final int SUCCESS = 1;
    static final int FAILURE = -1;
    static final int JOINED = 2;
    static final int ABORTED = 3;
    private WorkflowEngineAgent.WorkflowExecutor we;
    private String delegationId;
    private Subflow subflow;
    private SubflowEntry sbflEntry;
    private MessageTemplate template;
    private SubflowDelegationBehaviour delegationBehaviour;
    private String delegatedExecutionId;
    private volatile int status = 0;
    private Exception subflowException;
    private TerminationListener listener;
    protected Logger myLogger = Logger.getMyLogger((String)TerminationNotificationReceiver.class.getName());

    TerminationNotificationReceiver(WorkflowEngineAgent.WorkflowExecutor we, String delegatedExecutionId, String delegationId, String delegatedWorkflowId, MessageTemplate template, SubflowEntry sbflEntry) {
        this.we = we;
        this.setBehaviourName("TNR-" + we.getId() + "#" + delegationId);
        this.delegatedExecutionId = delegatedExecutionId;
        this.delegationId = delegationId;
        this.subflow = new Subflow(delegatedWorkflowId, null);
        this.sbflEntry = sbflEntry;
        if (sbflEntry != null) {
            this.sbflEntry.setTerminationNotificationReceiver(this);
        }
        this.template = template;
    }

    void setDelegationBehaviour(SubflowDelegationBehaviour delegationBehaviour) {
        this.delegationBehaviour = delegationBehaviour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        if (this.status == 0) {
            ACLMessage msg = this.myAgent.receive(this.template);
            if (msg != null) {
                this.handleTerminationNotification(msg);
            } else {
                this.block();
            }
        } else if (this.status == 1 || this.status == -1) {
            TerminationNotificationReceiver terminationNotificationReceiver = this;
            synchronized (terminationNotificationReceiver) {
                if (this.listener != null) {
                    this.listener.handleTermination(this);
                    this.listener = null;
                } else {
                    this.block();
                }
            }
        }
    }

    public boolean done() {
        return this.status == 2 || this.status == 3;
    }

    private void handleTerminationNotification(ACLMessage msg) {
        if (this.sbflEntry != null) {
            this.sbflEntry.setNotification(msg);
            this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + this.we.getId() + ": Set " + ACLMessage.getPerformative((int)msg.getPerformative()) + " notification to asynchronous Subflow Entry " + this.delegationId);
        }
        CAServices.getInstance(this.myAgent).expectedReplyReceived(msg);
        try {
            switch (msg.getPerformative()) {
                case 7: 
                case 11: {
                    Result r = (Result)this.myAgent.getContentManager().extractContent(msg);
                    this.subflow.setParams(r.getItems());
                    this.status = 1;
                    break;
                }
                case 6: {
                    SubflowDelegationBehaviour.handleSubflowFailure(this.myAgent, msg);
                }
                default: {
                    throw new FailedSubflow("Unexpected performative " + ACLMessage.getPerformative((int)msg.getPerformative()));
                }
            }
        }
        catch (Exception e) {
            this.status = -1;
            if (e instanceof ContentException) {
                this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + this.we.getId() + ": Error parsing termination notification of asynchronous Subflow " + this.delegationId, (Throwable)e);
            }
            this.subflowException = e;
        }
    }

    Subflow getResult() throws Exception {
        switch (this.status) {
            case 1: {
                return this.subflow;
            }
            case -1: {
                throw this.subflowException;
            }
        }
        throw new IllegalStateException("Wrong TerminationNotificationReceiver status " + this.status);
    }

    synchronized void registerListener(TerminationListener listener) {
        this.listener = listener;
        this.restart();
    }

    synchronized void deregisterListener() {
        this.listener = null;
    }

    void setJoined() {
        if (this.status != 2) {
            int sbfexitValue = this.status == 1 ? 0 : 1;
            ((WorkflowEngineAgent)this.myAgent).handleCompletedSubflow(this.we, this.delegatedExecutionId, sbfexitValue);
        }
        this.status = 2;
        this.delegationBehaviour.removeAsynchronousDelegation(this);
        this.restart();
    }

    public void abort() {
        this.status = 3;
        this.delegationBehaviour.removeAsynchronousDelegation(this);
        this.restart();
    }

    String getDelegationId() {
        return this.delegationId;
    }

    Subflow getSubflow() {
        return this.subflow;
    }

    static interface TerminationListener {
        public void handleTermination(TerminationNotificationReceiver var1);
    }
}

