/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.ActivityBehaviour;
import com.tilab.wade.performer.ApplicationList;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.event.ExecutionErrorEvent;
import com.tilab.wade.performer.event.WorkflowEvent;
import jade.core.Agent;

public class ToolExecutionBehaviour
extends ActivityBehaviour {
    private MethodInvocator invocator;
    private ApplicationList applications;

    public ToolExecutionBehaviour(String name, WorkflowBehaviour owner) {
        super(name, owner);
        this.applications = new ApplicationList(owner);
        String methodName = EngineHelper.activityName2Method(this.getBehaviourName());
        EngineHelper.checkMethodName(methodName, "activity", name);
        this.invocator = new MethodInvocator(owner, methodName, this.applications, ApplicationList.class);
    }

    public void addApplication(String applicationId) {
        this.applications.add(applicationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        try {
            this.owner.enterInterruptableSection();
            this.invocator.invoke();
        }
        catch (InterruptedException ie) {
        }
        catch (Agent.Interrupted i) {
        }
        catch (ThreadDeath td) {
        }
        catch (Throwable t) {
            this.handleException(t, this.applications.getCurrentApplication());
            t.printStackTrace();
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    public void reset() {
        super.reset();
        this.applications.reset();
    }

    public void handleException(Throwable t, String currentApplication) {
        this.lastException = t;
        WorkflowEngineAgent.WorkflowExecutor root = (WorkflowEngineAgent.WorkflowExecutor)this.root();
        String workflowName = root.getDescriptor().getId();
        ExecutionErrorEvent errorEvent = new ExecutionErrorEvent(workflowName, this.getBehaviourName(), currentApplication, this.lastException);
        root.getEventEmitter().fireEvent("warning", (WorkflowEvent)errorEvent, 5);
        root.setLastErrorEvent(errorEvent);
    }

    public boolean requireSave() {
        return true;
    }
}

