/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.event.EventEmitter;
import com.tilab.wade.performer.event.TraceEvent;
import com.tilab.wade.performer.event.WorkflowEvent;
import jade.core.Agent;
import java.io.Serializable;

public class Tracer
implements Serializable {
    private String sessionId;
    private EventEmitter eventEmitter;
    private String defaultAspect = null;

    public Tracer(String id, String sessionId, Agent a) {
        this.sessionId = sessionId;
        this.eventEmitter = new EventEmitter(a, id);
        this.eventEmitter.setControlInfo("tracing", null);
    }

    public Tracer(String id, String sessionId, String host, int port) {
    }

    Tracer(String sessionId, EventEmitter eventEmitter) {
        this.sessionId = sessionId;
        this.eventEmitter = eventEmitter;
    }

    public void setDefaultAspect(String aspect) {
        this.defaultAspect = aspect;
    }

    public void trace(String msg) {
        this.trace(3, msg, this.defaultAspect);
    }

    public void trace(String msg, String aspect) {
        this.trace(3, msg, aspect);
    }

    public void trace(int level, String msg) {
        this.trace(level, msg, this.defaultAspect);
    }

    public void trace(int level, String msg, String aspect) {
        TraceEvent ev = new TraceEvent(this.sessionId, msg, level, aspect);
        if (this.eventEmitter != null) {
            this.eventEmitter.fireEvent("tracing", (WorkflowEvent)ev, level);
        }
    }
}

