/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.eval.Condition;
import com.tilab.wade.performer.eval.MethodCondition;
import jade.util.leap.Serializable;

public class Transition
implements Serializable {
    private boolean defaultType;
    private boolean exceptionType;
    private int exitValue;
    private String source;
    private String destination;
    private Condition condition;

    public Transition() {
        this(1, null, null);
    }

    public Transition(String conditionName, WorkflowBehaviour owner) {
        this(0, conditionName, owner);
    }

    public Transition(Condition condition) {
        this(0, condition);
    }

    protected Transition(int type, Condition condition) {
        this.defaultType = type == 1 || type == 3;
        boolean bl = this.exceptionType = type == 2 || type == 3;
        if (!this.defaultType) {
            if (condition == null) {
                throw new IllegalArgumentException("Missing condition for transition of type " + type);
            }
            this.condition = condition;
        }
    }

    protected Transition(int type, String conditionName, WorkflowBehaviour owner) {
        this.defaultType = type == 1 || type == 3;
        boolean bl = this.exceptionType = type == 2 || type == 3;
        if (!this.defaultType) {
            if (conditionName == null) {
                throw new IllegalArgumentException("Missing condition name for transition of type " + type);
            }
            if (owner == null) {
                throw new IllegalArgumentException("Missing owner for transition of type " + type);
            }
            if (conditionName != null) {
                String methodName = EngineHelper.conditionName2Method(conditionName);
                EngineHelper.checkMethodName(methodName, "condition", conditionName);
                MethodInvocator invocator = this.createInvocator(owner, methodName);
                this.condition = new MethodCondition(conditionName, invocator);
            }
        }
    }

    protected MethodInvocator createInvocator(WorkflowBehaviour owner, String methodName) {
        return new MethodInvocator(owner, methodName);
    }

    public boolean evaluateCondition() throws Exception {
        boolean result = true;
        if (this.condition != null) {
            Boolean b = this.condition.evaluate();
            result = b;
        }
        return result;
    }

    final boolean isDefault() {
        return this.defaultType;
    }

    final boolean isException() {
        return this.exceptionType;
    }

    final int getExitValue() {
        return this.exitValue;
    }

    final void setExitValue(int v) {
        this.exitValue = v;
    }

    final void setDestination(String destination) {
        this.destination = destination;
    }

    final String getDestination() {
        return this.destination;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getConditionName() {
        return this.condition.toString();
    }

    public String toString() {
        return "[Transition from " + (this.source != null ? this.source : "???") + " to " + (this.destination != null ? this.destination : "???") + "]";
    }
}

