/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.event.EventOntology;
import com.tilab.wade.event.EventTemplate;
import com.tilab.wade.event.GenericEvent;
import com.tilab.wade.event.Match;
import com.tilab.wade.event.Occurred;
import com.tilab.wade.performer.BaseWaitBehaviour;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.EventTemplateBB;
import com.tilab.wade.performer.GenericEventBB;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.utils.DFUtils;
import com.tilab.wade.utils.GUIDGenerator;
import jade.content.ContentElement;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.ParallelBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class WaitEventBehaviour
extends BaseWaitBehaviour {
    private static final long serialVersionUID = 746786876L;
    private EventTemplateBB templateBB = new EventTemplateBB(new EventTemplate(), this);
    private GenericEventBB eventBB;
    private boolean timeoutExpired = false;
    private ACLMessage registrationMsg;
    private String registrationId;
    private boolean exclusive = false;
    private boolean futureEventsOnly = false;
    private transient EventReceiver eventReceiver;
    private long timeout;

    public WaitEventBehaviour(String name, WorkflowBehaviour owner) {
        this(name, owner, true);
    }

    public WaitEventBehaviour(String name, WorkflowBehaviour owner, boolean hasDedicatedMethods) {
        super(name, owner, hasDedicatedMethods);
    }

    public void setEventType(String eventType) {
        this.templateBB.getEventTemplate().setEventType(eventType);
    }

    public void setEventIdentificationExpression(String eventIdentificationExpression) {
        this.templateBB.getEventTemplate().setEventIdentificationExpression(eventIdentificationExpression);
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void setFutureEventsOnly(boolean futureEventsOnly) {
        this.futureEventsOnly = futureEventsOnly;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected MethodInvocator createBeforeMethodInvocator(String beforeMethodName) {
        return new MethodInvocator(this.owner, beforeMethodName, null, EventTemplate.class){
            private static final long serialVersionUID = 486345624L;

            protected Object[] getMethodParams() {
                return new Object[]{WaitEventBehaviour.this.templateBB.getEventTemplate()};
            }
        };
    }

    protected MethodInvocator createAfterMethodInvocator(String afterMethodName) {
        return new MethodInvocator(this.owner, afterMethodName, null, GenericEvent.class){
            private static final long serialVersionUID = 98795874L;

            protected Object[] getMethodParams() {
                return new Object[]{WaitEventBehaviour.this.timeoutExpired ? null : WaitEventBehaviour.this.eventBB.getGenericEvent()};
            }
        };
    }

    protected void manageBindings() throws Exception {
        this.owner.manageBindings(this.templateBB);
    }

    public BuildingBlock getBuildingBlock(String id) {
        if (EventTemplateBB.ID.equals(id)) {
            return this.templateBB;
        }
        if (GenericEventBB.ID.equals(id)) {
            return this.eventBB;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws Exception {
        this.registrationMsg = new ACLMessage(17);
        this.registrationMsg.setOntology(EventOntology.getInstance().getName());
        this.registrationMsg.setLanguage("fipa-sl");
        String convId = GUIDGenerator.getGUID();
        this.registrationMsg.setConversationId(convId);
        AID esa = DFUtils.getAID((DFAgentDescription)DFUtils.searchAnyByType((Agent)this.myAgent, (String)"Event System Agent", null));
        if (esa == null) throw new Exception("Event System Agent not found");
        this.registrationMsg.addReceiver(esa);
        Match match = new Match(this.templateBB.getEventTemplate(), this.owner.getExecutionId(), this.exclusive, this.futureEventsOnly);
        this.myAgent.getContentManager().fillContent(this.registrationMsg, (ContentElement)match);
        this.myAgent.send(this.registrationMsg);
        ACLMessage reply = this.myAgent.blockingReceive(MessageTemplate.MatchConversationId((String)convId), 60000L);
        if (reply == null) throw new Exception("No reply received from Event System Agent " + esa.getLocalName() + " in due time");
        switch (reply.getPerformative()) {
            case 7: {
                this.storeEvent(reply);
                return;
            }
            case 1: {
                this.registrationId = reply.getContent();
                this.eventReceiver = new EventReceiver(reply.getConversationId(), this.timeout);
                this.myAgent.addBehaviour((Behaviour)this.eventReceiver);
                return;
            }
            case 6: {
                this.handleFailure(reply);
            }
        }
    }

    public boolean checkCompleted() {
        return this.eventBB != null || this.timeoutExpired;
    }

    public void reset() {
        super.reset();
        this.templateBB.reset();
        this.eventBB = null;
        this.timeoutExpired = false;
        this.registrationMsg = null;
        this.registrationId = null;
    }

    private void storeEvent(ACLMessage inform) {
        if (inform.getContent() == null) {
            this.timeoutExpired = true;
        } else {
            try {
                Occurred occurred = (Occurred)this.myAgent.getContentManager().extractContent(inform);
                this.eventBB = new GenericEventBB((GenericEvent)occurred.getEvent(), this);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void handleFailure(ACLMessage failure) {
        if (failure.getSender().equals((Object)this.myAgent.getAMS())) {
            this.handleException(new Exception("Event System Agent does not exist"));
        } else {
            this.handleException(new Exception(failure.getContent()));
        }
    }

    private void handleTimeout() {
        this.timeoutExpired = true;
        this.cancelRegistration();
    }

    public void setInterrupted() {
        super.setInterrupted();
        this.cancelRegistration();
        if (this.eventReceiver != null) {
            this.myAgent.removeBehaviour((Behaviour)this.eventReceiver);
        }
    }

    private void cancelRegistration() {
        this.registrationMsg.setPerformative(2);
        this.registrationMsg.setContent(this.registrationId);
        this.myAgent.send(this.registrationMsg);
    }

    private class EventReceiver
    extends ParallelBehaviour {
        private static final long serialVersionUID = 234274750685L;
        private MessageTemplate msgTemplate;

        public EventReceiver(String convId, long timeout) {
            super(null, 1);
            this.msgTemplate = MessageTemplate.MatchConversationId((String)convId);
            this.addSubBehaviour((Behaviour)new SimpleBehaviour(null){
                private static final long serialVersionUID = 83683451984L;
                private boolean finished;
                {
                    super(x0);
                    this.finished = false;
                }

                public void action() {
                    ACLMessage msg = this.myAgent.receive(EventReceiver.this.msgTemplate);
                    if (msg != null) {
                        if (msg.getPerformative() == 7) {
                            WaitEventBehaviour.this.storeEvent(msg);
                        } else {
                            WaitEventBehaviour.this.handleFailure(msg);
                        }
                        this.finished = true;
                    } else {
                        this.block();
                    }
                }

                public boolean done() {
                    return this.finished;
                }
            });
            if (timeout > 0L) {
                this.addSubBehaviour((Behaviour)new WakerBehaviour(null, timeout){
                    private static final long serialVersionUID = 98372367L;

                    public void onWake() {
                        WaitEventBehaviour.this.handleTimeout();
                    }
                });
            }
        }

        public int onEnd() {
            WaitEventBehaviour.this.owner.resume();
            return super.onEnd();
        }
    }
}

