/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.event.EventTemplate;
import com.tilab.wade.event.GenericEvent;
import com.tilab.wade.event.Occurred;
import com.tilab.wade.performer.AbstractWaitEventBehaviour;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.EventCase;
import com.tilab.wade.performer.EventTemplateBB;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.WorkflowBehaviour;
import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.domain.FIPAAgentManagement.Property;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitMultipleCasesBehaviour
extends AbstractWaitEventBehaviour {
    private static final long serialVersionUID = 57235736517L;
    public static final String BB_SEPARTOR = "#";
    private Map<String, EventCase> cases = new HashMap<String, EventCase>();
    private String occurredCaseId = null;

    public WaitMultipleCasesBehaviour(String name, WorkflowBehaviour owner) {
        this(name, owner, true);
    }

    public WaitMultipleCasesBehaviour(String name, WorkflowBehaviour owner, boolean hasDedicatedMethods) {
        super(name, owner, hasDedicatedMethods);
    }

    public void addCase(String caseId, EventCase ec) {
        ec.setId(caseId);
        ec.setActivity(this);
        this.cases.put(caseId, ec);
    }

    @Override
    public void init() throws Exception {
        for (EventCase ec : this.cases.values()) {
            ec.init(this.myAgent);
        }
        super.init();
    }

    @Override
    protected MethodInvocator createBeforeMethodInvocator(String beforeMethodName) {
        return new MethodInvocator(this.owner, beforeMethodName, null, Map.class){
            private static final long serialVersionUID = 486345624L;

            protected Object[] getMethodParams() {
                HashMap<String, EventTemplate> templateMap = new HashMap<String, EventTemplate>(WaitMultipleCasesBehaviour.this.cases.size());
                for (String caseId : WaitMultipleCasesBehaviour.this.cases.keySet()) {
                    templateMap.put(caseId, ((EventCase)WaitMultipleCasesBehaviour.this.cases.get(caseId)).getEventTemplate());
                }
                return new Object[]{templateMap};
            }
        };
    }

    @Override
    protected MethodInvocator createAfterMethodInvocator(String afterMethodName) {
        return new MethodInvocator(this.owner, afterMethodName){
            private static final long serialVersionUID = 98795874L;

            protected Object[] getMethodParams() {
                if (WaitMultipleCasesBehaviour.this.occurredCaseId != null) {
                    return new Object[]{WaitMultipleCasesBehaviour.this.occurredCaseId, ((EventCase)WaitMultipleCasesBehaviour.this.cases.get(WaitMultipleCasesBehaviour.this.occurredCaseId)).getEvent()};
                }
                return new Object[]{null, null};
            }

            protected Class[] getMethodParamTypes() {
                return new Class[]{String.class, GenericEvent.class};
            }
        };
    }

    @Override
    protected void manageBindings() throws Exception {
        for (String caseId : this.cases.keySet()) {
            this.owner.manageBindings(this.cases.get(caseId).getBuildingBlock(EventTemplateBB.ID));
        }
    }

    @Override
    public BuildingBlock getBuildingBlock(String id) {
        int sepPos = id.indexOf(BB_SEPARTOR);
        if (sepPos > 0 && sepPos < id.length() - 1) {
            String caseId = id.substring(0, sepPos);
            String type = id.substring(sepPos + 1);
            EventCase ec = this.cases.get(caseId);
            if (ec != null) {
                return ec.getBuildingBlock(type);
            }
        }
        return null;
    }

    @Override
    public boolean checkCompleted() throws Exception {
        return this.occurredCaseId != null || this.timeoutExpired;
    }

    @Override
    protected ContentElement prepareRegistrationContent() {
        ContentElementList cel = new ContentElementList();
        for (String caseId : this.cases.keySet()) {
            cel.add((ContentElement)this.cases.get(caseId).getMatch());
        }
        return cel;
    }

    @Override
    protected void handleOccurredEvent(Occurred occurred) {
        GenericEvent event = (GenericEvent)occurred.getEvent();
        List properties = event.getProperties();
        this.occurredCaseId = (String)WaitMultipleCasesBehaviour.getProperty(properties, "Event-template-tag");
        EventCase occurredCase = this.cases.get(this.occurredCaseId);
        occurredCase.setEvent(event);
    }

    @Override
    public void reset() {
        super.reset();
        this.occurredCaseId = null;
        for (String caseId : this.cases.keySet()) {
            this.cases.get(caseId).reset();
        }
    }

    String getOccurredCase() {
        return this.occurredCaseId;
    }

    private static Object getProperty(List<Property> pp, String name) {
        for (Property p : pp) {
            if (!p.getName().equals(name)) continue;
            return p.getValue();
        }
        return null;
    }
}

