/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.BaseWaitBehaviour;
import com.tilab.wade.performer.WorkflowBehaviour;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.util.Logger;

public class WaitTimerBehaviour
extends BaseWaitBehaviour {
    private long timeout;
    private long deadline;
    private boolean deadlineExpired = false;
    private transient WakerBehaviour timerWatchDog;
    private Logger myLogger = Logger.getJADELogger((String)this.getClass().getName());

    public WaitTimerBehaviour(String name, WorkflowBehaviour owner) {
        this(name, owner, true);
    }

    public WaitTimerBehaviour(String name, WorkflowBehaviour owner, boolean callMethods) {
        super(name, owner, callMethods);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void onStart() {
        super.onStart();
        this.deadline = System.currentTimeMillis() + this.timeout;
    }

    public void init() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.deadline) {
            this.timerWatchDog = new WakerBehaviour(this.myAgent, this.deadline - currentTime){
                private static final long serialVersionUID = 111111111111L;

                protected void onWake() {
                    WaitTimerBehaviour.this.deadlineExpired = true;
                    try {
                        WaitTimerBehaviour.this.owner.resume();
                    }
                    catch (Exception e) {
                        WaitTimerBehaviour.this.myLogger.log(Logger.INFO, "Cannot resume workflow " + WaitTimerBehaviour.this.owner.getExecutionId());
                    }
                }
            };
            this.myAgent.addBehaviour((Behaviour)this.timerWatchDog);
        } else {
            this.deadlineExpired = true;
        }
    }

    public boolean checkCompleted() {
        return this.deadlineExpired;
    }

    public int onEnd() {
        if (this.timerWatchDog != null) {
            this.myAgent.removeBehaviour((Behaviour)this.timerWatchDog);
        }
        return super.onEnd();
    }
}

