/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.performer.WaitEventBehaviour;
import com.tilab.wade.performer.WebServiceException;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.descriptors.webservice.ServiceDescriptor;
import java.util.Iterator;

public class WaitWebServiceBehaviour
extends WaitEventBehaviour {
    private static final long serialVersionUID = 5150928887662410200L;
    private String port;
    private String operation;
    private String descriptorClassName;
    private transient ServiceDescriptor descriptor;

    public WaitWebServiceBehaviour(String name, WorkflowBehaviour owner) {
        super(name, owner, true);
    }

    public WaitWebServiceBehaviour(String name, WorkflowBehaviour owner, boolean hasDedicatedMethods) {
        super(name, owner, hasDedicatedMethods);
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getDescriptorClassName() {
        return this.descriptorClassName;
    }

    public void setDescriptorClassName(String descriptorClassName) {
        this.descriptorClassName = descriptorClassName;
        this.descriptor = null;
    }

    public void init() throws Exception {
        Iterator<String> it;
        String service;
        if (this.descriptor == null) {
            if (this.descriptorClassName == null) {
                throw new WebServiceException("Missing ServiceDescriptor classname");
            }
            ClassLoader cl = CAServices.getInstance(this.getAgent()).getDefaultClassLoader();
            Class<?> descriptorClass = Class.forName(this.descriptorClassName, true, cl);
            this.descriptor = (ServiceDescriptor)descriptorClass.newInstance();
        }
        if ((service = this.descriptor.getServiceName()) == null) {
            throw new WebServiceException("Missing webservice name in ServiceDescriptor " + this.descriptorClassName);
        }
        if (this.port == null && (it = this.descriptor.getPortNames().iterator()).hasNext()) {
            this.port = it.next();
        }
        if (this.port == null) {
            throw new WebServiceException("Missing webservice-port name for webservice " + service);
        }
        if (this.operation == null) {
            throw new WebServiceException("Missing webservice-operation name for webservice " + service);
        }
        this.setEventType(service + "." + this.port + "." + this.operation);
        super.init();
    }
}

