/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.WebServiceAddressingContext;
import com.tilab.wade.performer.WebServiceException;
import com.tilab.wade.performer.WebServiceInvocationBehaviour;
import com.tilab.wade.performer.WebServiceSecurityContext;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.webservice.Header;
import com.tilab.wade.performer.descriptors.webservice.OperationDescriptor;
import com.tilab.wade.performer.descriptors.webservice.ServiceDescriptor;
import com.tilab.wade.utils.OntologyUtils;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.onto.BeanOntology;
import jade.content.onto.Ontology;
import jade.util.leap.HashMap;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebService
extends BuildingBlock {
    private transient ServiceDescriptor descriptor;
    private WorkflowBehaviour owner;
    private Map params = new HashMap();
    private Map headers = new HashMap();
    private Object returnValue;
    private String port;
    private String operation;
    private String descriptorClassName;
    private int timeout;
    private String endpointAddress;
    private WebServiceSecurityContext securityContext;
    private WebServiceAddressingContext addressingContext;

    public WebService(WorkflowBehaviour owner, WebServiceInvocationBehaviour activity) {
        super(activity);
        this.owner = owner;
        this.timeout = -1;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public WebServiceSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(WebServiceSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public WebServiceAddressingContext getAddressingContext() {
        return this.addressingContext;
    }

    public void setAddressingContext(WebServiceAddressingContext addressingContext) {
        this.addressingContext = addressingContext;
    }

    public WorkflowBehaviour getOwner() {
        return this.owner;
    }

    public String getDescriptorClassName() {
        return this.descriptorClassName;
    }

    public void setDescriptorClassName(String descriptorClassName) {
        this.descriptorClassName = descriptorClassName;
    }

    ServiceDescriptor getDescriptor() throws Exception {
        if (this.descriptor == null) {
            ClassLoader wcl = CAServices.getInstance(this.owner.getAgent()).getDefaultClassLoader();
            this.descriptor = (ServiceDescriptor)Class.forName(this.descriptorClassName, true, wcl).newInstance();
        }
        return this.descriptor;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void invoke() throws Exception {
        ServiceDescriptor serviceDescriptor;
        WebServiceAddressingContext wfAddressingContext;
        WebServiceSecurityContext wfSecurityContext = EngineHelper.extractWebServiceSecurityContext(this.owner, this.activity.getBehaviourName());
        if (wfSecurityContext != null) {
            this.securityContext = wfSecurityContext;
        }
        if ((wfAddressingContext = EngineHelper.extractWebServiceAddressingContext(this.owner, this.activity.getBehaviourName())) != null) {
            this.addressingContext = wfAddressingContext;
        }
        try {
            serviceDescriptor = this.getDescriptor();
        }
        catch (Exception e) {
            throw new WebServiceException("No descriptor found (" + this.getDescriptorClassName() + ")", e);
        }
        serviceDescriptor.invoke(this);
    }

    public final void fill(String key, Object value) {
        this.params.put((Object)key, value);
    }

    public final Object extract(String key) {
        return this.params.get((Object)key);
    }

    public final void fillHeader(String key, Object value) {
        this.headers.put((Object)key, value);
    }

    public final Object extractHeader(String key) {
        return this.headers.get((Object)key);
    }

    public Map getParams() {
        return this.params;
    }

    public Map getHeaders() {
        return this.headers;
    }

    @Deprecated
    public Object getReturnValue() {
        return this.returnValue;
    }

    @Deprecated
    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    @Override
    public void reset() {
        this.params.clear();
        this.headers.clear();
        this.returnValue = null;
    }

    private OperationDescriptor getOperationDescriptor() {
        try {
            if (this.port != null) {
                return this.getDescriptor().getPortDescriptor(this.port).getOperationDescriptor(this.operation);
            }
            return this.getDescriptor().getOperationDescriptor(this.operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean requireAbsParameters() {
        return false;
    }

    @Override
    public Ontology createOntology() throws Exception {
        BeanOntology onto = new BeanOntology("WebServiceOnto");
        OperationDescriptor operationDescriptor = this.getOperationDescriptor();
        List formalParams = operationDescriptor.getFormalParams();
        for (Parameter p : formalParams) {
            OntologyUtils.addFormalParameterToOntology((BeanOntology)onto, (Parameter)p, (ClassLoader)this.owner.getClass().getClassLoader());
        }
        List formalHeaders = operationDescriptor.getFormalHeaders();
        for (Header h : formalHeaders) {
            OntologyUtils.addFormalParameterToOntology((BeanOntology)onto, (Parameter)h, (ClassLoader)this.owner.getClass().getClassLoader());
        }
        return onto;
    }

    @Override
    public AbsObject createAbsTemplate(String key) throws Exception {
        Class parameterClass = this.getParameterClass(key);
        return AbsHelper.createAbsTemplate((Class)parameterClass, (Ontology)this.getOntology());
    }

    private Class getParameterClass(String key) throws Exception {
        OperationDescriptor operationDescriptor = this.getOperationDescriptor();
        List params = null;
        String name = null;
        Class paramClass = null;
        int sepPos = key.indexOf(".");
        if (sepPos > 0) {
            name = key.substring(sepPos + 1);
            params = operationDescriptor.getFormalHeaders();
        } else {
            name = key;
            params = operationDescriptor.getFormalParams();
        }
        for (Parameter p : params) {
            if (!p.getName().equals(name)) continue;
            paramClass = p.getTypeClass(false, this.owner.getClass().getClassLoader());
            break;
        }
        if (paramClass == null) {
            throw new WebServiceException("Parameter class type not found for key " + key);
        }
        return paramClass;
    }

    private java.util.List<String> getParameterNames(int mode) {
        OperationDescriptor operationDescriptor = this.getOperationDescriptor();
        ArrayList<String> inputParameterNames = new ArrayList<String>();
        List formalParams = operationDescriptor.getFormalParams();
        for (Parameter p : formalParams) {
            if (p.getMode() != mode && p.getMode() != 2) continue;
            inputParameterNames.add(p.getName());
        }
        List formalHeaders = operationDescriptor.getFormalHeaders();
        for (Header h : formalHeaders) {
            if (h.getMode() != mode && h.getMode() != 2) continue;
            inputParameterNames.add("header." + h.getName());
        }
        return inputParameterNames;
    }

    @Override
    public java.util.List<String> getInputParameterNames() {
        return this.getParameterNames(0);
    }

    @Override
    public java.util.List<String> getOutputParameterNames() {
        return this.getParameterNames(0);
    }

    private Object getValue(String key) {
        int sepPos = key.indexOf(".");
        Object value = sepPos > 0 ? this.extractHeader(key.substring(sepPos + 1)) : this.extract(key);
        return value;
    }

    @Override
    public Object getInput(String key) {
        return this.getValue(key);
    }

    @Override
    public Object getOutput(String key) {
        return this.getValue(key);
    }

    private void setValue(String key, Object value) {
        int sepPos = key.indexOf(".");
        if (sepPos > 0) {
            this.fillHeader(key.substring(sepPos + 1), value);
        } else {
            this.fill(key, value);
        }
    }

    @Override
    public void setInput(String key, Object value) {
        this.setValue(key, value);
    }

    @Override
    public void setOutput(String key, Object value) {
        this.setValue(key, value);
    }

    @Override
    public boolean isInputEmpty(String key) {
        int sepPos = key.indexOf(".");
        boolean inputEmpty = sepPos > 0 ? !this.headers.containsKey((Object)key.substring(sepPos + 1)) : !this.params.containsKey((Object)key);
        return inputEmpty;
    }

    private Parameter getFormalDescriptor(String key, int mode) {
        String name;
        List formals;
        OperationDescriptor operationDescriptor = this.getOperationDescriptor();
        int sepPos = key.indexOf(".");
        if (sepPos > 0) {
            formals = operationDescriptor.getFormalHeaders();
            name = key.substring(sepPos + 1);
        } else {
            formals = operationDescriptor.getFormalParams();
            name = key;
        }
        for (Parameter p : formals) {
            if (!p.getName().equals(name) || p.getMode() != mode && p.getMode() != 2) continue;
            return p;
        }
        return null;
    }

    @Override
    public Parameter getInputParameter(String key) {
        return this.getFormalDescriptor(key, 0);
    }

    @Override
    public Parameter getOutputParameter(String key) {
        return this.getFormalDescriptor(key, 1);
    }
}

