/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.performer.EventCase;
import com.tilab.wade.performer.WebServiceException;
import com.tilab.wade.performer.descriptors.webservice.ServiceDescriptor;
import jade.core.Agent;
import java.util.Iterator;

public class WebServiceEventCase
extends EventCase {
    private static final long serialVersionUID = 8768686315345L;
    private String port;
    private String operation;
    private String descriptorClassName;
    private transient ServiceDescriptor descriptor;

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getDescriptorClassName() {
        return this.descriptorClassName;
    }

    public void setDescriptorClassName(String descriptorClassName) {
        this.descriptorClassName = descriptorClassName;
        this.descriptor = null;
    }

    void init(Agent a) throws Exception {
        Iterator<String> it;
        String service;
        if (this.descriptor == null) {
            if (this.descriptorClassName == null) {
                throw new WebServiceException("Missing ServiceDescriptor classname");
            }
            ClassLoader cl = CAServices.getInstance(a).getDefaultClassLoader();
            Class<?> descriptorClass = Class.forName(this.descriptorClassName, true, cl);
            this.descriptor = (ServiceDescriptor)descriptorClass.newInstance();
        }
        if ((service = this.descriptor.getServiceName()) == null) {
            throw new WebServiceException("Missing webservice name in ServiceDescriptor " + this.descriptorClassName);
        }
        if (this.port == null && (it = this.descriptor.getPortNames().iterator()).hasNext()) {
            this.port = it.next();
        }
        if (this.port == null) {
            throw new WebServiceException("Missing webservice-port name for webservice " + service);
        }
        if (this.operation == null) {
            throw new WebServiceException("Missing webservice-operation name for webservice " + service);
        }
        this.setEventType(service + "." + this.port + "." + this.operation);
    }
}

