/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.performer.ActivityBehaviour;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.WebService;
import com.tilab.wade.performer.WebServiceAddressingContext;
import com.tilab.wade.performer.WebServiceSecurityContext;
import com.tilab.wade.performer.WorkflowBehaviour;
import jade.core.Agent;

public class WebServiceInvocationBehaviour
extends ActivityBehaviour {
    private MethodInvocator invocator;
    private WebService webService;

    public WebServiceInvocationBehaviour(String name, WorkflowBehaviour owner) {
        this(name, owner, true);
    }

    public WebServiceInvocationBehaviour(String name, WorkflowBehaviour owner, boolean callExecuteMethod) {
        super(name, owner);
        this.webService = new WebService(owner, this);
        String methodName = callExecuteMethod ? EngineHelper.activityName2Method(this.getBehaviourName()) : "performWebService";
        EngineHelper.checkMethodName(methodName, "activity", name);
        this.invocator = new MethodInvocator(owner, methodName, this.webService, WebService.class);
    }

    public void setOperation(String operation) {
        this.webService.setOperation(operation);
    }

    public void setDescriptorClassName(String descriptorClassName) {
        this.webService.setDescriptorClassName(descriptorClassName);
    }

    public void setTimeout(int timeout) {
        this.webService.setTimeout(timeout);
    }

    public void setSecurityContext(WebServiceSecurityContext securityContext) {
        this.webService.setSecurityContext(securityContext);
    }

    public void setAddressingContext(WebServiceAddressingContext addressingContext) {
        this.webService.setAddressingContext(addressingContext);
    }

    public void setEndpointAddress(String endpointAddress) {
        this.webService.setEndpointAddress(endpointAddress);
    }

    public void setPort(String port) {
        this.webService.setPort(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        try {
            this.owner.enterInterruptableSection();
            this.invocator.invoke();
        }
        catch (InterruptedException ie) {
        }
        catch (Agent.Interrupted i) {
        }
        catch (ThreadDeath td) {
        }
        catch (Throwable t) {
            this.handleException(t);
            t.printStackTrace();
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    public void reset() {
        super.reset();
        this.webService.reset();
    }

    public BuildingBlock getBuildingBlock(String id) {
        return this.webService;
    }
}

