/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.ca.ontology.WorkflowDetails;
import com.tilab.wade.performer.Aborted;
import com.tilab.wade.performer.Application;
import com.tilab.wade.performer.AsynchSubflowCollector;
import com.tilab.wade.performer.BindingException;
import com.tilab.wade.performer.BindingManager;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.DefaultParameterValues;
import com.tilab.wade.performer.DynamicWebService;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.FailedSubflow;
import com.tilab.wade.performer.HierarchyNode;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.OntologyHolder;
import com.tilab.wade.performer.OutgoingTransitions;
import com.tilab.wade.performer.RestService;
import com.tilab.wade.performer.Subflow;
import com.tilab.wade.performer.SubflowDelegationBehaviour;
import com.tilab.wade.performer.TerminatedInErrorActivity;
import com.tilab.wade.performer.TerminationNotificationReceiver;
import com.tilab.wade.performer.Tracer;
import com.tilab.wade.performer.Transition;
import com.tilab.wade.performer.WaitMultipleCasesBehaviour;
import com.tilab.wade.performer.WebService;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.WorkflowException;
import com.tilab.wade.performer.WorkflowSerializationManager;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.event.ExecutionErrorEvent;
import com.tilab.wade.performer.event.WorkflowEvent;
import com.tilab.wade.performer.layout.WorkflowSkipped;
import com.tilab.wade.performer.ontology.ExecuteWorkflow;
import com.tilab.wade.performer.ontology.KillWorkflow;
import com.tilab.wade.performer.ontology.Modifier;
import com.tilab.wade.performer.ontology.WorkflowManagementOntology;
import com.tilab.wade.performer.transaction.ApplicationEntry;
import com.tilab.wade.performer.transaction.SubflowEntry;
import com.tilab.wade.performer.transaction.TransactionManager;
import com.tilab.wade.utils.OntologyUtils;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.lang.Codec;
import jade.content.onto.BeanOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.ThreadedBehaviourFactory;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WorkflowSkipped
public class WorkflowBehaviour
extends FSMBehaviour
implements HierarchyNode,
OntologyHolder {
    public static final int INITIAL = 1;
    public static final int FINAL = 2;
    public static final int INITIAL_AND_FINAL = 3;
    public static final int INTERMEDIATE = 0;
    protected static final String START_STATE = "__Start-state__";
    protected static final String COLLECT_ASYNCH_SUBFLOWS_STATE = "__Collect-asynch-subflows__";
    protected static final String END_STATE = "__End-state__";
    protected static final String ERROR_STATE = "__Error-state__";
    protected static final String FROZEN_STATE = "__Frozen-state__";
    protected transient WorkflowEngineAgent.WorkflowExecutor rootExecutor;
    protected Logger myLogger = Logger.getMyLogger((String)WorkflowBehaviour.class.getName());
    protected Throwable lastException;
    protected List formalParams = null;
    private boolean useDataStore = false;
    private boolean interruptable = false;
    private boolean interrupted = false;
    protected boolean frozen = false;
    private boolean thawed = false;
    private transient boolean suspendAsap = false;
    private String abortMessage = null;
    private WorkflowBehaviour rollbackWorkflow = null;
    private BindingManager bindingManager;
    private transient Ontology onto;
    private WorkflowDetails workflowDetails;
    private boolean inline;
    private Subflow subflow;
    private WorkflowDescriptor inlineDescriptor;
    private OutgoingTransitions outgoingTransitions;
    private boolean errorActivity = false;
    private boolean executed = false;
    private boolean inlineInterrupted = false;
    private Set<String> managedFieldNames;
    private static long applicationEntryCnt = 0L;
    private static long delegationCnt = 0L;
    private transient Map<String, Method> cachedMethods = new HashMap<String, Method>();
    private transient Map<String, Field> cachedFields = new HashMap<String, Field>();

    public WorkflowBehaviour() {
        this.registerFirstState((Behaviour)new OneShotBehaviour(){

            public void action() {
                try {
                    WorkflowBehaviour.this.configure();
                }
                catch (Throwable t) {
                    EngineHelper.fireExecutionErrorEvent(WorkflowBehaviour.this, t, 1);
                    WorkflowBehaviour.this.handleException(t);
                }
            }
        }, START_STATE);
        this.registerState((Behaviour)new AsynchSubflowCollector(this), COLLECT_ASYNCH_SUBFLOWS_STATE);
        this.registerLastState((Behaviour)new OneShotBehaviour(){

            public void action() {
            }

            public int onEnd() {
                return 0;
            }
        }, END_STATE);
        this.registerLastState((Behaviour)new OneShotBehaviour(){

            public void action() {
                if (WorkflowBehaviour.this.lastException == null) {
                    WorkflowBehaviour.this.lastException = new TerminatedInErrorActivity(WorkflowBehaviour.this.getPrevious().getBehaviourName());
                }
            }

            public int onEnd() {
                return 1;
            }
        }, ERROR_STATE);
        this.registerLastState((Behaviour)new OneShotBehaviour(){

            public void action() {
            }

            public int onEnd() {
                WorkflowBehaviour.this.onFrozen();
                return 2;
            }
        }, FROZEN_STATE);
        this.registerTransition(COLLECT_ASYNCH_SUBFLOWS_STATE, END_STATE, 0);
        this.registerTransition(COLLECT_ASYNCH_SUBFLOWS_STATE, ERROR_STATE, 1);
        this.fillFormalParameters();
        if (!this.getClass().equals(WorkflowBehaviour.class)) {
            this.init(this.getClass());
        }
        this.workflowDetails = EngineHelper.buildWorkflowDetails(this.getClass());
    }

    public WorkflowBehaviour(String activityName) {
        this();
        this.inline = true;
        this.setBehaviourName(activityName.replace(' ', '-'));
        this.outgoingTransitions = new OutgoingTransitions();
    }

    private void init(Class c) {
        Class superclass = c.getSuperclass();
        if (!superclass.equals(WorkflowBehaviour.class)) {
            this.init(superclass);
        }
        this.executeDefineMethod(c, "defineActivities");
        this.executeDefineMethod(c, "defineTransitions");
    }

    private void executeDefineMethod(Class c, String methodName) {
        block5: {
            try {
                Method m = c.getDeclaredMethod(methodName, new Class[0]);
                if (m == null || m.isAccessible()) break block5;
                try {
                    m.setAccessible(true);
                    m.invoke((Object)this, new Object[0]);
                }
                catch (SecurityException se) {
                    throw new WorkflowInitializationException("Method " + methodName + "() of class " + c.getName() + " is not accessible.", se);
                }
                catch (Exception e) {
                    throw new WorkflowInitializationException("Error invoking method " + methodName + "() of class " + c.getName(), e);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public boolean isLongRunning() {
        return false;
    }

    public boolean isVolatile() {
        return false;
    }

    public boolean isCompressionActive() {
        return false;
    }

    public boolean supportTags() {
        return false;
    }

    public boolean supportEnqueuing() {
        return true;
    }

    boolean isFrozen() {
        return this.frozen;
    }

    private void setFrozen() {
        this.frozen = true;
        Behaviour currentBehaviour = this.getCurrent();
        if (currentBehaviour != null && currentBehaviour instanceof WorkflowBehaviour) {
            ((WorkflowBehaviour)currentBehaviour).setFrozen();
        }
    }

    public WorkflowDetails getDetails() {
        return this.workflowDetails;
    }

    public void SetDetails(WorkflowDetails workflowDetails) {
        this.workflowDetails = workflowDetails;
    }

    protected void fillFormalParameters() {
        this.formalParams = new ArrayList();
        EngineHelper.fillFormalParameters(this, WorkflowBehaviour.class, this.formalParams);
    }

    public List getFormalParameters() {
        return this.formalParams;
    }

    protected void setUseDataStore(boolean b) {
        this.useDataStore = b;
    }

    protected void initRootExecutor() {
        this.rootExecutor = (WorkflowEngineAgent.WorkflowExecutor)this.root();
        Behaviour currentBehaviour = this.getCurrent();
        if (currentBehaviour != null && currentBehaviour instanceof WorkflowBehaviour) {
            ((WorkflowBehaviour)currentBehaviour).initRootExecutor();
        }
    }

    public void onStart() {
        this.initRootExecutor();
        try {
            if (!this.inline) {
                this.getAgent().handleBeginWorkflow(this.rootExecutor);
            } else {
                this.copyInputParams();
                this.getOwner().handleBeginActivity(this);
            }
        }
        catch (Exception e) {
            EngineHelper.fireExecutionErrorEvent(this, e, 1);
            this.handleException(e);
        }
    }

    private void copyInputParams() throws Exception {
        this.subflow = new Subflow(this.getClass().getName(), this);
        String methodName = EngineHelper.activityName2Method(this.getBehaviourName(), 1);
        EngineHelper.checkMethodName(methodName, "activity", this.getBehaviourName());
        MethodInvocator invocator = new MethodInvocator((WorkflowBehaviour)this.parent, methodName, this.subflow, Subflow.class);
        invocator.invoke();
        this.manageBindings(this.subflow);
        EngineHelper.copyInputParameters(this, this.subflow.getParams());
    }

    public int onEnd() {
        int ret;
        block7: {
            ret = super.onEnd();
            if (this.supportTags() && !this.inline) {
                try {
                    WorkflowSerializationManager.deleteTags(this);
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + this.rootExecutor.getId() + ": Error deleting TAGS ");
                }
            }
            if (!this.frozen) {
                try {
                    if (this.inline) {
                        this.restoreOutputParams();
                        return EngineHelper.endActivity(this);
                    }
                    this.getAgent().handleEndWorkflow(this.rootExecutor, ret);
                }
                catch (Exception e) {
                    if (this.lastException != null) break block7;
                    this.lastException = e;
                }
            }
        }
        return ret;
    }

    private void restoreOutputParams() throws Exception {
        this.extractOutputParameters();
        String methodName = EngineHelper.activityName2Method(this.getBehaviourName(), 2);
        EngineHelper.checkMethodName(methodName, "activity", this.getBehaviourName());
        MethodInvocator invocator = new MethodInvocator((WorkflowBehaviour)this.parent, methodName, this.subflow, Subflow.class);
        invocator.invoke();
    }

    public final Behaviour getCurrent() {
        return super.getCurrent();
    }

    final void setFieldValue(String key, Object value) {
        if (this.useDataStore) {
            this.getDataStore().put((Object)key, value);
        } else {
            EngineHelper.setFieldValue(key, value, this, this.cachedFields);
        }
    }

    final Object getFieldValue(String key) {
        if (this.useDataStore) {
            return this.getDataStore().get((Object)key);
        }
        return EngineHelper.getFieldValue(key, this, this.cachedFields);
    }

    public int getDefaultPriority() {
        return 0;
    }

    public long getLimit() {
        return -1L;
    }

    public final WorkflowDescriptor getDescriptor() {
        if (!this.inline) {
            return this.rootExecutor.getDescriptor();
        }
        if (this.inlineDescriptor == null && this.subflow != null) {
            this.inlineDescriptor = this.subflow.getDescriptor();
            this.inlineDescriptor.importInfo(this.rootExecutor.getDescriptor());
        }
        return this.inlineDescriptor;
    }

    public final String getExecutionId() {
        return this.rootExecutor.getId();
    }

    public final void setFailureReason(String reason) {
        this.rootExecutor.setFailureReason(reason);
    }

    public final ExecutionErrorEvent getLastErrorEvent() {
        return this.rootExecutor.getLastErrorEvent();
    }

    public final List getModifiers() {
        return this.rootExecutor.getModifiers();
    }

    public final Modifier getModifier(String name) {
        List modifiers = this.getModifiers();
        return Modifier.getModifier((String)name, (List)modifiers);
    }

    public final void fireEvent(String type, WorkflowEvent ev, int level) {
        this.rootExecutor.getEventEmitter().fireEvent(type, ev, level);
    }

    public final boolean isFireable(String type, int level) {
        return this.rootExecutor.getEventEmitter().isFireable(type, level);
    }

    protected void configure() {
    }

    protected boolean commit() {
        TransactionManager tm = this.rootExecutor.getTransactionManager();
        if (tm != null) {
            return tm.commit();
        }
        return false;
    }

    protected boolean rollback() {
        TransactionManager tm = this.rootExecutor.getTransactionManager();
        if (tm != null) {
            return tm.rollback();
        }
        return false;
    }

    protected WorkflowBehaviour getRollbackWorkflow() {
        return this.getAgent().loadRollbackWorkflow(this.rootExecutor, this.getClass().getClassLoader());
    }

    public final TransactionManager getTransactionManager() {
        return this.rootExecutor.getTransactionManager();
    }

    synchronized void setRollbackWorkflow(WorkflowBehaviour wb) {
        this.rollbackWorkflow = wb;
        this.rollbackWorkflow.interrupted = this.interrupted;
        this.rollbackWorkflow.abortMessage = this.abortMessage;
    }

    public Hashtable getExecutionContext() {
        return this.rootExecutor.getExecutionContext();
    }

    protected void performApplication(Application appl) throws Exception {
        this.handleBeginApplication(appl, (HierarchyNode)this.getCurrent());
        try {
            appl.checkParameters();
            appl.execute();
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
        this.handleEndApplication(appl, (HierarchyNode)this.getCurrent());
        TransactionManager tm = this.rootExecutor.getTransactionManager();
        if (tm != null && appl.isTransactional()) {
            String entryId = WorkflowBehaviour.generateApplicationEntryId(appl.getName());
            tm.addEntry(new ApplicationEntry(entryId, appl, appl.getDataStore()));
        }
    }

    private java.util.List<Subflow> getOngoingSubflows() {
        java.util.ArrayList<Subflow> subflows = new java.util.ArrayList<Subflow>();
        for (Behaviour b : this.getChildren()) {
            if (b instanceof SubflowDelegationBehaviour) {
                SubflowDelegationBehaviour sdb = (SubflowDelegationBehaviour)b;
                if (sdb == this.getCurrent() && !sdb.getSubflow().getAsynch()) {
                    subflows.add(sdb.getSubflow());
                    continue;
                }
                Iterator<TerminationNotificationReceiver> it2 = sdb.getAllAsynchronousDelegations();
                while (it2.hasNext()) {
                    TerminationNotificationReceiver tnr = it2.next();
                    subflows.add(tnr.getSubflow());
                }
                continue;
            }
            if (!(b instanceof WorkflowBehaviour)) continue;
            WorkflowBehaviour wb = (WorkflowBehaviour)b;
            java.util.List<Subflow> ongoingSubflows = wb.getOngoingSubflows();
            subflows.addAll(ongoingSubflows);
        }
        return subflows;
    }

    boolean propagateKill(KillWorkflow kw) throws FIPAException, Codec.CodecException, OntologyException {
        java.util.List<Subflow> subflows = this.getOngoingSubflows();
        if (subflows.isEmpty()) {
            return false;
        }
        for (Subflow subflow : subflows) {
            kw.setExecutionId(subflow.getExecutionId());
            AID performer = new AID(subflow.getPerformer(), false);
            ACLMessage msg = new ACLMessage(16);
            msg.setLanguage("fipa-sl");
            msg.setProtocol("fipa-request");
            msg.setOntology(WorkflowManagementOntology.getInstance().getName());
            msg.addReceiver(performer);
            Action action = new Action();
            action.setActor(performer);
            action.setAction((Concept)kw);
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)action);
            FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)msg);
        }
        return true;
    }

    protected void performSubflow(Subflow sbfl) throws Exception {
        this.manageBindings(sbfl);
        WorkflowDescriptor rootDescriptor = this.rootExecutor.getDescriptor();
        WorkflowDescriptor sbflDescriptor = sbfl.getDescriptor();
        sbflDescriptor.importInfo(rootDescriptor);
        boolean transactionScope = rootDescriptor.getTransactional() && !sbfl.getIndependent();
        String rootDelegationChain = rootDescriptor.getDelegationChain();
        String prefix = rootDelegationChain != null ? rootDelegationChain + ';' : "";
        sbflDescriptor.setDelegationChain(prefix + this.myAgent.getName() + ',' + this.rootExecutor.getId());
        Hashtable infos = this.rootExecutor.getEventEmitter().getControlInfo();
        Object[] tmp = infos.values().toArray();
        ArrayList cInfo = new ArrayList(tmp.length);
        for (int i = 0; i < tmp.length; ++i) {
            cInfo.add(tmp[i]);
        }
        List modifiers = this.propagateModifier(sbfl);
        int perf = transactionScope ? 3 : 16;
        ACLMessage request = new ACLMessage(perf);
        AID performer = sbfl.getPerformer() != null ? new AID(sbfl.getPerformer(), false) : this.myAgent.getAID();
        request.addReceiver(performer);
        String delegationId = WorkflowBehaviour.generateDelegationId(sbfl.getPerformer(), this.myAgent.getLocalName());
        request.setConversationId(delegationId);
        request.setOntology(this.getAgent().getOntology().getName());
        request.setLanguage("LEAP");
        ExecuteWorkflow ew = new ExecuteWorkflow(sbflDescriptor, (List)cInfo);
        ew.setModifiers(modifiers);
        Action aExpr = new Action(performer, (Concept)ew);
        this.myAgent.getContentManager().fillContent(request, (ContentElement)aExpr);
        this.getAgent().addConversation(request);
        this.myAgent.send(request);
        MessageTemplate template = MessageTemplate.MatchConversationId((String)delegationId);
        template = EngineHelper.adjustReplyTemplate(template, request);
        SubflowEntry myEntry = null;
        if (transactionScope) {
            TransactionManager tm = this.rootExecutor.getTransactionManager();
            myEntry = new SubflowEntry(delegationId, this.getBehaviourName(), this.myAgent, performer, sbflDescriptor);
            tm.addEntry(myEntry);
            this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + this.rootExecutor.getId() + ": Added Subflow Entry " + delegationId);
        }
        String delegatedExecutionId = null;
        boolean finished = false;
        ACLMessage reply = null;
        block7: while (!finished) {
            reply = this.myAgent.blockingReceive(template);
            switch (reply.getPerformative()) {
                case 1: {
                    delegatedExecutionId = reply.getContent();
                    sbfl.setExecutionId(delegatedExecutionId);
                    sbfl.setPerformer(performer.getLocalName());
                    if (sbfl.getIndependent()) {
                        finished = true;
                        continue block7;
                    }
                    this.getAgent().handleDelegatedSubflow(this.rootExecutor, sbflDescriptor.getId(), sbfl.getPerformer(), delegatedExecutionId);
                    if (transactionScope) {
                        myEntry.setAgree(reply);
                        this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + this.rootExecutor.getId() + ": Set AGREE message to Subflow Entry " + delegationId + ". Delegated executionID = " + delegatedExecutionId);
                    }
                    CAServices.getInstance(this.myAgent).registerExpectedReply(request);
                    if (!sbfl.getAsynch()) continue block7;
                    TerminationNotificationReceiver recv = new TerminationNotificationReceiver(this.rootExecutor, delegatedExecutionId, delegationId, sbflDescriptor.getId(), template, myEntry);
                    this.addAsynchronousDelegation(recv);
                    this.myAgent.addBehaviour((Behaviour)recv);
                    finished = true;
                    continue block7;
                }
                case 7: {
                    this.getAgent().removeConversation(reply);
                }
                case 11: {
                    CAServices.getInstance(this.myAgent).expectedReplyReceived(reply);
                    this.storeSubflowTransactionalNotification(myEntry, reply);
                    this.getAgent().handleCompletedSubflow(this.rootExecutor, delegatedExecutionId, 0);
                    Result r = (Result)this.myAgent.getContentManager().extractContent(reply);
                    sbfl.setParams(r.getItems());
                    finished = true;
                    continue block7;
                }
                case 6: {
                    this.getAgent().removeConversation(reply);
                    CAServices.getInstance(this.myAgent).expectedReplyReceived(reply);
                    this.storeSubflowTransactionalNotification(myEntry, reply);
                    this.handleSubflowFailure(delegatedExecutionId, reply);
                }
            }
            this.getAgent().removeConversation(reply);
            this.storeSubflowTransactionalNotification(myEntry, reply);
            throw new FailedSubflow("Performer replied with " + ACLMessage.getPerformative((int)reply.getPerformative()));
        }
    }

    protected void handleSubflowFailure(String delegatedExecutionId, ACLMessage reply) throws Exception {
        if (delegatedExecutionId != null) {
            this.getAgent().handleCompletedSubflow(this.rootExecutor, delegatedExecutionId, 1);
        }
        SubflowDelegationBehaviour.handleSubflowFailure(this.getAgent(), reply);
    }

    protected List propagateModifier(Subflow sbfl) {
        return this.rootExecutor.getModifiers();
    }

    private void addAsynchronousDelegation(TerminationNotificationReceiver recv) {
        SubflowDelegationBehaviour sdb = (SubflowDelegationBehaviour)this.getCurrent();
        sdb.addAsynchronousDelegation(recv);
    }

    private void storeSubflowTransactionalNotification(SubflowEntry entry, ACLMessage msg) {
        if (entry != null) {
            entry.setNotification(msg);
            this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + this.rootExecutor.getId() + ": Set " + ACLMessage.getPerformative((int)msg.getPerformative()) + " notification to Subflow Entry " + entry.getId());
        }
    }

    private static synchronized String generateApplicationEntryId(String applName) {
        String id = "A_" + applName + '_' + applicationEntryCnt;
        ++applicationEntryCnt;
        return id;
    }

    private static synchronized String generateDelegationId(String dlegated, String delegator) {
        String id = "D_" + System.currentTimeMillis() + '-' + delegator + '-' + dlegated + '-' + delegationCnt;
        ++delegationCnt;
        return id;
    }

    protected final boolean checkModifier(String name) {
        List modifiers = this.rootExecutor.getModifiers();
        return Modifier.getModifier((String)name, (List)modifiers) != null;
    }

    public final void registerActivity(HierarchyNode activity) {
        this.registerActivity(activity, 0);
    }

    public final void registerActivity(HierarchyNode activity, int order) {
        boolean isFirst = order == 1 || order == 3;
        boolean isLast = order == 2 || order == 3;
        HierarchyNode previous = (HierarchyNode)this.getState(activity.getBehaviourName());
        if (previous != null) {
            OutgoingTransitions oldOt = previous.getOutgoingTransitions();
            activity.getOutgoingTransitions().init(oldOt);
        }
        this.registerState((Behaviour)activity, activity.getBehaviourName());
        activity.setDataStore(this.getDataStore());
        if (isFirst) {
            this.registerDefaultTransition(START_STATE, activity.getBehaviourName());
        }
        if (isLast) {
            if (activity.isError()) {
                this.registerTransition(activity.getBehaviourName(), ERROR_STATE, -68392);
            } else {
                this.registerTransition(activity.getBehaviourName(), COLLECT_ASYNCH_SUBFLOWS_STATE, -68392);
            }
        }
    }

    public final HierarchyNode deregisterActivity(String name) {
        return (HierarchyNode)this.deregisterState(name);
    }

    public final void changeActivityOrder(String name, int order) {
        HierarchyNode activity = this.deregisterActivity(name);
        if (activity != null) {
            this.registerActivity(activity, order);
            OutgoingTransitions ot = activity.getOutgoingTransitions();
            for (Transition t : ot.getTransitions()) {
                this.registerTransition(t.getSource(), t.getDestination(), t.getExitValue());
            }
            for (Transition t : ot.getExceptionTransitions()) {
                this.registerTransition(t.getSource(), t.getDestination(), t.getExitValue());
            }
        }
    }

    public final void registerTransition(Transition t, String source, String destination) {
        t.setSource(source);
        t.setDestination(destination);
        HierarchyNode sourceAct = (HierarchyNode)this.getState(source);
        Transition old = sourceAct.getOutgoingTransitions().putTransition(t);
        if (old != null) {
            this.deregisterTransition(source, old.getExitValue());
        }
        this.registerTransition(source, destination, t.getExitValue());
    }

    public final void deregisterTransition(String source, String destination, boolean exception) {
        Transition t;
        HierarchyNode sourceAct = (HierarchyNode)this.getState(source);
        if (sourceAct != null && (t = sourceAct.getOutgoingTransitions().removeTransition(destination, exception)) != null) {
            this.deregisterTransition(source, t.getExitValue());
        }
    }

    public void suspend() {
        this.rootExecutor.suspend();
    }

    public void resume() {
        this.getAgent().submitWorkflow(this.rootExecutor);
    }

    void suspendAsap(boolean suspendAsap) {
        this.suspendAsap = suspendAsap;
        Behaviour currentBehaviour = this.getCurrent();
        if (currentBehaviour != null && currentBehaviour instanceof WorkflowBehaviour) {
            ((WorkflowBehaviour)currentBehaviour).suspendAsap(suspendAsap);
        }
    }

    @Override
    public void setDataStore(DataStore ds) {
        for (Behaviour b : this.getChildren()) {
            b.setDataStore(ds);
        }
        super.setDataStore(ds);
    }

    @Override
    public final WorkflowEngineAgent getAgent() {
        return (WorkflowEngineAgent)this.myAgent;
    }

    protected void handleStateEntered(Behaviour state) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - WorkflowBehaviour " + this.getBehaviourName() + ": Entering state " + state.getBehaviourName());
        }
        if (state instanceof HierarchyNode) {
            ((HierarchyNode)state).reinit();
        }
    }

    @Override
    public OutgoingTransitions getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    @Override
    public boolean hasJADEDefaultTransition() {
        if (!this.inline) {
            return false;
        }
        return ((WorkflowBehaviour)this.parent).hasDefaultTransition(this.getBehaviourName());
    }

    @Override
    public void mark() {
        if (this.inline) {
            this.executed = true;
        }
    }

    @Override
    public void reinit() {
        if (this.inline && this.executed) {
            this.reset();
        }
    }

    public void reset() {
        if (this.inline) {
            this.executed = false;
            this.lastException = null;
            this.inlineDescriptor = null;
            if (this.managedFieldNames == null) {
                this.managedFieldNames = EngineHelper.initManagedFields(this, WorkflowBehaviour.class);
            }
            for (String fieldName : this.managedFieldNames) {
                this.setFieldValue(fieldName, null);
            }
        }
        super.reset();
    }

    @Override
    public boolean isError() {
        return this.errorActivity;
    }

    @Override
    public void setError(boolean b) {
        if (this.inline) {
            this.errorActivity = true;
        }
    }

    @Override
    public final Throwable getLastException() {
        return this.lastException;
    }

    @Override
    public final void handleException(Throwable t) {
        if (this.frozen) {
            this.forceTransitionTo(FROZEN_STATE);
        } else {
            this.lastException = t;
            this.forceTransitionTo(ERROR_STATE);
        }
    }

    @Override
    public void propagateException(Throwable t) {
        if (this.inline) {
            ((HierarchyNode)this.parent).handleException(t);
        }
    }

    protected void handleInconsistentFSM(String current, int exitValue) {
        WorkflowException t = null;
        HierarchyNode node = null;
        if (current.equals(START_STATE)) {
            node = this;
            t = new WorkflowException("Inconsistent FSM: missing initial activity");
        } else {
            node = (HierarchyNode)this.getState(current);
            Throwable nested = node.getLastException();
            t = nested != null ? new WorkflowException("Uncaught exception in activity  " + current, nested) : new WorkflowException("Inconsistent FSM: activity " + current + ", event " + exitValue);
        }
        EngineHelper.fireExecutionErrorEvent(node, (Throwable)t, 1);
        this.handleException((Throwable)t);
        this.scheduleNext(true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterInterruptableSection() {
        if (!this.inline) {
            WorkflowBehaviour workflowBehaviour = this;
            synchronized (workflowBehaviour) {
                if (!this.interruptable) {
                    if (this.interrupted) {
                        throw new Agent.Interrupted();
                    }
                    this.interruptable = true;
                    return true;
                }
                return false;
            }
        }
        return ((WorkflowBehaviour)this.parent).enterInterruptableSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitInterruptableSection(HierarchyNode current) {
        if (!this.inline) {
            WorkflowBehaviour workflowBehaviour = this;
            synchronized (workflowBehaviour) {
                this.interruptable = false;
                if (this.interrupted) {
                    this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - WorkflowBehaviour " + this.getExecutionId() + " interrupted");
                    if (current != null) {
                        current.setInterrupted();
                        this.handleException((Throwable)((Object)new Aborted(this.abortMessage, current.getLastException())));
                    } else {
                        this.handleException((Throwable)((Object)new Aborted(this.abortMessage)));
                    }
                    this.clearInterruption();
                    this.rootExecutor.resume();
                    this.notifyAll();
                }
            }
        } else {
            ((WorkflowBehaviour)this.parent).exitInterruptableSection(this);
        }
    }

    void clearInterruption() {
        this.interrupted = false;
        this.abortMessage = null;
        Thread.interrupted();
    }

    synchronized void interrupt(WorkflowEngineAgent.WorkflowExecutor executor, ThreadedBehaviourFactory tbf, String abortMessage, boolean frozen) {
        if (this.rollbackWorkflow != null) {
            this.rollbackWorkflow.interrupt(executor, tbf, abortMessage, frozen);
        } else {
            if (frozen) {
                this.setFrozen();
            }
            this.abortMessage = abortMessage;
            this.interrupted = true;
            if (this.interruptable) {
                try {
                    Thread t = tbf.getThread((Behaviour)executor);
                    t.interrupt();
                    this.wait(10000L);
                    if (this.interrupted) {
                        this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Workflow " + this.getExecutionId() + " did not react to interruption. Stop it!");
                        t.stop();
                    }
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.inlineInterrupted;
    }

    @Override
    public void setInterrupted() {
        if (this.inline) {
            this.inlineInterrupted = true;
            this.forceTransitionTo(ERROR_STATE);
            ((HierarchyNode)this.getCurrent()).setInterrupted();
        }
    }

    protected boolean checkTermination(boolean currentDone, int currentResult) {
        if (currentDone) {
            if (this.suspendAsap) {
                this.suspend();
                this.suspendAsap(false);
            }
            if (!this.isVolatile() && (this.isLongRunning() || this.supportTags()) && (this.getCurrent().getBehaviourName().equals(START_STATE) || this.getCurrent() instanceof HierarchyNode && ((HierarchyNode)this.getCurrent()).requireSave() && !((HierarchyNode)this.getCurrent()).isInterrupted())) {
                WorkflowSerializationManager.save(this);
            }
        }
        boolean b = super.checkTermination(currentDone, currentResult);
        boolean b1 = false;
        if (currentDone) {
            b1 = this.lastStates.contains((Object)this.currentName);
        }
        if (b != b1) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - WorkflowBehaviour " + this.getBehaviourName() + ": FSM.checkTermination() returned " + b + " with Last-states = " + this.lastStates + " and currentName = " + this.currentName);
        }
        return b1;
    }

    protected void scheduleNext(boolean currentDone, int currentResult) {
        if (this.thawed) {
            this.manageThawed();
        }
        super.scheduleNext(currentDone, currentResult);
    }

    Method getMethod(String methodName, Class[] paramTypes) throws NoSuchMethodException {
        Method m = this.cachedMethods.get(methodName);
        if (m == null) {
            m = this.getMethod(methodName, this.getClass(), paramTypes);
            if (m != null) {
                if (!m.isAccessible()) {
                    try {
                        m.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        throw new NoSuchMethodException("Method " + methodName + "() of class " + this.getClass().getName() + " not accessible.");
                    }
                }
                this.cachedMethods.put(methodName, m);
            } else {
                throw new NoSuchMethodException("Method " + methodName + "() not found class " + this.getClass().getName());
            }
        }
        return m;
    }

    Method getMethod(String methodName, Class currentClass, Class[] paramTypes) throws NoSuchMethodException {
        Method m;
        block2: {
            m = null;
            try {
                m = currentClass.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException nsme) {
                Class superClass = currentClass.getSuperclass();
                if (FSMBehaviour.class.equals(superClass)) break block2;
                m = this.getMethod(methodName, superClass, paramTypes);
            }
        }
        return m;
    }

    void copyFieldsValue(WorkflowBehaviour sourceWorkflow) {
        this.copyFields(sourceWorkflow, this.getClass());
    }

    private void copyFields(WorkflowBehaviour sourceWorkflow, Class currentClass) {
        Class superClass = currentClass.getSuperclass();
        if (!WorkflowBehaviour.class.equals(superClass)) {
            this.copyFields(sourceWorkflow, superClass);
        }
        Field[] myFields = currentClass.getDeclaredFields();
        for (int i = 0; i < myFields.length; ++i) {
            Field myField = myFields[i];
            String fieldName = myField.getName();
            try {
                Field f = EngineHelper.getField(fieldName, sourceWorkflow, sourceWorkflow.cachedFields);
                if (!f.getType().equals(myField.getType())) continue;
                try {
                    Object value = f.get(sourceWorkflow);
                    myField.setAccessible(true);
                    myField.set(this, value);
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.WARNING, "Cannot copy value of field " + fieldName + ". " + e.getMessage());
                }
                continue;
            }
            catch (NoSuchFieldException nsfe) {
                // empty catch block
            }
        }
    }

    public final void trace(int level, String msg) {
        this.rootExecutor.getTracer().trace(level, msg);
    }

    public final void trace(String msg) {
        this.trace(3, msg);
    }

    public Tracer getTracer() {
        return this.rootExecutor.getTracer();
    }

    protected void performRestService(RestService rs) throws Exception {
        this.manageBindings(rs);
        rs.invoke();
    }

    protected void performWebService(WebService ws) throws Exception {
        this.manageBindings(ws);
        ws.invoke();
    }

    protected void performDynamicWebService(DynamicWebService dws) throws Exception {
        this.manageBindings(dws);
        dws.invoke();
    }

    @Override
    public BindingManager getBindingManager() {
        if (this.bindingManager == null) {
            this.bindingManager = new BindingManager(this);
        }
        return this.bindingManager;
    }

    private BindingManager getBindingManager(String activityName) throws BindingException {
        BindingManager bindingManager = null;
        HierarchyNode activity = (HierarchyNode)this.getState(activityName);
        if (activity == null) {
            throw new BindingException("Activity " + activityName + " not present in " + this.getBehaviourName());
        }
        bindingManager = activity.getBindingManager();
        return bindingManager;
    }

    protected AbsObject getAbsValue(String activityName, String key, int mode, String part) throws Exception {
        BindingManager bm = this.getBindingManager(activityName);
        return bm.getAbsValue(key, mode, part);
    }

    protected Object getValue(String activityName, String key, int mode, String part) throws Exception {
        BindingManager bm = this.getBindingManager(activityName);
        return bm.getValue(key, mode, part);
    }

    protected String getOccurredCase(String activityName) throws IllegalArgumentException {
        HierarchyNode activity = (HierarchyNode)this.getState(activityName);
        if (activity != null && activity instanceof WaitMultipleCasesBehaviour) {
            return ((WaitMultipleCasesBehaviour)activity).getOccurredCase();
        }
        throw new IllegalArgumentException("Activity " + activityName + " does not exist or is not a WaitMultipleCases activity");
    }

    protected void manageBindings(BuildingBlock bb) throws Exception {
        bb.getActivity().getBindingManager().resolveBindings(bb);
        this.handleDefaultParameters(bb);
        this.handleUngroundedParameters(bb);
        bb.getActivity().getBindingManager().convertParameters(bb);
    }

    protected void handleDefaultParameters(BuildingBlock bb) throws Exception {
        DefaultParameterValues dpv = EngineHelper.extractDefaultParameterValues(this);
        if (dpv != null) {
            for (String parameterName : bb.getInputParameterNames()) {
                Object parameterValue = bb.getInput(parameterName);
                java.util.List defaultValues = dpv.getValues(bb.getActivity().getBehaviourName(), parameterName);
                if (defaultValues == null || defaultValues.size() <= 0) continue;
                AbsObject parameterAbsValue = null;
                boolean applyDefaults = false;
                if (parameterValue == null) {
                    applyDefaults = true;
                } else if (parameterValue != null && parameterValue instanceof AbsObject && !(parameterAbsValue = (AbsObject)parameterValue).isGrounded()) {
                    applyDefaults = true;
                }
                if (!applyDefaults) continue;
                if (parameterValue == null) {
                    parameterAbsValue = bb.createAbsTemplate(parameterName);
                }
                for (DefaultParameterValues.DefaultValue defaultValue : defaultValues) {
                    String defPart = defaultValue.getPart();
                    Object defValue = defaultValue.getValue();
                    AbsObject templateAbsValue = defPart == null ? parameterAbsValue : BindingManager.getAttribute(parameterAbsValue, defPart);
                    AbsObject defAbsValue = bb.getOntology().fromObject(defValue);
                    AbsObject defaultedAbsValue = AbsHelper.applyDefaultValues((AbsObject)templateAbsValue, (AbsObject)defAbsValue);
                    if (defPart == null) {
                        parameterAbsValue = defaultedAbsValue;
                        this.myLogger.log(Logger.INFO, "Total default value of activity " + bb.getActivity().getBehaviourName() + ", parameter " + parameterName + " = " + parameterAbsValue);
                        break;
                    }
                    BindingManager.setAttribute(parameterAbsValue, defPart, defaultedAbsValue);
                    this.myLogger.log(Logger.INFO, "Partial default of activity " + bb.getActivity().getBehaviourName() + ", parameter " + parameterName + "." + defPart + " = " + defaultedAbsValue);
                }
                bb.setInput(parameterName, parameterAbsValue);
            }
        }
    }

    protected void handleUngroundedParameters(BuildingBlock bb) throws Exception {
        for (String parameterName : bb.getInputParameterNames()) {
            AbsObject parameterAbs;
            Object parameterValue = bb.getInput(parameterName);
            if (parameterValue == null || !(parameterValue instanceof AbsObject) || (parameterAbs = (AbsObject)parameterValue).isGrounded()) continue;
            bb.setInput(parameterName, AbsHelper.nullifyVariables((AbsObject)parameterAbs, (boolean)false));
        }
    }

    @Override
    public BuildingBlock getBuildingBlock(String id) {
        if (this.inline && this.subflow != null) {
            return this.subflow;
        }
        return null;
    }

    protected void handleBeginActivity(HierarchyNode activity) {
        this.getAgent().handleBeginActivity(this.rootExecutor, activity.getBehaviourName());
    }

    protected void handleEndActivity(HierarchyNode activity) {
        activity.getAgent().handleEndActivity(this.rootExecutor, activity.getBehaviourName());
    }

    protected void handleBeginApplication(Application appl, HierarchyNode activity) {
        this.getAgent().handleBeginApplication(this.rootExecutor, appl.getName());
    }

    protected void handleEndApplication(Application appl, HierarchyNode activity) {
        this.getAgent().handleEndApplication(this.rootExecutor, appl.getName());
    }

    @Override
    public WorkflowBehaviour getOwner() {
        if (this.inline) {
            return (WorkflowBehaviour)this.getParent();
        }
        return null;
    }

    public Ontology getOntology() throws Exception {
        if (this.onto == null) {
            this.onto = this.createOntology();
        }
        return this.onto;
    }

    private Ontology createOntology() throws Exception {
        BeanOntology onto = new BeanOntology("WfFormalParametersOnto");
        List formalParams = this.getFormalParameters();
        for (Parameter param : formalParams) {
            OntologyUtils.addFormalParameterToOntology((BeanOntology)onto, (Parameter)param, (ClassLoader)this.getClass().getClassLoader());
        }
        return onto;
    }

    public void onSuspended() {
    }

    public void onResumed() {
    }

    protected void onFrozen() {
    }

    protected void onThawed() {
    }

    protected void manageThawed() {
        if (this.inline) {
            ((WorkflowBehaviour)this.parent).manageThawed();
        } else {
            this.onThawed();
            this.setThawed(false);
        }
    }

    void setThawed(boolean thawed) {
        this.thawed = thawed;
        Behaviour currentBehaviour = this.getCurrent();
        if (currentBehaviour != null && currentBehaviour instanceof WorkflowBehaviour) {
            ((WorkflowBehaviour)currentBehaviour).setThawed(thawed);
        }
    }

    @Override
    public boolean requireSave() {
        return false;
    }

    protected void tag(String tagName) throws Exception {
        WorkflowSerializationManager.tag(tagName, this);
    }

    protected void reloadTag(String tagName) throws Exception {
        WorkflowSerializationManager.reloadTag(tagName, this);
    }

    protected WorkflowEvent customizeEvent(String id, long time, String type, WorkflowEvent ev, List controllers) {
        return ev;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.cachedFields = new HashMap<String, Field>();
        this.cachedMethods = new HashMap<String, Method>();
    }

    protected boolean isInline() {
        return this.inline;
    }

    protected List extractOutputParameters() throws WorkflowException {
        List parameters = this.getDescriptor().getParameters();
        EngineHelper.extractOutputParameters(this, parameters);
        return parameters;
    }

    protected final boolean isSubflow() {
        if (this.inline) {
            return true;
        }
        return this.getDescriptor().getDelegationChain() != null;
    }

    private class WorkflowInitializationException
    extends RuntimeException {
        private WorkflowInitializationException(String msg, Exception nested) {
            super(msg, nested);
        }
    }
}

