/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.ca.WadeClassLoader;
import com.tilab.wade.commons.AgentInitializationException;
import com.tilab.wade.commons.AttributeGetter;
import com.tilab.wade.commons.AttributeSetter;
import com.tilab.wade.commons.WadeAgentImpl;
import com.tilab.wade.event.EventOntology;
import com.tilab.wade.formats.WorkflowInterpreter;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.ExecutorsTable;
import com.tilab.wade.performer.StatusManager;
import com.tilab.wade.performer.Tracer;
import com.tilab.wade.performer.UnsupportedEnqueuingException;
import com.tilab.wade.performer.WEAEventEmitter;
import com.tilab.wade.performer.WatchDog;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowException;
import com.tilab.wade.performer.WorkflowExecutorReplacer;
import com.tilab.wade.performer.WorkflowSerializationManager;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.event.AbortedTransaction;
import com.tilab.wade.performer.event.BeginActivity;
import com.tilab.wade.performer.event.BeginApplication;
import com.tilab.wade.performer.event.BeginWorkflow;
import com.tilab.wade.performer.event.CommittedTransaction;
import com.tilab.wade.performer.event.DelegatedSubflow;
import com.tilab.wade.performer.event.EndActivity;
import com.tilab.wade.performer.event.EndApplication;
import com.tilab.wade.performer.event.EndSubflow;
import com.tilab.wade.performer.event.EndWorkflow;
import com.tilab.wade.performer.event.EventEmitter;
import com.tilab.wade.performer.event.ExecutionErrorEvent;
import com.tilab.wade.performer.event.OpenedTransaction;
import com.tilab.wade.performer.event.SuccessfulTerminationEvent;
import com.tilab.wade.performer.event.UnsuccessfulTerminationEvent;
import com.tilab.wade.performer.event.WorkflowEvent;
import com.tilab.wade.performer.interactivity.ontology.InteractivityOntology;
import com.tilab.wade.performer.ontology.ControlInfo;
import com.tilab.wade.performer.ontology.ExecuteWorkflow;
import com.tilab.wade.performer.ontology.ExecutionError;
import com.tilab.wade.performer.ontology.ExecutorInfo;
import com.tilab.wade.performer.ontology.Frozen;
import com.tilab.wade.performer.ontology.GetPoolSize;
import com.tilab.wade.performer.ontology.GetSessionStatus;
import com.tilab.wade.performer.ontology.GetWRD;
import com.tilab.wade.performer.ontology.KillWorkflow;
import com.tilab.wade.performer.ontology.Modifier;
import com.tilab.wade.performer.ontology.RecoverWorkflow;
import com.tilab.wade.performer.ontology.ResetControlInfos;
import com.tilab.wade.performer.ontology.ResetModifiers;
import com.tilab.wade.performer.ontology.SetControlInfo;
import com.tilab.wade.performer.ontology.SetPoolSize;
import com.tilab.wade.performer.ontology.SetWRD;
import com.tilab.wade.performer.ontology.ThawWorkflow;
import com.tilab.wade.performer.ontology.UpdateControlInfo;
import com.tilab.wade.performer.ontology.WorkflowManagementOntology;
import com.tilab.wade.performer.transaction.TransactionEntry;
import com.tilab.wade.performer.transaction.TransactionManager;
import com.tilab.wade.utils.GUIDGenerator;
import com.tilab.wade.wsma.ontology.WorkflowExecutionInfo;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.ThreadedBehaviourFactory;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.introspection.IntrospectionServer;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ConversationList;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.util.Date;
import java.util.Hashtable;

public class WorkflowEngineAgent
extends WadeAgentImpl {
    private static final boolean TRACE_ACTIVITIES = false;
    public static final int IDLE_STATUS = 0;
    public static final int EXECUTING_STATUS = 1;
    public static final int TERMINATING_STATUS = 2;
    public static final int WAITING_STATUS = 3;
    public static final int DONE_STATUS = 4;
    public static final int SUSPENDED_STATUS = 5;
    public static final String POOL_SIZE_ATTRIBUTE = "PoolSize";
    public static final String BUSY_EXECUTORS_ATTRIBUTE = "BusyExecutors";
    public static final String THREAD_CNT_ATTRIBUTE = "ThreadCnt";
    public static final String WORKFLOW_CNT_ATTRIBUTE = "WorkflowCnt";
    public static final String ENQUEUED_CNT_ATTRIBUTE = "EnqueuedCnt";
    public static final String ACTIVE_CNT_ATTRIBUTE = "ActiveCnt";
    public static final String DEFAULT_WORKFLOW_TIMEOUT_ATTRIBUTE = "DefaultWorkflowTimeout";
    public static final String REQUIRE_WSMA_ATTRIBUTE = "RequireWSMA";
    public static final String WSMA_SEARCH_TIMEOUT_ATTRIBUTE = "WSMASearchTimeout";
    static final String EXECUTE = "execute";
    private static final String HANDLE_SUCCESS = "handle-success";
    private static final String HANDLE_FAILURE = "handle-failure";
    private static final String HANDLE_FROZEN = "handle-frozen";
    private static final String WAIT_COMMIT = "wait-commit";
    private static final String PREPARE_ROLLBACK = "prepare-rollback";
    private static final String COMMIT = "commit";
    private static final String ROLLBACK = "rollback";
    private static final String HANDLE_COMMIT_SUCCESS = "handle-commit-success";
    private static final String HANDLE_ROLLBACK_SUCCESS = "handle-rollback-success";
    private static final String HANDLE_TRANSACTION_FAILURE = "handle-transaction-failure";
    private static final String SEND_REPLY = "send-reply";
    private static final int TRANSACTION = -11;
    static final int NONE = 0;
    static final int KILLED = 1;
    static final int TIMED_OUT = 2;
    private static ThreadLocal<Hashtable> executionContexts = new ThreadLocal();
    protected transient Ontology onto = this.getOntology();
    private long wfCnt = 0L;
    protected ExecutorsTable executors = new ExecutorsTable();
    protected transient ThreadedBehaviourFactory tbf = new ThreadedBehaviourFactory();
    private int poolSize;
    private static final int DEFAULT_POOL_SIZE = 3;
    private long defaultWorkflowTimeout;
    private static final long DEFAULT_WORKFLOW_TIMEOUT = 1800000L;
    public static final long DEFAULT_WSMA_SEARCH_TIMEOUT = 10000L;
    public static final String TAG_DIR = "tagDir";
    private List workflowQueue = new LinkedList();
    private transient Object enqueuingLock = new Object();
    private ConversationList conversations;
    private ConversationList interactivityConversations;
    private transient StatusManager statusManager;

    public static Hashtable getExecutionContext() {
        return executionContexts.get();
    }

    protected void agentSpecificSetup() throws AgentInitializationException {
        this.getContentManager().registerOntology(this.onto);
        this.getContentManager().registerOntology(EventOntology.getInstance());
        this.getContentManager().registerOntology(InteractivityOntology.getInstance());
        this.addBehaviour((Behaviour)new CyclicBehaviour(){
            private MessageTemplate template;
            {
                this.template = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)WorkflowEngineAgent.this.onto.getName()), (MessageTemplate)MessageTemplate.or((MessageTemplate)MessageTemplate.MatchPerformative((int)16), (MessageTemplate)MessageTemplate.MatchPerformative((int)3)));
            }

            public void action() {
                ACLMessage msg = this.myAgent.receive(this.template);
                if (msg != null) {
                    if (WorkflowEngineAgent.this.myLogger.isLoggable(Logger.FINEST)) {
                        WorkflowEngineAgent.this.myLogger.log(Logger.FINEST, "Agent " + WorkflowEngineAgent.this.getName() + " - Incoming request received: " + msg);
                    }
                    WorkflowEngineAgent.this.serveRequest(msg);
                } else {
                    this.block();
                }
            }
        });
        this.conversations = new ConversationList((Agent)this);
        this.addBehaviour((Behaviour)new CyclicBehaviour(){
            private MessageTemplate template;
            {
                this.template = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)WorkflowEngineAgent.this.onto.getName()), (MessageTemplate)MessageTemplate.and((MessageTemplate)MessageTemplate.or((MessageTemplate)MessageTemplate.MatchPerformative((int)11), (MessageTemplate)MessageTemplate.or((MessageTemplate)MessageTemplate.MatchPerformative((int)0), (MessageTemplate)MessageTemplate.MatchPerformative((int)15))), (MessageTemplate)WorkflowEngineAgent.this.conversations.getMessageTemplate()));
            }

            public void action() {
                ACLMessage msg = this.myAgent.receive(this.template);
                if (msg != null) {
                    if (msg.getPerformative() == 11) {
                        ACLMessage reply = msg.createReply();
                        WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + WorkflowEngineAgent.this.getName() + " - Spurious PROPOSE message received from " + msg.getSender().getName() + ". Reject it");
                        reply.setPerformative(15);
                        reply.setContent(WorkflowEngineAgent.this.getName() + ": refuse unknown PROPOSE message");
                        WorkflowEngineAgent.this.send(reply);
                    } else if (msg.getPerformative() == 0 || msg.getPerformative() == 15) {
                        ACLMessage reply = msg.createReply();
                        WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + WorkflowEngineAgent.this.getName() + " - Spurious " + ACLMessage.getPerformative((int)msg.getPerformative()) + " message received from " + msg.getSender().getName() + ". Reply with FAILURE");
                        reply.setPerformative(6);
                        reply.setContent(WorkflowEngineAgent.this.getName() + ": refuse unknown ACCEPT-PROPOSAL or REJECT_PROPOSAL message");
                        WorkflowEngineAgent.this.send(reply);
                    }
                } else {
                    this.block();
                }
            }
        });
        this.interactivityConversations = new ConversationList((Agent)this);
        this.addBehaviour((Behaviour)new CyclicBehaviour(){
            private MessageTemplate template;
            {
                this.template = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)InteractivityOntology.getInstance().getName()), (MessageTemplate)WorkflowEngineAgent.this.interactivityConversations.getMessageTemplate());
            }

            public void action() {
                ACLMessage msg = this.myAgent.receive(this.template);
                if (msg != null) {
                    if (msg.getPerformative() == 16) {
                        WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + WorkflowEngineAgent.this.getName() + " - Spurious interactivity REQUEST message received from " + msg.getSender().getName() + ". Conversation-id=" + msg.getConversationId() + ". Send back a FAILURE");
                        ACLMessage reply = msg.createReply();
                        reply.setPerformative(6);
                        reply.setContent("Unknown session " + msg.getConversationId() + ". Workflow has probably expired");
                        WorkflowEngineAgent.this.send(reply);
                    }
                } else {
                    this.block();
                }
            }
        });
        this.addBehaviour((Behaviour)new IntrospectionServer((Agent)this));
        this.poolSize = this.getIntArgument(POOL_SIZE_ATTRIBUTE, -1);
        if (this.poolSize == -1) {
            this.poolSize = this.getIntTypeProperty(POOL_SIZE_ATTRIBUTE, 3);
        }
        this.defaultWorkflowTimeout = this.getLongArgument(DEFAULT_WORKFLOW_TIMEOUT_ATTRIBUTE, -1L);
        if (this.defaultWorkflowTimeout == -1L) {
            this.defaultWorkflowTimeout = this.getLongTypeProperty(DEFAULT_WORKFLOW_TIMEOUT_ATTRIBUTE, 1800000L);
        }
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Ready ...");
    }

    protected void takeDown() {
        this.tbf.interrupt();
        if (this.myLogger != null) {
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Terminated");
        }
    }

    protected void beforeMove() {
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Wait for currently active executors to complete before moving...");
        ThreadedBehaviourFactory.ThreadedBehaviourWrapper[] wrappers = this.tbf.getWrappers();
        boolean ok = this.tbf.waitUntilEmpty(60000L);
        if (ok) {
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - All executors completed");
        } else {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - " + this.tbf.size() + " executors still active. Interrupt them.");
            this.tbf.interrupt();
            this.tbf.waitUntilEmpty(5000L);
        }
        for (int i = 0; i < wrappers.length; ++i) {
            this.removeBehaviour((Behaviour)wrappers[i]);
        }
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Move now");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.tbf = new ThreadedBehaviourFactory();
        this.enqueuingLock = new Object();
        this.onto = this.getOntology();
        this.getContentManager().registerOntology(this.onto);
        this.getContentManager().registerOntology(EventOntology.getInstance());
    }

    public int getCurrentLoad() {
        return this.executors.size();
    }

    public boolean isWorking() {
        return this.executors.size() > 0;
    }

    public boolean prepareForShutdown() {
        for (ExecutorInfo ei : this.executors.getStatus()) {
            WorkflowExecutor we = this.executors.get(ei.getId());
            boolean longRunning = we.getWorkflow().isLongRunning();
            if (longRunning) {
                if (we.getStatus() == 5) {
                    this.executors.remove(ei.getId());
                    continue;
                }
                we.getWorkflow().suspendAsap(true);
                continue;
            }
            if (this.isShuttingDown()) continue;
            we.kill(false, true);
        }
        return super.prepareForShutdown();
    }

    private final void serveRequest(ACLMessage msg) {
        try {
            Action aExpr = (Action)this.getContentManager().extractContent(msg);
            AgentAction act = (AgentAction)aExpr.getAction();
            if (act instanceof ExecuteWorkflow) {
                this.serveExecuteWorkflow(msg, aExpr, (ExecuteWorkflow)act);
            } else if (act instanceof ThawWorkflow) {
                this.serveThawWorkflow(msg, aExpr, (ThawWorkflow)act);
            } else if (act instanceof RecoverWorkflow) {
                this.serveRecoverWorkflow(msg, aExpr, (RecoverWorkflow)act);
            } else if (act instanceof KillWorkflow) {
                this.serveKillWorkflow(msg, aExpr, (KillWorkflow)act);
            } else if (act instanceof SetControlInfo) {
                this.serveSetControlInfo(msg, aExpr, (SetControlInfo)act);
            } else if (act instanceof UpdateControlInfo) {
                this.serveUpdateControlInfo(msg, aExpr, (UpdateControlInfo)act);
            } else if (act instanceof GetWRD) {
                this.serveGetWRD(msg, aExpr, (GetWRD)act);
            } else if (act instanceof SetWRD) {
                this.serveSetWRD(msg, aExpr, (SetWRD)act);
            } else if (act instanceof GetPoolSize) {
                this.serveGetPoolSize(msg, aExpr, (GetPoolSize)act);
            } else if (act instanceof SetPoolSize) {
                this.serveSetPoolSize(msg, aExpr, (SetPoolSize)act);
            } else if (act instanceof GetSessionStatus) {
                this.serveGetSessionStatus(msg, aExpr, (GetSessionStatus)act);
            } else if (act instanceof ResetControlInfos) {
                this.serveResetControlInfos(msg, aExpr, (ResetControlInfos)act);
            } else if (act instanceof ResetModifiers) {
                this.serveResetModifiers(msg, aExpr, (ResetModifiers)act);
            } else {
                this.handleUnknownAction(act, aExpr, msg);
            }
        }
        catch (OntologyException oe) {
            this.handleError(oe, msg, 10, "Malformed request. ");
        }
        catch (Codec.CodecException ce) {
            this.handleError(ce, msg, 10, "Malformed request. ");
        }
        catch (Throwable t) {
            this.handleError(t, msg, 6, "Unexpected error. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serveExecuteWorkflow(ACLMessage msg, Action aExpr, ExecuteWorkflow ew) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving ExecuteWorkflow request... ");
        }
        this.updateSessionStartup(ew.getWhat());
        try {
            this.checkVerifyModifier(ew, aExpr, msg);
            Object object = this.enqueuingLock;
            synchronized (object) {
                WorkflowExecutor we = new WorkflowExecutor(this, ew, msg, aExpr);
                if (this.mustEnqueue(we) && !we.getWorkflow().supportEnqueuing()) {
                    throw new UnsupportedEnqueuingException();
                }
                if (!we.getWorkflow().isVolatile()) {
                    this.getStatusManager().notifyStarted(we);
                }
                this.reply(msg, 1, we.getId());
                this.handleIncomingWorkflow(we, msg.getSender());
                this.executors.insert(we);
            }
            if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Agent " + this.getName() + " - ExecuteWorkflow request served.");
            }
        }
        catch (UnsupportedEnqueuingException uee) {
            this.handleError(uee, msg, 6, "Agent busy and workflow does not support enqueuing " + ew.getWhat().getId() + ". ");
        }
        catch (Throwable t) {
            this.handleError(t, msg, 6, "Error loading Workflow " + ew.getWhat().getId() + ". ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serveThawWorkflow(ACLMessage msg, Action aExpr, ThawWorkflow dw) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving ThawWorkflow request... ");
        }
        try {
            Object object = this.enqueuingLock;
            synchronized (object) {
                WorkflowExecutor we = WorkflowSerializationManager.deserializeWorkflow(dw.getWorkflowSerializedState(), this);
                we.reply = msg.createReply();
                we.getWorkflow().setThawed(true);
                we.getEventEmitter().setControlInfo(dw.getControlInfos());
                we.setModifiers(dw.getModifiers());
                if (dw.getExecution() != null) {
                    we.getDescriptor().setExecution(dw.getExecution().intValue());
                }
                if (this.mustEnqueue(we) && !we.getWorkflow().supportEnqueuing()) {
                    throw new UnsupportedEnqueuingException();
                }
                if (!we.getWorkflow().isVolatile()) {
                    this.getStatusManager().notifyThawed(we);
                }
                this.reply(msg, 1, we.getId());
                this.handleIncomingWorkflow(we, msg.getSender());
                this.executors.insert(we);
            }
            if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Agent " + this.getName() + " - ThawWorkflow request served.");
            }
        }
        catch (UnsupportedEnqueuingException uee) {
            this.handleError(uee, msg, 6, "Agent busy and workflow does not support enqueuing " + dw.getExecution() + ". ");
        }
        catch (Throwable t) {
            this.handleError(t, msg, 6, "Error thawing workflow");
        }
    }

    protected void serveRecoverWorkflow(ACLMessage msg, Action aExpr, RecoverWorkflow rw) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving RecoverWorkflow request... ");
        }
        try {
            List newModifiers;
            WorkflowExecutor we = this.executors.get(rw.getExecutionId());
            if (we == null) {
                throw new WorkflowException("Workflow " + rw.getExecutionId() + " not present. ");
            }
            we.reply = msg.createReply();
            List newControlInfos = rw.getControlInfos();
            if (newControlInfos != null) {
                we.getEventEmitter().setControlInfo(newControlInfos);
            }
            if ((newModifiers = rw.getModifiers()) != null) {
                we.setModifiers(newModifiers);
            }
            if (rw.getExecution() != null) {
                we.getDescriptor().setExecution(rw.getExecution().intValue());
            }
            if (we.getStatus() == 5) {
                we.resume();
            }
            this.reply(msg, 1, we.getId());
            if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Agent " + this.getName() + " - RecoverWorkflow request served.");
            }
        }
        catch (Throwable t) {
            this.handleError(t, msg, 6, "Error recovering Workflow " + rw.getExecutionId() + ". ");
        }
    }

    private void updateSessionStartup(WorkflowDescriptor wd) {
        if (wd.getSessionId() != null && wd.getSessionStartup() == null) {
            wd.setSessionStartup(new Date());
        }
    }

    private boolean checkVerifyModifier(ExecuteWorkflow ew, Action aExpr, ACLMessage request) {
        List modifiers = ew.getModifiers();
        Modifier verifyModifier = Modifier.getModifier((String)"VERIFY", (List)modifiers);
        if (verifyModifier != null) {
            this.cleanPendingSessions(ew, aExpr, request);
        }
        return false;
    }

    private void cleanPendingSessions(ExecuteWorkflow ew, Action aExpr, ACLMessage request) {
        String sessionId = ew.getWhat().getSessionId();
        if (sessionId != null) {
            Date startup = ew.getWhat().getSessionStartup();
            List ee = this.executors.getPendingExecutors(sessionId, startup);
            for (WorkflowExecutor we : ee) {
                this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Killing pending execution " + we.getId() + " with verified session id " + sessionId);
                we.kill(false, true);
            }
        }
    }

    protected void serveKillWorkflow(final ACLMessage msg, Action aExpr, final KillWorkflow kw) {
        Thread t = new Thread(){

            public void run() {
                block7: {
                    String executionId = kw.getExecutionId();
                    WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Serving KillWorkflow request. ID = " + executionId + " ... ");
                    WorkflowExecutor we = WorkflowEngineAgent.this.executors.get(executionId);
                    if (we != null) {
                        try {
                            boolean freeze;
                            boolean bl = freeze = kw.getFreeze() != null ? kw.getFreeze() : false;
                            if (freeze && !we.getWorkflow().isLongRunning()) {
                                WorkflowEngineAgent.this.reply(msg, 14, WorkflowEngineAgent.this.createGenericError("Cannot freeze a short-running workflow"));
                                break block7;
                            }
                            boolean smooth = kw.getSmooth() != null ? kw.getSmooth() : true;
                            boolean requireKill = kw.getScope() == 0 || kw.getScope() == 2;
                            boolean propagated = true;
                            if (kw.getScope() != 0) {
                                propagated = we.getWorkflow().propagateKill(kw);
                            }
                            if (requireKill || !propagated) {
                                we.kill(false, smooth, freeze, kw.getMessage());
                            }
                            WorkflowEngineAgent.this.reply(msg, 7, null);
                            WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - KillWorkflow request served.");
                        }
                        catch (Throwable t) {
                            WorkflowEngineAgent.this.handleError(t, msg, 6, "Error killing Workflow " + executionId + ". ");
                        }
                    } else {
                        WorkflowEngineAgent.this.reply(msg, 14, WorkflowEngineAgent.this.createGenericError("Workflow not assigned"));
                    }
                }
            }
        };
        t.start();
    }

    protected void serveSetControlInfo(ACLMessage msg, Action aExpr, SetControlInfo sci) {
        WorkflowExecutor we;
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving SetControlInfo request... ");
        }
        if ((we = this.executors.get(sci.getExecutionId())) != null) {
            we.getEventEmitter().setControlInfo(sci.getInfo());
            this.reply(msg, 7, null);
            if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Agent " + this.getName() + " - SetControlInfo request served.");
            }
        } else {
            this.reply(msg, 14, this.createGenericError("Workflow not assigned"));
        }
    }

    protected void serveUpdateControlInfo(ACLMessage msg, Action aExpr, UpdateControlInfo uci) {
        WorkflowExecutor we;
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving UpdateControlInfo request... ");
        }
        if ((we = this.executors.get(uci.getExecutionId())) != null) {
            we.getEventEmitter().updateControlInfo(uci.getInfo());
            this.reply(msg, 7, null);
            if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Agent " + this.getName() + " - UpdateControlInfo request served.");
            }
        } else {
            this.reply(msg, 14, this.createGenericError("Workflow not assigned"));
        }
    }

    protected void serveGetWRD(ACLMessage msg, Action aExpr, GetWRD gwrd) {
        WorkflowExecutor we;
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving GetWRD request... ");
        }
        if ((we = this.executors.get(gwrd.getExecutionId())) != null) {
            try {
                Object value = we.getWorkflow().getFieldValue(gwrd.getWrd());
                if (value == null) {
                    value = "null";
                }
                Result r = new Result((Concept)aExpr, value);
                ACLMessage reply = msg.createReply();
                reply.setPerformative(7);
                this.getContentManager().fillContent(reply, (ContentElement)r);
                this.send(reply);
            }
            catch (Throwable t) {
                this.handleError(t, msg, 6, "Error retrieving value of WRD " + gwrd.getWrd() + ". ");
            }
        } else {
            this.reply(msg, 14, this.createGenericError("Workflow not assigned"));
        }
    }

    protected void serveSetWRD(ACLMessage msg, Action aExpr, SetWRD swrd) {
        WorkflowExecutor we;
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving SetWRD request... ");
        }
        if ((we = this.executors.get(swrd.getExecutionId())) != null) {
            we.getWorkflow().setFieldValue(swrd.getWrd(), swrd.getValue());
            this.reply(msg, 7, null);
        } else {
            this.reply(msg, 14, this.createGenericError("Workflow not assigned"));
        }
    }

    protected void serveGetPoolSize(ACLMessage msg, Action aExpr, GetPoolSize gps) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving GetPoolSize request... ");
        }
        try {
            Result r = new Result((Concept)aExpr, (Object)new Integer(this.getPoolSize()));
            ACLMessage reply = msg.createReply();
            reply.setPerformative(7);
            this.getContentManager().fillContent(reply, (ContentElement)r);
            this.send(reply);
        }
        catch (Throwable t) {
            this.handleError(t, msg, 6, "Error retrieving pool size. ");
        }
    }

    protected void serveSetPoolSize(ACLMessage msg, Action aExpr, SetPoolSize sps) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving SetPoolSize request... ");
        }
        this.setPoolSize(sps.getValue());
        this.reply(msg, 7, null);
        if (this.myLogger.isLoggable(Logger.FINER)) {
            this.myLogger.log(Logger.FINER, "Agent " + this.getName() + " - SetPoolSize request served.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AttributeSetter(defaultValue="3")
    public void setPoolSize(int s) {
        Object object = this.enqueuingLock;
        synchronized (object) {
            this.poolSize = s;
            this.flush();
        }
    }

    protected void serveGetSessionStatus(ACLMessage msg, Action aExpr, GetSessionStatus gss) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving GetSessionStatus request... ");
        }
        try {
            Result r = new Result((Concept)aExpr, (Object)this.executors.getStatus(gss.getSessionId()));
            ACLMessage reply = msg.createReply();
            reply.setPerformative(7);
            this.getContentManager().fillContent(reply, (ContentElement)r);
            this.send(reply);
        }
        catch (Throwable t) {
            this.handleError(t, msg, 6, "Error retrieving session status. ");
        }
    }

    private void serveResetModifiers(ACLMessage msg, Action aExpr, ResetModifiers rm) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving ResetModifiers request... ");
        }
        try {
            WorkflowExecutor we = this.executors.get(rm.getExecutionId());
            if (we == null) {
                throw new WorkflowException("Workflow " + rm.getExecutionId() + " not present. ");
            }
            we.setModifiers(rm.getModifiers());
            this.reply(msg, 7, null);
        }
        catch (Throwable t) {
            this.handleError(t, msg, 6, "Error serving ResetModifiers for workflow " + rm.getExecutionId() + ". ");
        }
    }

    private void serveResetControlInfos(ACLMessage msg, Action aExpr, ResetControlInfos rci) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Agent " + this.getName() + " - Serving ResetControlInfos request... ");
        }
        try {
            WorkflowExecutor we = this.executors.get(rci.getExecutionId());
            if (we == null) {
                throw new WorkflowException("Workflow " + rci.getExecutionId() + " not present. ");
            }
            we.getEventEmitter().setControlInfo(rci.getControlInfos());
            this.reply(msg, 7, null);
        }
        catch (Throwable t) {
            this.handleError(t, msg, 6, "Error serving ResetControlInfos for workflow " + rci.getExecutionId() + ". ");
        }
    }

    protected void handleUnknownAction(AgentAction act, Action aExpr, ACLMessage msg) {
        String errorMsg = "Unknown requested action " + act.getClass().getName();
        this.myLogger.log(Logger.SEVERE, errorMsg);
        this.reply(msg, 14, this.createGenericError(errorMsg));
    }

    protected void handleIncomingWorkflow(WorkflowExecutor we, AID requester) {
        if (EngineHelper.isInteractive(we)) {
            this.addInteractivityConversation(we.getDescriptor().getSessionId());
        }
        this.submitWorkflow(we);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitWorkflow(WorkflowExecutor we) {
        Object object = this.enqueuingLock;
        synchronized (object) {
            if (this.mustEnqueue(we)) {
                this.enqueue(we);
            } else if (we.getStatus() == 5) {
                we.resume();
            } else {
                this.addBehaviour(this.tbf.wrap((Behaviour)we));
            }
        }
    }

    private boolean mustEnqueue(WorkflowExecutor we) {
        return this.getActiveCnt() >= this.getPoolSize() && !this.executors.belongsToRunningSession(we);
    }

    protected void handleCleanupWorkflow(WorkflowExecutor we) {
    }

    protected ClassLoader getWorkflowClassLoader(WorkflowDescriptor wd) {
        return CAServices.getInstance(this).getClassLoader(wd.getClassLoaderIdentifier());
    }

    protected String getClassLoaderIdentifier(ClassLoader cl) {
        if (cl instanceof WadeClassLoader) {
            return ((WadeClassLoader)cl).getId();
        }
        return null;
    }

    public Ontology getOntology() {
        return WorkflowManagementOntology.getInstance();
    }

    public Codec getLanguage() {
        return this.codec;
    }

    protected void adjustControlInfo(ControlInfo cInfo, WorkflowDescriptor descriptor) {
    }

    @AttributeGetter(name="Default workflow timeout")
    public long getDefaultWorkflowTimeout() {
        return this.defaultWorkflowTimeout;
    }

    public long getRollbackTimeout() {
        return 2000L;
    }

    public long getCommitTimeout() {
        return 0L;
    }

    @AttributeGetter(name="Executors pool size")
    public int getPoolSize() {
        return this.poolSize;
    }

    @AttributeGetter(name="Busy executors")
    public int getBusyExecutors() {
        return this.tbf.size();
    }

    public final Object[] getExecutorsTableStatus() {
        List l = this.executors.getStatus();
        return l.toArray();
    }

    @AttributeGetter(name="Active threads")
    public final int getThreadCnt() {
        return this.tbf.size();
    }

    @AttributeGetter(name="Executed workflows")
    public final long getWorkflowCnt() {
        return this.wfCnt;
    }

    protected void handleBeginWorkflow(WorkflowExecutor we) {
        if (we.getEventEmitter().isFireable("flow", 3)) {
            WorkflowDescriptor wd = we.getActualDescriptor();
            we.getEventEmitter().fireEvent("flow", (WorkflowEvent)new BeginWorkflow(wd.getId(), wd.getId(), wd.getSessionId()), 3);
        }
    }

    protected void handleEndWorkflow(WorkflowExecutor we, int exitValue) {
        if (we.getEventEmitter().isFireable("flow", 3)) {
            WorkflowDescriptor wd = we.getActualDescriptor();
            we.getEventEmitter().fireEvent("flow", (WorkflowEvent)new EndWorkflow(wd.getId(), wd.getId(), exitValue, wd.getSessionId()), 3);
        }
    }

    protected void handleBeginActivity(WorkflowExecutor we, String name) {
        WorkflowDescriptor wd = we.getActualDescriptor();
        we.getEventEmitter().fireEvent("flow", (WorkflowEvent)new BeginActivity(name, wd.getId(), wd.getSessionId()), 4);
    }

    protected void handleEndActivity(WorkflowExecutor we, String name) {
        WorkflowDescriptor wd = we.getActualDescriptor();
        we.getEventEmitter().fireEvent("flow", (WorkflowEvent)new EndActivity(name, wd.getId(), wd.getSessionId()), 4);
    }

    protected void handleBeginApplication(WorkflowExecutor we, String name) {
        WorkflowDescriptor wd = we.getActualDescriptor();
        we.getEventEmitter().fireEvent("flow", (WorkflowEvent)new BeginApplication(name, wd.getId(), wd.getSessionId()), 5);
    }

    protected void handleEndApplication(WorkflowExecutor we, String name) {
        WorkflowDescriptor wd = we.getActualDescriptor();
        we.getEventEmitter().fireEvent("flow", (WorkflowEvent)new EndApplication(name, wd.getId(), wd.getSessionId()), 5);
    }

    protected void handleDelegatedSubflow(WorkflowExecutor we, String workflowId, String performer, String executionId) {
        WorkflowDescriptor wd = we.getActualDescriptor();
        we.getEventEmitter().fireEvent("flow", (WorkflowEvent)new DelegatedSubflow(workflowId, performer, executionId, wd.getId(), wd.getSessionId()), 3);
    }

    protected void handleCompletedSubflow(WorkflowExecutor we, String executionId, int exitValue) {
        WorkflowDescriptor wd = we.getActualDescriptor();
        we.getEventEmitter().fireEvent("flow", (WorkflowEvent)new EndSubflow(executionId, exitValue, wd.getId(), wd.getSessionId()), 3);
    }

    protected void handleEvent(String executionId, String type, Object event) {
        this.myLogger.log("warning".equals(type) ? Logger.WARNING : Logger.INFO, "Agent " + this.getName() + " - Executor " + executionId + ": " + event);
    }

    protected String generateWorkflowExecutionId(ExecuteWorkflow ew) {
        String requester = ew.getWhat().getRequester();
        return (requester != null ? requester + "#" : "") + GUIDGenerator.getGUID();
    }

    protected void enqueue(WorkflowExecutor we) {
        this.workflowQueue.add((Object)we);
    }

    protected WorkflowExecutor dequeue() {
        if (this.workflowQueue.size() > 0) {
            return (WorkflowExecutor)((Object)this.workflowQueue.remove(0));
        }
        return null;
    }

    @AttributeGetter(name="Enqueued workflows")
    public int getEnqueuedCnt() {
        return this.workflowQueue.size();
    }

    @AttributeGetter(name="Suspended workflows")
    public int getSuspendedCnt() {
        return this.executors.suspendedCnt();
    }

    protected boolean removeFromQueue(WorkflowExecutor we) {
        return this.workflowQueue.remove((Object)we);
    }

    private void flush() {
        WorkflowExecutor w;
        while (this.getActiveCnt() < this.getPoolSize() && (w = this.dequeue()) != null) {
            this.addBehaviour(this.tbf.wrap((Behaviour)w));
        }
    }

    @AttributeGetter(name="Active workflows")
    public final int getActiveCnt() {
        return this.executors.size() - this.getEnqueuedCnt() - this.getSuspendedCnt();
    }

    protected void handleOpenedTransaction(WorkflowExecutor we) {
        we.getEventEmitter().fireEvent("transaction", (WorkflowEvent)new OpenedTransaction(we.getId()), 3);
    }

    protected void handleCommittedTransaction(WorkflowExecutor we) {
        we.getEventEmitter().fireEvent("transaction", (WorkflowEvent)new CommittedTransaction(we.getId()), 3);
    }

    protected void handleAbortedTransaction(WorkflowExecutor we) {
        we.getEventEmitter().fireEvent("transaction", (WorkflowEvent)new AbortedTransaction(we.getId()), 3);
    }

    protected void handleFailedTransaction(WorkflowExecutor we) {
    }

    protected WorkflowBehaviour loadRollbackWorkflow(WorkflowExecutor we, ClassLoader loader) {
        WorkflowDescriptor wd = we.getDescriptor();
        String wfId = wd.getId();
        WorkflowDescriptor rbWd = new WorkflowDescriptor(wfId + "_RB", wd.getParameters());
        rbWd.setRequester(wd.getRequester());
        rbWd.setSessionId(wd.getSessionId());
        rbWd.setDelegationChain(wd.getDelegationChain());
        rbWd.setPriority(wd.getPriority());
        we.setRBDescriptor(rbWd);
        WorkflowBehaviour wb = null;
        try {
            wb = (WorkflowBehaviour)Class.forName(rbWd.getId(), true, loader).newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        return wb;
    }

    protected final void handleError(Throwable t, ACLMessage msg, int replyPerformative, String info) {
        String errorMsg = info + t.getMessage();
        this.myLogger.log(Logger.SEVERE, errorMsg);
        t.printStackTrace();
        this.reply(msg, replyPerformative, this.createGenericError(errorMsg));
    }

    protected final void reply(ACLMessage msg, int performative, String content) {
        ACLMessage reply = msg.createReply();
        reply.setPerformative(performative);
        reply.setContent(content);
        this.send(reply);
    }

    protected final String createGenericError(String reason) {
        return "((generic-error \"" + reason + "\"))";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConversation(ACLMessage msg) {
        if (msg != null) {
            ConversationList conversationList = this.conversations;
            synchronized (conversationList) {
                this.conversations.registerConversation(msg.getConversationId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConversation(ACLMessage msg) {
        if (msg != null) {
            ConversationList conversationList = this.conversations;
            synchronized (conversationList) {
                this.conversations.deregisterConversation(msg.getConversationId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInteractivityConversation(String id) {
        if (id != null) {
            ConversationList conversationList = this.interactivityConversations;
            synchronized (conversationList) {
                this.interactivityConversations.registerConversation(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInteractivityConversation(String id) {
        if (id != null) {
            ConversationList conversationList = this.interactivityConversations;
            synchronized (conversationList) {
                this.interactivityConversations.deregisterConversation(id);
            }
        }
    }

    private String getErrorType(Throwable t) {
        Throwable nested;
        if (t instanceof WorkflowException && (nested = t.getCause()) != null) {
            return nested.getClass().getName();
        }
        return t.getClass().getName();
    }

    WorkflowExecutor createWorkflowExecutor(WorkflowExecutorReplacer replacer) {
        return new WorkflowExecutor(replacer);
    }

    public StatusManager getStatusManager() {
        if (this.statusManager == null) {
            this.statusManager = new StatusManager(this);
        }
        return this.statusManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WorkflowExecutor
    extends FSMBehaviour {
        private int status;
        private Action requestedAction;
        private WorkflowDescriptor myDescriptor;
        private WorkflowDescriptor myRBDescriptor;
        private EventEmitter eventEmitter;
        private Tracer tracer;
        private List modifiers;
        private WorkflowBehaviour myWorkflow;
        private String myId;
        private Hashtable myContext;
        private boolean transactionScope;
        private ACLMessage reply;
        private WatchDog watchDog;
        private int abortCondition;
        private ExecutionErrorEvent lastErrorEvent;
        private String failureReason;
        private TransactionManager myTransactionManager;
        private transient List parameters;
        private transient String errorMessage;
        private transient AID wsmaAid;
        transient byte[] lastSerializedState;

        private WorkflowExecutor(Agent agent, ExecuteWorkflow ew, ACLMessage rq, Action a) throws Throwable {
            super(agent);
            this.status = 0;
            this.myContext = new Hashtable();
            this.watchDog = null;
            this.abortCondition = 0;
            this.lastErrorEvent = null;
            this.myId = WorkflowEngineAgent.this.generateWorkflowExecutionId(ew);
            this.setBehaviourName(this.myId);
            this.myDescriptor = ew.getWhat();
            this.modifiers = ew.getModifiers();
            WorkflowEngineAgent.this.wfCnt++;
            this.transactionScope = rq.getPerformative() == 3;
            this.requestedAction = a;
            this.reply = rq.createReply();
            this.reply.setSender(this.myAgent.getAID());
            if (this.reply.getConversationId() == null) {
                this.reply.setConversationId(this.myId + "R");
            }
            WorkflowEngineAgent.this.addConversation(this.reply);
            if (this.myDescriptor.getFormat() == null || this.myDescriptor.getRepresentation() == null) {
                ClassLoader classLoader = WorkflowEngineAgent.this.getWorkflowClassLoader(this.myDescriptor);
                this.myWorkflow = (WorkflowBehaviour)Class.forName(this.myDescriptor.getId(), true, classLoader).newInstance();
                this.myDescriptor.setClassLoaderIdentifier(WorkflowEngineAgent.this.getClassLoaderIdentifier(classLoader));
            } else {
                String wfiBasePkgName = "com.tilab.wade.formats";
                String wfiFormat = this.myDescriptor.getFormat();
                String wfiClassName = wfiBasePkgName + "." + wfiFormat.toLowerCase() + ".interpreter." + wfiFormat.toUpperCase() + "Interpreter";
                WorkflowInterpreter wfi = (WorkflowInterpreter)Class.forName(wfiClassName).newInstance();
                this.myWorkflow = wfi.interpret(this.myDescriptor.getRepresentation());
            }
            this.eventEmitter = new WEAEventEmitter(agent, this.myId, WorkflowEngineAgent.this.onto.getName(), WorkflowEngineAgent.this.codec.getName(), this.myDescriptor, this.myWorkflow);
            this.tracer = new Tracer(this.myDescriptor.getSessionId(), this.eventEmitter);
            List l = ew.getHow();
            if (l != null) {
                for (ControlInfo cInfo : l) {
                    this.eventEmitter.setControlInfo(cInfo);
                }
            }
            this.adjustWarningControlInfo();
            this.setDataStore(this.myWorkflow.getDataStore());
            if (this.myDescriptor.getPriority() == -1) {
                this.myDescriptor.setPriority(this.myWorkflow.getDefaultPriority());
            }
            if (this.getTransactionScope()) {
                this.myDescriptor.setTransactional(true);
            }
            if (this.myDescriptor.getTransactional()) {
                this.myTransactionManager = new TransactionManager(this.myId, this.eventEmitter);
                WorkflowEngineAgent.this.handleOpenedTransaction(this);
            }
            this.registerTransitions();
            this.registerStates();
            EngineHelper.copyInputParameters(this.myWorkflow, this.myDescriptor.getParameters());
            this.checkTermination(true, 0);
        }

        WorkflowExecutor(WorkflowExecutorReplacer replacer) {
            super((Agent)replacer.getEnclosingAgent());
            this.status = 0;
            this.myContext = new Hashtable();
            this.watchDog = null;
            this.abortCondition = 0;
            this.lastErrorEvent = null;
            this.myId = replacer.getExecutionId();
            this.status = replacer.getStatus();
            this.reply = replacer.getReply();
            this.requestedAction = replacer.getRequestedAction();
            this.myDescriptor = replacer.getDescriptor();
            this.modifiers = replacer.getModifiers();
            this.eventEmitter = replacer.getEventEmitter();
            this.eventEmitter.setAgent((Agent)replacer.getEnclosingAgent());
            this.tracer = new Tracer(this.myDescriptor.getSessionId(), this.eventEmitter);
            this.myWorkflow = replacer.getWorkflow();
            this.myContext = replacer.getContext();
            this.abortCondition = replacer.getAbortCondition();
            this.lastErrorEvent = replacer.getLastErrorEvent();
            this.failureReason = replacer.getFailureReason();
            this.transactionScope = replacer.getTransactionScope();
            this.myTransactionManager = replacer.getTransactionManager();
            this.registerTransitions();
            this.registerStates();
            this.checkTermination(true, 0);
        }

        private Object writeReplace() throws ObjectStreamException {
            return new WorkflowExecutorReplacer(this.myAgent, this.myId, this.status, this.reply, this.requestedAction, this.myDescriptor, this.modifiers, this.eventEmitter, this.myWorkflow, this.myContext, this.abortCondition, this.lastErrorEvent, this.failureReason, this.transactionScope, this.myTransactionManager);
        }

        private void registerTransitions() {
            this.registerTransition(WorkflowEngineAgent.EXECUTE, WorkflowEngineAgent.HANDLE_SUCCESS, 0);
            this.registerTransition(WorkflowEngineAgent.EXECUTE, WorkflowEngineAgent.HANDLE_FAILURE, 1);
            this.registerTransition(WorkflowEngineAgent.EXECUTE, WorkflowEngineAgent.HANDLE_FROZEN, 2);
            this.registerDefaultTransition(WorkflowEngineAgent.HANDLE_SUCCESS, WorkflowEngineAgent.SEND_REPLY);
            this.registerDefaultTransition(WorkflowEngineAgent.HANDLE_FAILURE, WorkflowEngineAgent.SEND_REPLY);
            this.registerDefaultTransition(WorkflowEngineAgent.HANDLE_FROZEN, WorkflowEngineAgent.SEND_REPLY);
            if (this.myDescriptor.getTransactional()) {
                this.registerTransition(WorkflowEngineAgent.HANDLE_FAILURE, WorkflowEngineAgent.PREPARE_ROLLBACK, -11);
                if (this.getTransactionScope()) {
                    this.registerTransition(WorkflowEngineAgent.HANDLE_SUCCESS, WorkflowEngineAgent.WAIT_COMMIT, -11);
                    this.registerTransition(WorkflowEngineAgent.WAIT_COMMIT, WorkflowEngineAgent.COMMIT, 0);
                    this.registerDefaultTransition(WorkflowEngineAgent.WAIT_COMMIT, WorkflowEngineAgent.PREPARE_ROLLBACK);
                } else {
                    this.registerTransition(WorkflowEngineAgent.HANDLE_SUCCESS, WorkflowEngineAgent.COMMIT, -11);
                }
                this.registerDefaultTransition(WorkflowEngineAgent.PREPARE_ROLLBACK, WorkflowEngineAgent.ROLLBACK);
                this.registerTransition(WorkflowEngineAgent.COMMIT, WorkflowEngineAgent.HANDLE_COMMIT_SUCCESS, 0);
                this.registerTransition(WorkflowEngineAgent.COMMIT, WorkflowEngineAgent.HANDLE_TRANSACTION_FAILURE, 1);
                this.registerTransition(WorkflowEngineAgent.ROLLBACK, WorkflowEngineAgent.HANDLE_ROLLBACK_SUCCESS, 0);
                this.registerTransition(WorkflowEngineAgent.ROLLBACK, WorkflowEngineAgent.HANDLE_TRANSACTION_FAILURE, 1);
                this.registerDefaultTransition(WorkflowEngineAgent.HANDLE_COMMIT_SUCCESS, WorkflowEngineAgent.SEND_REPLY);
                this.registerDefaultTransition(WorkflowEngineAgent.HANDLE_ROLLBACK_SUCCESS, WorkflowEngineAgent.SEND_REPLY);
                this.registerDefaultTransition(WorkflowEngineAgent.HANDLE_TRANSACTION_FAILURE, WorkflowEngineAgent.SEND_REPLY);
            }
        }

        private void registerStates() {
            this.registerFirstState((Behaviour)this.myWorkflow, WorkflowEngineAgent.EXECUTE);
            this.myWorkflow.setBehaviourName(this.myDescriptor.getId().replace(' ', '-'));
            this.registerState((Behaviour)new TerminationHandler(){

                public void handle() throws Exception {
                    WorkflowExecutor.this.errorMessage = null;
                    if (WorkflowExecutor.this.getTransactionScope()) {
                        WorkflowExecutor.this.status = 3;
                        WorkflowExecutor.this.reply.setPerformative(11);
                        CAServices.getInstance(WorkflowEngineAgent.this).registerExpectedReply(WorkflowExecutor.this.reply);
                    } else {
                        WorkflowExecutor.this.status = 2;
                        WorkflowExecutor.this.reply.setPerformative(7);
                    }
                    WorkflowExecutor.this.parameters = WorkflowExecutor.this.myWorkflow.extractOutputParameters();
                    if (WorkflowExecutor.this.parameters == null) {
                        WorkflowExecutor.this.parameters = (List)new ArrayList();
                    }
                    Result result = new Result((Concept)WorkflowExecutor.this.requestedAction, (Object)WorkflowExecutor.this.parameters);
                    WorkflowExecutor.this.eventEmitter.fireEvent("termination", (WorkflowEvent)new SuccessfulTerminationEvent(result), 3);
                    this.myAgent.getContentManager().fillContent(WorkflowExecutor.this.reply, (ContentElement)result);
                    WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": SUCCEEDED.");
                }
            }, WorkflowEngineAgent.HANDLE_SUCCESS);
            this.registerState((Behaviour)new TerminationHandler(){

                public void handle() throws Exception {
                    WorkflowExecutor.this.status = 2;
                    WorkflowExecutor.this.myWorkflow.clearInterruption();
                    WorkflowExecutor.this.reply.setPerformative(6);
                    WorkflowExecutor.this.parameters = WorkflowExecutor.this.myWorkflow.extractOutputParameters();
                    WorkflowExecutor.this.errorMessage = "UNKNOWN";
                    String errorType = "UNKNOWN";
                    Throwable t = WorkflowExecutor.this.myWorkflow.getLastException();
                    if (t != null) {
                        WorkflowExecutor.this.errorMessage = t.getMessage();
                        errorType = WorkflowEngineAgent.this.getErrorType(t);
                    }
                    if (WorkflowExecutor.this.failureReason != null) {
                        WorkflowExecutor.this.errorMessage = WorkflowExecutor.this.failureReason;
                    }
                    ExecutionError er = new ExecutionError(errorType, WorkflowExecutor.this.errorMessage, WorkflowExecutor.this.parameters);
                    WorkflowExecutor.this.eventEmitter.fireEvent("termination", (WorkflowEvent)new UnsuccessfulTerminationEvent(er), 3);
                    this.myAgent.getContentManager().fillContent(WorkflowExecutor.this.reply, (ContentElement)er);
                    WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": FAILED.");
                }
            }, WorkflowEngineAgent.HANDLE_FAILURE);
            this.registerState((Behaviour)new TerminationHandler(){

                public void handle() throws Exception {
                    WorkflowExecutor.this.errorMessage = null;
                    WorkflowExecutor.this.reply.setPerformative(7);
                    this.myAgent.getContentManager().fillContent(WorkflowExecutor.this.reply, (ContentElement)new Frozen());
                    WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": Frozen");
                }
            }, WorkflowEngineAgent.HANDLE_FROZEN);
            this.registerLastState((Behaviour)new OneShotBehaviour(){

                public void action() {
                    if (WorkflowExecutor.this.myDescriptor.getExecution() == 0 && WorkflowExecutor.this.reply != null) {
                        if (WorkflowEngineAgent.this.myLogger.isLoggable(Logger.FINE)) {
                            WorkflowEngineAgent.this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": Final reply " + ACLMessage.getPerformative((int)WorkflowExecutor.this.reply.getPerformative()) + " sent back.");
                        }
                        WorkflowExecutor.this.reply.addUserDefinedParameter("JADE-ignore-failure", "true");
                        this.myAgent.send(WorkflowExecutor.this.reply);
                    }
                    if (!WorkflowExecutor.this.getWorkflow().isVolatile()) {
                        if (WorkflowExecutor.this.getWorkflow().isFrozen()) {
                            WorkflowEngineAgent.this.getStatusManager().notifyStatusChanged(WorkflowExecutor.this, WorkflowExecutionInfo.WorkflowStatus.FROZEN);
                        } else {
                            WorkflowEngineAgent.this.getStatusManager().notifyTerminated(WorkflowExecutor.this, WorkflowExecutor.this.parameters, WorkflowExecutor.this.errorMessage);
                        }
                    }
                }
            }, WorkflowEngineAgent.SEND_REPLY);
            if (this.myDescriptor.getTransactional()) {
                if (this.getTransactionScope()) {
                    this.registerState((Behaviour)new OneShotBehaviour(this.myAgent){
                        private ACLMessage msg;
                        {
                            this.msg = null;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void action() {
                            if (!WorkflowExecutor.this.getWorkflow().isVolatile()) {
                                WorkflowEngineAgent.this.getStatusManager().notifyStatusChanged(WorkflowExecutor.this, WorkflowExecutionInfo.WorkflowStatus.WAIT_COMMIT);
                            }
                            this.myAgent.send(WorkflowExecutor.this.reply);
                            MessageTemplate tpl = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchConversationId((String)WorkflowExecutor.this.reply.getConversationId()), (MessageTemplate)MessageTemplate.or((MessageTemplate)MessageTemplate.MatchPerformative((int)6), (MessageTemplate)MessageTemplate.or((MessageTemplate)MessageTemplate.MatchPerformative((int)0), (MessageTemplate)MessageTemplate.MatchPerformative((int)15))));
                            try {
                                WorkflowExecutor.this.myWorkflow.enterInterruptableSection();
                                this.msg = this.myAgent.blockingReceive(tpl);
                                WorkflowEngineAgent.this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": End-transaction message " + ACLMessage.getPerformative((int)this.msg.getPerformative()) + " received.");
                                CAServices.getInstance(WorkflowEngineAgent.this).expectedReplyReceived(this.msg);
                                WorkflowExecutor.this.reply = this.msg.createReply();
                                WorkflowExecutor.this.reply.setPerformative(7);
                            }
                            catch (Throwable t) {
                                WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": killed while waiting for commit");
                                WorkflowEngineAgent.this.removeConversation(WorkflowExecutor.this.reply);
                                WorkflowExecutor.this.reply = null;
                            }
                            finally {
                                WorkflowExecutor.this.status = 2;
                                WorkflowExecutor.this.myWorkflow.exitInterruptableSection(null);
                            }
                        }

                        public int onEnd() {
                            int ret = this.msg != null ? this.msg.getPerformative() : 15;
                            return ret;
                        }
                    }, WorkflowEngineAgent.WAIT_COMMIT);
                }
                this.registerState((Behaviour)new WakerBehaviour(this.myAgent, WorkflowEngineAgent.this.getRollbackTimeout()){

                    public void onWake() {
                        WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": Activating rollback procedure");
                        WorkflowBehaviour rollbackWorkflow = WorkflowExecutor.this.myWorkflow.getRollbackWorkflow();
                        if (rollbackWorkflow != null) {
                            WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": User-defined rollback workflow found");
                            WorkflowExecutor.this.myWorkflow.setRollbackWorkflow(rollbackWorkflow);
                            WorkflowExecutor.this.registerState((Behaviour)rollbackWorkflow, WorkflowEngineAgent.ROLLBACK);
                            rollbackWorkflow.setBehaviourName(WorkflowExecutor.this.myRBDescriptor.getId().replace(' ', '-'));
                            rollbackWorkflow.setDataStore(WorkflowExecutor.this.myWorkflow.getDataStore());
                            rollbackWorkflow.copyFieldsValue(WorkflowExecutor.this.myWorkflow);
                        }
                        if (!WorkflowExecutor.this.getWorkflow().isVolatile()) {
                            WorkflowEngineAgent.this.getStatusManager().notifyStatusChanged(WorkflowExecutor.this, WorkflowExecutionInfo.WorkflowStatus.ROLLBACK);
                        }
                    }
                }, WorkflowEngineAgent.PREPARE_ROLLBACK);
                this.registerState((Behaviour)new WakerBehaviour(this.myAgent, WorkflowEngineAgent.this.getCommitTimeout()){
                    private int ret;
                    {
                        this.ret = 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onWake() {
                        try {
                            WorkflowExecutor.this.myWorkflow.enterInterruptableSection();
                            if (!WorkflowExecutor.this.myWorkflow.commit()) {
                                this.ret = 1;
                            }
                        }
                        catch (Agent.Interrupted ai) {
                            this.ret = 1;
                            WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": commit procedure interrupted");
                        }
                        catch (ThreadDeath td) {
                            WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": commit procedure interrupted (ThreadDeath)");
                        }
                        finally {
                            WorkflowExecutor.this.myWorkflow.exitInterruptableSection(null);
                        }
                    }

                    public int onEnd() {
                        return this.ret;
                    }
                }, WorkflowEngineAgent.COMMIT);
                this.registerState((Behaviour)new OneShotBehaviour(){

                    public void action() {
                        WorkflowEngineAgent.this.handleCommittedTransaction(WorkflowExecutor.this);
                    }
                }, WorkflowEngineAgent.HANDLE_COMMIT_SUCCESS);
                this.registerState((Behaviour)new OneShotBehaviour(){
                    private int ret = 0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void action() {
                        try {
                            WorkflowEngineAgent.this.handleBeginWorkflow(WorkflowExecutor.this);
                        }
                        catch (Exception e) {
                            WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": Unexpected error in handleBeginWorkflow() of rollback procedure", (Throwable)e);
                        }
                        try {
                            WorkflowExecutor.this.myWorkflow.enterInterruptableSection();
                            if (!WorkflowExecutor.this.myWorkflow.rollback()) {
                                this.ret = 1;
                            }
                        }
                        catch (Agent.Interrupted ai) {
                            this.ret = 1;
                            WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": rollback procedure interrupted");
                        }
                        catch (ThreadDeath td) {
                            this.ret = 1;
                            WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": rollback procedure interrupted (ThreadDeath)");
                        }
                        finally {
                            WorkflowExecutor.this.myWorkflow.exitInterruptableSection(null);
                        }
                        try {
                            WorkflowEngineAgent.this.handleEndWorkflow(WorkflowExecutor.this, this.ret);
                        }
                        catch (Exception e) {
                            WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": Unexpected error in handleEndWorkflow() of rollback procedure", (Throwable)e);
                        }
                    }

                    public int onEnd() {
                        return this.ret;
                    }
                }, WorkflowEngineAgent.ROLLBACK);
                this.registerState((Behaviour)new OneShotBehaviour(){

                    public void action() {
                        WorkflowExecutor.this.checkPendingSubflows();
                        WorkflowEngineAgent.this.handleAbortedTransaction(WorkflowExecutor.this);
                    }
                }, WorkflowEngineAgent.HANDLE_ROLLBACK_SUCCESS);
                this.registerState((Behaviour)new OneShotBehaviour(){

                    public void action() {
                        WorkflowEngineAgent.this.myLogger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + " - Executor " + WorkflowExecutor.this.myId + ": TRANSACTION FAILED!!!!!! Session-id = " + WorkflowExecutor.this.myDescriptor.getSessionId());
                        WorkflowEngineAgent.this.handleFailedTransaction(WorkflowExecutor.this);
                        WorkflowExecutor.this.checkPendingSubflows();
                        if (WorkflowExecutor.this.reply != null) {
                            WorkflowExecutor.this.reply.setPerformative(6);
                        }
                    }
                }, WorkflowEngineAgent.HANDLE_TRANSACTION_FAILURE);
            }
        }

        private void checkPendingSubflows() {
            if (!this.myTransactionManager.rollback(TransactionEntry.SUBFLOW_TYPE, null)) {
                WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + this.myId + ": Unexpected failure rollbacking orphan subflows");
            }
        }

        protected void handleStateEntered(Behaviour state) {
            if (WorkflowEngineAgent.this.myLogger.isLoggable(Logger.FINE)) {
                WorkflowEngineAgent.this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - Executor " + this.myId + ": Entering state " + state.getBehaviourName());
            }
        }

        protected boolean checkTermination(boolean currentDone, int currentResult) {
            boolean b = super.checkTermination(currentDone, currentResult);
            boolean b1 = false;
            if (currentDone) {
                b1 = this.lastStates.contains((Object)this.currentName);
            }
            if (b != b1) {
                WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + this.myId + ": FSM.checkTermination() returned " + b + " with Last-states = " + this.lastStates + " and currentName = " + this.currentName);
            }
            return b1;
        }

        public synchronized void onStart() {
            this.status = 1;
            WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + this.myId + ": STARTED.");
            if (!this.myWorkflow.isLongRunning()) {
                long timeout = this.myDescriptor.getTimeout();
                if (timeout <= 0L) {
                    timeout = this.myWorkflow.getLimit();
                }
                if (timeout <= 0L) {
                    timeout = WorkflowEngineAgent.this.getDefaultWorkflowTimeout();
                }
                if (timeout > 0L) {
                    this.watchDog = new WatchDog(this.myAgent, timeout, this);
                    this.myAgent.addBehaviour((Behaviour)this.watchDog);
                    WorkflowEngineAgent.this.myLogger.log(Logger.CONFIG, "Agent " + this.myAgent.getName() + " - Executor " + this.myId + ": WatchDog timer activated.");
                }
            }
            executionContexts.set(this.myContext);
        }

        public int onEnd() {
            this.eventEmitter.close();
            this.terminate();
            return super.onEnd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminate() {
            this.status = 4;
            WorkflowEngineAgent.this.removeConversation(this.reply);
            if (EngineHelper.isInteractive(this)) {
                WorkflowEngineAgent.this.removeInteractivityConversation(this.myDescriptor.getSessionId());
            }
            try {
                WorkflowEngineAgent.this.handleCleanupWorkflow(this);
            }
            catch (RuntimeException re) {
                WorkflowEngineAgent.this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Executor " + this.myId + ": handleCleanupWorkflow throw a RuntimeException.", (Throwable)re);
            }
            Object object = WorkflowEngineAgent.this.enqueuingLock;
            synchronized (object) {
                WorkflowEngineAgent.this.executors.remove(this.myId);
                WorkflowEngineAgent.this.flush();
            }
            WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + this.myId + ": TERMINATED.");
        }

        void suspend() {
            WorkflowEngineAgent.this.tbf.suspend((Behaviour)this);
        }

        void resume() {
            WorkflowEngineAgent.this.tbf.resume((Behaviour)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuspended() {
            WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + this.myId + ": SUSPENDED.");
            Object object = WorkflowEngineAgent.this.enqueuingLock;
            synchronized (object) {
                this.status = 5;
                WorkflowEngineAgent.this.flush();
            }
            if (!this.getWorkflow().isVolatile()) {
                WorkflowEngineAgent.this.getStatusManager().notifyStatusChanged(this, WorkflowExecutionInfo.WorkflowStatus.SUSPENDED);
            }
            this.myWorkflow.onSuspended();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResumed() {
            WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Executor " + this.myId + ": RESUMED.");
            executionContexts.set(this.myContext);
            Object object = WorkflowEngineAgent.this.enqueuingLock;
            synchronized (object) {
                this.status = 1;
            }
            if (!this.getWorkflow().isVolatile()) {
                WorkflowEngineAgent.this.getStatusManager().notifyStatusChanged(this, WorkflowExecutionInfo.WorkflowStatus.ACTIVE);
            }
            this.myWorkflow.onResumed();
        }

        public final String getId() {
            return this.myId;
        }

        public final WorkflowDescriptor getDescriptor() {
            return this.myDescriptor;
        }

        public final WorkflowDescriptor getRBDescriptor() {
            return this.myRBDescriptor;
        }

        public final WorkflowDescriptor getActualDescriptor() {
            WorkflowDescriptor wd = this.getRBDescriptor();
            if (wd == null) {
                wd = this.getDescriptor();
            }
            return wd;
        }

        private final void setRBDescriptor(WorkflowDescriptor wd) {
            this.myRBDescriptor = wd;
        }

        public final boolean getTransactionScope() {
            return this.transactionScope;
        }

        final TransactionManager getTransactionManager() {
            return this.myTransactionManager;
        }

        public final List getModifiers() {
            return this.modifiers;
        }

        public final void setModifiers(List modifiers) {
            this.modifiers = modifiers;
        }

        public final Hashtable getExecutionContext() {
            return this.myContext;
        }

        public EventEmitter getEventEmitter() {
            return this.eventEmitter;
        }

        public Tracer getTracer() {
            return this.tracer;
        }

        public final Hashtable<String, ControlInfo> getControlInfo() {
            return this.eventEmitter.getControlInfo();
        }

        public final void fireEvent(String type, WorkflowEvent ev, int level) {
            this.eventEmitter.fireEvent(type, ev, level);
        }

        public final boolean isFireable(String type, int level) {
            return this.eventEmitter.isFireable(type, level);
        }

        final void setFailureReason(String reason) {
            this.failureReason = reason;
        }

        final String getFailureReason() {
            return this.failureReason;
        }

        final void setLastErrorEvent(ExecutionErrorEvent ev) {
            this.lastErrorEvent = ev;
        }

        final ExecutionErrorEvent getLastErrorEvent() {
            return this.lastErrorEvent;
        }

        final WorkflowBehaviour getWorkflow() {
            return this.myWorkflow;
        }

        final void setWorkflow(WorkflowBehaviour wb) {
            this.myWorkflow = wb;
            if (this.eventEmitter instanceof WEAEventEmitter) {
                ((WEAEventEmitter)this.eventEmitter).setWorkflow(wb);
            }
        }

        public final Behaviour getCurrent() {
            return super.getCurrent();
        }

        final int getStatus() {
            return this.status;
        }

        final int getAbortCondition() {
            return this.abortCondition;
        }

        final WatchDog getWatchDog() {
            return this.watchDog;
        }

        private void adjustWarningControlInfo() {
            ControlInfo wInfo = (ControlInfo)this.eventEmitter.getControlInfo().get("warning");
            if (wInfo == null) {
                wInfo = new ControlInfo();
                wInfo.setType("warning");
                wInfo.setVerbosityLevel(3);
                this.eventEmitter.setControlInfo(wInfo);
            }
        }

        void kill(boolean isTimeout, boolean smooth) {
            this.kill(isTimeout, smooth, false, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void kill(boolean isTimeout, boolean smooth, boolean freeze, String message) {
            this.abortCondition = isTimeout ? 2 : 1;
            this.eventEmitter.disableSynchEvents();
            boolean enqueued = false;
            Object object = WorkflowEngineAgent.this.enqueuingLock;
            synchronized (object) {
                enqueued = WorkflowEngineAgent.this.removeFromQueue(this);
            }
            if (enqueued) {
                WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Workflow " + this.myId + " removed while in queue");
                this.handleAbortedWhileInQueue();
            } else {
                if (this.watchDog != null) {
                    this.watchDog.stop();
                }
                if (this.status == 2 && smooth) {
                    WorkflowEngineAgent.this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Smooth-kill for workflow " + this.myId + " while terminating --> just do nothing");
                    return;
                }
                if (message == null) {
                    message = isTimeout ? "Timed out" : "Killed from the outside";
                }
                this.myWorkflow.interrupt(this, WorkflowEngineAgent.this.tbf, message, freeze);
                if (this.status == 5) {
                    this.resume();
                }
            }
        }

        private void handleAbortedWhileInQueue() {
            try {
                this.reply.setPerformative(6);
                ExecutionError er = new ExecutionError("Aborted", "Aborted while in queue", null);
                this.myAgent.getContentManager().fillContent(this.reply, (ContentElement)er);
                this.myAgent.send(this.reply);
                if (!this.getWorkflow().isVolatile()) {
                    WorkflowEngineAgent.this.getStatusManager().notifyTerminated(this, null, "Aborted while in queue");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.onEnd();
        }

        AID getWSMA() {
            return this.wsmaAid;
        }

        void setWSMA(AID wsmaAid) {
            this.wsmaAid = wsmaAid;
        }

        private class TerminationHandler
        extends OneShotBehaviour {
            private TerminationHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void action() {
                WorkflowExecutor workflowExecutor = WorkflowExecutor.this;
                synchronized (workflowExecutor) {
                    if (WorkflowExecutor.this.watchDog != null) {
                        WorkflowExecutor.this.watchDog.stop();
                    }
                    try {
                        this.handle();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        WorkflowExecutor.this.reply.setPerformative(6);
                        WorkflowExecutor.this.reply.setContent("((notification-error))");
                    }
                }
            }

            public int onEnd() {
                return WorkflowExecutor.this.myDescriptor.getTransactional() ? -11 : 0;
            }

            protected void handle() throws Exception {
            }
        }
    }
}

