/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer;

import com.tilab.wade.ca.CAServices;
import com.tilab.wade.performer.HierarchyNode;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.WorkflowException;
import com.tilab.wade.utils.FileUtils;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

class WorkflowSerializationManager {
    private static WorkflowEngineAgent enclosingAgent;
    private static Logger myLogger;
    private static final HashMap primClasses;

    WorkflowSerializationManager() {
    }

    static void save(WorkflowBehaviour wb) {
        try {
            WorkflowEngineAgent.WorkflowExecutor we = wb.rootExecutor;
            WorkflowEngineAgent wea = we.getWorkflow().getAgent();
            byte[] serializedState = WorkflowSerializationManager.serializeWorkflow(we);
            if (wb.supportTags()) {
                we.lastSerializedState = serializedState;
            }
            if (wb.isLongRunning()) {
                wea.getStatusManager().notifySerializedStateChanged(we, serializedState);
            }
        }
        catch (Exception e) {
            myLogger.log(Logger.WARNING, "Error serializing workflow " + wb.getExecutionId() + ", exception message: " + e.getMessage());
        }
    }

    static WorkflowEngineAgent getEnclosingAgent() {
        return enclosingAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] serializeWorkflow(WorkflowEngineAgent.WorkflowExecutor executor) throws Exception {
        long startTime = System.currentTimeMillis();
        WorkflowEngineAgent agent = executor.getWorkflow().getAgent();
        executor.setAgent(null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream encoder = new ObjectOutputStream(out);
            encoder.writeObject((Object)executor);
        }
        finally {
            executor.setAgent(agent);
        }
        byte[] output = out.toByteArray();
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "Workflow serialize time=" + (System.currentTimeMillis() - startTime) + ", size=" + output.length);
        }
        if (executor.getWorkflow().isCompressionActive()) {
            output = WorkflowSerializationManager.compress(output);
        }
        return output;
    }

    static synchronized WorkflowEngineAgent.WorkflowExecutor deserializeWorkflow(byte[] serializedWorkflow, WorkflowEngineAgent agent) throws Exception {
        enclosingAgent = agent;
        if (serializedWorkflow.length > 2 && serializedWorkflow[0] == 120 && serializedWorkflow[1] == -38) {
            try {
                serializedWorkflow = WorkflowSerializationManager.decompress(serializedWorkflow);
            }
            catch (DataFormatException dfe) {
                // empty catch block
            }
        }
        long startTime = System.currentTimeMillis();
        ByteArrayInputStream inp = new ByteArrayInputStream(serializedWorkflow);
        ObjectInputStream decoder = new ObjectInputStream(inp){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                try {
                    return Class.forName(desc.getName(), true, CAServices.getInstance(enclosingAgent).getDefaultClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    Class cl = (Class)primClasses.get(desc.getName());
                    if (cl != null) {
                        return cl;
                    }
                    throw ex;
                }
            }
        };
        WorkflowEngineAgent.WorkflowExecutor executor = (WorkflowEngineAgent.WorkflowExecutor)((Object)decoder.readObject());
        executor.lastSerializedState = serializedWorkflow;
        executor.getWorkflow().initRootExecutor();
        enclosingAgent = null;
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "Workflow deserialize time=" + (System.currentTimeMillis() - startTime));
        }
        return executor;
    }

    static void tag(String tagName, WorkflowBehaviour wb) throws Exception {
        if (wb.supportTags()) {
            WorkflowEngineAgent agent;
            byte[] serializedState = wb.rootExecutor.lastSerializedState;
            String executionId = wb.getExecutionId();
            String tagDirName = WorkflowSerializationManager.getTagDirName(executionId, agent = wb.getAgent());
            File tagDir = new File(tagDirName);
            if (!tagDir.exists()) {
                myLogger.log(Logger.CONFIG, "Creating TAG directory " + tagDirName + " ...");
                boolean success = tagDir.mkdirs();
                if (!success) {
                    throw new IOException("Cannot create TAG directory " + tagDirName + ".");
                }
            } else if (!tagDir.isDirectory()) {
                throw new IOException("TAG-directory-name " + tagDirName + " does not refer to a directory.");
            }
            String tagFileName = WorkflowSerializationManager.getTagFileName(tagDirName, tagName);
            if (myLogger.isLoggable(Logger.FINE)) {
                myLogger.log(Logger.FINE, "Writing TAG file " + tagFileName + " ...");
            }
            FileUtils.byte2File((File)new File(tagFileName), (byte[])serializedState);
            if (myLogger.isLoggable(Logger.FINE)) {
                myLogger.log(Logger.FINE, "TAG file " + tagFileName + " successfully created");
            }
        } else {
            throw new WorkflowException("TAG error: workflow does not support TAGS");
        }
    }

    static void reloadTag(String tagName, WorkflowBehaviour wb) throws Exception {
        wb = wb.rootExecutor.getWorkflow();
        WorkflowEngineAgent wea = wb.getAgent();
        myLogger.log(Logger.INFO, "Reloading TAG " + tagName + " ...");
        String tagDirName = WorkflowSerializationManager.getTagDirName(wb.getExecutionId(), wb.getAgent());
        String tagFileName = WorkflowSerializationManager.getTagFileName(tagDirName, tagName);
        File tagFile = new File(tagFileName);
        if (tagFile.exists()) {
            byte[] tagBytes = FileUtils.file2byte((File)tagFile);
            WorkflowEngineAgent.WorkflowExecutor we = WorkflowSerializationManager.deserializeWorkflow(tagBytes, wea);
            WorkflowEngineAgent.WorkflowExecutor rootExecutor = wb.rootExecutor;
            WorkflowBehaviour oldWb = (WorkflowBehaviour)we.getState("execute");
            rootExecutor.setDataStore(oldWb.getDataStore());
            rootExecutor.registerFirstState((Behaviour)oldWb, "execute");
            oldWb.initRootExecutor();
            rootExecutor.setWorkflow(oldWb);
            rootExecutor.lastSerializedState = we.lastSerializedState;
            if (wb.isLongRunning()) {
                wea.getStatusManager().notifySerializedStateChanged(rootExecutor, tagBytes);
            }
            ((HierarchyNode)wb.getCurrent()).setInterrupted();
            myLogger.log(Logger.INFO, "TAG " + tagName + " successfully reloaded");
            throw new Agent.Interrupted();
        }
        throw new IOException("TAG " + tagName + " not found");
    }

    static void deleteTags(WorkflowBehaviour wb) throws Exception {
        wb = wb.rootExecutor.getWorkflow();
        WorkflowEngineAgent wea = wb.getAgent();
        String tagDirName = WorkflowSerializationManager.getTagDirName(wb.getExecutionId(), wb.getAgent());
        myLogger.log(Logger.INFO, "Deleting TAGS " + tagDirName + " ...");
        File tagsFile = new File(tagDirName);
        if (tagsFile.exists()) {
            FileUtils.recursiveDelete((File)tagsFile);
        }
        myLogger.log(Logger.INFO, "TAGS " + tagDirName + " successfully deleted");
    }

    private static String getTagDirName(String executionId, WorkflowEngineAgent agent) {
        String fileSeparator = System.getProperty("file.separator");
        String rootTagDirName = agent.getTypeProperty("tagDir", "TAG");
        return rootTagDirName + fileSeparator + executionId.replace(':', '_');
    }

    private static String getTagFileName(String tagDirName, String tagName) {
        String fileSeparator = System.getProperty("file.separator");
        return tagDirName + fileSeparator + tagName + ".tag";
    }

    private static byte[] compress(byte[] input) {
        long startTime = System.currentTimeMillis();
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[102400];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] out = bos.toByteArray();
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "Workflow compress time=" + (System.currentTimeMillis() - startTime) + ", initial size=" + input.length + ", final size" + out.length);
        }
        return out;
    }

    private static byte[] decompress(byte[] input) throws DataFormatException {
        long startTime = System.currentTimeMillis();
        Inflater decompressor = new Inflater();
        decompressor.setInput(input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[102400];
        while (!decompressor.finished()) {
            int count = decompressor.inflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] out = bos.toByteArray();
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "Workflow decompress time=" + (System.currentTimeMillis() - startTime) + ", initial size=" + input.length + ", final size" + out.length);
        }
        return out;
    }

    static {
        myLogger = Logger.getJADELogger((String)WorkflowSerializationManager.class.getName());
        primClasses = new HashMap(8, 1.0f);
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

