/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.descriptors.rest;

import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.rest.BodyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescriptor
implements Serializable {
    private static final long serialVersionUID = -4817898390981176509L;
    private String id;
    private MethodType type;
    private String documentation;
    private Map<String, BodyDescriptor> requestBodies = new HashMap<String, BodyDescriptor>();
    private Map<String, BodyDescriptor> responseBodies = new HashMap<String, BodyDescriptor>();
    private Map<Long, Map<String, BodyDescriptor>> faultBodies = new HashMap<Long, Map<String, BodyDescriptor>>();
    private List<Parameter> templateParameters = new ArrayList<Parameter>();
    private List<Parameter> queryParameters = new ArrayList<Parameter>();
    private List<Parameter> matrixParameters = new ArrayList<Parameter>();
    private List<Parameter> headerParameters = new ArrayList<Parameter>();
    private List<Parameter> httpParameters = new ArrayList<Parameter>();

    public MethodDescriptor(MethodType type) {
        this(null, type);
    }

    public MethodDescriptor(String id, MethodType type) {
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public MethodType getType() {
        return this.type;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Set<String> getRequestBodyMediaTypesElements() {
        return this.requestBodies.keySet();
    }

    public BodyDescriptor getRequestBody(String mediaTypeElement) {
        return this.requestBodies.get(mediaTypeElement);
    }

    public void addRequestBody(BodyDescriptor body) {
        this.requestBodies.put(body.getMediaTypeElement(), body);
    }

    public Set<String> getResponseBodyMediaTypesElements() {
        return this.responseBodies.keySet();
    }

    public BodyDescriptor getResponseBody(String mediaTypeElement) {
        return this.responseBodies.get(mediaTypeElement);
    }

    public void addResponseBody(BodyDescriptor body) {
        this.responseBodies.put(body.getMediaTypeElement(), body);
    }

    public Set<Long> getFaultStatus() {
        return this.faultBodies.keySet();
    }

    public Set<String> getFaultBodyMediaTypes(Long status) {
        return this.faultBodies.get(status).keySet();
    }

    public Map<String, BodyDescriptor> getFaultBodies(Long status) {
        return this.faultBodies.get(status);
    }

    public BodyDescriptor getFaultBody(Long status, String mediaTypeElement) {
        Map<String, BodyDescriptor> faultBodiesByStatus = this.faultBodies.get(status);
        if (faultBodiesByStatus != null) {
            return faultBodiesByStatus.get(mediaTypeElement);
        }
        return null;
    }

    public void addFaultBody(Long status, BodyDescriptor body) {
        Map<String, BodyDescriptor> faultBodiesByStatus = this.faultBodies.get(status);
        if (faultBodiesByStatus == null) {
            faultBodiesByStatus = new HashMap<String, BodyDescriptor>();
            this.faultBodies.put(status, faultBodiesByStatus);
        }
        faultBodiesByStatus.put(body.getMediaTypeElement(), body);
    }

    public List<Parameter> getTemplateParameters() {
        return this.templateParameters;
    }

    public void addTemplateParameter(Parameter param) {
        this.templateParameters.add(param);
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public void addQueryParameter(Parameter param) {
        this.queryParameters.add(param);
    }

    public List<Parameter> getMatrixParameters() {
        return this.matrixParameters;
    }

    public void addMatrixParameter(Parameter param) {
        this.matrixParameters.add(param);
    }

    public List<Parameter> getHeaderParameters() {
        return this.headerParameters;
    }

    public void addHeaderParameter(Parameter param) {
        this.headerParameters.add(param);
    }

    public List<Parameter> getHttpParameters() {
        return this.httpParameters;
    }

    public void addHttpParameter(Parameter param) {
        this.httpParameters.add(param);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

