/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.descriptors.rest;

import com.tilab.wade.performer.descriptors.rest.ResourceDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBaseDescriptor
implements Serializable {
    private static final long serialVersionUID = 6874598825428216169L;
    private String baseUri;
    private int resourceCnt;
    private Map<String, ResourceDescriptor> resources = new HashMap<String, ResourceDescriptor>();

    public ResourceBaseDescriptor(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getBaseURI() {
        return this.baseUri;
    }

    public Set<String> getResourceIds() {
        return this.resources.keySet();
    }

    public ResourceDescriptor getResource(String id) {
        return this.resources.get(id);
    }

    public void addResource(ResourceDescriptor resource) {
        String id = resource.getId();
        if (id == null || id.isEmpty()) {
            String path = resource.getPath();
            if (path != null && !path.isEmpty()) {
                resource.setId(path);
            } else {
                id = "Resource" + this.getResourceCounter();
                resource.setId(id);
            }
        }
        this.resources.put(resource.getId(), resource);
    }

    private synchronized int getResourceCounter() {
        return this.resourceCnt++;
    }
}

