/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.descriptors.rest;

import com.tilab.wade.performer.descriptors.rest.MethodDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDescriptor
implements Serializable {
    private static final long serialVersionUID = -5824068274786060353L;
    private String id;
    private String documentation;
    private String path;
    private int methodCnt;
    private Map<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();

    public ResourceDescriptor() {
        this(null, null);
    }

    public ResourceDescriptor(String path) {
        this(null, path);
    }

    public ResourceDescriptor(String id, String path) {
        this.id = id;
        this.path = path;
        this.methodCnt = 1;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getMethodIds() {
        return this.methods.keySet();
    }

    public MethodDescriptor getMethod(String id) {
        return this.methods.get(id);
    }

    public void addMethod(MethodDescriptor method) {
        String id = method.getId();
        if (id == null || id.isEmpty()) {
            id = method.getType().name() + this.getMethodCounter();
            method.setId(id);
        }
        this.methods.put(method.getId(), method);
    }

    private synchronized int getMethodCounter() {
        return this.methodCnt++;
    }
}

