/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.descriptors.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.tilab.wade.performer.RestException;
import com.tilab.wade.performer.RestService;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.rest.BodyDescriptor;
import com.tilab.wade.performer.descriptors.rest.MethodDescriptor;
import com.tilab.wade.performer.descriptors.rest.ResourceBaseDescriptor;
import com.tilab.wade.performer.descriptors.rest.ResourceDescriptor;
import jade.content.onto.Ontology;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestDescriptor
implements Serializable {
    private static final long serialVersionUID = -6387445684968098563L;
    public String serviceName;
    private String title;
    private String documentation;
    private String descriptorClassName;
    private Map<String, ResourceBaseDescriptor> resourceBases = new HashMap<String, ResourceBaseDescriptor>();

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Ontology getOntology() {
        return null;
    }

    public Set<String> getResourceBaseURIs() {
        return this.resourceBases.keySet();
    }

    public ResourceBaseDescriptor getResourceBase(String baseUri) {
        return this.resourceBases.get(baseUri);
    }

    public void addResourceBase(ResourceBaseDescriptor resourceBase) {
        this.resourceBases.put(resourceBase.getBaseURI(), resourceBase);
    }

    public String getDescriptorClassName() {
        return this.descriptorClassName;
    }

    public void setDescriptorClassName(String descriptorClassName) {
        this.descriptorClassName = descriptorClassName;
    }

    public void invoke(RestService rs) throws Exception {
        String baseURI = rs.getBaseUri();
        if (baseURI == null) {
            throw new RestException("Missing Rest base URI");
        }
        ResourceBaseDescriptor resourceBaseDescriptor = this.getResourceBase(baseURI);
        if (resourceBaseDescriptor == null) {
            throw new RestException("Status 404 not found. Base URI (" + baseURI + ") not found");
        }
        Set<String> resourcesID = resourceBaseDescriptor.getResourceIds();
        ResourceDescriptor resourceDescriptor = null;
        if (!resourcesID.contains(rs.getResourceId())) {
            throw new RestException("RestService " + this.serviceName + ": resource " + rs.getResourceId() + " not found in RestService stub");
        }
        resourceDescriptor = resourceBaseDescriptor.getResource(rs.getResourceId());
        Set<String> methodsID = resourceDescriptor.getMethodIds();
        MethodDescriptor methodDescriptor = null;
        if (!methodsID.contains(rs.getMethodId())) {
            throw new RestException("RestService " + this.serviceName + ": method " + rs.getMethodId() + " not found in RestService stub");
        }
        methodDescriptor = resourceDescriptor.getMethod(rs.getMethodId());
        String path = resourceDescriptor.getPath();
        URI base = null;
        try {
            base = new URI(baseURI);
        }
        catch (URISyntaxException e) {
            throw new RestException("RestService " + this.serviceName + ": URI Syntax Exception", e);
        }
        List<Parameter> headerParameters = methodDescriptor.getHeaderParameters();
        List<Parameter> matrixParameters = methodDescriptor.getMatrixParameters();
        List<Parameter> queryParameters = methodDescriptor.getQueryParameters();
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)base).clone();
        UriBuilder localUriBuilder = uriBuilder.path(path);
        for (Parameter queryParameter : queryParameters) {
            String queryParamName = queryParameter.getName();
            Object queryParameterValue = rs.extractQuery(queryParamName);
            if (queryParameter.getMandatory() && queryParameterValue == null) {
                throw new RestException("RestService " + this.serviceName + ": mandatory query parameter " + queryParamName + " not found");
            }
            if (queryParameterValue == null) continue;
            localUriBuilder = localUriBuilder.replaceQueryParam(queryParamName, new Object[]{queryParameterValue});
        }
        for (Parameter matrixParameter : matrixParameters) {
            String matrixParamName = matrixParameter.getName();
            Object matrixParameterValue = rs.extractMatrix(matrixParamName);
            if (matrixParameter.getMandatory() && matrixParameterValue == null) {
                throw new RestException("RestService " + this.serviceName + ": mandatory matrix parameter " + matrixParamName + " not found");
            }
            if (matrixParameterValue == null) continue;
            localUriBuilder = localUriBuilder.replaceMatrixParam(matrixParamName, new Object[]{matrixParameterValue});
        }
        WebResource resource = Client.create().resource(localUriBuilder.buildFromMap(rs.getTemplateParameters()));
        WebResource.Builder resourceBuilder = resource.getRequestBuilder();
        for (Parameter headerParameter : headerParameters) {
            String headerParamName = headerParameter.getName();
            Object headerParameterValue = rs.extractHeader(headerParamName);
            if (headerParameter.getMandatory() && headerParameterValue == null) {
                throw new RestException("RestService " + this.serviceName + ": mandatory header parameter " + headerParamName + " not found");
            }
            if (headerParameterValue == null) continue;
            resourceBuilder = (WebResource.Builder)resourceBuilder.header(headerParamName, headerParameterValue);
        }
        BodyDescriptor responseBody = null;
        if (rs.getResponseMediaTypeElement() != null) {
            responseBody = methodDescriptor.getResponseBody(rs.getResponseMediaTypeElement());
            if (responseBody != null) {
                resourceBuilder.accept(new MediaType[]{MediaType.valueOf((String)responseBody.getMediaType())});
            } else {
                throw new RestException("RestService " + this.serviceName + ": Response Media Type element" + rs.getResponseMediaTypeElement() + " not found");
            }
        }
        MethodDescriptor.MethodType methodType = methodDescriptor.getType();
        String type = "null";
        switch (methodType) {
            case POST: {
                type = "POST";
                break;
            }
            case PUT: {
                type = "PUT";
                break;
            }
            case DELETE: {
                type = "DELETE";
                break;
            }
            case GET: {
                type = "GET";
                break;
            }
        }
        ClientResponse response = null;
        if (methodType == MethodDescriptor.MethodType.POST || methodType == MethodDescriptor.MethodType.PUT) {
            if (!methodDescriptor.getRequestBodyMediaTypesElements().isEmpty()) {
                BodyDescriptor requestBody;
                if (rs.getRequestMediaTypeElement() != null) {
                    requestBody = methodDescriptor.getRequestBody(rs.getRequestMediaTypeElement());
                } else {
                    String mediaTypesElement = methodDescriptor.getRequestBodyMediaTypesElements().iterator().next();
                    requestBody = methodDescriptor.getRequestBody(mediaTypesElement);
                }
                if (requestBody == null) {
                    throw new RestException("RestService " + this.serviceName + ": Request Media Type element " + rs.getRequestMediaTypeElement() + " not found");
                }
                resourceBuilder.type(MediaType.valueOf((String)requestBody.getMediaType()));
                Object requestValue = rs.extractBody("request");
                if (requestValue != null) {
                    response = (ClientResponse)resourceBuilder.method(type, ClientResponse.class, requestValue);
                } else {
                    if (requestBody.getElementType() != null) {
                        throw new RestException("RestService " + this.serviceName + ": Request Object cannot be null, it must be of type " + requestBody.getType());
                    }
                    response = (ClientResponse)resourceBuilder.method(type, ClientResponse.class);
                }
            } else {
                response = (ClientResponse)resourceBuilder.method(type, ClientResponse.class);
            }
        } else {
            response = (ClientResponse)resourceBuilder.method(type, ClientResponse.class);
        }
        ClientResponse.Status responseStatus = response.getClientResponseStatus();
        Date date = response.getResponseDate();
        rs.fillHttp("statusCode", response.getStatus());
        if (response.getStatus() >= 400) {
            if (!methodDescriptor.getFaultStatus().isEmpty()) {
                BodyDescriptor faultBody = methodDescriptor.getFaultBody(Long.valueOf(response.getStatus()), rs.getFaultMediaTypeElement());
                if (faultBody != null && faultBody.getType() != null) {
                    rs.fillBody(String.valueOf(response.getStatus()), response.getEntity(faultBody.getTypeClass()));
                    throw new RestException("A REST response fault has been presented. ERROR status: " + response.getStatus() + " " + responseStatus + " " + date + ".  " + faultBody.getDocumentation(), response.getStatus(), response.getEntity(faultBody.getTypeClass()));
                }
                String res = (String)response.getEntity(String.class);
                rs.fillBody(String.valueOf(response.getStatus()), res);
                throw new RestException("ERROR status: " + response.getStatus() + " " + responseStatus + " " + date, response.getStatus(), res);
            }
            if (response.hasEntity()) {
                String res = (String)response.getEntity(String.class);
                rs.fillBody(String.valueOf(response.getStatus()), res);
                throw new RestException("ERROR status: " + response.getStatus() + " " + responseStatus + " " + date, response.getStatus(), res);
            }
        } else if (responseBody != null) {
            if (response.hasEntity() && responseBody.getType() != null) {
                rs.fillBody("response", response.getEntity(responseBody.getTypeClass()));
            } else if (response.getStatus() != 204) {
                rs.fillBody("response", response.getEntity(String.class));
            }
        } else if (response.hasEntity()) {
            rs.fillBody("response", response.getEntity(String.class));
        }
    }
}

