/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.descriptors.webservice;

import com.tilab.wade.performer.WebService;
import com.tilab.wade.performer.WebServiceAddressingContext;
import com.tilab.wade.performer.WebServiceException;
import com.tilab.wade.performer.WebServiceSecurityContext;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.descriptors.webservice.Header;
import com.tilab.wade.performer.descriptors.webservice.MultiportDescriptor;
import com.tilab.wade.performer.descriptors.webservice.OperationDescriptor;
import com.tilab.wade.performer.descriptors.webservice.PortDescriptor;
import com.tilab.wade.performer.descriptors.webservice.ServiceMetaInfo;
import jade.content.onto.Ontology;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.SimpleSessionHandler;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.handler.AddressingHandler;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.axis.types.URI;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.ws.axis.security.WSDoAllReceiver;
import org.apache.ws.axis.security.WSDoAllSender;
import org.apache.ws.axis.security.handler.WSDoAllHandler;
import org.apache.ws.security.WSPasswordCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceDescriptor
implements Serializable {
    public static final String SERVICE_DESCRIPTOR_SUFFIX = "Descriptor";
    private static final String DEFAULT_PORT = "_DEFAULT_PORT_";
    protected Map<String, PortDescriptor> portDescriptors = new HashMap<String, PortDescriptor>();
    private boolean multiport = this instanceof MultiportDescriptor;

    public ServiceDescriptor() {
        if (!this.multiport) {
            this.portDescriptors.put(DEFAULT_PORT, new PortDescriptor());
        }
    }

    protected abstract Remote getService() throws ServiceException;

    public abstract void setEndpointAddress(String var1);

    public abstract String getServiceName();

    public static boolean check(Class serviceDescriptorClass, ServiceUsage searchedServiceUsage, String searchedSServicePurpose) {
        if (!ServiceDescriptor.class.isAssignableFrom(serviceDescriptorClass)) {
            return false;
        }
        if (searchedServiceUsage == null && searchedSServicePurpose == null) {
            return true;
        }
        ServiceUsage serviceUsage = null;
        String servicePurpose = null;
        ServiceMetaInfo descriptorType = serviceDescriptorClass.getAnnotation(ServiceMetaInfo.class);
        if (descriptorType != null) {
            serviceUsage = descriptorType.usage();
            String annotServicePurpose = descriptorType.purpose();
            if (!annotServicePurpose.equals("__NULL__")) {
                servicePurpose = annotServicePurpose;
            }
        } else {
            serviceUsage = ServiceUsage.CLIENT;
        }
        if (searchedServiceUsage == null || serviceUsage == searchedServiceUsage) {
            if (searchedSServicePurpose == null) {
                return true;
            }
            return searchedSServicePurpose.equals(servicePurpose);
        }
        return false;
    }

    public Ontology getOntology() {
        return null;
    }

    public PortDescriptor getPortDescriptor(String portName) {
        return this.portDescriptors.get(portName);
    }

    public void addPortDescriptor(String portName, PortDescriptor pd) {
        this.portDescriptors.put(portName, pd);
    }

    public OperationDescriptor getOperationDescriptor(String operName) {
        PortDescriptor portDescriptor = this.portDescriptors.get(DEFAULT_PORT);
        return portDescriptor.getOperationDescriptor(operName);
    }

    public void addOperationDescriptor(String operName, OperationDescriptor operDesc) {
        PortDescriptor portDescriptor = this.portDescriptors.get(DEFAULT_PORT);
        portDescriptor.addOperationDescriptor(operName, operDesc);
    }

    public Set<String> getOperationNames() {
        PortDescriptor portDescriptor = this.portDescriptors.get(DEFAULT_PORT);
        return portDescriptor.getOperationNames();
    }

    public Set<String> getPortNames() {
        return this.portDescriptors.keySet();
    }

    public void invoke(WebService ws) throws Exception {
        Method operationMethod;
        WebServiceAddressingContext ac;
        Stub stub;
        String serviceName = this.getServiceName();
        if (serviceName == null) {
            throw new WebServiceException("Missing webservice name");
        }
        String operationName = ws.getOperation();
        if (operationName == null) {
            throw new WebServiceException("Missing operation name for webservice " + serviceName);
        }
        try {
            stub = this.multiport && ws.getPort() != null ? (Stub)((MultiportDescriptor)((Object)this)).getService(ws.getPort()) : (Stub)this.getService();
        }
        catch (ServiceException se) {
            throw new WebServiceException("No webservice stub class found for webservice " + serviceName, se);
        }
        int serviceCallTimeout = ws.getTimeout();
        if (serviceCallTimeout >= 0) {
            stub.setTimeout(serviceCallTimeout);
        }
        if (ws.getEndpointAddress() != null) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)ws.getEndpointAddress());
        }
        SimpleSessionHandler sessionHandler = new SimpleSessionHandler();
        SimpleChain reqHandlers = new SimpleChain();
        reqHandlers.addHandler((Handler)sessionHandler);
        SimpleChain respHandlers = new SimpleChain();
        respHandlers.addHandler((Handler)sessionHandler);
        HTTPSender pivot = new HTTPSender();
        SimpleTargetedChain transport = new SimpleTargetedChain((Handler)reqHandlers, (Handler)pivot, (Handler)respHandlers);
        SimpleProvider clientConfig = new SimpleProvider();
        clientConfig.deployTransport("http", (Handler)transport);
        Service service = (Service)stub._getService();
        service.setEngineConfiguration((EngineConfiguration)clientConfig);
        service.setEngine((AxisEngine)new AxisClient((EngineConfiguration)clientConfig));
        WebServiceSecurityContext sc = ws.getSecurityContext();
        if (sc != null) {
            Boolean enableCertificateChecking;
            String httpUsername = sc.getHttpUsername();
            String httpPassword = sc.getHttpPassword();
            if (httpUsername != null && httpPassword != null) {
                stub.setUsername(httpUsername);
                stub.setPassword(httpPassword);
            }
            String wssUsername = sc.getWSSUsername();
            String wssPassword = sc.getWSSPassword();
            String wssPasswordType = sc.getWSSPasswordType();
            Boolean wssMustUnderstand = sc.isWSSMustUnderstand();
            Integer wssTimeToLive = sc.getWSSTimeToLive();
            if (wssUsername != null && wssPassword != null || wssTimeToLive != null) {
                WSDoAllSender wssSenderHandler = new WSDoAllSender();
                reqHandlers.addHandler((Handler)wssSenderHandler);
                WSDoAllReceiver wssReceiverHandler = new WSDoAllReceiver();
                if (wssTimeToLive != null) {
                    respHandlers.addHandler((Handler)wssReceiverHandler);
                }
                if (wssMustUnderstand != null) {
                    stub._setProperty("mustUnderstand", (Object)wssMustUnderstand.toString());
                }
                if (wssUsername != null && wssPassword != null) {
                    ServiceDescriptor.addHandlerAction((WSDoAllHandler)wssSenderHandler, "UsernameToken");
                    stub._setProperty("passwordType", (Object)wssPasswordType);
                    stub._setProperty("user", (Object)wssUsername);
                    WSSPasswordCallback passwordCallback = new WSSPasswordCallback(wssPassword);
                    stub._setProperty("passwordCallbackRef", (Object)passwordCallback);
                }
                if (wssTimeToLive != null) {
                    ServiceDescriptor.addHandlerAction((WSDoAllHandler)wssSenderHandler, "Timestamp");
                    ServiceDescriptor.addHandlerAction((WSDoAllHandler)wssReceiverHandler, "Timestamp");
                    stub._setProperty("timeToLive", (Object)wssTimeToLive.toString());
                }
            }
            String trustStore = sc.getTrustStore();
            String trustStorePassword = sc.getTrustStorePassword();
            if (trustStore != null && trustStorePassword != null) {
                System.setProperty("javax.net.ssl.trustStore", trustStore);
                System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
            }
            if ((enableCertificateChecking = sc.isEnableCertificateChecking()) != null) {
                if (enableCertificateChecking.booleanValue()) {
                    AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"");
                } else {
                    AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"org.apache.axis.components.net.SunFakeTrustSocketFactory");
                }
            }
        }
        if ((ac = ws.getAddressingContext()) != null) {
            String faultTo;
            String replyTo;
            String to;
            String from;
            String action;
            String messageID;
            String version;
            Boolean sendDefaultTo;
            Boolean sendDefaultFrom;
            Boolean sendDefaultMessageID;
            AddressingHandler addressingHandler = new AddressingHandler();
            reqHandlers.addHandler((Handler)addressingHandler);
            respHandlers.addHandler((Handler)addressingHandler);
            AddressingHeaders addressingHeaders = new AddressingHeaders();
            Boolean mustUnderstand = ac.isMustUnderstand();
            if (mustUnderstand != null) {
                stub._setProperty("addressing.setMustUnderstand", (Object)mustUnderstand.toString());
            }
            if ((sendDefaultMessageID = ac.isSendDefaultMessageID()) != null) {
                stub._setProperty("addressing.sendDefaultID", (Object)sendDefaultMessageID.toString());
            }
            if ((sendDefaultFrom = ac.isSendDefaultFrom()) != null) {
                stub._setProperty("addressing.sendDefaultFrom", (Object)sendDefaultFrom.toString());
            }
            if ((sendDefaultTo = ac.isSendDefaultTo()) != null) {
                stub._setProperty("addressing.sendDefaultTo", (Object)sendDefaultTo.toString());
            }
            if ((version = ac.getVersion()) != null) {
                stub._setProperty("addressing.namespace.URI", (Object)version);
            }
            if ((messageID = ac.getMessageID()) != null) {
                addressingHeaders.setMessageID(new MessageID(new URI(messageID)));
            }
            if ((action = ac.getAction()) != null) {
                addressingHeaders.setAction(action);
            }
            if ((from = ac.getFrom()) != null) {
                addressingHeaders.setFrom(new EndpointReference(from));
            }
            if ((to = ac.getTo()) != null) {
                addressingHeaders.setTo(new AttributedURI(to));
            }
            if ((replyTo = ac.getReplyTo()) != null) {
                addressingHeaders.setReplyTo(new EndpointReference(replyTo));
            }
            if ((faultTo = ac.getFaultTo()) != null) {
                addressingHeaders.setFaultTo(new EndpointReference(faultTo));
            }
            stub._setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)addressingHeaders);
        }
        String methodName = Utils.xmlNameToJava((String)operationName);
        String portName = this.multiport ? ws.getPort() : DEFAULT_PORT;
        PortDescriptor portDescriptor = this.portDescriptors.get(portName);
        if (portDescriptor == null) {
            throw new WebServiceException("Descriptor of port " + portName + " not found in webservice descrptor " + this.getClass().getName());
        }
        OperationDescriptor operationDescriptor = portDescriptor.getOperationDescriptor(operationName);
        if (operationDescriptor == null) {
            throw new WebServiceException("Descriptor of operation " + operationName + " not found in webservice descrptor " + this.getClass().getName());
        }
        jade.util.leap.Map actualParams = ws.getParams();
        List formalParams = operationDescriptor.getFormalParams();
        jade.util.leap.Map actualHeaders = ws.getHeaders();
        List formalHeaders = operationDescriptor.getFormalHeaders();
        String returnValueName = operationDescriptor.getReturnValueName();
        Vector<Parameter> methodParams = this.getMethodParams(formalParams, actualParams, formalHeaders, actualHeaders, returnValueName);
        ClassLoader serviceClassLoader = ws.getOwner() != null ? ws.getOwner().getClass().getClassLoader() : this.getClass().getClassLoader();
        Class[] methodValuesClass = new Class[methodParams.size()];
        Object[] methodValuesObj = new Object[methodParams.size()];
        for (int index = 0; index < methodParams.size(); ++index) {
            Class methodParamClass;
            Parameter methodParam = methodParams.get(index);
            methodValuesClass[index] = methodParamClass = this.getParamClass(methodParam, serviceClassLoader);
            Object methodParamValue = this.getParamValue(methodParam, methodParamClass);
            if (Holder.class.isAssignableFrom(methodParamClass)) {
                methodParamValue = JavaUtils.convert((Object)methodParamValue, (Class)methodParamClass);
            }
            methodValuesObj[index] = methodParamValue;
        }
        for (Header formalHeader : formalHeaders) {
            Object actualHeaderValue;
            String headerName = formalHeader.getName();
            int signaturePosition = formalHeader.getSignaturePosition();
            if (signaturePosition != -1 || formalHeader.getMode() != 0 && formalHeader.getMode() != 2 || (actualHeaderValue = actualHeaders.get((Object)headerName)) == null) continue;
            SOAPHeaderElement header = new SOAPHeaderElement(formalHeader.getNamespace(), headerName, actualHeaderValue);
            header.setActor(formalHeader.getActor());
            header.setMustUnderstand(formalHeader.isMustUnderstand());
            header.setRelay(formalHeader.isRelay());
            stub.setHeader(header);
        }
        try {
            operationMethod = stub.getClass().getMethod(methodName, methodValuesClass);
        }
        catch (Exception e) {
            throw new WebServiceException("WebService " + serviceName + ": method " + methodName + " not found in service stub", e);
        }
        Object returnValue = null;
        try {
            returnValue = operationMethod.invoke((Object)stub, methodValuesObj);
        }
        catch (InvocationTargetException ie) {
            if (ie.getCause() instanceof RemoteException) {
                throw (RemoteException)ie.getCause();
            }
            throw new WebServiceException("WebService " + serviceName + ": operation " + operationName + " invocation error", ie.getCause());
        }
        catch (Exception e) {
            throw new WebServiceException("WebService " + serviceName + ": method " + methodName + " invocation error", e);
        }
        for (Header formalHeader : formalHeaders) {
            Object headerValue;
            String headerName = formalHeader.getName();
            int signaturePosition = formalHeader.getSignaturePosition();
            if (signaturePosition != -1 || formalHeader.getMode() != 1 && formalHeader.getMode() != 2 || (headerValue = this.getHeaderValue(stub, formalHeader, serviceClassLoader)) == null) continue;
            formalHeader.setValue(headerValue);
            ws.getHeaders().put((Object)headerName, headerValue);
        }
        for (int index = 0; index < methodParams.size(); ++index) {
            Parameter methodParam = methodParams.get(index);
            String paramName = methodParam.getName();
            int paramMode = methodParam.getMode();
            if (paramMode != 1 && paramMode != 2) continue;
            Holder paramHolderValue = (Holder)methodValuesObj[index];
            Class paramValueClass = JavaUtils.getHolderValueType(paramHolderValue.getClass());
            Object methodParamValue = JavaUtils.convert((Object)paramHolderValue, (Class)paramValueClass);
            methodParam.setValue(methodParamValue);
            if (methodParam instanceof Header) {
                ws.getHeaders().put((Object)paramName, methodParamValue);
                continue;
            }
            ws.getParams().put((Object)paramName, methodParamValue);
        }
        ws.setReturnValue(returnValue);
        if (returnValueName != null) {
            ws.getParams().put((Object)returnValueName, returnValue);
        }
    }

    private static void addHandlerAction(WSDoAllHandler handler, String action) {
        String prevAction = (String)handler.getOption("action");
        if (prevAction != null) {
            action = prevAction + " " + action;
        }
        handler.setOption("action", (Object)action);
    }

    private Object getHeaderValue(Stub service, Header formalHeader, ClassLoader headersClassLoader) throws WebServiceException {
        String name = formalHeader.getName();
        SOAPHeaderElement header = service.getResponseHeader(formalHeader.getNamespace(), name);
        if (header == null) {
            header = service.getResponseHeader(null, name);
        }
        Object headerValue = null;
        if (header != null) {
            Class headerClass = this.getParamClass((Parameter)formalHeader, headersClassLoader);
            try {
                headerValue = header.getObjectValue(headerClass);
            }
            catch (Exception e) {
                throw new WebServiceException("Header " + name + " error getting value");
            }
        }
        return headerValue;
    }

    private Vector<Parameter> getMethodParams(List formalParams, jade.util.leap.Map actualParams, List formalHeaders, jade.util.leap.Map actualHeaders, String returnValueName) throws WebServiceException {
        Parameter methodParam;
        Vector<Parameter> methodParams = new Vector<Parameter>();
        int methodParamsSize = 0;
        for (Header formalHeader : formalHeaders) {
            int signaturePosition = formalHeader.getSignaturePosition();
            if (signaturePosition == -1) continue;
            if (methodParams.size() <= signaturePosition) {
                methodParams.setSize(signaturePosition + 1);
            }
            methodParam = this.createMethodParam((Parameter)formalHeader, actualHeaders);
            methodParams.set(signaturePosition, methodParam);
            ++methodParamsSize;
        }
        methodParamsSize += formalParams.size();
        if (returnValueName != null) {
            --methodParamsSize;
        }
        methodParams.setSize(methodParamsSize);
        Iterator it = formalParams.iterator();
        for (int i = 0; i < methodParamsSize; ++i) {
            if (methodParams.get(i) != null) continue;
            Parameter formalParam = (Parameter)it.next();
            if (returnValueName != null && formalParam.getName().equals(returnValueName) && formalParam.getMode() == 1) continue;
            methodParam = this.createMethodParam(formalParam, actualParams);
            methodParams.set(i, methodParam);
        }
        return methodParams;
    }

    private Parameter createMethodParam(Parameter formal, jade.util.leap.Map actuals) throws WebServiceException {
        Parameter methodParam = this.cloneParam(formal);
        String name = formal.getName();
        int mode = formal.getMode();
        if (mode == 0 || mode == 2) {
            methodParam.setValue(actuals.get((Object)name));
        }
        return methodParam;
    }

    private Parameter cloneParam(Parameter param) throws WebServiceException {
        if (param == null) {
            throw new WebServiceException("Parameter clone error: param = null");
        }
        Object cloneParam = param instanceof Header ? new Header() : new Parameter();
        cloneParam.setName(param.getName());
        cloneParam.setMode(param.getMode());
        cloneParam.setType(param.getType());
        cloneParam.setValue(param.getValue());
        return cloneParam;
    }

    private Class getParamClass(Parameter methodParam, ClassLoader paramsClassLoader) throws WebServiceException {
        try {
            return methodParam.getTypeClass(false, paramsClassLoader);
        }
        catch (Exception e) {
            throw new WebServiceException("Parameter " + methodParam.getName() + " class (" + methodParam.getType() + ") not found");
        }
    }

    private Object getParamValue(Parameter methodParam, Class methodParamClass) throws WebServiceException {
        Object paramValue;
        if (methodParam.getMode() == 1) {
            try {
                paramValue = methodParamClass.newInstance();
            }
            catch (Exception e) {
                throw new WebServiceException("Parameter " + methodParam.getName() + " error creating instance of " + methodParamClass);
            }
        } else {
            paramValue = methodParam.getValue();
        }
        return paramValue;
    }

    private class WSSPasswordCallback
    implements CallbackHandler {
        private String password;

        public WSSPasswordCallback(String password) {
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof WSPasswordCallback)) {
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                }
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                pc.setPassword(this.password);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServiceUsage {
        CLIENT,
        SERVER,
        CLIENT_SERVER;

    }
}

