/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.eval;

import bsh.EvalError;
import bsh.Interpreter;
import com.tilab.wade.performer.BindingHolder;
import com.tilab.wade.performer.ComparisonHelper;
import com.tilab.wade.performer.eval.Formula;
import jade.util.Logger;

public class Function
extends BindingHolder
implements Formula {
    protected Logger myLogger = Logger.getMyLogger((String)Function.class.getName());
    private String functionScript;
    private Interpreter interpreter = new Interpreter();

    public Function(String functionScript) {
        this.functionScript = functionScript;
        this.interpreter.getNameSpace().importClass(ComparisonHelper.class.getName());
    }

    public Object evaluate() throws Exception {
        Object result;
        this.myLogger.log(Logger.INFO, "Evaluate function " + this.functionScript);
        this.resolveBindings();
        try {
            result = this.interpreter.eval(this.functionScript);
        }
        catch (Exception e) {
            if (e instanceof EvalError) {
                throw (EvalError)e;
            }
            throw new EvalError("Function <" + this.functionScript + "> is not a valid expression", null, null);
        }
        this.myLogger.log(Logger.INFO, "Function " + this.functionScript + " -> " + result);
        return result;
    }

    public String toString() {
        return "Function(" + this.functionScript + ")";
    }

    private void resolveBindings() throws Exception {
        for (BindingHolder.Bind bind : this.getBindings()) {
            if (bind.getFormula() == null) continue;
            Object value = bind.getFormula().evaluate();
            this.interpreter.set(bind.getName(), value);
            this.myLogger.log(Logger.INFO, "Set " + bind.getName() + " = " + value);
        }
    }
}

