/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.eval;

import com.tilab.wade.performer.BindingException;
import com.tilab.wade.performer.HierarchyNode;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.eval.Formula;
import jade.content.abs.AbsObject;

public class Reference
implements Formula {
    private String activityName;
    private String parameterName;
    private int parameterMode;
    private String parameterPart;
    private WorkflowBehaviour owner;

    public Reference(String activityName, String parameterName, WorkflowBehaviour owner) {
        this(activityName, parameterName, 1, null, owner);
    }

    public Reference(String activityName, String parameterName, int parameterMode, String parameterPart, WorkflowBehaviour owner) {
        this.activityName = activityName;
        this.parameterName = parameterName;
        this.parameterMode = parameterMode;
        this.parameterPart = parameterPart;
        this.owner = owner;
    }

    public Object evaluate() throws Exception {
        HierarchyNode activity = this.getSourceActivity();
        return activity.getBindingManager().getValue(this.parameterName, this.parameterMode, this.parameterPart);
    }

    public AbsObject evaluateAbs() throws Exception {
        HierarchyNode activity = this.getSourceActivity();
        return activity.getBindingManager().getAbsValue(this.parameterName, this.parameterMode, this.parameterPart);
    }

    private HierarchyNode getSourceActivity() throws BindingException {
        HierarchyNode activity = (HierarchyNode)this.owner.getState(this.activityName);
        if (activity == null) {
            throw new BindingException("Activity " + this.activityName + " not present in workflow");
        }
        return activity;
    }

    public String toString() {
        return "Reference(" + this.activityName + "," + this.parameterName + "," + this.parameterMode + "," + this.parameterPart + ")";
    }
}

