/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.eval;

import bsh.EvalError;
import bsh.Interpreter;
import com.tilab.wade.performer.BindingHolder;
import com.tilab.wade.performer.ComparisonHelper;
import com.tilab.wade.performer.eval.Condition;
import jade.util.Logger;

public class ScriptCondition
extends Condition {
    protected Logger myLogger = Logger.getMyLogger((String)ScriptCondition.class.getName());
    private String conditionScript;
    private Interpreter interpreter = new Interpreter();

    public ScriptCondition(String conditionScript) {
        this.conditionScript = conditionScript;
        this.interpreter.getNameSpace().importClass(ComparisonHelper.class.getName());
    }

    public boolean evaluate() throws Exception {
        this.myLogger.log(Logger.INFO, "Evaluate script-condition " + this.conditionScript);
        this.resolveBindings();
        boolean result = true;
        try {
            result = (Boolean)this.interpreter.eval(this.conditionScript);
        }
        catch (Exception e) {
            if (e instanceof EvalError) {
                throw (EvalError)e;
            }
            throw new EvalError("Condition <" + this.conditionScript + "> is not a valid logical expression", null, null);
        }
        this.myLogger.log(Logger.INFO, "Script-condition " + this.conditionScript + " -> " + result);
        return result;
    }

    private void resolveBindings() throws Exception {
        for (BindingHolder.Bind bind : this.getBindings()) {
            if (bind.getFormula() == null) continue;
            Object value = bind.getFormula().evaluate();
            this.interpreter.set(bind.getName(), value);
            this.myLogger.log(Logger.INFO, "Set " + bind.getName() + " = " + value);
        }
    }

    public String toString() {
        return this.conditionScript;
    }
}

