/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.HierarchyNode;
import com.tilab.wade.performer.Subflow;
import com.tilab.wade.performer.UnmanagedField;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.performer.event.WorkflowEvent;
import com.tilab.wade.performer.interactivity.Action;
import com.tilab.wade.performer.interactivity.AdditionalInfoConstraint;
import com.tilab.wade.performer.interactivity.BackOnFirstInteractionException;
import com.tilab.wade.performer.interactivity.Component;
import com.tilab.wade.performer.interactivity.Constraint;
import com.tilab.wade.performer.interactivity.Interaction;
import com.tilab.wade.performer.interactivity.InteractionException;
import com.tilab.wade.performer.interactivity.InteractivitySnapshot;
import com.tilab.wade.performer.interactivity.ListPanel;
import com.tilab.wade.performer.interactivity.NotificationInfo;
import com.tilab.wade.performer.interactivity.OutputInteraction;
import com.tilab.wade.performer.interactivity.Panel;
import com.tilab.wade.performer.interactivity.StructuredDataElement;
import com.tilab.wade.performer.interactivity.ontology.Back;
import com.tilab.wade.performer.interactivity.ontology.GetSnapshot;
import com.tilab.wade.performer.interactivity.ontology.Go;
import com.tilab.wade.performer.interactivity.ontology.InteractivityCompleted;
import com.tilab.wade.performer.interactivity.ontology.InteractivityOntology;
import com.tilab.wade.performer.layout.WorkflowSkipped;
import com.tilab.wade.performer.ontology.ExecutionError;
import com.tilab.wade.performer.ontology.Modifier;
import com.tilab.wade.utils.OntologyUtils;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.Predicate;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Result;
import jade.content.schema.ObjectSchema;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WorkflowSkipped
public class InteractiveWorkflowBehaviour
extends WorkflowBehaviour {
    protected static final String UNGROUNDED_PARAMETERS_PANEL_ID = "UNGROUNDED_PARAMETERS_PANEL_ID";
    @UnmanagedField
    private boolean interactivityCompleted = false;
    @UnmanagedField
    private Interaction currentInteraction;
    @UnmanagedField
    private List<Display> toBeDisplayed = new java.util.ArrayList<Display>();
    @UnmanagedField
    protected String displayActivityName = "";
    @UnmanagedField
    private List<NotificationInfo> notifications = new java.util.ArrayList<NotificationInfo>();
    @UnmanagedField
    private boolean closeInteractivityOnSuspension = true;
    @UnmanagedField
    private String suspendMessage;
    @UnmanagedField
    private Stack<String> steps = new Stack();
    @UnmanagedField
    private HashMap<String, HashMap<String, java.util.ArrayList>> inputDisplays = new HashMap();
    @UnmanagedField
    private HashMap<String, HashMap<String, java.util.ArrayList>> outputDisplays = new HashMap();
    @UnmanagedField
    private HashMap<String, HashMap<String, java.util.ArrayList>> inputInfos = new HashMap();
    @UnmanagedField
    private HashMap<String, HashMap<String, java.util.ArrayList>> outputInfos = new HashMap();

    public InteractiveWorkflowBehaviour() {
    }

    public InteractiveWorkflowBehaviour(String activityName) {
        super(activityName);
    }

    private List getParamActions(HashMap<String, HashMap<String, java.util.ArrayList>> actionsMap, String activityName, String paramKey, boolean createIfNotPresent) {
        java.util.ArrayList actions4Param = null;
        HashMap<String, java.util.ArrayList<Object>> actions4Activity = actionsMap.get(activityName);
        if (actions4Activity == null && createIfNotPresent) {
            actions4Activity = new HashMap();
            actionsMap.put(activityName, actions4Activity);
        }
        if (actions4Activity != null && (actions4Param = actions4Activity.get(paramKey)) == null && createIfNotPresent) {
            actions4Param = new java.util.ArrayList();
            actions4Activity.put(paramKey, actions4Param);
        }
        return actions4Param;
    }

    private List getParamActions(HashMap<String, HashMap<String, java.util.ArrayList>> inputActionsMap, HashMap<String, HashMap<String, java.util.ArrayList>> outputActionsMap, String activityName, String paramKey, int paramMode, boolean createIfNotPresent) {
        List paramActions = paramMode == 0 ? this.getParamActions(inputActionsMap, activityName, paramKey, createIfNotPresent) : this.getParamActions(outputActionsMap, activityName, paramKey, createIfNotPresent);
        return paramActions;
    }

    public void setAdditionalInfo(String activityName, String paramKey, int paramMode, String paramPart, String info) {
        List paramInfos = this.getParamActions(this.inputInfos, this.outputInfos, activityName, paramKey, paramMode, true);
        paramInfos.add(new AdditionalInfo(paramPart, info));
    }

    public void display(String activityName, String paramKey, int paramMode, String paramPart, String label) {
        List paramDisplays = this.getParamActions(this.inputDisplays, this.outputDisplays, activityName, paramKey, paramMode, true);
        if (label == null) {
            label = paramKey;
            if (paramPart != null) {
                label = label + "." + paramPart;
            }
        }
        paramDisplays.add(new Display(activityName, paramKey, paramMode, paramPart, label));
    }

    protected ListPanel prepareDisplaysPanel() {
        ListPanel displayPanel = null;
        if (!this.toBeDisplayed.isEmpty()) {
            displayPanel = new ListPanel();
            displayPanel.setLabel(this.getDisplaysTitle());
            int displayIndex = 0;
            for (Display display : this.toBeDisplayed) {
                String displayKey = "display#" + displayIndex;
                StructuredDataElement displayElement = new StructuredDataElement(displayKey);
                displayElement.setEditable(false);
                displayElement.setLabel(display.label);
                displayElement.setValue(display.value);
                List paramInfos = this.getParamActions(this.inputInfos, this.outputInfos, display.activityName, display.paramKey, display.paramMode, false);
                if (paramInfos != null) {
                    for (AdditionalInfo additionalInfo : paramInfos) {
                        String paramPart = null;
                        String displayPart = display.paramPart;
                        String infoPart = additionalInfo.paramPart;
                        if (displayPart == null) {
                            paramPart = infoPart != null ? infoPart : "";
                        } else if (infoPart != null && infoPart.startsWith(displayPart)) {
                            paramPart = infoPart.equals(displayPart) ? "" : infoPart.substring(displayPart.length() + 1);
                        }
                        if (paramPart == null) continue;
                        try {
                            displayElement.addConstraint((Constraint)new AdditionalInfoConstraint(additionalInfo.info), paramPart);
                        }
                        catch (OntologyException e) {
                            this.myLogger.log(Logger.WARNING, e.getMessage(), (Throwable)e);
                        }
                    }
                }
                displayPanel.addComponent((Component)displayElement);
                ++displayIndex;
            }
            this.toBeDisplayed.clear();
        }
        return displayPanel;
    }

    private ListPanel perpareUngroundedParametersPanel(BuildingBlock bb, Map<String, AbsObject> ungroundedParameters) {
        ListPanel paramPanel = null;
        if (!ungroundedParameters.isEmpty()) {
            paramPanel = new ListPanel(UNGROUNDED_PARAMETERS_PANEL_ID);
            paramPanel.setLabel(this.getUngroundedParametersTitle());
            for (String ungroundedParameterName : ungroundedParameters.keySet()) {
                Parameter inputParameter = bb.getInputParameter(ungroundedParameterName);
                AbsObject ungroundedParameterValue = ungroundedParameters.get(ungroundedParameterName);
                try {
                    ObjectSchema paramSchema = OntologyUtils.getParameterSchema((Parameter)inputParameter, (Ontology)bb.getOntology());
                    inputParameter.setSchema(paramSchema);
                    StructuredDataElement ungroundedParameterElement = new StructuredDataElement(ungroundedParameterName);
                    ungroundedParameterElement.setEditable(true);
                    boolean paramMandatory = inputParameter.getMandatory();
                    ungroundedParameterElement.markToBeRemove(!paramMandatory && (paramMandatory || !(ungroundedParameterValue instanceof AbsPrimitive)));
                    ungroundedParameterElement.setLabel(ungroundedParameterName);
                    ungroundedParameterElement.setValue(ungroundedParameterValue);
                    ungroundedParameterElement.addNodeConstraints(paramSchema);
                    ungroundedParameterElement.addConstraints(inputParameter);
                    this.manageAdditionalInfoConstraint(ungroundedParameterElement, bb.getActivity().getBehaviourName(), ungroundedParameterName, inputParameter.getMode());
                    paramPanel.addComponent((Component)ungroundedParameterElement);
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.WARNING, "Impossible set value/constraints of parameter " + ungroundedParameterName + ", value=" + ungroundedParameterValue, (Throwable)e);
                }
            }
        }
        return paramPanel;
    }

    public void manageAdditionalInfoConstraint(StructuredDataElement sde, String activityName, String paramKey, int paramMode) throws OntologyException {
        List paramInfos = this.getParamActions(this.inputInfos, this.outputInfos, activityName, paramKey, paramMode, false);
        if (paramInfos != null) {
            for (AdditionalInfo additionalInfo : paramInfos) {
                sde.addConstraint((Constraint)new AdditionalInfoConstraint(additionalInfo.info), additionalInfo.paramPart);
            }
        }
    }

    protected boolean skipParameter(BuildingBlock bb, List<String> prefixesToSkip, String parameterName) {
        if (prefixesToSkip != null) {
            String prefix = null;
            int sepPos = parameterName.indexOf(".");
            if (sepPos > 0) {
                prefix = parameterName.substring(0, sepPos - 1);
            }
            return prefixesToSkip.contains(prefix);
        }
        return false;
    }

    @Override
    protected void handleUngroundedParameters(BuildingBlock bb) throws Exception {
        if (this.isInteractiveMode()) {
            HashMap<String, AbsObject> ungroundedParameters = new HashMap<String, AbsObject>();
            List<String> prefixesToSkip = this.getParameterPrefixesToSkip(bb);
            for (String parameterName : bb.getInputParameterNames()) {
                AbsObject parameterAbs;
                Object parameterValue;
                if (this.skipParameter(bb, prefixesToSkip, parameterName) || (parameterValue = bb.getInput(parameterName)) == null || !(parameterValue instanceof AbsObject) || (parameterAbs = (AbsObject)parameterValue).isGrounded() && (!(parameterValue instanceof AbsAggregate) || parameterAbs.getCount() != 0)) continue;
                ungroundedParameters.put(parameterName, parameterAbs);
            }
            if (!ungroundedParameters.isEmpty() || !this.toBeDisplayed.isEmpty()) {
                ListPanel ungroundedParametersPanel;
                Interaction interaction = new Interaction(this.getInteractionTitle(bb));
                ListPanel mainPanel = new ListPanel();
                interaction.setMainPanel((Panel)mainPanel);
                Action next = new Action(this.getNextButtonLabel());
                next.requireAllComponentsValidation();
                interaction.addAction(next);
                ListPanel displaysPanel = this.prepareDisplaysPanel();
                if (displaysPanel != null) {
                    mainPanel.addComponent((Component)displaysPanel);
                }
                if ((ungroundedParametersPanel = this.perpareUngroundedParametersPanel(bb, ungroundedParameters)) != null) {
                    mainPanel.addComponent((Component)ungroundedParametersPanel);
                }
                this.customizeUngroundedParametersInteraction(bb, interaction);
                interaction = this.interact(interaction);
                for (String ungroundedParameterName : ungroundedParameters.keySet()) {
                    StructuredDataElement groundedParameterElement = (StructuredDataElement)interaction.getComponent(ungroundedParameterName);
                    if (groundedParameterElement == null) continue;
                    bb.setInput(ungroundedParameterName, groundedParameterElement.getValue());
                }
            }
        }
        super.handleUngroundedParameters(bb);
    }

    protected void customizeUngroundedParametersInteraction(BuildingBlock bb, Interaction interaction) {
    }

    @Override
    public void onStart() {
        try {
            this.initRootExecutor();
            if (this.isInteractiveMode() && !this.isInline() && this.getDescriptor().getDelegationChain() == null) {
                try {
                    this.blockUntilGo(this.getDescriptor().getSessionId(), null);
                }
                catch (InteractionException e) {
                    e.printStackTrace();
                }
            }
            super.onStart();
        }
        catch (Agent.Interrupted interrupted) {
            // empty catch block
        }
    }

    @Override
    public int onEnd() {
        boolean failed = false;
        boolean interrupted = false;
        if (!this.frozen && !this.interactivityCompleted && this.isInteractiveMode()) {
            try {
                ListPanel displaysPanel = this.prepareDisplaysPanel();
                if (displaysPanel != null) {
                    Interaction interaction = new Interaction(this.getLastDisplaysInteractionTitle());
                    ListPanel mainPanel = new ListPanel();
                    interaction.setMainPanel((Panel)mainPanel);
                    mainPanel.addComponent((Component)displaysPanel);
                    Action ok = new Action(this.getOkButtonLabel());
                    interaction.addAction(ok);
                    try {
                        this.interact(interaction);
                    }
                    catch (Agent.Interrupted e) {
                        interrupted = true;
                    }
                }
                if (!(interrupted || this.isSubflow() || this.isInteractivityCompleted())) {
                    Interaction defaultLastInteraction = this.getDefaultLastInteraction();
                    if (defaultLastInteraction != null) {
                        defaultLastInteraction.setLast(true);
                        this.interact(defaultLastInteraction);
                    } else {
                        this.markInteractivityCompleted();
                    }
                }
            }
            catch (InteractionException e) {
                this.myLogger.log(Logger.WARNING, "Error performing interaction", (Throwable)((Object)e));
                failed = true;
            }
        }
        int ret = super.onEnd();
        if (this.frozen && ret == 0) {
            ret = 2;
        }
        return failed ? 1 : ret;
    }

    private Go blockUntilGo(String sessionId, String expectedInteractionId) throws InteractionException {
        MessageTemplate interactionTemplate = MessageTemplate.and((MessageTemplate)MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)InteractivityOntology.getInstance().getName()), (MessageTemplate)MessageTemplate.MatchConversationId((String)sessionId)), (MessageTemplate)MessageTemplate.MatchPerformative((int)16));
        boolean entered = false;
        try {
            boolean receivedGoAction;
            entered = this.enterInterruptableSection();
            AgentAction agentAction = null;
            do {
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Begin BlockUntilGo for sessionId=" + sessionId);
                }
                ACLMessage msg = this.myAgent.blockingReceive(interactionTemplate);
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "BlockUntilGo for sessionId=" + sessionId + " receive msg=" + msg);
                }
                if (msg == null) {
                    Go go = null;
                    return go;
                }
                try {
                    jade.content.onto.basic.Action action = (jade.content.onto.basic.Action)this.myAgent.getContentManager().extractContent(msg);
                    agentAction = (AgentAction)action.getAction();
                }
                catch (Exception e) {
                    throw new InteractionException("Error extracting action from message", e);
                }
                if (agentAction instanceof GetSnapshot) {
                    this.serveGetSnapshot((GetSnapshot)agentAction, msg.createReply());
                    receivedGoAction = false;
                    continue;
                }
                if (agentAction instanceof Back) {
                    this.serveBack((Back)agentAction, msg.createReply());
                    receivedGoAction = false;
                    continue;
                }
                if (agentAction instanceof Go) {
                    Interaction interaction = ((Go)agentAction).getInteraction();
                    if (expectedInteractionId == null && interaction == null || expectedInteractionId == null && interaction != null && interaction.getId() == null || expectedInteractionId != null && interaction != null && expectedInteractionId.equals(interaction.getId())) {
                        receivedGoAction = true;
                        continue;
                    }
                    this.myLogger.log(Logger.WARNING, "BlockUntilGo for sessionId=" + sessionId + " receive unexpected interaction, extected=" + expectedInteractionId + ", received=" + (interaction != null ? interaction.getId() : "null"));
                    receivedGoAction = false;
                    continue;
                }
                this.myLogger.log(Logger.WARNING, "BlockUntilGo for sessionId=" + sessionId + " receive unexpected msg=" + msg);
                receivedGoAction = false;
            } while (!receivedGoAction);
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Exit from BlockUntilGo for sessionId=" + sessionId);
            }
            Go go = (Go)agentAction;
            return go;
        }
        catch (Agent.Interrupted e) {
            this.interactivityCompleted = true;
            throw e;
        }
        finally {
            if (entered) {
                this.exitInterruptableSection(null);
            }
        }
    }

    private void serveGetSnapshot(GetSnapshot im, ACLMessage reply) throws InteractionException {
        this.myLogger.log(Logger.INFO, "Serving GetSnapshot action");
        try {
            InteractivitySnapshot snapshot = new InteractivitySnapshot();
            snapshot.setInteraction(this.currentInteraction);
            snapshot.setNotifications(this.notifications);
            Result result = new Result((Concept)im, (Object)snapshot);
            this.informManagerAgent(reply, (Predicate)result);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error sending snapshot to proxy for sessionId=" + this.getDescriptor().getSessionId());
            throw new InteractionException("Error sending snapshot to proxy", e);
        }
    }

    private void serveBack(Back back, ACLMessage reply) throws InteractionException {
        this.myLogger.log(Logger.INFO, "Serving Back action");
        if (!this.supportTags()) {
            this.myLogger.log(Logger.WARNING, "Workflow without tags support, sessionId=" + this.getDescriptor().getSessionId());
            throw new InteractionException("Workflow without tags support");
        }
        if (this.getSteps().isEmpty()) {
            this.myLogger.log(Logger.INFO, "Workflow without previous step available -> back to parent workflow, sessionId=" + this.getDescriptor().getSessionId());
            this.handleException((Throwable)((Object)new BackOnFirstInteractionException(this.getBackOnFirstInteractonMessage())));
            throw new Agent.Interrupted();
        }
        try {
            this.back();
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error in go back for sessionId=" + this.getDescriptor().getSessionId());
            throw new InteractionException("Error in go back", e);
        }
    }

    private String getTagName() {
        String tagName = null;
        WorkflowBehaviour wb = this;
        do {
            tagName = wb.getCurrent().getBehaviourName() + (tagName != null ? "." + tagName : "");
        } while ((wb = wb.getOwner()) != null);
        return tagName + "_" + System.currentTimeMillis();
    }

    private Stack<String> getSteps() {
        WorkflowBehaviour owner = this.getOwner();
        if (owner != null && owner instanceof InteractiveWorkflowBehaviour) {
            return ((InteractiveWorkflowBehaviour)owner).getSteps();
        }
        return this.steps;
    }

    private void flash() throws Exception {
        if (this.supportTags()) {
            String tagName = this.getTagName();
            this.tag(tagName);
            this.getSteps().push(tagName);
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Flashed tag " + tagName);
            }
        }
    }

    private void back() throws Exception {
        String tagName = this.getSteps().pop();
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Moving back to tag: " + tagName);
        }
        this.reloadTag(tagName);
    }

    public Interaction interact(Interaction interaction) throws InteractionException {
        if (interaction == null) {
            throw new InteractionException("Null interaction");
        }
        if (interaction.getId() != null) {
            interaction.setId(interaction.getId() + this.getExecutionId() + this.getCurrent().getRestartCounter());
        }
        this.myLogger.log(Logger.INFO, "Begin interact (title=" + interaction.getTitle() + ", id=" + interaction.getId() + ", executionId=" + this.getExecutionId() + ", sessionId=" + this.getDescriptor().getSessionId() + ")");
        this.currentInteraction = interaction;
        AID interactionManagerAgent = this.getInteractionManagerAgent();
        if (interactionManagerAgent == null) {
            return null;
        }
        if (this.interactivityCompleted) {
            this.myLogger.log(Logger.WARNING, "Interaction already finished for sessionId=" + this.getDescriptor().getSessionId());
            throw new InteractionException("Interaction already finished");
        }
        if (interaction.isLast()) {
            this.interactivityCompleted = true;
        }
        if (this.supportTags() && this.getSteps().isEmpty() && this.getDescriptor().getId().equals(this.getWorkflowIdOfFirstInteraction())) {
            this.resetFirstInteractionAsExecuted();
        }
        interaction.setBackEnabled(this.isFirstInteractionExecuted());
        try {
            Result result = new Result((Concept)new Go(), (Object)interaction);
            this.informManagerAgent((Predicate)result);
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Send INFORM(RESULT(GO)) for sessionId=" + this.getDescriptor().getSessionId());
            }
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error sending interaction to proxy for sessionId=" + this.getDescriptor().getSessionId());
            throw new InteractionException("Error sending interaction to proxy", e);
        }
        if (this.interactivityCompleted) {
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Interactivity completed for sessionId=" + this.getDescriptor().getSessionId());
            }
            return null;
        }
        Interaction newInteraction = null;
        Go goAction = this.blockUntilGo(this.getDescriptor().getSessionId(), interaction.getId());
        if (goAction == null) {
            this.myLogger.log(Logger.WARNING, "Interaction timeout for sessionId=" + this.getDescriptor().getSessionId());
            throw new InteractionException("Interaction timeout");
        }
        newInteraction = goAction.getInteraction();
        this.currentInteraction = null;
        try {
            this.flash();
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error flashing tag for sessionId=" + this.getDescriptor().getSessionId());
            throw new InteractionException("Error flashing tag", e);
        }
        if (!this.isFirstInteractionExecuted() && this.supportTags()) {
            this.markFirstInteractionAsExecuted();
        }
        if (newInteraction != null) {
            this.myLogger.log(Logger.INFO, "End interact (title=" + newInteraction.getTitle() + ", id=" + newInteraction.getId() + ", executionId=" + this.getExecutionId() + ", sessionId=" + this.getDescriptor().getSessionId() + ")");
        } else {
            this.myLogger.log(Logger.WARNING, "End interact, received null interaction (executionId=" + this.getExecutionId() + ", sessionId=" + this.getDescriptor().getSessionId() + ")");
        }
        return newInteraction;
    }

    protected boolean isInteractivityCompleted() {
        return this.interactivityCompleted;
    }

    private void setInteractivityCompleted() {
        this.interactivityCompleted = true;
        this.currentInteraction = null;
        Behaviour currentBehaviour = this.getCurrent();
        if (currentBehaviour != null && currentBehaviour instanceof InteractiveWorkflowBehaviour) {
            ((InteractiveWorkflowBehaviour)currentBehaviour).setInteractivityCompleted();
        }
    }

    protected void markInteractivityCompleted() {
        if (!this.interactivityCompleted) {
            if (this.isSubflow() && this.parent instanceof InteractiveWorkflowBehaviour) {
                ((InteractiveWorkflowBehaviour)this.parent).markInteractivityCompleted();
            } else {
                this.setInteractivityCompleted();
                try {
                    InteractivityCompleted completed = new InteractivityCompleted(InteractivityCompleted.Reason.PROGRAMMATING);
                    this.informManagerAgent((Predicate)completed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void informManagerAgent(Predicate predicate) throws InteractionException {
        this.informManagerAgent(new ACLMessage(), predicate);
    }

    private void informManagerAgent(ACLMessage msg, Predicate predicate) throws InteractionException {
        AID interactionManagerAgent = this.getInteractionManagerAgent();
        if (interactionManagerAgent != null) {
            msg.setPerformative(7);
            msg.setLanguage("LEAP");
            msg.setOntology(InteractivityOntology.getInstance().getName());
            msg.setProtocol("fipa-request");
            msg.addUserDefinedParameter("JADE-ignore-failure", "true");
            msg.setConversationId(this.getDescriptor().getSessionId());
            msg.addReceiver(interactionManagerAgent);
            try {
                this.myAgent.getContentManager().fillContent(msg, (ContentElement)predicate);
                this.myAgent.send(msg);
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Error sending " + (predicate != null ? predicate : "FAILURE") + " to proxy for sessionId=" + this.getDescriptor().getSessionId());
                throw new InteractionException("Error sending " + (predicate != null ? predicate : "FAILURE") + " to proxy", e);
            }
        }
    }

    protected String getInteractionTitle(BuildingBlock bb) {
        return "Activity " + bb.getActivity().getBehaviourName();
    }

    protected String getLastInteractionTitle() {
        return "";
    }

    protected String getLastDisplaysInteractionTitle() {
        return "";
    }

    protected String getDisplaysTitle() {
        return "Displays";
    }

    protected String getUngroundedParametersTitle() {
        return "Request parameters";
    }

    protected String getOkButtonLabel() {
        return "OK";
    }

    protected String getNextButtonLabel() {
        return "NEXT";
    }

    protected String getUnknownValueLabel() {
        return "UNKNOWN";
    }

    protected List<String> getParameterPrefixesToSkip(BuildingBlock bb) {
        return null;
    }

    protected String getBackOnFirstInteractonMessage() {
        return "Back pressed on first interaction";
    }

    @Override
    protected void handleEndActivity(HierarchyNode activity) {
        this.prepareDisplays(activity, 0);
        this.prepareDisplays(activity, 1);
        super.handleEndActivity(activity);
    }

    public void suspend(String message) {
        this.setInteractivityPolicyOnSuspension(true, message);
        this.suspend();
    }

    public void setInteractivityPolicyOnSuspension(boolean closeInteractivity, String suspendMessage) {
        this.closeInteractivityOnSuspension = closeInteractivity;
        this.suspendMessage = suspendMessage;
    }

    protected void prepareDisplays(HierarchyNode activity, int mode) {
        this.displayActivityName = activity.getBehaviourName();
        HashMap<String, HashMap<String, java.util.ArrayList>> displaysMap = mode == 0 ? this.inputDisplays : this.outputDisplays;
        HashMap<String, java.util.ArrayList> displays4Activity = displaysMap.get(activity.getBehaviourName());
        if (displays4Activity != null) {
            for (String parameterKey : displays4Activity.keySet()) {
                java.util.ArrayList displays4Param = displays4Activity.get(parameterKey);
                if (displays4Param == null) continue;
                for (Display display : displays4Param) {
                    try {
                        display.value = activity.getBindingManager().getAbsValue(parameterKey, mode, display.paramPart);
                    }
                    catch (Exception e) {
                        this.myLogger.log(Logger.WARNING, "Error getting AbsValue for parameter key= " + parameterKey + ", mode= " + mode + ", part= " + display.paramPart + ". Error=" + e.getMessage());
                        display.value = null;
                    }
                    if (display.value == null) {
                        display.value = AbsPrimitive.wrap((String)this.getUnknownValueLabel());
                    }
                    this.toBeDisplayed.add(display);
                }
            }
        }
    }

    protected Interaction getDefaultLastInteraction() {
        return null;
    }

    protected void performOutputInteraction(OutputInteraction oi) throws Exception {
        this.manageBindings(oi);
        if (this.isInteractiveMode()) {
            Interaction interaction = oi.getOutputInteraction();
            this.interact(interaction);
        }
    }

    @Override
    public boolean isLongRunning() {
        return false;
    }

    @Override
    public boolean supportEnqueuing() {
        return false;
    }

    @Override
    public boolean supportTags() {
        return true;
    }

    @Override
    public void onSuspended() {
        if (!this.interactivityCompleted && this.closeInteractivityOnSuspension) {
            try {
                InteractivityCompleted suspended = new InteractivityCompleted(InteractivityCompleted.Reason.SUSPENDED);
                suspended.setSuspendMessage(this.suspendMessage);
                this.informManagerAgent((Predicate)suspended);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onFrozen() {
        if (!this.interactivityCompleted) {
            try {
                InteractivityCompleted frozen = new InteractivityCompleted(InteractivityCompleted.Reason.FROZEN);
                this.informManagerAgent((Predicate)frozen);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected WorkflowEvent customizeEvent(String id, long time, String type, WorkflowEvent ev, jade.util.leap.List controllers) {
        AID managerAgent = this.getInteractionManagerAgent();
        if (managerAgent != null && controllers.contains((Object)managerAgent)) {
            NotificationInfo notificationInfo = new NotificationInfo(time, type, (Object)ev);
            this.notifications.add(notificationInfo);
        }
        return ev;
    }

    @Override
    protected void onThawed() {
        super.onThawed();
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "OnThawed for sessionId=" + this.getDescriptor().getSessionId());
        }
        this.myAgent.getContentManager().registerOntology(InteractivityOntology.getInstance());
        if (this.isInteractiveMode()) {
            try {
                this.blockUntilGo(this.getDescriptor().getSessionId(), null);
            }
            catch (InteractionException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onResumed() {
        super.onResumed();
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "OnResumed for sessionId=" + this.getDescriptor().getSessionId());
        }
        if (this.isInteractiveMode() && this.closeInteractivityOnSuspension) {
            try {
                this.blockUntilGo(this.getDescriptor().getSessionId(), null);
            }
            catch (InteractionException e) {
                e.printStackTrace();
            }
        }
    }

    private void markFirstInteractionAsExecuted() {
        Modifier modifier = this.getModifier("INTERACTIVE_MODIFIER");
        if (modifier != null) {
            modifier.setProperty("INTERACTIVE_FIRST_INTERACTION_EXECUTED", (Object)this.getDescriptor().getId());
        }
    }

    private void resetFirstInteractionAsExecuted() {
        Modifier modifier = this.getModifier("INTERACTIVE_MODIFIER");
        if (modifier != null) {
            modifier.removeProperty("INTERACTIVE_FIRST_INTERACTION_EXECUTED");
        }
    }

    private String getWorkflowIdOfFirstInteraction() {
        Modifier modifier = this.getModifier("INTERACTIVE_MODIFIER");
        if (modifier != null) {
            return (String)modifier.getProperty("INTERACTIVE_FIRST_INTERACTION_EXECUTED");
        }
        return null;
    }

    private boolean isFirstInteractionExecuted() {
        return this.getWorkflowIdOfFirstInteraction() != null;
    }

    private AID getInteractionManagerAgent() {
        AID interactionManagerAgent = null;
        Modifier modifier = this.getModifier("INTERACTIVE_MODIFIER");
        if (modifier != null) {
            interactionManagerAgent = (AID)modifier.getProperty("INTERACTIVE_AID");
        }
        return interactionManagerAgent;
    }

    protected boolean isInteractiveMode() {
        return this.getInteractionManagerAgent() != null;
    }

    @Override
    protected jade.util.leap.List propagateModifier(Subflow sbfl) {
        if (sbfl.getAsynch()) {
            ArrayList filteredModifiers = null;
            jade.util.leap.List superModifier = super.propagateModifier(sbfl);
            if (superModifier != null) {
                filteredModifiers = new ArrayList();
                for (Modifier m : superModifier) {
                    if (m.getName().equals("INTERACTIVE_MODIFIER")) continue;
                    filteredModifiers.add((Object)m);
                }
            }
            return filteredModifiers;
        }
        return super.propagateModifier(sbfl);
    }

    @Override
    public void reset() {
        this.notifications.clear();
        super.reset();
    }

    @Override
    protected void handleSubflowFailure(String delegatedExecutionId, ACLMessage reply) throws Exception {
        try {
            ExecutionError ee;
            ContentElement failureContent = this.myAgent.getContentManager().extractContent(reply);
            if (failureContent instanceof ExecutionError && (ee = (ExecutionError)failureContent).getType().equals(BackOnFirstInteractionException.class.getName())) {
                this.serveBack(null, null);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.handleSubflowFailure(delegatedExecutionId, reply);
    }

    private class AdditionalInfo
    implements Serializable {
        public String info;
        public String paramPart;

        public AdditionalInfo(String paramPart, String info) {
            this.paramPart = paramPart;
            this.info = info;
        }
    }

    private class Display
    implements Serializable {
        public String activityName;
        public String paramKey;
        public int paramMode;
        public String paramPart;
        public String label;
        public AbsObject value;

        public Display(String activityName, String paramKey, int paramMode, String paramPart, String label) {
            this.activityName = activityName;
            this.paramKey = paramKey;
            this.paramMode = paramMode;
            this.paramPart = paramPart;
            this.label = label;
        }
    }
}

