/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.interactivity;

import com.tilab.wade.performer.ActivityBehaviour;
import com.tilab.wade.performer.BuildingBlock;
import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.MethodInvocator;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.interactivity.OutputInteraction;
import jade.core.Agent;

public class OutputActivityBehaviour
extends ActivityBehaviour {
    private MethodInvocator invocator;
    private OutputInteraction outputInteraction;

    public OutputActivityBehaviour(String name, WorkflowBehaviour owner) {
        this(name, owner, true);
    }

    public OutputActivityBehaviour(String name, WorkflowBehaviour owner, boolean callExecuteMethod) {
        super(name, owner);
        this.outputInteraction = new OutputInteraction(owner, this);
        String methodName = callExecuteMethod ? EngineHelper.activityName2Method(this.getBehaviourName()) : "performOutputInteraction";
        EngineHelper.checkMethodName(methodName, "activity", name);
        this.invocator = new MethodInvocator(owner, methodName, this.outputInteraction, OutputInteraction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        try {
            this.owner.enterInterruptableSection();
            this.invocator.invoke();
        }
        catch (InterruptedException ie) {
        }
        catch (Agent.Interrupted i) {
        }
        catch (ThreadDeath td) {
        }
        catch (Throwable t) {
            this.handleException(t);
            t.printStackTrace();
        }
        finally {
            this.owner.exitInterruptableSection(this);
        }
    }

    public void reset() {
        super.reset();
        this.outputInteraction.reset();
    }

    public BuildingBlock getBuildingBlock(String id) {
        return this.outputInteraction;
    }

    public void setMessage(String message) {
        this.outputInteraction.setMessage(message);
    }

    public void createParameter(String name) {
        this.outputInteraction.setInput(name, null);
    }
}

