/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.transaction;

import com.tilab.wade.performer.EngineHelper;
import com.tilab.wade.performer.TerminationNotificationReceiver;
import com.tilab.wade.performer.WorkflowEngineAgent;
import com.tilab.wade.performer.WorkflowException;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.ontology.KillWorkflow;
import com.tilab.wade.performer.transaction.TransactionEntry;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.NotFoundException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;

public class SubflowEntry
extends TransactionEntry {
    public static final long TRANSACTION_CLOSURE_TIMEOUT = 600000L;
    public static final int REQUESTED = 0;
    public static final int ACCEPTED = 1;
    public static final int COMPLETED = 2;
    public static final int FAILED = 3;
    public static final int COMMITTING = 4;
    public static final int ROLLBACKING = 5;
    public static final int DONE = 6;
    public static final int ERROR = 7;
    private WorkflowEngineAgent myAgent;
    private AID delegatedPerformer;
    private WorkflowDescriptor myDescriptor;
    private int status;
    private TerminationNotificationReceiver terminationNotificationReceiver;
    private String executionId;
    private ACLMessage agree;
    private ACLMessage notification;
    private Logger myLogger;

    public SubflowEntry(String id, String activity, Agent agent, AID performer, WorkflowDescriptor wd) {
        this.setId(id);
        this.setActivity(activity);
        this.myAgent = (WorkflowEngineAgent)agent;
        this.delegatedPerformer = performer;
        this.myDescriptor = wd;
        this.status = 0;
        this.myLogger = Logger.getMyLogger((String)this.myAgent.getName());
    }

    public void setTerminationNotificationReceiver(TerminationNotificationReceiver terminationNotificationReceiver) {
        this.terminationNotificationReceiver = terminationNotificationReceiver;
    }

    public final AID getDelegatedPerformer() {
        return this.delegatedPerformer;
    }

    public final WorkflowDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public final void setAgree(ACLMessage agree) {
        this.agree = agree;
        this.executionId = agree.getContent();
        this.status = 1;
    }

    public final String getExecutionId() {
        return this.executionId;
    }

    public final int getStatus() {
        return this.status;
    }

    public final void setNotification(ACLMessage notification) {
        this.notification = notification;
        this.status = notification.getPerformative() == 11 ? 2 : 3;
    }

    public final ACLMessage getNotification() {
        return this.notification;
    }

    public boolean isSuccessful() {
        return this.status != 3;
    }

    public void commit() throws Throwable {
        try {
            if (this.status != 2) {
                throw new IllegalStateException("Cannot commit a subflow in state " + this.status);
            }
            this.status = 4;
            this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - Committing subflow " + this.getId());
            this.close(0);
            this.myLogger.log(Logger.FINER, "Agent " + this.myAgent.getName() + " - Subflow " + this.getId() + " successfully committed");
            this.status = 6;
        }
        catch (Throwable t) {
            this.status = 7;
            throw t;
        }
    }

    public void rollback() throws Throwable {
        block4: {
            try {
                if (this.status == 2) {
                    this.status = 5;
                    this.myLogger.log(Logger.FINE, "Agent " + this.myAgent.getName() + " - Rolling back subflow " + this.getId());
                    this.close(15);
                    this.myLogger.log(Logger.FINER, "Agent " + this.myAgent.getName() + " - Subflow " + this.getId() + " successfully rolled back");
                    this.status = 6;
                    break block4;
                }
                if (this.status == 1 || this.status == 0) {
                    this.status = 5;
                    this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Killing pending subflow " + this.getId());
                    this.killPendingSubflow();
                    this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Pending subflow " + this.getId() + " successfully killed");
                    this.status = 6;
                    break block4;
                }
                throw new IllegalStateException("Cannot rollback a subflow in state " + this.status);
            }
            catch (Throwable t) {
                this.status = 7;
                throw t;
            }
        }
    }

    private void close(int performative) throws NotFoundException, WorkflowException {
        ACLMessage msg = this.notification.createReply();
        msg.setPerformative(performative);
        this.myAgent.send(msg);
        MessageTemplate template = MessageTemplate.MatchConversationId((String)msg.getConversationId());
        template = EngineHelper.adjustReplyTemplate(template, msg);
        ACLMessage reply = this.myAgent.blockingReceive(template, 600000L);
        this.myAgent.removeConversation(this.notification);
        if (reply != null) {
            if (reply.getPerformative() == 6) {
                if (reply.getSender().equals((Object)this.myAgent.getAMS())) {
                    throw new NotFoundException("Agent " + this.delegatedPerformer.getName() + " not found.");
                }
                throw new WorkflowException("Agent " + this.delegatedPerformer.getName() + " failed to close the transaction");
            }
        } else {
            throw new WorkflowException("Agent " + this.delegatedPerformer.getName() + " did not reply in due time");
        }
    }

    private void killPendingSubflow() throws WorkflowException {
        AID performer = this.agree.getSender();
        KillWorkflow ki = new KillWorkflow(this.executionId);
        Action aExpr = new Action(performer, (Concept)ki);
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(performer);
        msg.setLanguage(this.myAgent.getLanguage().getName());
        msg.setOntology(this.myAgent.getOntology().getName());
        try {
            if (this.terminationNotificationReceiver != null) {
                this.terminationNotificationReceiver.abort();
            }
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)aExpr);
            FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)msg);
            MessageTemplate template = MessageTemplate.MatchConversationId((String)this.agree.getConversationId());
            this.myLogger.log(Logger.INFO, "Agent " + this.myAgent.getName() + " - Waiting for subflow " + this.getId() + " termination notification...");
            this.notification = this.myAgent.blockingReceive(template, 600000L);
            if (this.notification != null) {
                if (this.notification.getPerformative() == 11) {
                    this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Successful termination notification received from subflow " + this.getId() + " while we were killing it. Don't wait for any further notification");
                }
            } else {
                this.myLogger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Missing termination notification from subflow " + this.getId());
            }
        }
        catch (RefuseException re) {
        }
        catch (Exception e) {
            throw new WorkflowException("Error killing pending subflow. ", (Throwable)e);
        }
        finally {
            if (this.agree != null) {
                this.myAgent.removeConversation(this.agree);
            }
        }
    }
}

