/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.performer.transaction;

import com.tilab.wade.performer.event.CommitFailedEvent;
import com.tilab.wade.performer.event.EventEmitter;
import com.tilab.wade.performer.event.RollbackFailedEvent;
import com.tilab.wade.performer.event.WorkflowEvent;
import com.tilab.wade.performer.transaction.TransactionEntry;
import jade.core.Agent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TransactionManager
implements Serializable {
    public static final String DEFAULT_LABEL = "__default__";
    private List entriesByOrder = new LinkedList();
    private Map entriesById = new HashMap();
    private String currentLabel = "__default__";
    private List labels = new ArrayList();
    private String executionId;
    private EventEmitter myEventEmitter;

    public TransactionManager(String executionId, EventEmitter emitter) {
        this.executionId = executionId;
        this.myEventEmitter = emitter;
    }

    public void setLabel(String label) {
        this.currentLabel = label;
    }

    public String getLabel() {
        return this.currentLabel;
    }

    public List getLabels() {
        return this.labels;
    }

    public synchronized void addEntry(TransactionEntry entry) {
        entry.setLabel(this.currentLabel);
        if (!this.labels.contains(this.currentLabel)) {
            this.labels.add(this.currentLabel);
        }
        this.labels.add(this.currentLabel);
        this.entriesByOrder.add(entry);
        this.entriesById.put(entry.getId(), entry);
    }

    public synchronized TransactionEntry getEntry(String id) {
        return (TransactionEntry)this.entriesById.get(id);
    }

    public synchronized TransactionEntry removeEntry(String id) {
        TransactionEntry entry = (TransactionEntry)this.entriesById.remove(id);
        if (entry != null) {
            this.entriesByOrder.remove(entry);
        }
        return entry;
    }

    public synchronized void clear() {
        this.entriesByOrder.clear();
        this.entriesById.clear();
    }

    public synchronized List getEntries(Class type, String label) {
        Iterator it = this.entriesByOrder.iterator();
        ArrayList<TransactionEntry> l = new ArrayList<TransactionEntry>();
        while (it.hasNext()) {
            TransactionEntry entry = (TransactionEntry)it.next();
            if (!type.isInstance(entry) || label != null && !label.equals(entry.getLabel())) continue;
            l.add(entry);
        }
        return l;
    }

    public synchronized List removeEntries(Class type, String label) {
        List l = null;
        if (type.equals(TransactionEntry.ANY_TYPE) && label == null) {
            l = this.entriesByOrder;
            this.entriesByOrder = new LinkedList();
            this.entriesById.clear();
        } else {
            l = this.getEntries(type, label);
            for (TransactionEntry entry : l) {
                this.removeEntry(entry.getId());
            }
        }
        return l;
    }

    public synchronized TransactionEntry removeLastEntry(Class type) {
        int size;
        TransactionEntry lastEntry = null;
        for (int i = size = this.entriesByOrder.size(); i > 0; --i) {
            lastEntry = (TransactionEntry)this.entriesByOrder.get(i - 1);
            if (!type.isInstance(lastEntry)) continue;
            return lastEntry;
        }
        return null;
    }

    public boolean commit() {
        return this.commit(TransactionEntry.ANY_TYPE, null);
    }

    public boolean commit(Class type, String label) {
        boolean ret = true;
        List l = this.removeEntries(type, label);
        for (int i = l.size(); i > 0; --i) {
            TransactionEntry entry = (TransactionEntry)l.get(i - 1);
            if (this.commit(entry)) continue;
            ret = false;
        }
        return ret;
    }

    public boolean commitLast(Class type) {
        TransactionEntry lastEntry = this.removeLastEntry(type);
        if (lastEntry != null) {
            return this.commit(lastEntry);
        }
        return true;
    }

    private boolean commit(TransactionEntry entry) {
        try {
            if (entry.isSuccessful()) {
                entry.commit();
            }
            return true;
        }
        catch (InterruptedException ie) {
            throw new Agent.Interrupted();
        }
        catch (Agent.Interrupted ai) {
            throw ai;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.myEventEmitter.fireEvent("warning", (WorkflowEvent)new CommitFailedEvent(this.executionId, entry.getId(), entry.getClass().getName(), t), 1);
            t.printStackTrace();
            return false;
        }
    }

    public boolean rollback() {
        return this.rollback(TransactionEntry.ANY_TYPE, null);
    }

    public boolean rollback(Class type, String label) {
        boolean ret = true;
        List l = this.removeEntries(type, label);
        for (int i = l.size(); i > 0; --i) {
            TransactionEntry entry = (TransactionEntry)l.get(i - 1);
            if (this.rollback(entry)) continue;
            ret = false;
        }
        return ret;
    }

    public boolean rollbackLast(Class type) {
        TransactionEntry lastEntry = this.removeLastEntry(type);
        if (lastEntry != null) {
            return this.rollback(lastEntry);
        }
        return true;
    }

    private boolean rollback(TransactionEntry entry) {
        try {
            if (entry.isSuccessful()) {
                entry.rollback();
            }
            return true;
        }
        catch (InterruptedException ie) {
            throw new Agent.Interrupted();
        }
        catch (Agent.Interrupted ai) {
            throw ai;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.myEventEmitter.fireEvent("warning", (WorkflowEvent)new RollbackFailedEvent(this.executionId, entry.getId(), entry.getClass().getName(), t), 1);
            t.printStackTrace();
            return false;
        }
    }
}

