/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.proxy;

import com.tilab.wade.dispatcher.WorkflowEventListener;
import com.tilab.wade.dispatcher.WorkflowResultListener;
import com.tilab.wade.performer.DefaultParameterValues;
import com.tilab.wade.performer.WebServiceSecurityContext;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.interactivity.Action;
import com.tilab.wade.performer.interactivity.CardinalityConstraint;
import com.tilab.wade.performer.interactivity.Component;
import com.tilab.wade.performer.interactivity.ConstrainedAbsConcept;
import com.tilab.wade.performer.interactivity.Constraint;
import com.tilab.wade.performer.interactivity.ConstraintException;
import com.tilab.wade.performer.interactivity.DefaultConstraint;
import com.tilab.wade.performer.interactivity.DocumentationConstraint;
import com.tilab.wade.performer.interactivity.Interaction;
import com.tilab.wade.performer.interactivity.MandatoryConstraint;
import com.tilab.wade.performer.interactivity.OptionalityConstraint;
import com.tilab.wade.performer.interactivity.Panel;
import com.tilab.wade.performer.interactivity.PermittedValuesConstraint;
import com.tilab.wade.performer.interactivity.RegexConstraint;
import com.tilab.wade.performer.interactivity.StructuredDataElement;
import com.tilab.wade.performer.interactivity.TypeConstraint;
import com.tilab.wade.performer.ontology.ExecutionError;
import com.tilab.wade.proxy.EngineProxy;
import com.tilab.wade.proxy.EngineProxyException;
import com.tilab.wade.proxy.WorkflowContext;
import com.tilab.wade.proxy.WorkflowController;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.onto.OntologyException;
import jade.core.AID;
import jade.util.leap.Properties;
import jade.wrapper.gateway.DynamicJadeGateway;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class EngineProxyShell
implements WorkflowResultListener,
WorkflowEventListener {
    private EngineProxy ep;
    private DynamicJadeGateway gateway;
    private String host = "localhost";
    private int port = 1099;
    private BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
    private boolean inited = false;
    private WorkflowContext context = new WorkflowContext();
    private WorkflowController controller;
    private int varCounter;
    private int nodeCounter;
    private Vector<Variable> vars = new Vector();
    private ArrayList<String> nots = new ArrayList();

    public EngineProxyShell() {
        this.gateway = new DynamicJadeGateway();
        this.ep = EngineProxy.getEngineProxy((DynamicJadeGateway)this.gateway);
        this.context.setDefaultParameterValues(new DefaultParameterValues());
        this.context.setWebServiceDefaultSecurityContext(new WebServiceSecurityContext());
        this.writeLine("Interactive Wade Console");
        this.writeLine("------------------------");
        this.writeLine();
        this.mainMenu();
    }

    private void mainMenu() {
        while (true) {
            this.writeLine();
            this.writeLine("1) Console configuration/status");
            this.writeLine("2) Execute workflow");
            this.writeLine("3) Exit");
            String choice = this.readLine("Choice? ");
            this.writeLine();
            if ("1".equalsIgnoreCase(choice)) {
                this.configureMenu();
                continue;
            }
            if ("2".equalsIgnoreCase(choice)) {
                this.executeMenu();
                continue;
            }
            if (!"3".equalsIgnoreCase(choice)) continue;
            this.exit();
        }
    }

    private void configureMenu() {
        boolean exit = false;
        while (!exit) {
            this.writeLine();
            this.writeLine("1) Show actual configuration/status");
            this.writeLine("2) Configure");
            this.writeLine("3) Connect platform");
            this.writeLine("4) Disconnect platform");
            this.writeLine("5) Return");
            String choice = this.readLine("Choice? ");
            this.writeLine();
            if ("1".equalsIgnoreCase(choice)) {
                this.showConfig();
                continue;
            }
            if ("2".equalsIgnoreCase(choice)) {
                this.config();
                continue;
            }
            if ("3".equalsIgnoreCase(choice)) {
                try {
                    this.init(false);
                    this.gateway.checkJADE();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("4".equalsIgnoreCase(choice)) {
                this.gateway.shutdown();
                continue;
            }
            if (!"5".equalsIgnoreCase(choice)) continue;
            exit = true;
        }
    }

    private void showConfig() {
        this.writeLine("Platform host: " + this.host);
        this.writeLine("Platform port: " + this.port);
        this.writeLine("Platform status: " + (this.gateway.isGatewayActive() ? "connected" : "disconnected"));
    }

    private void config() {
        this.host = this.readLine("Platform host? ");
        this.port = Integer.parseInt(this.readLine("Platform port? "));
        this.init(true);
    }

    private void executeMenu() {
        boolean exit = false;
        while (!exit) {
            this.writeLine();
            this.writeLine("1) Launch interpreted WF");
            this.writeLine("2) Launch deployed WF");
            this.writeLine("3) View wf events");
            this.writeLine("4) Security");
            this.writeLine("5) Default parameters");
            this.writeLine("6) Return");
            String choice = this.readLine("Choice? ");
            this.writeLine();
            if ("1".equalsIgnoreCase(choice)) {
                this.launchInterpretedWF();
                continue;
            }
            if ("2".equalsIgnoreCase(choice)) {
                this.launchDeployedWF();
                continue;
            }
            if ("3".equalsIgnoreCase(choice)) {
                this.viewEvents();
                continue;
            }
            if ("4".equalsIgnoreCase(choice)) {
                this.securityMenu();
                continue;
            }
            if ("5".equalsIgnoreCase(choice)) {
                this.dpMenu();
                continue;
            }
            if (!"6".equalsIgnoreCase(choice)) continue;
            exit = true;
        }
    }

    private void viewEvents() {
        this.writeLine("Last workflow events");
        for (String not : this.nots) {
            this.writeLine(not, 1);
        }
    }

    private void dpMenu() {
        boolean exit = false;
        while (!exit) {
            String value;
            String part;
            String name;
            String activity;
            this.writeLine();
            this.writeLine("1) View");
            this.writeLine("2) Reset");
            this.writeLine("3) Set parameter");
            this.writeLine("4) Set header");
            this.writeLine("5) Return");
            String choice = this.readLine("Choice? ");
            this.writeLine();
            DefaultParameterValues dpv = this.context.getDefaultParameterValues();
            if ("1".equalsIgnoreCase(choice)) {
                this.writeLine("Not implemented...");
                continue;
            }
            if ("2".equalsIgnoreCase(choice)) {
                this.context.setDefaultParameterValues(new DefaultParameterValues());
                continue;
            }
            if ("3".equalsIgnoreCase(choice)) {
                activity = this.readLine("Activity name? ");
                name = this.readLine("Parameter name? ");
                part = this.readLine("Parameter part? ");
                value = this.readLine("Parameter value? ");
                dpv.setParameterValue(activity, name, part, (Object)value);
                continue;
            }
            if ("4".equalsIgnoreCase(choice)) {
                activity = this.readLine("Activity name? ");
                name = this.readLine("Header name? ");
                part = this.readLine("Header part? ");
                value = this.readLine("Header value? ");
                dpv.setHeaderValue(activity, name, part, (Object)value);
                continue;
            }
            if (!"5".equalsIgnoreCase(choice)) continue;
            exit = true;
        }
    }

    private void securityMenu() {
        boolean exit = false;
        while (!exit) {
            this.writeLine();
            this.writeLine("1) View");
            this.writeLine("2) Reset");
            this.writeLine("3) Set http security");
            this.writeLine("4) Set wss security");
            this.writeLine("5) Set ssl");
            this.writeLine("6) Return");
            String choice = this.readLine("Choice? ");
            this.writeLine();
            WebServiceSecurityContext wssc = this.context.getWebServiceDefaultSecurityContext();
            if ("1".equalsIgnoreCase(choice)) {
                this.writeLine("HttpUsername: " + wssc.getHttpUsername());
                this.writeLine("HttpPassword: " + wssc.getHttpPassword());
                this.writeLine("WSSUsername: " + wssc.getWSSUsername());
                this.writeLine("WSSPasswordType: " + wssc.getWSSPasswordType());
                this.writeLine("WSSPassword: " + wssc.getWSSPassword());
                this.writeLine("WSSTimeToLive: " + wssc.getWSSTimeToLive());
                this.writeLine("CertificareChecking: " + wssc.isEnableCertificateChecking());
                this.writeLine("TrustStore: " + wssc.getTrustStore());
                this.writeLine("TrustStorePassword: " + wssc.getTrustStorePassword());
                continue;
            }
            if ("2".equalsIgnoreCase(choice)) {
                this.context.setWebServiceDefaultSecurityContext(new WebServiceSecurityContext());
                continue;
            }
            if ("3".equalsIgnoreCase(choice)) {
                wssc.setHttpUsername(this.readLine("HttpUsername? "));
                wssc.setHttpPassword(this.readLine("HttpPassword? "));
                continue;
            }
            if ("4".equalsIgnoreCase(choice)) {
                wssc.setWSSUsername(this.readLine("WSSUsername? "));
                String wssPasswordType = this.readLine("WSSPasswordType? (PasswordDigest, [PasswordText])");
                if (wssPasswordType == null || "".equals(wssPasswordType)) {
                    wssPasswordType = "PasswordText";
                }
                wssc.setWSSPasswordType(wssPasswordType);
                wssc.setWSSPassword(this.readLine("WSSPassword? "));
                wssc.setWSSTimeToLive(Integer.valueOf(this.readLine("WSSTimeToLive? [sec]")));
                wssc.setWSSMustUnderstand(Boolean.valueOf(false));
                continue;
            }
            if ("5".equalsIgnoreCase(choice)) {
                String enableCertificateChecking = this.readLine("EnableCertificateChecking? ([false], true)");
                if (enableCertificateChecking == null || "".equals(enableCertificateChecking)) {
                    enableCertificateChecking = "false";
                }
                wssc.setCertificateChecking(Boolean.valueOf("true".equalsIgnoreCase(enableCertificateChecking)));
                if (!wssc.isEnableCertificateChecking().booleanValue()) continue;
                wssc.setTrustStore(this.readLine("TrustStore? "));
                wssc.setTrustStorePassword(this.readLine("TrustStorePassword? "));
                continue;
            }
            if (!"6".equalsIgnoreCase(choice)) continue;
            exit = true;
        }
    }

    private void launchDeployedWF() {
        try {
            this.init(false);
            this.nots.clear();
            String id = this.readLine("Workflow id? ");
            WorkflowDescriptor wd = new WorkflowDescriptor(id);
            this.controller = this.ep.launch(wd, (WorkflowResultListener)this, (WorkflowEventListener)this, this.context, true);
            this.go();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void launchInterpretedWF() {
        try {
            this.init(false);
            this.nots.clear();
            String format = this.readLine("WF format? ");
            String fileName = this.readLine("WF representation file? ");
            String representation = this.getFileContent(fileName);
            WorkflowDescriptor wd = new WorkflowDescriptor("test");
            wd.setFormat(format);
            wd.setRepresentation(representation);
            this.controller = this.ep.launch(wd, (WorkflowResultListener)this, (WorkflowEventListener)this, this.context, true);
            this.go();
        }
        catch (Exception e) {
            this.writeLine("ERROR: " + e.getMessage());
        }
    }

    private void go() throws EngineProxyException {
        if (this.controller == null) {
            return;
        }
        Interaction interact = null;
        do {
            interact = this.controller.go(interact);
        } while (!(interact = this.showInteraction(interact)).isLast());
    }

    private Interaction showInteraction(Interaction interact) {
        int intChoice;
        do {
            Action action;
            intChoice = -1;
            this.vars.clear();
            this.varCounter = 0;
            this.nodeCounter = 0;
            this.writeLine("----------------------------------");
            this.writeLine("--- " + interact.getTitle());
            this.showComponent((Component)interact.getMainPanel(), 0);
            if (interact.isLast()) continue;
            this.writeLine("--- Actions");
            if (this.varCounter > 0) {
                this.writeLine("s) Set variable value", 1);
            }
            if (this.nodeCounter > 0) {
                this.writeLine("r) Remove/Add node", 1);
            }
            this.writeLine("k) kill wf", 1);
            List actions = interact.getActions();
            for (int i = 0; i < actions.size(); ++i) {
                action = (Action)actions.get(i);
                String state = "";
                try {
                    action.validate();
                }
                catch (ConstraintException e) {
                    state = "(DISABLE)";
                }
                this.writeLine(i + 1 + ") " + action.getLabel() + " " + state, 1);
            }
            String choice = this.readLine("Choice? ");
            try {
                intChoice = Integer.parseInt(choice);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (choice.equalsIgnoreCase("s") && this.varCounter > 0) {
                this.setValue();
                continue;
            }
            if (choice.equalsIgnoreCase("k")) {
                try {
                    this.ep.kill(this.controller.getExecutionId());
                }
                catch (EngineProxyException e) {
                    this.writeLine("WARNING: Error killing wf, " + e.getMessage());
                }
                interact.setLast(true);
                continue;
            }
            if (intChoice >= 1 && intChoice <= actions.size()) {
                action = (Action)interact.getActions().get(intChoice - 1);
                try {
                    action.validate();
                    action.setSelected(true);
                }
                catch (ConstraintException e) {
                    this.writeLine("WARNING: " + e.getMessage() + ", element=" + e.getVisualElement().getLabel());
                    intChoice = -1;
                }
                continue;
            }
            intChoice = -1;
        } while (intChoice <= 0 && !interact.isLast());
        return interact;
    }

    private void setValue() {
        int varNumber = -1;
        try {
            varNumber = Integer.parseInt(this.readLine("Choice variable number? "));
        }
        catch (Exception e) {
            // empty catch block
        }
        String varValue = this.readLine("Value? ");
        if (varNumber >= 1 && varNumber <= this.vars.size()) {
            Variable var = this.vars.get(varNumber - 1);
            Object parent = var.parent;
            if (parent instanceof StructuredDataElement) {
                ((StructuredDataElement)parent).setValue((AbsObject)this.getTypedValue(varValue, var.type));
            } else if (parent instanceof AbsAggregate) {
                AbsAggregate agg = (AbsAggregate)parent;
                int pos = Integer.parseInt(var.name.substring(1));
                AbsTerm template = agg.get(pos);
                agg.remove(pos);
                agg.add((AbsTerm)this.getTypedValue(varValue, var.type));
                agg.add(template);
            } else {
                try {
                    AbsHelper.setAttribute((AbsObject)((AbsObject)parent), (String)var.name, (AbsObject)this.getTypedValue(varValue, var.type));
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private AbsPrimitive getTypedValue(String value, String type) {
        if (type.equals("BO_String")) {
            return AbsPrimitive.wrap((String)value);
        }
        if (type.equals("BO_Float")) {
            return AbsPrimitive.wrap((float)Float.valueOf(value).floatValue());
        }
        if (type.equals("BO_Integer")) {
            return AbsPrimitive.wrap((int)Integer.valueOf(value));
        }
        if (type.equals("BO_Boolean")) {
            if (value.equalsIgnoreCase("true")) {
                return AbsPrimitive.wrap((boolean)new Boolean(true));
            }
            if (value.equalsIgnoreCase("false")) {
                return AbsPrimitive.wrap((boolean)new Boolean(false));
            }
            this.writeLine("WARNING: " + value + " not boolean value (true/false)");
        }
        if (type.equals("BO_Date")) {
            SimpleDateFormat W3CISO8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            try {
                Date date = W3CISO8601DateFormat.parse(value);
                return AbsPrimitive.wrap((Date)date);
            }
            catch (ParseException e) {
                this.writeLine("WARNING: Date " + value + " not in W3C-ISO8601 format");
            }
        }
        return null;
    }

    private void showComponent(Component comp, int indentLevel) {
        if (comp instanceof Panel) {
            Panel panel = (Panel)comp;
            this.writeLine(panel.getLabel(), indentLevel);
            for (Component c : panel.getComponents()) {
                this.showComponent(c, indentLevel + 1);
            }
        } else if (comp instanceof StructuredDataElement) {
            StructuredDataElement de = (StructuredDataElement)comp;
            this.showAbs(de, de.getValue(), de.getLabel(), indentLevel);
        } else {
            this.writeLine("-" + comp.getLabel() + " = NOT SUPPORTED", indentLevel);
        }
    }

    private void showAbs(Object parent, AbsObject value, String name, int currentLevel) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!(value instanceof AbsVariable)) break block2;
                        this.writeLine("-" + name + " = ?" + (this.varCounter + 1) + " " + this.getConstaints(parent, name), currentLevel);
                        Variable var = new Variable();
                        var.name = name;
                        var.parent = parent;
                        var.type = ((AbsVariable)value).getType();
                        this.vars.add(var);
                        ++this.varCounter;
                        break block3;
                    }
                    if (!(value instanceof AbsPrimitive)) break block4;
                    this.writeLine("-" + name + " = " + value, currentLevel);
                    break block3;
                }
                if (!(value instanceof AbsAggregate)) break block5;
                AbsAggregate agg = (AbsAggregate)value;
                this.writeLine("+" + name + " " + this.getConstaints(parent, name), currentLevel);
                for (int i = 0; i < agg.size(); ++i) {
                    this.showAbs(value, (AbsObject)agg.get(i), "#" + i, currentLevel + 1);
                }
                break block3;
            }
            if (!(value instanceof AbsConcept)) break block3;
            this.writeLine("+" + name + " " + this.getConstaints(parent, name), currentLevel);
            for (String slot : value.getNames()) {
                this.showAbs(value, value.getAbsObject(slot), slot, currentLevel + 1);
            }
        }
    }

    private String getConstaints(Object parent, String name) {
        String consts;
        List constraints = new ArrayList();
        if (parent instanceof StructuredDataElement) {
            constraints = ((StructuredDataElement)parent).getConstraints();
        } else if (parent instanceof ConstrainedAbsConcept) {
            constraints = ((ConstrainedAbsConcept)parent).getConstraints(name);
        }
        StringBuilder sb = new StringBuilder();
        if (constraints != null) {
            for (Constraint c : constraints) {
                if (c instanceof TypeConstraint) {
                    this.addToConstaintsList(sb, ((TypeConstraint)c).getType());
                    continue;
                }
                if (c instanceof MandatoryConstraint) {
                    this.addToConstaintsList(sb, "MAN");
                    continue;
                }
                if (c instanceof OptionalityConstraint) {
                    this.addToConstaintsList(sb, "OPT");
                    continue;
                }
                if (c instanceof DefaultConstraint) {
                    this.addToConstaintsList(sb, "def=" + ((DefaultConstraint)c).getValue());
                    continue;
                }
                if (c instanceof PermittedValuesConstraint) {
                    this.addToConstaintsList(sb, "values={" + ((PermittedValuesConstraint)c).getPermittedValuesString() + "}");
                    continue;
                }
                if (c instanceof RegexConstraint) {
                    this.addToConstaintsList(sb, "rgx=" + ((RegexConstraint)c).getRegex());
                    continue;
                }
                if (c instanceof DocumentationConstraint) {
                    this.addToConstaintsList(sb, "doc=" + ((DocumentationConstraint)c).getDocumentation());
                    continue;
                }
                if (!(c instanceof CardinalityConstraint)) continue;
                int min = ((CardinalityConstraint)c).getMin();
                int max = ((CardinalityConstraint)c).getMax();
                this.addToConstaintsList(sb, "[" + min + "," + (max == -1 ? "unbounded" : Integer.valueOf(max)) + "]");
            }
        }
        if ((consts = sb.toString()).length() > 0) {
            consts = "(" + consts + ")";
        }
        return consts;
    }

    private void addToConstaintsList(StringBuilder sb, String text) {
        if (sb.length() != 0) {
            sb.append(", ");
        }
        sb.append(text);
    }

    private void exit() {
        this.writeLine("Goodbye!");
        System.exit(0);
    }

    private void init(boolean reinit) {
        if (!this.inited || reinit) {
            try {
                Properties props = new Properties();
                props.setProperty("host", this.host);
                props.setProperty("port", Integer.toString(this.port));
                this.gateway.init(null, props);
                this.inited = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String readLine(String text) {
        String line = null;
        try {
            this.write(text);
            line = this.input.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        if (line == null || line.equals("")) {
            line = null;
        }
        return line;
    }

    private void writeLine() {
        this.writeLine("", 0);
    }

    private void writeLine(String text) {
        this.writeLine(text, 0);
    }

    private void writeLine(String text, int indentLevel) {
        if (text != null) {
            this.write(text, indentLevel);
            System.out.println();
        }
    }

    private void write(String text) {
        this.write(text, 0);
    }

    private void write(String text, int indentLevel) {
        if (text != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append(text);
            System.out.print(sb.toString());
        }
    }

    private String getFileContent(String fileName) throws FileNotFoundException, IOException {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        input = new BufferedReader(new FileReader(new File(fileName)));
        String line = null;
        while ((line = input.readLine()) != null) {
            contents.append(line);
            contents.append(System.getProperty("line.separator"));
        }
        if (input != null) {
            input.close();
        }
        return contents.toString();
    }

    public void handleAssignedId(AID executor, String executionId) {
    }

    public void handleExecutionCompleted(jade.util.leap.List results, AID executor, String executionId) {
        this.nots.add("ExecutionCompleted " + executor + ", " + executionId + ", " + results);
    }

    public void handleExecutionError(ExecutionError er, AID executor, String executionId) {
        this.nots.add("ExecutionError " + executor + ", " + executionId + ", " + er);
    }

    public void handleLoadError(String reason) {
        this.nots.add("LoadError " + reason);
    }

    public void handleNotificationError(AID executor, String executionId) {
        this.nots.add("NotificationError " + executor + ", " + executionId);
    }

    public void handleEvent(long time, Object ev, AID executor, String executionId) {
        this.nots.add("handleEvent " + ev + ", " + executor + ", " + executionId);
    }

    public void handleExecutionCompleted(AID executor, String executionId) {
    }

    public static void main(String[] args) {
        new EngineProxyShell();
    }

    private class Variable {
        Object parent;
        String name;
        String type;

        private Variable() {
        }
    }
}

