/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.raa;

import com.tilab.wade.cfa.beans.AgentArgumentInfo;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.raa.AgentInfoConstants;
import com.tilab.wade.utils.condition.Getter;
import com.tilab.wade.utils.condition.GetterFactory;
import com.tilab.wade.utils.condition.GetterFactoryException;
import com.tilab.wade.utils.condition.UnexistentGetterException;
import com.tilab.wade.utils.condition.basic.StringGetter;
import jade.util.Logger;

class AgentInfoGetterFactory
implements GetterFactory,
AgentInfoConstants {
    private static final Logger logger = Logger.getMyLogger((String)AgentInfoGetterFactory.class.getName());
    private static final Getter nameGetterInstance = new NameGetter();
    private static final Getter typeGetterInstance = new TypeGetter();
    private static final Getter classNameGetterInstance = new ClassNameGetter();
    private static final Getter ownerGetterInstance = new OwnerGetter();

    AgentInfoGetterFactory() {
    }

    public Getter createGetter(String key) throws GetterFactoryException {
        Getter result = null;
        try {
            if (key.equals("name")) {
                result = nameGetterInstance;
            } else if (key.equals("type")) {
                result = typeGetterInstance;
            } else if (key.equals("classname")) {
                result = classNameGetterInstance;
            } else if (key.equals("owner")) {
                result = ownerGetterInstance;
            } else if (key.startsWith("arguments.")) {
                String argumentName = key.substring("arguments.".length());
                result = new ArgumentGetter(argumentName);
            }
        }
        catch (Exception e) {
            throw new GetterFactoryException(e);
        }
        if (result == null) {
            throw new UnexistentGetterException("Unexistent getter for key " + key);
        }
        return result;
    }

    public class ArgumentGetter
    extends StringGetter {
        private String argumentName;

        public ArgumentGetter(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getValue(Object obj) {
            String result = null;
            AgentArgumentInfo parameter = ((AgentInfo)obj).getParameter(this.argumentName);
            if (parameter != null) {
                Object value = parameter.getValue();
                if (value != null) {
                    result = value.toString();
                } else {
                    logger.log(Logger.WARNING, "Property " + this.argumentName + " is null");
                }
            } else {
                logger.log(Logger.WARNING, "Property " + this.argumentName + " not found!!");
            }
            return result;
        }
    }

    public static class OwnerGetter
    extends StringGetter {
        public String getValue(Object obj) {
            return ((AgentInfo)obj).getOwner();
        }
    }

    public static class ClassNameGetter
    extends StringGetter {
        public String getValue(Object obj) {
            return ((AgentInfo)obj).getClassName();
        }
    }

    public static class TypeGetter
    extends StringGetter {
        public String getValue(Object obj) {
            return ((AgentInfo)obj).getType();
        }
    }

    public static class NameGetter
    extends StringGetter {
        public String getValue(Object obj) {
            return ((AgentInfo)obj).getName();
        }
    }
}

