/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.raa;

import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.raa.AgentAllocationPolicy;
import com.tilab.wade.raa.DoNotCreateException;
import com.tilab.wade.raa.RuntimeAllocatorAgent;
import com.tilab.wade.utils.CAUtils;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.util.Iterator;

class AgentStarter
extends FSMBehaviour {
    private static final Logger logger = Logger.getMyLogger((String)RuntimeAllocatorAgent.class.getName());
    private static final String GET_POLICY = "GET-POLICY";
    private static final String RUN_ALLOCATION_BEHAVIOUR = "RUN-ALLOCATION-BEHAVIOUR";
    private static final String CREATE_AGENT = "CREATE-AGENT";
    private static final String SUCCESS = "SUCCESS";
    private static final String ERROR = "ERROR";
    public static final int POLICY_NOT_FOUND = 0;
    public static final int ALLOCATION_BEHAVIOUR_PRESENT = 1;
    public static final int ALLOCATION_BEHAVIOUR_NOT_PRESENT = 2;
    private static final int AGENT_STARTUP_OK = 0;
    private static final int AGENT_STARTUP_KO = 1;
    private RuntimeAllocatorAgent raa;
    private Iterator<AgentAllocationPolicy> allocationPoliciesIter;
    private AgentInfo info;
    private ACLMessage request;
    private Behaviour allocationBehaviour;
    private AgentAllocationPolicy allocationPolicy;
    private String containerName;
    private String errorMessage;

    protected AgentStarter(RuntimeAllocatorAgent raaAgent, ACLMessage createAgentRequest, final Action action, final AgentInfo info) {
        this.raa = raaAgent;
        this.allocationPoliciesIter = this.raa.getPolicies(info);
        this.info = info;
        this.request = createAgentRequest;
        this.registerFirstState((Behaviour)new GetPolicy(), GET_POLICY);
        this.registerState((Behaviour)new CreateAgent(), CREATE_AGENT);
        this.registerLastState((Behaviour)new OneShotBehaviour(){

            public void action() {
                ACLMessage reply = AgentStarter.this.request.createReply();
                reply.setPerformative(7);
                try {
                    Result r = new Result((Concept)action, (Object)AgentStarter.this.containerName);
                    this.myAgent.getContentManager().fillContent(reply, (ContentElement)r);
                }
                catch (ContentException ce) {
                    logger.log(Logger.WARNING, "Agent " + this.myAgent.getName() + " - Error encoding CreateAgent result", (Throwable)ce);
                }
                reply.addUserDefinedParameter("JADE-ignore-failure", "true");
                this.myAgent.send(reply);
            }
        }, SUCCESS);
        this.registerLastState((Behaviour)new OneShotBehaviour(){

            public void action() {
                ACLMessage reply = AgentStarter.this.request.createReply();
                reply.setPerformative(6);
                reply.setContent("Cannot create agent " + info.getName() + "[" + AgentStarter.this.errorMessage + "]");
                reply.addUserDefinedParameter("JADE-ignore-failure", "true");
                this.myAgent.send(reply);
            }
        }, ERROR);
        this.registerTransition(GET_POLICY, RUN_ALLOCATION_BEHAVIOUR, 1);
        this.registerTransition(GET_POLICY, CREATE_AGENT, 2);
        this.registerDefaultTransition(GET_POLICY, ERROR);
        this.registerDefaultTransition(RUN_ALLOCATION_BEHAVIOUR, CREATE_AGENT);
        this.registerTransition(CREATE_AGENT, SUCCESS, 0);
        this.registerDefaultTransition(CREATE_AGENT, GET_POLICY, new String[]{GET_POLICY, CREATE_AGENT});
    }

    private class CreateAgent
    extends OneShotBehaviour {
        int result;

        private CreateAgent() {
        }

        public void action() {
            this.result = 1;
            String failureReason = null;
            try {
                AgentStarter.this.containerName = AgentStarter.this.allocationPolicy.getContainer(AgentStarter.this.info, AgentStarter.this.allocationBehaviour);
                if (AgentStarter.this.containerName != null) {
                    AID ca = AgentStarter.this.raa.getCA(AgentStarter.this.containerName);
                    if (ca != null) {
                        logger.log(Logger.FINE, "Agent " + AgentStarter.this.raa.getName() + ": Creating agent " + AgentStarter.this.info.getName() + " in container " + AgentStarter.this.containerName);
                        ACLMessage response = CAUtils.createAgent(this.myAgent, AgentStarter.this.info, ca);
                        if (response != null) {
                            logger.log(Logger.INFO, "Agent " + AgentStarter.this.raa.getName() + ": Agent " + AgentStarter.this.info.getName() + " successfully created in container " + AgentStarter.this.containerName);
                            this.result = 0;
                        } else {
                            failureReason = "CA in container " + AgentStarter.this.containerName + " did not reply in due time";
                        }
                    } else {
                        failureReason = "CA in container " + AgentStarter.this.containerName + " does not exist";
                    }
                } else {
                    failureReason = "No container selected";
                }
            }
            catch (DoNotCreateException dnce) {
                logger.log(Logger.INFO, "Agent " + AgentStarter.this.raa.getName() + ": Agent " + AgentStarter.this.info.getName() + " must not be re-created");
                AgentStarter.this.containerName = "NO-CONTAINER";
                this.result = 0;
            }
            catch (Exception e) {
                failureReason = "Creation error: " + e.getMessage();
            }
            if (failureReason != null) {
                AgentStarter.this.errorMessage = AgentStarter.this.errorMessage != null ? AgentStarter.this.errorMessage + "; Policy " + AgentStarter.this.allocationPolicy.getKey() + ": " + failureReason : "Policy " + AgentStarter.this.allocationPolicy.getKey() + ": " + failureReason;
                logger.log(Logger.WARNING, "Agent " + AgentStarter.this.raa.getName() + ": Cannot create agent " + AgentStarter.this.info.getName() + " [" + failureReason + "]");
            }
        }

        public int onEnd() {
            return this.result;
        }
    }

    private class GetPolicy
    extends OneShotBehaviour {
        private int result;
        private boolean firstRun = true;

        private GetPolicy() {
        }

        public void action() {
            this.result = 0;
            if (AgentStarter.this.allocationPoliciesIter.hasNext()) {
                AgentStarter.this.allocationPolicy = (AgentAllocationPolicy)AgentStarter.this.allocationPoliciesIter.next();
                logger.log(Logger.FINE, "Agent " + this.myAgent.getName() + ": Trying to allocate agent " + AgentStarter.this.info.getName() + " through policy " + AgentStarter.this.allocationPolicy.getKey());
                AgentStarter.this.allocationBehaviour = AgentStarter.this.allocationPolicy.getAllocationBehaviour(AgentStarter.this.info);
                if (AgentStarter.this.allocationBehaviour != null) {
                    AgentStarter.this.registerState(AgentStarter.this.allocationBehaviour, AgentStarter.RUN_ALLOCATION_BEHAVIOUR);
                    this.result = 1;
                } else {
                    this.result = 2;
                }
            } else if (this.firstRun) {
                AgentStarter.this.errorMessage = "No suitable policy found to allocate agent " + AgentStarter.this.info.getName() + ".";
                logger.log(Logger.SEVERE, "Agent " + AgentStarter.this.raa.getName() + " - " + AgentStarter.this.errorMessage);
            }
            this.firstRun = false;
        }

        public int onEnd() {
            return this.result;
        }
    }
}

