/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.raa;

import com.tilab.wade.raa.AllocationRule;
import com.tilab.wade.raa.ConfigurationException;
import com.tilab.wade.raa.PolicyCondition;
import com.tilab.wade.raa.PolicyConfiguration;
import jade.core.Agent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationReader {
    private static final String ALLOCATION_RULE = "allocationRule";
    private static final String CONDITION = "condition";
    private static final String POLICY = "policy";
    private static final String PROPERTIES = "properties";
    private static final String NAME = "name";
    private static final Object PROPERTY = "property";
    private static final String VALUE = "value";
    private Document doc;
    private Agent myAgent;

    public ConfigurationReader(String fileName, Agent myAgent) throws ConfigurationException {
        this.doc = this.getDocument(fileName);
        this.myAgent = myAgent;
    }

    private Document getDocument(String cfgPathName) throws ConfigurationException {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            File f;
            DocumentBuilder builder = factory.newDocumentBuilder();
            URL input = ClassLoader.getSystemResource(cfgPathName);
            if (input == null) {
                input = this.getClass().getResource(cfgPathName);
            }
            if (input == null && (f = new File(cfgPathName)).exists()) {
                input = f.toURI().toURL();
            }
            if (input == null) {
                throw new ConfigurationException("Configuration file " + cfgPathName + " not found");
            }
            doc = builder.parse(input.openStream());
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error reading configuration file " + cfgPathName, e);
        }
        return doc;
    }

    List<AllocationRule> getAllocationRules() throws ConfigurationException {
        ArrayList<AllocationRule> rules = new ArrayList<AllocationRule>();
        NodeList nodes = this.doc.getElementsByTagName(ALLOCATION_RULE);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            AllocationRule ar = this.getAllocationRule(i + 1, e);
            rules.add(ar);
        }
        return rules;
    }

    private AllocationRule getAllocationRule(int ruleNumber, Element e) throws ConfigurationException {
        NodeList children = e.getChildNodes();
        String key = Integer.toString(ruleNumber);
        AllocationRule ar = new AllocationRule(key);
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            Element allocationRuleInnerElement = (Element)n;
            String tag = allocationRuleInnerElement.getTagName();
            if (tag.equals(CONDITION)) {
                if (ar.getCondition() != null) {
                    throw new ConfigurationException("too many conditions in element " + e);
                }
                ar.setCondition(new PolicyCondition(allocationRuleInnerElement.getTextContent()));
                continue;
            }
            if (tag.equals(POLICY)) {
                if (ar.getConfiguration() != null) {
                    throw new ConfigurationException("too many policies in element " + e);
                }
                PolicyConfiguration pc = this.getPolicyConfiguration(key, allocationRuleInnerElement);
                ar.setConfiguration(pc);
                continue;
            }
            throw new ConfigurationException("unrecognized tag in element " + e);
        }
        if (ar.getCondition() == null) {
            throw new ConfigurationException("missing condition in element " + e);
        }
        if (ar.getConfiguration() == null) {
            throw new ConfigurationException("missing policy in element " + e);
        }
        return ar;
    }

    private PolicyConfiguration getPolicyConfiguration(String ruleKey, Element e) throws ConfigurationException {
        NodeList children = e.getChildNodes();
        PolicyConfiguration pc = null;
        String className = null;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        className = e.getAttribute(NAME).trim();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            Element propertiesElement = (Element)n;
            String tag = propertiesElement.getTagName();
            if (tag.equals(PROPERTIES)) {
                NodeList propertiesNodeList = propertiesElement.getChildNodes();
                for (int j = 0; j < propertiesNodeList.getLength(); ++j) {
                    Node n2 = propertiesNodeList.item(j);
                    if (!(n2 instanceof Element)) continue;
                    Element propertyElement = (Element)n2;
                    String tag2 = propertyElement.getTagName();
                    if (tag2.equals(PROPERTY)) {
                        String key = propertyElement.getAttribute(NAME).trim();
                        if (properties.get(key) != null) {
                            throw new ConfigurationException("duplicate property \"" + key + "\" in allocationRule " + ruleKey);
                        }
                        properties.put(key, propertyElement.getAttribute(VALUE));
                        continue;
                    }
                    throw new ConfigurationException("(properties) unrecognized tag in element " + e);
                }
                continue;
            }
            throw new ConfigurationException("(policy) unrecognized tag in elemnent " + e);
        }
        pc = new PolicyConfiguration(ruleKey, className, properties, this.myAgent);
        return pc;
    }

    public static void main(String[] args) throws Exception {
        String filename = "raa.xml";
        ConfigurationReader cr = new ConfigurationReader(filename, null);
        List<AllocationRule> rules = cr.getAllocationRules();
        boolean i = true;
        for (AllocationRule rule : rules) {
            System.out.println(rule);
        }
    }
}

