/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.raa;

import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.raa.AgentInfoGetterFactory;
import com.tilab.wade.raa.ConfigurationException;
import com.tilab.wade.utils.condition.Condition;
import com.tilab.wade.utils.condition.FilterException;
import com.tilab.wade.utils.condition.MatcherException;

class PolicyCondition {
    private String expression;
    private Condition filter;

    public PolicyCondition(String expression) throws ConfigurationException {
        this.parseExpression(expression.trim());
    }

    private void parseExpression(String expression) throws ConfigurationException {
        try {
            this.filter = new Condition(new AgentInfoGetterFactory(), expression);
            this.expression = expression;
        }
        catch (FilterException fe) {
            throw new ConfigurationException("cannot create PolicyCondition from expression " + expression, fe);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return "PolicyCondition {expression=\"" + this.expression + "\"}";
    }

    public Condition getFilter() {
        return this.filter;
    }

    public boolean matches(AgentInfo ai) throws MatcherException {
        return this.filter.match(ai);
    }
}

