/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.raa;

import com.tilab.wade.raa.AgentAllocationPolicy;
import com.tilab.wade.raa.ConfigurationException;
import jade.core.Agent;
import java.lang.reflect.Constructor;
import java.util.Map;

class PolicyConfiguration {
    private String key;
    private String className;
    private Map configurationProperties;
    private AgentAllocationPolicy policy;
    private Agent myAgent;

    public PolicyConfiguration(String key, String className, Map configurationProperties, Agent myAgent) throws ConfigurationException {
        if (className == null) {
            throw new ConfigurationException("className cannot be null");
        }
        this.key = key;
        this.className = className;
        this.configurationProperties = configurationProperties;
        this.myAgent = myAgent;
        this.loadPolicy();
    }

    private void loadPolicy() throws ConfigurationException {
        try {
            Class<?> policyClass = Class.forName(this.className);
            Constructor<?> policyClassDefaultConstructor = policyClass.getConstructor(new Class[0]);
            this.policy = (AgentAllocationPolicy)policyClassDefaultConstructor.newInstance(new Object[0]);
            this.policy.init(this.key, this.configurationProperties, this.myAgent);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("cannot load class " + this.className, cnfe);
        }
        catch (ClassCastException cce) {
            throw new ConfigurationException("class " + this.className + " does not implement AgentAllocationPolicy", cce);
        }
        catch (Exception e) {
            throw new ConfigurationException("error instantiating class " + this.className, e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Map getConfigurationProperties() {
        return this.configurationProperties;
    }

    public AgentAllocationPolicy getPolicy() {
        return this.policy;
    }

    public String toString() {
        return "PolicyConfiguration {className=\"" + this.className + "\"; configurationProperties=" + this.configurationProperties + "}";
    }
}

