/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.raa;

import com.tilab.wade.ca.ontology.ControlOntology;
import com.tilab.wade.ca.ontology.CreateAgent;
import com.tilab.wade.cfa.beans.AgentArgumentInfo;
import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.commons.AgentInitializationException;
import com.tilab.wade.commons.AgentType;
import com.tilab.wade.commons.AttributeGetter;
import com.tilab.wade.commons.AttributeSetter;
import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.commons.WadeAgentImpl;
import com.tilab.wade.commons.WadeBasicResponder;
import com.tilab.wade.commons.ontology.WadeManagementOntology;
import com.tilab.wade.raa.AgentAllocationPolicy;
import com.tilab.wade.raa.AgentStarter;
import com.tilab.wade.raa.AllocationRule;
import com.tilab.wade.raa.ConfigurationException;
import com.tilab.wade.raa.ConfigurationReader;
import com.tilab.wade.utils.DFUtils;
import com.tilab.wade.utils.condition.MatcherException;
import jade.content.AgentAction;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.SubscriptionInitiator;
import jade.util.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeAllocatorAgent
extends WadeAgentImpl {
    public static final String CFG_FILENAME_KEY = "cfgFilename";
    private static final String CFG_FILENAME_DEFAULT = "/raa/raa.xml";
    public static final String CFG_FILENAME_ATTRIBUTE = "CfgFilename";
    private TypeManager tm = TypeManager.getInstance();
    private List<AllocationRule> allocationRules = null;
    private Map<String, DFAgentDescription> controlAgentDescriptions = new HashMap<String, DFAgentDescription>();
    private Map<AID, String> containers = new HashMap<AID, String>();
    private String cfgFilename;

    @AttributeGetter(name="Configuration file name")
    public String getCfgFilename() {
        return this.cfgFilename;
    }

    @AttributeSetter(defaultValue="/raa/raa.xml")
    public void setCfgFilename(String newCfgFilename) {
        String oldCfgFilename = this.cfgFilename;
        Object oldAllocationRules = null;
        try {
            this.cfgFilename = newCfgFilename;
            this.readConfiguration();
            this.notifyExistingContainers();
            if (!this.cfgFilename.equals(oldCfgFilename)) {
                this.arguments.put(CFG_FILENAME_KEY, this.cfgFilename);
                DFService.modify((Agent)this, (DFAgentDescription)this.getDFDescription());
            }
        }
        catch (ConfigurationException ce) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + " - Cannot load new configuration (restore the previous one). ", (Throwable)ce);
            this.cfgFilename = oldCfgFilename;
            this.allocationRules = oldAllocationRules;
        }
        catch (FIPAException fe) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - Error modifying DF-registration after loding of new configuration file");
        }
    }

    @Override
    protected void agentSpecificSetup() throws AgentInitializationException {
        try {
            this.getContentManager().registerOntology(ControlOntology.getInstance());
            this.readConfiguration();
            DFAgentDescription template = new DFAgentDescription();
            ServiceDescription sd = new ServiceDescription();
            sd.setType(TypeManager.getInstance().getType("Control Agent").getDescription());
            template.addServices(sd);
            ACLMessage subscriptionMsg = DFService.createSubscriptionMessage((Agent)this, (AID)this.getDefaultDF(), (DFAgentDescription)template, null);
            this.addBehaviour((Behaviour)new SubscriptionInitiator(this, subscriptionMsg){

                protected void handleInform(ACLMessage inform) {
                    try {
                        DFAgentDescription[] dfds = DFService.decodeNotification((String)inform.getContent());
                        for (int i = 0; i < dfds.length; ++i) {
                            AID caAid = dfds[i].getName();
                            jade.util.leap.Iterator services = dfds[i].getAllServices();
                            if (services.hasNext()) {
                                ServiceDescription sd = (ServiceDescription)services.next();
                                String containerName = (String)DFUtils.getPropertyValue((ServiceDescription)sd, (String)"AGENT-LOCATION");
                                RuntimeAllocatorAgent.this.myLogger.log(Level.INFO, "Agent " + this.myAgent.getName() + ": Container " + containerName + " detected - CA is " + caAid.getName());
                                RuntimeAllocatorAgent.this.controlAgentDescriptions.put(containerName, dfds[i]);
                                RuntimeAllocatorAgent.this.containers.put(caAid, containerName);
                                RuntimeAllocatorAgent.this.notifyNewContainer(containerName, caAid, sd);
                                continue;
                            }
                            String containerName = (String)RuntimeAllocatorAgent.this.containers.remove(caAid);
                            if (containerName == null) continue;
                            RuntimeAllocatorAgent.this.controlAgentDescriptions.remove(containerName);
                            RuntimeAllocatorAgent.this.myLogger.log(Level.INFO, "Agent " + this.myAgent.getName() + ": Container " + containerName + " removed");
                            RuntimeAllocatorAgent.this.notifyDeadContainer(containerName);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            throw new AgentInitializationException("Agent " + this.getName() + ": Error during startup, could not start", e);
        }
    }

    @Override
    public WadeBasicResponder getManagementResponder() {
        WadeBasicResponder responder = new WadeBasicResponder(this);
        MessageTemplate template = MessageTemplate.and((MessageTemplate)MessageTemplate.or((MessageTemplate)MessageTemplate.MatchOntology((String)ControlOntology.getInstance().getName()), (MessageTemplate)MessageTemplate.MatchOntology((String)WadeManagementOntology.getInstance().getName())), (MessageTemplate)MessageTemplate.MatchPerformative((int)16));
        responder.setTemplate(template);
        responder.registerHandler(CreateAgent.class, new WadeBasicResponder.ActionHandler(){

            public ACLMessage handleAction(AgentAction act, Action aExpr, ACLMessage request) throws Exception {
                return RuntimeAllocatorAgent.this.serveCreateAgent((CreateAgent)act, aExpr, request);
            }
        });
        return responder;
    }

    private ACLMessage serveCreateAgent(CreateAgent createAgent, Action action, ACLMessage msg) {
        AgentInfo info = this.prepareAgentInfo(createAgent);
        this.myLogger.log(Level.INFO, "Agent " + this.getName() + ": CreateAgent request received from " + msg.getSender().getName() + ". Name = " + info.getName() + " class = " + info.getClassName());
        this.addBehaviour((Behaviour)new AgentStarter(this, msg, action, info));
        return null;
    }

    AID getCA(String containerName) {
        DFAgentDescription dfd = this.controlAgentDescriptions.get(containerName);
        if (dfd != null) {
            return dfd.getName();
        }
        return null;
    }

    private AgentInfo prepareAgentInfo(CreateAgent ca) {
        HashSet<AgentArgumentInfo> properties = null;
        Object[] args = ca.getArguments();
        String agentType = null;
        if (args != null && args.length == 1 && args[0] instanceof Map) {
            Map m = (Map)args[0];
            properties = new HashSet<AgentArgumentInfo>();
            for (Map.Entry e : m.entrySet()) {
                String key = (String)e.getKey();
                Object value = e.getValue();
                if (key.equals("AGENT-TYPE")) {
                    agentType = (String)value;
                }
                AgentArgumentInfo aai = new AgentArgumentInfo(key, value);
                properties.add(aai);
            }
        }
        String name = ca.getName();
        String className = ca.getClassName();
        AgentType type = null;
        type = agentType == null ? this.tm.getTypeForClass(className) : this.tm.getType(agentType);
        if (className == null) {
            className = type.getClassName();
        }
        if (className == null) {
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": unknown class-name for agent " + name);
        }
        String owner = "NONE";
        return new AgentInfo(name, type.getDescription(), className, owner, properties);
    }

    Iterator<AgentAllocationPolicy> getPolicies(AgentInfo info) {
        LinkedList<AgentAllocationPolicy> policies = new LinkedList<AgentAllocationPolicy>();
        if (this.allocationRules != null) {
            for (AllocationRule allocationRule : this.allocationRules) {
                try {
                    if (!allocationRule.getCondition().matches(info)) continue;
                    policies.add(allocationRule.getConfiguration().getPolicy());
                }
                catch (MatcherException me) {
                    this.myLogger.log(Logger.SEVERE, "Agent " + this.getName() + ": error trying to match condition of " + allocationRule + " with AgentInfo " + info + "; skipping rule", (Throwable)me);
                }
            }
        }
        this.myLogger.log(Logger.FINE, "Agent " + this.getName() + ": " + policies.size() + " policies applying to creation of agent " + info.getName());
        return policies.iterator();
    }

    private void readConfiguration() throws ConfigurationException {
        this.cfgFilename = null;
        if (this.arguments != null) {
            this.cfgFilename = (String)this.arguments.get(CFG_FILENAME_KEY);
        }
        if (this.cfgFilename != null) {
            this.myLogger.log(Logger.CONFIG, "Agent " + this.getName() + " - Argument " + CFG_FILENAME_KEY + " found. Value = " + this.cfgFilename);
        } else {
            this.cfgFilename = (String)this.tm.getProperties(this.getType()).get(CFG_FILENAME_KEY);
            if (this.cfgFilename != null) {
                this.myLogger.log(Logger.CONFIG, "Agent " + this.getName() + " - Type-property " + CFG_FILENAME_KEY + " found. Value = " + this.cfgFilename);
            }
        }
        if (this.cfgFilename == null) {
            this.myLogger.log(Logger.CONFIG, "Agent " + this.getName() + " - Using default configuration file " + CFG_FILENAME_DEFAULT);
            this.cfgFilename = CFG_FILENAME_DEFAULT;
        }
        this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Reading agent allocation rules from file " + this.cfgFilename);
        ConfigurationReader cr = new ConfigurationReader(this.cfgFilename, this);
        this.allocationRules = cr.getAllocationRules();
        if (this.allocationRules == null) {
            this.myLogger.log(Logger.WARNING, "Agent " + this.getName() + " - No allocation rule available");
        } else {
            this.myLogger.log(Logger.INFO, "Agent " + this.getName() + " - Initialized " + this.allocationRules.size() + " allocation rules");
            this.myLogger.log(Logger.CONFIG, "Agent " + this.getName() + " - Allocation rules are: " + this.allocationRules.toString());
        }
    }

    private void notifyExistingContainers() {
        for (String containerName : this.controlAgentDescriptions.keySet()) {
            DFAgentDescription dfd = this.controlAgentDescriptions.get(containerName);
            AID caAid = dfd.getName();
            jade.util.leap.Iterator services = dfd.getAllServices();
            if (!services.hasNext()) continue;
            ServiceDescription sd = (ServiceDescription)services.next();
            this.notifyNewContainer(containerName, caAid, sd);
        }
    }

    private void notifyNewContainer(String containerName, AID caAid, ServiceDescription sd) {
        for (int j = 0; j < this.allocationRules.size(); ++j) {
            this.allocationRules.get(j).getConfiguration().getPolicy().newContainer(containerName, caAid, sd);
        }
    }

    private void notifyDeadContainer(String containerName) {
        for (int j = 0; j < this.allocationRules.size(); ++j) {
            this.allocationRules.get(j).getConfiguration().getPolicy().deadContainer(containerName);
        }
    }
}

