/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.raa.policies;

import com.tilab.wade.raa.policies.RoundRobinPolicy;
import jade.core.Agent;
import jade.core.Profile;
import jade.core.Specifier;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.util.leap.Iterator;
import java.util.List;
import java.util.Map;

public class HostBasedRRPolicy
extends RoundRobinPolicy {
    private static final String CFG_HOSTNAME = "hostname";
    private List<String> validHosts;

    public void init(String key, Map arguments, Agent agent) {
        super.init(key, arguments, agent);
        String tmp = (String)arguments.get(CFG_HOSTNAME);
        this.validHosts = Specifier.parseList((String)tmp, (char)'|');
    }

    public boolean isRelevant(ServiceDescription caServiceDescription) {
        Iterator iter = caServiceDescription.getAllProperties();
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            if (!p.getName().equals("HOSTNAME")) continue;
            String host = (String)p.getValue();
            return this.isValid(host);
        }
        return false;
    }

    private boolean isValid(String host) {
        for (String validHost : this.validHosts) {
            if (!Profile.compareHostNames((String)validHost, (String)host)) continue;
            return true;
        }
        return false;
    }
}

