/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.raa.policies;

import com.tilab.wade.cfa.beans.AgentInfo;
import com.tilab.wade.raa.DoNotCreateException;
import com.tilab.wade.raa.policies.BaseAgentAllocationPolicy;
import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.util.Logger;
import jade.util.leap.RoundList;
import java.util.NoSuchElementException;

public class RoundRobinPolicy
extends BaseAgentAllocationPolicy {
    private static final Logger logger = Logger.getMyLogger((String)RoundRobinPolicy.class.getName());
    private RoundList availableContainers = new RoundList();

    public String getContainer(AgentInfo info, Behaviour b) throws DoNotCreateException {
        try {
            return (String)this.availableContainers.get();
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    protected boolean isRelevant(ServiceDescription sd) {
        return true;
    }

    public void newContainer(String containerName, AID ca, ServiceDescription caDescription) {
        if (this.isRelevant(caDescription) && !this.availableContainers.contains((Object)containerName)) {
            this.availableContainers.add((Object)containerName);
            logger.log(Logger.CONFIG, "Agent " + this.myAgent.getName() + ": Policy " + this.myKey + " - Added container " + containerName);
            logger.log(Logger.FINER, "Agent " + this.myAgent.getName() + ": After newContainer() available containers are " + this.availableContainers.toString());
        }
    }

    public void deadContainer(String containerName) {
        if (this.availableContainers.remove((Object)containerName)) {
            logger.log(Logger.CONFIG, "Agent " + this.myAgent.getName() + ": Policy " + this.myKey + " - Removed container " + containerName);
            logger.log(Logger.FINER, "Agent " + this.myAgent.getName() + ": After deadContainer() available containers are " + this.availableContainers.toString());
        }
    }
}

