/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.tools.launcher.gui;

import com.tilab.wade.ca.ontology.GetWorkflowList;
import com.tilab.wade.ca.ontology.GetWorkflowParameters;
import com.tilab.wade.ca.ontology.WorkflowDetails;
import com.tilab.wade.commons.AgentType;
import com.tilab.wade.commons.TypeManager;
import com.tilab.wade.dispatcher.DefaultEventListener;
import com.tilab.wade.dispatcher.DispatchingCapabilities;
import com.tilab.wade.dispatcher.WorkflowEventListener;
import com.tilab.wade.dispatcher.WorkflowResultListener;
import com.tilab.wade.performer.WorkflowBehaviour;
import com.tilab.wade.performer.WorkflowException;
import com.tilab.wade.performer.descriptors.ElementDescriptor;
import com.tilab.wade.performer.descriptors.WorkflowDescriptor;
import com.tilab.wade.performer.event.BeginActivity;
import com.tilab.wade.performer.event.BeginApplication;
import com.tilab.wade.performer.event.BeginWorkflow;
import com.tilab.wade.performer.event.DelegatedSubflow;
import com.tilab.wade.performer.event.EndActivity;
import com.tilab.wade.performer.event.EndApplication;
import com.tilab.wade.performer.event.EndWorkflow;
import com.tilab.wade.performer.ontology.ControlInfo;
import com.tilab.wade.performer.ontology.ExecutionError;
import com.tilab.wade.tools.launcher.gui.EventsPanel;
import com.tilab.wade.tools.launcher.gui.ExitAction;
import com.tilab.wade.tools.launcher.gui.KillAction;
import com.tilab.wade.tools.launcher.gui.LaunchAction;
import com.tilab.wade.tools.launcher.gui.LauncherPanel;
import com.tilab.wade.tools.launcher.gui.ResetAction;
import com.tilab.wade.utils.DFUtils;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.proto.SubscriptionInitiator;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

public class LauncherGUI
extends JFrame
implements WorkflowResultListener {
    private static Color DEFAULT_COLOR = new Color(251, 249, 249);
    private Agent myAgent;
    private ExitAction exitAction;
    private LaunchAction launchAction;
    private KillAction killAction;
    private ResetAction resetAction;
    private LauncherPanel launcherPanel;
    private EventsPanel eventsPanel;
    private List<String> wadeWorkflowList = new java.util.ArrayList<String>();
    private DispatchingCapabilities dc = new DispatchingCapabilities();
    int cnt = 0;
    static final long CA_TIMEOUT = 30000L;
    private String workflowExecutionId;

    public LauncherGUI(Agent a) {
        this.myAgent = a;
        this.setLocation(100, 100);
        this.setTitle("WORKFLOW LAUNCHER");
        this.setBackground(DEFAULT_COLOR);
        URL url = LauncherGUI.class.getClassLoader().getResource("com/tilab/wade/tools/launcher/gui/images/start.png");
        ImageIcon icon = new ImageIcon(url);
        this.launchAction = new LaunchAction(this, icon);
        url = LauncherGUI.class.getClassLoader().getResource("com/tilab/wade/tools/launcher/gui/images/stop.png");
        icon = new ImageIcon(url);
        this.killAction = new KillAction(this, icon);
        url = LauncherGUI.class.getClassLoader().getResource("com/tilab/wade/tools/launcher/gui/images/reset.png");
        icon = new ImageIcon(url);
        this.resetAction = new ResetAction(this, icon);
        url = LauncherGUI.class.getClassLoader().getResource("com/tilab/wade/tools/launcher/gui/images/exit.png");
        icon = new ImageIcon(url);
        this.exitAction = new ExitAction(this, icon);
        JMenuBar jmb = new JMenuBar();
        JMenu menu = null;
        JMenuItem item = null;
        menu = new JMenu("File");
        item = menu.add(this.exitAction);
        jmb.add(menu);
        menu = new JMenu("Workflow");
        item = menu.add(this.launchAction);
        item = menu.add(this.killAction);
        item = menu.add(this.resetAction);
        jmb.add(menu);
        jmb.setBackground(DEFAULT_COLOR);
        this.setJMenuBar(jmb);
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.setBackground(DEFAULT_COLOR);
        bar.setBorderPainted(false);
        this.enrichButton(bar.add(this.launchAction), "Launch workflow");
        this.enrichButton(bar.add(this.killAction), "Kill workflow");
        this.enrichButton(bar.add(this.resetAction), "Reset form");
        bar.addSeparator();
        this.enrichButton(bar.add(this.exitAction), "Exit");
        this.getContentPane().setBackground(DEFAULT_COLOR);
        this.getContentPane().add((Component)bar, "North");
        this.launcherPanel = new LauncherPanel(this);
        this.getContentPane().add((Component)this.launcherPanel, "Center");
        this.eventsPanel = new EventsPanel(this);
        this.getContentPane().add((Component)this.eventsPanel, "East");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LauncherGUI.this.handleExit();
            }
        });
        this.populatePerformer();
        this.populateWadeWorkflows();
        this.refreshActionsStatus();
        this.dc.init(this.myAgent);
    }

    public void handleExit() {
        int answer = JOptionPane.showConfirmDialog(this, "Are you sure to exit?");
        if (answer == 0) {
            this.myAgent.doDelete();
        }
    }

    public void handleLaunch() {
        String performerName = this.launcherPanel.getWorkflowPanel().getPerformerName();
        String workflowName = this.launcherPanel.getWorkflowPanel().getWorkflowName();
        if (performerName == null) {
            JOptionPane.showMessageDialog(this, "Performer can't be null", "WARNING", 0);
        } else if (workflowName == null) {
            JOptionPane.showMessageDialog(this, "Workflow can't be null", "WARNING", 0);
        } else {
            WorkflowDescriptor wd = new WorkflowDescriptor(workflowName, ElementDescriptor.paramListToMap((jade.util.leap.List)this.launcherPanel.getParameterPanel().getParameters()));
            wd.setTransactional(this.launcherPanel.getWorkflowPanel().isTransactional());
            wd.setSessionId(this.launcherPanel.getWorkflowPanel().getSessionId());
            ArrayList infos = new ArrayList();
            infos.add((Object)new ControlInfo("flow", this.myAgent.getAID(), this.launcherPanel.getWorkflowPanel().getFlowLevel()));
            AID performer = new AID(performerName, false);
            try {
                this.dc.launchWorkflow(performer, wd, this, (jade.util.leap.List)infos);
            }
            catch (WorkflowException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Workflow launching error: " + e.getMessage(), "WARNING", 0);
            }
        }
    }

    public void handleKill() {
        if (this.workflowExecutionId != null) {
            String performerName = this.launcherPanel.getWorkflowPanel().getPerformerName();
            AID performer = new AID(performerName, false);
            try {
                this.dc.killWorkflow(performer, this.workflowExecutionId);
                this.refreshActionsStatus();
            }
            catch (WorkflowException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Workflow killing error: " + e.getMessage(), "WARNING", 0);
            }
        }
    }

    public void handleReset() {
        this.launcherPanel.reset();
        this.eventsPanel.reset();
        this.refreshActionsStatus();
    }

    private void enrichButton(JButton button, String toolTipText) {
        button.setToolTipText(toolTipText);
        button.setBorderPainted(false);
        button.getAction().setEnabled(false);
        button.setBackground(DEFAULT_COLOR);
        button.setFocusPainted(false);
    }

    void refreshActionsStatus() {
        String workflowName = this.launcherPanel.getWorkflowPanel().getWorkflowName();
        boolean worflowNameOk = workflowName != null && !"".equals(workflowName);
        String workflowStatus = this.launcherPanel.getStatusPanel().getStatus();
        boolean workflowRunning = workflowStatus != null && workflowStatus.equals("RUNNING");
        String performerName = this.launcherPanel.getWorkflowPanel().getPerformerName();
        boolean performerNameOk = performerName != null && !"".equals(performerName);
        boolean parametersOk = this.launcherPanel.getParameterPanel().checkInputParameters();
        this.launchAction.setEnabled(worflowNameOk && performerNameOk && parametersOk && !workflowRunning);
        this.killAction.setEnabled(workflowRunning);
        this.resetAction.setEnabled(!workflowRunning);
        this.exitAction.setEnabled(!workflowRunning);
        this.launcherPanel.getWorkflowPanel().setFieldsEnabled(!workflowRunning);
        this.launcherPanel.getParameterPanel().setFieldsEnabled(!workflowRunning);
    }

    void populateWadeWorkflows() {
        this.launcherPanel.getWorkflowPanel().setWadeWorkflowList(this.getWadeWorkflows());
    }

    List getWadeWorkflows() {
        AID ca = null;
        this.wadeWorkflowList = new java.util.ArrayList<String>();
        try {
            ACLMessage request = new ACLMessage(16);
            AgentType caType = TypeManager.getInstance().getType("Control Agent");
            DFAgentDescription[] dfadList = DFUtils.searchAllByType((Agent)this.myAgent, (AgentType)caType, null);
            AID[] aidList = DFUtils.getAIDs((DFAgentDescription[])dfadList);
            if (aidList.length > 0) {
                ca = aidList[0];
            }
            if (ca != null) {
                request.addReceiver(ca);
                request.setOntology("Deployment-ontology");
                request.setLanguage("fipa-sl");
                Action action = new Action();
                action.setActor(ca);
                GetWorkflowList workflowList = new GetWorkflowList();
                action.setAction((Concept)workflowList);
                request.setConversationId(this.buildConversationalId());
                request.setReplyByDate(new Date(System.currentTimeMillis() + 30000L));
                this.myAgent.getContentManager().fillContent(request, (ContentElement)action);
                ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request);
                if (reply != null && reply.getPerformative() == 7) {
                    Result result = (Result)this.myAgent.getContentManager().extractContent(reply);
                    jade.util.leap.List workflows = (jade.util.leap.List)result.getValue();
                    Iterator iter = workflows.iterator();
                    while (iter.hasNext()) {
                        this.wadeWorkflowList.add(((WorkflowDetails)iter.next()).getClassName());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.wadeWorkflowList;
    }

    private void populatePerformer() {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.addProperties(new Property("AGENT-ROLE", (Object)"Workflow Executor"));
        template.addServices(sd);
        ACLMessage subscriptionMsg = DFService.createSubscriptionMessage((Agent)this.myAgent, (AID)this.myAgent.getDefaultDF(), (DFAgentDescription)template, null);
        this.myAgent.addBehaviour((Behaviour)new SubscriptionInitiator(this.myAgent, subscriptionMsg){

            protected void handleInform(ACLMessage inform) {
                try {
                    DFAgentDescription[] dfds = DFService.decodeNotification((String)inform.getContent());
                    for (int i = 0; i < dfds.length; ++i) {
                        AID agent = dfds[i].getName();
                        if (dfds[i].getAllServices().hasNext()) {
                            LauncherGUI.this.launcherPanel.getWorkflowPanel().addPerformer(agent.getLocalName());
                            continue;
                        }
                        LauncherGUI.this.launcherPanel.getWorkflowPanel().removePerformer(agent.getLocalName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private jade.util.leap.List getWorkflowParameters(String workflowName) throws Exception {
        jade.util.leap.List parameters = null;
        if (this.wadeWorkflowList.contains(workflowName)) {
            AID ca = null;
            ACLMessage request = new ACLMessage(16);
            AgentType caType = TypeManager.getInstance().getType("Control Agent");
            DFAgentDescription[] dfadList = DFUtils.searchAllByType((Agent)this.myAgent, (AgentType)caType, null);
            AID[] aidList = DFUtils.getAIDs((DFAgentDescription[])dfadList);
            if (aidList.length > 0) {
                ca = aidList[0];
            }
            if (ca == null) return parameters;
            request.addReceiver(ca);
            request.setOntology("Deployment-ontology");
            request.setLanguage("fipa-sl");
            Action action = new Action();
            action.setActor(ca);
            GetWorkflowParameters wfParametersAction = new GetWorkflowParameters();
            wfParametersAction.setName(workflowName);
            action.setAction((Concept)wfParametersAction);
            request.setConversationId(this.buildConversationalId());
            request.setReplyByDate(new Date(System.currentTimeMillis() + 30000L));
            this.myAgent.getContentManager().fillContent(request, (ContentElement)action);
            ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request);
            if (reply == null) return parameters;
            if (reply.getPerformative() != 7) throw new Exception(reply.getContent());
            Result result = (Result)this.myAgent.getContentManager().extractContent(reply);
            Object o = result.getValue();
            return (jade.util.leap.List)o;
        }
        WorkflowBehaviour myWorkflow = null;
        try {
            myWorkflow = (WorkflowBehaviour)Class.forName(workflowName).newInstance();
            return myWorkflow.getFormalParameters();
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Workflow " + workflowName + " not found ");
        }
    }

    private synchronized String buildConversationalId() {
        return this.myAgent.getLocalName() + "-" + System.currentTimeMillis() + "-" + this.cnt++;
    }

    void handleSelectedWorkflow(String workflowName) {
        try {
            jade.util.leap.List workflowParameters = this.getWorkflowParameters(workflowName);
            this.launcherPanel.getParameterPanel().setParameters(workflowParameters);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), "WARNING", 0);
        }
    }

    public void handleAssignedId(AID executor, String executionId) {
        DefaultEventListener l = new DefaultEventListener(){

            public void handleBeginActivity(long time, BeginActivity event, AID executor, String executionId) {
                LauncherGUI.this.eventsPanel.addEvent("BeginActivity " + event.getName());
            }

            public void handleBeginApplication(long time, BeginApplication event, AID executor, String executionId) {
                LauncherGUI.this.eventsPanel.addEvent("BeginApplication " + event.getName());
            }

            public void handleDelegatedSubflow(long time, DelegatedSubflow event, AID executor, String executionId) {
                LauncherGUI.this.eventsPanel.addEvent("DelegatedSubflow " + event.getWorkflowId());
            }

            public void handleEndActivity(long time, EndActivity event, AID executor, String executionId) {
                LauncherGUI.this.eventsPanel.addEvent("EndActivity " + event.getName());
            }

            public void handleEndApplication(long time, EndApplication event, AID executor, String executionId) {
                LauncherGUI.this.eventsPanel.addEvent("EndApplication " + event.getName());
            }

            public void handleEndWorkflow(long time, EndWorkflow event, AID executor, String executionId) {
                LauncherGUI.this.eventsPanel.addEvent("EndWorkflow " + event.getName());
            }

            public void handleBeginWorkflow(long time, BeginWorkflow event, AID executor, String executionId) {
                LauncherGUI.this.launcherPanel.getStatusPanel().setStatus("RUNNING");
                LauncherGUI.this.launcherPanel.setFailureReason(null);
                LauncherGUI.this.refreshActionsStatus();
                LauncherGUI.this.eventsPanel.addEvent("");
                LauncherGUI.this.eventsPanel.addEvent("BeginWorkflow " + event.getName() + " (execId=" + executionId + ")");
            }
        };
        this.dc.setEventListener((WorkflowEventListener)l, "flow", executor, executionId);
        this.workflowExecutionId = executionId;
    }

    public void handleExecutionCompleted(jade.util.leap.List results, AID executor, String executionId) {
        this.launcherPanel.getParameterPanel().setResult(results);
        this.launcherPanel.getStatusPanel().setStatus("COMPLETE");
        this.refreshActionsStatus();
    }

    public void handleExecutionError(ExecutionError er, AID executor, String executionId) {
        this.launcherPanel.getStatusPanel().setStatus("FAILED");
        this.launcherPanel.setFailureReason(er.getReason());
        this.refreshActionsStatus();
    }

    public void handleLoadError(String reason) {
        this.launcherPanel.getStatusPanel().setStatus("FAILED");
        this.launcherPanel.setFailureReason(reason);
        this.refreshActionsStatus();
    }

    public void handleNotificationError(AID executor, String executionId) {
        this.launcherPanel.getStatusPanel().setStatus("FAILED");
        this.refreshActionsStatus();
    }
}

