/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.tools.launcher.gui;

import com.tilab.wade.tools.launcher.gui.LauncherGUI;
import com.tilab.wade.tools.launcher.gui.ParametersPanel;
import com.tilab.wade.tools.launcher.gui.StatusPanel;
import com.tilab.wade.tools.launcher.gui.WorkflowPanel;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LauncherPanel
extends JPanel {
    private Font smallFont = new Font("Monospaced", 1, 10);
    private WorkflowPanel workflowPanel;
    private ParametersPanel parametersPanel;
    private StatusPanel statusPanel;
    private JTextField failureReason;
    private LauncherGUI launcherGUI;

    public LauncherPanel(LauncherGUI launcherGUI) {
        this.launcherGUI = launcherGUI;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.workflowPanel = new WorkflowPanel(this.launcherGUI);
        this.add(this.workflowPanel);
        JPanel workflowParametersPanel = new JPanel();
        workflowParametersPanel.add(new JLabel("Workflow Parameters"));
        this.add(workflowParametersPanel);
        this.parametersPanel = new ParametersPanel(this.launcherGUI);
        this.add(this.parametersPanel);
        JPanel workflowStatusPanel = new JPanel();
        workflowStatusPanel.add(new JLabel("Workflow Status"));
        this.add(workflowStatusPanel);
        this.statusPanel = new StatusPanel();
        this.add(this.statusPanel);
        JPanel failurePanel = new JPanel();
        JLabel failureReasonLabel = new JLabel("Failure Reason:");
        failureReasonLabel.setFont(this.smallFont);
        failurePanel.add(failureReasonLabel);
        this.failureReason = new JTextField();
        this.failureReason.setEditable(false);
        this.failureReason.setPreferredSize(new Dimension(350, 20));
        failurePanel.add(this.failureReason);
        this.add(failurePanel);
    }

    ParametersPanel getParameterPanel() {
        return this.parametersPanel;
    }

    WorkflowPanel getWorkflowPanel() {
        return this.workflowPanel;
    }

    StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    public void setFailureReason(String msg) {
        this.failureReason.setText(msg);
    }

    void reset() {
        this.workflowPanel.reset();
        this.parametersPanel.reset();
        this.statusPanel.reset();
        this.failureReason.setText(null);
    }
}

