/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.tools.launcher.gui;

import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.tools.launcher.gui.LauncherGUI;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ParametersPanel
extends JScrollPane {
    private JTable table;
    private AbstractTableModel model;
    private TableCellRenderer renderer;
    private java.util.List<Row> rows = new java.util.ArrayList<Row>();
    private LauncherGUI launcherGUI;

    public ParametersPanel(LauncherGUI launcherGUI) {
        this.launcherGUI = launcherGUI;
        this.renderer = new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                Row r = (Row)ParametersPanel.this.rows.get(row);
                switch (col) {
                    case 0: {
                        return r.getName();
                    }
                    case 1: {
                        return r.getType();
                    }
                    case 2: {
                        return r.getMode();
                    }
                    case 3: {
                        return r.getValue();
                    }
                }
                return null;
            }
        };
        this.setParameters((List)new ArrayList());
    }

    public void setParameters(List parameters) {
        this.rows.clear();
        int labelNameMaxWidth = -1;
        for (int i = 0; i < parameters.size(); ++i) {
            Row r = new Row((Parameter)parameters.get(i));
            this.rows.add(r);
            JLabel labelName = r.getName();
            int width = labelName.getPreferredSize().width;
            if (width <= labelNameMaxWidth) continue;
            labelNameMaxWidth = width;
        }
        this.model = new AbstractTableModel(){

            public int getColumnCount() {
                return 4;
            }

            public int getRowCount() {
                return ParametersPanel.this.rows.size();
            }

            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Type";
                    }
                    case 2: {
                        return "Mode";
                    }
                    case 3: {
                        return "Value";
                    }
                }
                return null;
            }

            public Object getValueAt(int row, int col) {
                Parameter param = ((Row)ParametersPanel.this.rows.get(row)).getParameter();
                switch (col) {
                    case 0: {
                        return param.getName();
                    }
                    case 1: {
                        return param.getType();
                    }
                    case 2: {
                        return ParametersPanel.this.getParameterMode(param.getMode());
                    }
                    case 3: {
                        return param.getValue();
                    }
                }
                return null;
            }

            public void setValueAt(Object aValue, int row, int col) {
                if (col == 3) {
                    Parameter param = ((Row)ParametersPanel.this.rows.get(row)).getParameter();
                    try {
                        if (aValue instanceof String) {
                            aValue = this.decodeValue((String)aValue, param.getType());
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(ParametersPanel.this.launcherGUI, e.getMessage());
                        aValue = null;
                        ((Row)ParametersPanel.this.rows.get(row)).resetValue();
                    }
                    param.setValue(aValue);
                    this.fireTableCellUpdated(row, col);
                    ParametersPanel.this.launcherGUI.refreshActionsStatus();
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private Object decodeValue(String valueStr, String type) throws Exception {
                try {
                    String result = null;
                    if (type.equals(String.class.getName())) {
                        return valueStr;
                    }
                    if (type.equals(Integer.TYPE.getName())) return new Long(valueStr);
                    if (type.equals(Long.TYPE.getName())) return new Long(valueStr);
                    if (type.equals(Integer.class.getName())) return new Long(valueStr);
                    if (type.equals(Long.class.getName())) {
                        return new Long(valueStr);
                    }
                    if (type.equals(Float.TYPE.getName())) return new Double(valueStr);
                    if (type.equals(Double.TYPE.getName())) return new Double(valueStr);
                    if (type.equals(Float.class.getName())) return new Double(valueStr);
                    if (type.equals(Double.class.getName())) {
                        return new Double(valueStr);
                    }
                    if (type.equals(Boolean.TYPE.getName())) return new Boolean(valueStr);
                    if (type.equals(Boolean.class.getName())) {
                        return new Boolean(valueStr);
                    }
                    if (!type.equals(Character.TYPE.getName())) {
                        if (!type.equals(Character.class.getName())) throw new Exception("Can't handle values of type " + type);
                    }
                    if (valueStr.length() != 1) throw new Exception("Value " + valueStr + " cannot be converted into a " + type);
                    return new Character(valueStr.charAt(0));
                }
                catch (Exception e) {
                    throw new Exception("Value " + valueStr + " cannot be converted into a " + type);
                }
            }

            public boolean isCellEditable(int row, int col) {
                return col == 3 && (((Row)ParametersPanel.this.rows.get(row)).getParameter().getMode() == 0 || ((Row)ParametersPanel.this.rows.get(row)).getParameter().getMode() == 2);
            }
        };
        this.table = new JTable(this.model){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return ParametersPanel.this.renderer;
            }

            public TableCellEditor getCellEditor(int row, int col) {
                if (col == 3) {
                    return ((Row)ParametersPanel.this.rows.get(row)).getValueEditor();
                }
                return null;
            }
        };
        this.table.setIntercellSpacing(new Dimension(2, 2));
        this.table.setRowHeight(25);
        if ((labelNameMaxWidth += 10) < 150) {
            labelNameMaxWidth = 150;
        }
        this.table.getColumnModel().getColumn(0).setPreferredWidth(labelNameMaxWidth);
        this.table.getColumnModel().getColumn(0).setMaxWidth(labelNameMaxWidth);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setMaxWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setMaxWidth(50);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(200);
        this.table.setBackground(this.getBackground());
        this.table.setShowGrid(true);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.table.getTableHeader().setBackground(Color.LIGHT_GRAY);
        this.setViewportView(this.table);
    }

    public List getParameters() {
        ArrayList parameters = new ArrayList();
        for (Row row : this.rows) {
            parameters.add((Object)row.getParameter());
        }
        return parameters;
    }

    boolean checkInputParameters() {
        boolean valid = true;
        for (Row row : this.rows) {
            if (row.getParameter().getMode() != 0 && row.getParameter().getMode() != 2 || row.getParameter().getValue() != null) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public void setResult(List parameters) {
        this.setParameters(parameters);
    }

    private String getParameterMode(int mode) {
        String modeLabel = mode == 0 ? "IN" : (mode == 2 ? "INOUT" : "OUT");
        return modeLabel;
    }

    void setFieldsEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
    }

    void reset() {
        this.setParameters((List)new ArrayList());
    }

    private class Row {
        private Parameter parameter;
        private JLabel name;
        private JLabel type;
        private JLabel mode;
        private JComponent valueShower;
        private TableCellEditor valueEditor;

        public Row(Parameter parameter) {
            this.parameter = parameter;
            this.name = new JLabel(parameter.getName());
            this.type = new JLabel(parameter.getType());
            this.mode = new JLabel(ParametersPanel.this.getParameterMode(parameter.getMode()), 0);
            if (parameter.getType().equals("java.lang.Boolean")) {
                JCheckBox checkBox = new JCheckBox();
                if (parameter.getValue() != null && ((Boolean)parameter.getValue()).booleanValue()) {
                    checkBox.setSelected(true);
                }
                checkBox.setEnabled(parameter.getMode() == 0 || parameter.getMode() == 2);
                this.valueEditor = new DefaultCellEditor(checkBox);
                this.valueShower = checkBox;
            } else {
                JTextField textField = new JTextField();
                if (parameter.getValue() != null) {
                    textField.setText(parameter.getValue().toString());
                }
                textField.setEditable(parameter.getMode() == 0 || parameter.getMode() == 2);
                this.valueEditor = new DefaultCellEditor(textField);
                this.valueShower = textField;
            }
            this.valueShower.setToolTipText("Double click to edit, Enter to validate");
        }

        public void resetValue() {
            if (this.valueShower instanceof JTextField) {
                ((JTextField)this.valueShower).setText(null);
            }
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        public JComponent getValue() {
            return this.valueShower;
        }

        public TableCellEditor getValueEditor() {
            return this.valueEditor;
        }

        public JLabel getName() {
            return this.name;
        }

        public JLabel getType() {
            return this.type;
        }

        public JLabel getMode() {
            return this.mode;
        }
    }
}

